/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.ai.snowtitan;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class EntityAISnowGolemTitanShoot
extends Goal {
    private EntitySnowGolemTitan entity;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private int attackIntervalMin;
    private int attackIntervalMax;
    private float attackRadius;
    private int seeTime;
    private float moveRadius;
    private double speedModifier;

    public EntityAISnowGolemTitanShoot(EntitySnowGolemTitan entity, int attackInterval, float attackRadius, float moveRadius, float speedModifier) {
        this(entity, attackInterval, attackInterval, attackRadius, moveRadius, speedModifier);
    }

    public EntityAISnowGolemTitanShoot(EntitySnowGolemTitan entity, int attackIntervalMin, int attackIntervalMax, float attackRadius, float moveRadius, float speedModifier) {
        this.entity = entity;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadius = attackRadius;
        this.moveRadius = moveRadius;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity target = this.entity.getTarget();
        if (target != null && target.isAlive()) {
            this.target = target;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse() || this.target.isAlive() && !this.entity.getNavigation().isDone();
    }

    public void stop() {
        this.target = null;
        this.attackTime = -1;
        this.seeTime = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        double d0 = this.entity.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean flag = this.entity.getSensing().hasLineOfSight((Entity)this.target);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (d0 > (double)(this.moveRadius * this.moveRadius)) {
            this.entity.getNavigation().stop();
        } else if (this.seeTime >= 5) {
            this.entity.getNavigation().moveTo((Entity)this.target, this.speedModifier);
        }
        this.entity.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!this.entity.getSensing().hasLineOfSight((Entity)this.target)) {
                return;
            }
            float f = (float)Math.sqrt(d0) / this.attackRadius;
            float f1 = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
            this.entity.performRangedAttack(this.target, f1);
            this.attackTime = Mth.floor((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }
}

