/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.minion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.minion.ghast.EntityAIGhastGuardMinionShoot;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.minion.IMinion;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityZombifiedPiglinTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoPredicateTargets;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;

public class EntityGhastGuardMinion
extends Ghast
implements IMinion {
    private static final EntityDataAccessor<Integer> MINION_TYPE = SynchedEntityData.defineId(EntityGhastGuardMinion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public EntityTitan master;

    public EntityGhastGuardMinion(EntityType<? extends EntityGhastGuardMinion> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 20;
        this.setPersistenceRequired();
    }

    public EntityGhastGuardMinion(Level level) {
        this((EntityType<? extends EntityGhastGuardMinion>)((EntityType)TheTitansNeoEntities.GHAST_GUARD_MINION.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Ghast.createAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 100.0).add(Attributes.MOVEMENT_SPEED, 1.0).add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof AvoidEntityGoal);
        this.goalSelector.removeAllGoals(goal -> goal instanceof Ghast.GhastLookGoal);
        this.goalSelector.removeAllGoals(goal -> goal instanceof Ghast.GhastShootFireballGoal);
        this.goalSelector.addGoal(7, (Goal)new EntityAIGhastGuardMinionShoot(this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, TheTitansNeoPredicateTargets.ZombifiedPiglinTitan));
    }

    @Override
    public int getMinionTypeInt() {
        return (Integer)this.getEntityData().get(MINION_TYPE);
    }

    @Override
    public void setMinionType(int minionType) {
        this.getEntityData().set(MINION_TYPE, (Object)minionType);
        this.refreshAttributes();
    }

    @Override
    public EntityTitan getMaster() {
        return this.master;
    }

    @Override
    public void setMaster(EntityTitan master) {
        this.master = master;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MINION_TYPE, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setMinionType(tag.getInt("MinionType"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("MinionType", this.getMinionTypeInt());
    }

    public float rotlerp(float angle, float targetAngle, float maxIncrease) {
        float f = Mth.wrapDegrees((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    protected void dropRareDrop(int count) {
    }

    protected void dropFewItems(boolean attackedRecently, int loottingLevel) {
        int k;
        int j = this.getRandom().nextInt(2) + this.getRandom().nextInt(1 + loottingLevel);
        for (k = 0; k < j; ++k) {
            this.spawnAtLocation((ItemLike)Items.GHAST_TEAR, 1);
        }
        j = this.getRandom().nextInt(3) + this.getRandom().nextInt(1 + loottingLevel);
        for (k = 0; k < j; ++k) {
            this.spawnAtLocation((ItemLike)Items.GUNPOWDER, 1);
        }
    }

    @Override
    public EnumMinionType getMinionType() {
        return EnumMinionType.SPECIAL;
    }

    public boolean canAttackType(EntityType<?> entityType) {
        return entityType != TheTitansNeoEntities.ZOMBIFIED_PIGLIN_TITAN.get() && entityType != TheTitansNeoEntities.ZOMBIFIED_PIGLIN_TITAN_MINION.get() && entityType != TheTitansNeoEntities.GHAST_GUARD_MINION.get();
    }

    public int getExplosionPower() {
        return 3;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.GHAST_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.GHAST_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GHAST_DEATH;
    }

    public float getSoundVolume() {
        return 10.0f;
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (this.getMaster() != null) {
            this.getMaster().retractMinionNumFromType(this.getMinionType());
        }
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target == this) {
            return;
        }
        if (this.getMaster() != null && !this.getMaster().canAttackEntity((Entity)target, true)) {
            return;
        }
        super.setTarget(target);
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        Entity entity = damageSource.getEntity();
        if (this.isInvulnerable()) {
            return false;
        }
        if (entity instanceof EntityGhastGuardMinion || entity instanceof EntityZombifiedPiglinTitan) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.setTarget(livingEntity);
        }
        return super.hurt(damageSource, amount);
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    public void aiStep() {
        super.aiStep();
        if (this.getTarget() != null) {
            double d1 = this.getTarget().getX() - this.getX();
            double d2 = this.getTarget().getEyeY() - this.getEyeY();
            double d3 = this.getTarget().getZ() - this.getZ();
            double d4 = Math.sqrt(d1 * d1 + d3 * d3);
            float f1 = -((float)Mth.atan2((double)d2, (double)d4) * 180.0f / (float)Math.PI);
            float f2 = -((float)Mth.atan2((double)d1, (double)d3) * 180.0f / (float)Math.PI);
            this.setXRot(this.rotlerp(this.getXRot(), f1, 180.0f));
            if (!this.level().isClientSide()) {
                this.setYRot(this.rotlerp(this.getYRot(), f2, 180.0f));
                this.yBodyRot = this.getYRot();
            }
        }
        if (this.getMaster() != null) {
            if (this.getMaster().getTarget() != null) {
                this.setTarget(this.getMaster().getTarget());
            }
        } else {
            List entities = this.level().getEntitiesOfClass(EntityTitan.class, this.getBoundingBox().inflate(100.0, 100.0, 100.0));
            if (!entities.isEmpty()) {
                for (EntityTitan entity : entities) {
                    if (entity == null || !(entity instanceof EntityZombifiedPiglinTitan)) continue;
                    this.setMaster(entity);
                }
            }
        }
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource damageSource) {
        boolean flag;
        this.captureDrops(new ArrayList());
        boolean bl = flag = this.lastHurtByPlayerTime > 0;
        if (this.shouldDropLoot() && level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            int j;
            this.dropFromLootTable(damageSource, flag);
            this.dropCustomDeathLoot(level, damageSource, flag);
            int i = 0;
            Entity entity = damageSource.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                i = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(Enchantments.LOOTING), (ItemStack)player.getMainHandItem());
            }
            this.dropFewItems(flag, i);
            if (flag && (j = this.getRandom().nextInt(200) - i) < 5) {
                this.dropRareDrop(j <= 0 ? 1 : 0);
            }
        }
        this.dropEquipment();
        int reward = EventHooks.getExperienceDrop((LivingEntity)this, (Player)this.lastHurtByPlayer, (int)this.getExperienceReward(level, damageSource.getEntity()));
        ExperienceOrb.award((ServerLevel)((ServerLevel)this.level()), (Vec3)this.position(), (int)reward);
        Collection drops = this.captureDrops(null);
        if (!CommonHooks.onLivingDrops((LivingEntity)this, (DamageSource)damageSource, (Collection)drops, (this.lastHurtByPlayerTime > 0 ? 1 : 0) != 0)) {
            for (ItemEntity drop : drops) {
                this.level().addFreshEntity((Entity)drop);
            }
        }
    }
}

