/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.minion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.minion.EntityAIFindEntityNearestInjuredAlly;
import net.byAqua3.thetitansneo.entity.ai.minion.EntityAIFindMaster;
import net.byAqua3.thetitansneo.entity.ai.minion.EntityAIMeleeAttack;
import net.byAqua3.thetitansneo.entity.ai.minion.EntityAIRandomDoHurtTarget;
import net.byAqua3.thetitansneo.entity.ai.minion.skeleton.EntityAISkeletonTitanMinionBowAttack;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.minion.IMinion;
import net.byAqua3.thetitansneo.entity.projectile.EntityHarcadiumArrow;
import net.byAqua3.thetitansneo.entity.titan.EntitySkeletonTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoBlocks;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoDamageTypes;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoMobEffects;
import net.byAqua3.thetitansneo.loader.TheTitansNeoPredicateTargets;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;

public class EntitySkeletonTitanMinion
extends Skeleton
implements RangedAttackMob,
IMinion {
    private static final EntityDataAccessor<Integer> MINION_TYPE = SynchedEntityData.defineId(EntitySkeletonTitanMinion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final EntityAISkeletonTitanMinionBowAttack rangedBowAttackGoal = new EntityAISkeletonTitanMinionBowAttack(this, 1.2, 10, 40, 24.0f);
    public final EntityAIMeleeAttack meleeAttackGoal = new EntityAIMeleeAttack((PathfinderMob)this, 1.2, true){

        @Override
        public void stop() {
            super.stop();
            EntitySkeletonTitanMinion.this.setAggressive(false);
        }

        @Override
        public void start() {
            super.start();
            EntitySkeletonTitanMinion.this.setAggressive(true);
        }
    };
    public EntityTitan master;
    private LivingEntity entityToHeal;
    private int attackPattern;
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    public int deathTicks;
    public int randomSoundDelay;

    public EntitySkeletonTitanMinion(EntityType<? extends EntitySkeletonTitanMinion> entityType, Level level) {
        super(entityType, level);
        this.getNavigation().getNodeEvaluator().setCanOpenDoors(true);
        this.getNavigation().getNodeEvaluator().setCanPassDoors(true);
        this.getNavigation().getNodeEvaluator().setCanWalkOverFences(true);
        this.refreshAttributes();
        this.setHealth(this.getMaxHealth());
    }

    public EntitySkeletonTitanMinion(Level level) {
        this((EntityType<? extends EntitySkeletonTitanMinion>)((EntityType)TheTitansNeoEntities.SKELETON_TITAN_MINION.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Skeleton.createAttributes().add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof AvoidEntityGoal);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new BreakDoorGoal((Mob)this, difficulty -> true));
        this.goalSelector.addGoal(0, (Goal)new EntityAIFindMaster(this, 100.0, titan -> {
            EntitySkeletonTitan skeletonTitan;
            return titan instanceof EntitySkeletonTitan && (skeletonTitan = (EntitySkeletonTitan)titan).getSkeletonType() == 0;
        }));
        this.goalSelector.addGoal(0, (Goal)new EntityAIRandomDoHurtTarget(this));
        this.goalSelector.addGoal(0, (Goal)new EntityAIFindEntityNearestInjuredAlly(this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, TheTitansNeoPredicateTargets.SkeletonTitan));
        this.reassessWeaponGoal();
    }

    @Override
    public int getMinionTypeInt() {
        return (Integer)this.getEntityData().get(MINION_TYPE);
    }

    @Override
    public void setMinionType(int minionType) {
        this.getEntityData().set(MINION_TYPE, (Object)minionType);
        this.refreshAttributes();
    }

    @Override
    public EntityTitan getMaster() {
        return this.master;
    }

    @Override
    public void setMaster(EntityTitan master) {
        this.master = master;
    }

    @Override
    public LivingEntity getEntityToHeal() {
        return this.entityToHeal;
    }

    @Override
    public void setEntityToHeal(LivingEntity entityToHeal) {
        this.entityToHeal = entityToHeal;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MINION_TYPE, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setMinionType(tag.getInt("MinionType"));
        this.deathTicks = tag.getInt("DeathTicks");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("MinionType", this.getMinionTypeInt());
        tag.putInt("DeathTicks", this.deathTicks);
    }

    protected void dropRareDrop(int count) {
        this.spawnAtLocation((ItemLike)Items.SKELETON_SKULL, 1);
    }

    protected void dropFewItems(boolean attackedRecently, int loottingLevel) {
        int k;
        int j = this.getRandom().nextInt(3 + loottingLevel);
        for (k = 0; k < j; ++k) {
            this.spawnAtLocation((ItemLike)Items.BONE, 1);
        }
        j = this.getRandom().nextInt(5 + loottingLevel);
        for (k = 0; k < j; ++k) {
            this.spawnAtLocation((ItemLike)Items.BONE_MEAL, 1);
        }
        j = this.getRandom().nextInt(3 + loottingLevel);
        for (k = 0; k < j; ++k) {
            this.spawnAtLocation((ItemLike)Items.ARROW, 1);
        }
        if (this.getMinionTypeInt() >= 1) {
            j = this.getRandom().nextInt(2);
            if (loottingLevel > 0) {
                j += this.getRandom().nextInt(loottingLevel + 1);
            }
            for (k = 0; k < j; ++k) {
                this.spawnAtLocation((ItemLike)Items.EXPERIENCE_BOTTLE, 1);
            }
            if (this.getMinionTypeInt() >= 2) {
                j = this.getRandom().nextInt(2);
                if (loottingLevel > 0) {
                    j += this.getRandom().nextInt(loottingLevel + 1);
                }
                for (k = 0; k < j; ++k) {
                    this.spawnAtLocation((ItemLike)Items.GOLDEN_APPLE, 1);
                }
                if (this.getMinionTypeInt() >= 3) {
                    j = this.getRandom().nextInt(2);
                    if (loottingLevel > 0) {
                        j += this.getRandom().nextInt(loottingLevel + 1);
                    }
                    block17: for (k = 0; k < j; ++k) {
                        switch (this.getRandom().nextInt(5)) {
                            case 0: {
                                this.spawnAtLocation((ItemLike)Items.EMERALD, 1);
                                continue block17;
                            }
                            case 1: {
                                this.spawnAtLocation((ItemLike)Items.DIAMOND, 1);
                                continue block17;
                            }
                            case 2: {
                                this.spawnAtLocation((ItemLike)Items.GOLD_INGOT, 1);
                                continue block17;
                            }
                            case 3: {
                                this.spawnAtLocation((ItemLike)Items.GOLD_INGOT, 1);
                                continue block17;
                            }
                            case 4: {
                                this.spawnAtLocation((ItemLike)Items.GOLD_INGOT, 1);
                            }
                        }
                    }
                    if (this.getMinionTypeInt() >= 4) {
                        if (this.getRandom().nextInt(5) == 0) {
                            this.spawnAtLocation(new ItemStack((ItemLike)TheTitansNeoBlocks.PLEASANT_BLADE_SEED.get()), 0.0f);
                        }
                        if (this.getRandom().nextInt(100) == 0) {
                            this.spawnAtLocation(new ItemStack((ItemLike)TheTitansNeoBlocks.MALGRUM_SEEDS.get()), 0.0f);
                        }
                        j = 2 + this.getRandom().nextInt(5);
                        if (loottingLevel > 0) {
                            j += this.getRandom().nextInt(loottingLevel + 1);
                        }
                        block18: for (k = 0; k < j; ++k) {
                            switch (this.getRandom().nextInt(3)) {
                                case 0: {
                                    this.spawnAtLocation((ItemLike)Items.EMERALD, 1);
                                    continue block18;
                                }
                                case 1: {
                                    this.spawnAtLocation((ItemLike)Items.DIAMOND, 1);
                                    continue block18;
                                }
                                case 2: {
                                    this.spawnAtLocation((ItemLike)Items.GOLD_INGOT, 1);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).addOrReplacePermanentModifier(new AttributeModifier(RANDOM_SPAWN_BONUS_ID, this.getRandom().nextGaussian() * 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        this.getAttribute(Attributes.FOLLOW_RANGE).addOrReplacePermanentModifier(new AttributeModifier(RANDOM_SPAWN_BONUS_ID, this.getRandom().nextGaussian() * 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        this.setRandomMinionType();
        this.setHealth(this.getMaxHealth());
        return groupData;
    }

    public Component getName() {
        switch (this.getMinionType()) {
            case PRIEST: {
                return Component.translatable((String)"entity.thetitansneo.skeleton_priest");
            }
            case ZEALOT: {
                return Component.translatable((String)"entity.thetitansneo.skeleton_zealot");
            }
            case BISHOP: {
                return Component.translatable((String)"entity.thetitansneo.skeleton_bishop");
            }
            case TEMPLAR: {
                return Component.translatable((String)"entity.thetitansneo.skeleton_templar");
            }
        }
        return Component.translatable((String)"entity.thetitansneo.skeleton_loyalist");
    }

    public boolean fireImmune() {
        if (this.getMinionTypeInt() >= 3) {
            return true;
        }
        return super.fireImmune();
    }

    @Override
    public void refreshAttributes() {
        switch (this.getMinionType()) {
            case PRIEST: {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(40.0);
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(4.0);
                this.xpReward = 15;
                break;
            }
            case ZEALOT: {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(180.0);
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(10.0);
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.5);
                this.xpReward = 100;
                break;
            }
            case BISHOP: {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(400.0);
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(15.0);
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.375);
                this.xpReward = 200;
                break;
            }
            case TEMPLAR: {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(1800.0);
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(30.0);
                this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
                this.xpReward = 1000;
                break;
            }
            default: {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(26.0);
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(3.0);
                this.xpReward = 7;
            }
        }
    }

    public boolean canAttack(LivingEntity target) {
        if (this.getMaster() != null) {
            return this.getMaster().canAttack(target);
        }
        return target.canBeSeenByAnyone();
    }

    public boolean canAttackType(EntityType<?> entityType) {
        return entityType != TheTitansNeoEntities.SKELETON_TITAN.get() && entityType != TheTitansNeoEntities.SKELETON_TITAN_MINION.get();
    }

    public int getArmorValue() {
        int i = super.getArmorValue();
        switch (this.getMinionType()) {
            case PRIEST: {
                i += 2;
                break;
            }
            case ZEALOT: {
                i += 15;
                break;
            }
            case BISHOP: {
                i += 18;
                break;
            }
            case TEMPLAR: {
                i += 22;
                break;
            }
        }
        if (i > 24) {
            i = 24;
        }
        return i;
    }

    protected SoundEvent getAmbientSound() {
        if (this.getMinionType() == EnumMinionType.TEMPLAR) {
            return (SoundEvent)TheTitansNeoSounds.TITAN_SKELETON_LIVING.get();
        }
        return SoundEvents.SKELETON_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        if (this.getMinionType() == EnumMinionType.TEMPLAR) {
            return (SoundEvent)TheTitansNeoSounds.TITAN_SKELETON_GRUNT.get();
        }
        return SoundEvents.SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        if (this.getMinionType() == EnumMinionType.TEMPLAR) {
            return (SoundEvent)TheTitansNeoSounds.TITAN_SKELETON_DEATH.get();
        }
        return SoundEvents.SKELETON_DEATH;
    }

    public float getVoicePitch() {
        if (this.getMinionType() == EnumMinionType.TEMPLAR) {
            return super.getVoicePitch() + 0.3f;
        }
        return super.getVoicePitch();
    }

    protected float getDamageAfterMagicAbsorb(DamageSource damageSource, float damage) {
        damage = super.getDamageAfterMagicAbsorb(damageSource, damage);
        if (this.getMinionType() == EnumMinionType.TEMPLAR) {
            if (damageSource.getEntity() == this) {
                damage = 0.0f;
            }
            if (damageSource.is(DamageTypeTags.WITCH_RESISTANT_TO)) {
                damage *= 0.15f;
            }
        }
        return damage;
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (this.getMaster() != null) {
            this.getMaster().retractMinionNumFromType(this.getMinionType());
        }
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target == this) {
            return;
        }
        if (this.getMaster() != null && !this.getMaster().canAttackEntity((Entity)target, true)) {
            return;
        }
        super.setTarget(target);
    }

    public void reassessWeaponGoal() {
        if (this.meleeAttackGoal == null || this.rangedBowAttackGoal == null) {
            return;
        }
        if (this.level() != null && !this.level().isClientSide()) {
            this.goalSelector.removeGoal((Goal)this.meleeAttackGoal);
            this.goalSelector.removeGoal((Goal)this.rangedBowAttackGoal);
            ItemStack itemstack = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            if (itemstack.is(Items.BOW)) {
                this.goalSelector.addGoal(3, (Goal)this.rangedBowAttackGoal);
            } else {
                this.goalSelector.addGoal(3, (Goal)this.meleeAttackGoal);
            }
        }
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity) && entity instanceof LivingEntity && this.getMinionTypeInt() >= 3) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int i = 10;
            if (this.level().getDifficulty() == Difficulty.NORMAL) {
                i = 20;
            } else if (this.level().getDifficulty() == Difficulty.HARD) {
                i = 30;
            }
            if (i > 0) {
                livingEntity.addEffect(new MobEffectInstance(TheTitansNeoMobEffects.ELECTRIC_JUDGMENT, i * 20, 0));
            }
            return true;
        }
        return false;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        Entity entity = damageSource.getEntity();
        if (this.isInvulnerable() || this.getMinionType() == EnumMinionType.TEMPLAR && damageSource.is(TheTitansNeoDamageTypes.RADIATION)) {
            return false;
        }
        if (entity instanceof EntitySkeletonTitanMinion || entity instanceof EntitySkeletonTitan) {
            return false;
        }
        if (entity != null && this.xxa == 0.0f && this.getMinionType() == EnumMinionType.ZEALOT) {
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 1.0f, 2.0f);
            switch (this.getRandom().nextInt(3)) {
                case 0: {
                    this.zza = -2.0f;
                    this.moveRelative(0.99f, new Vec3(0.0, 0.0, -2.0));
                    this.xxa = 0.01f;
                    break;
                }
                case 1: {
                    this.xxa = 1.0f;
                    this.moveRelative(0.25f, new Vec3(1.0, 0.0, 0.0));
                    break;
                }
                case 2: {
                    this.xxa = -1.0f;
                    this.moveRelative(0.25f, new Vec3(-1.0, 0.0, 0.0));
                }
            }
            this.jumpFromGround();
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 32.0, 32.0));
            for (Entity entity1 : entities) {
                if (entity1 instanceof EntitySkeletonTitanMinion) {
                    EntitySkeletonTitanMinion skeletonTitanMinion = (EntitySkeletonTitanMinion)entity1;
                    skeletonTitanMinion.setTarget(livingEntity);
                    skeletonTitanMinion.randomSoundDelay = this.getRandom().nextInt(40);
                }
                this.setTarget(livingEntity);
                this.randomSoundDelay = this.getRandom().nextInt(40);
            }
        }
        return super.hurt(damageSource, amount);
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        if (this.getMinionType() == EnumMinionType.TEMPLAR) {
            this.xxa = 0.0f;
            this.zza = 0.0f;
            return false;
        }
        return super.causeFallDamage(fallDistance, multiplier, damageSource);
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        if (this.getMinionType() == EnumMinionType.TEMPLAR) {
            if (this.distanceToSqr((Entity)target) < (double)(target.getBbWidth() * target.getBbWidth()) + 36.0) {
                this.doHurtTarget((Entity)target);
            } else {
                int randomInt = this.getRandom().nextInt(5);
                if (randomInt == 0) {
                    this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                    ItemStack weapon = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
                    ItemStack itemstack1 = this.getProjectile(weapon);
                    AbstractArrow abstractArrow = this.getArrow(itemstack1, velocity, weapon);
                    Item item2 = weapon.getItem();
                    if (item2 instanceof ProjectileWeaponItem) {
                        ProjectileWeaponItem weaponItem = (ProjectileWeaponItem)item2;
                        abstractArrow = weaponItem.customArrow(abstractArrow, itemstack1, weapon);
                    }
                    double d0 = target.getX() - this.getX();
                    double d1 = target.getY(0.3333333333333333) - this.getY() - (double)this.getEyeHeight();
                    double d2 = target.getZ() - this.getZ();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                    abstractArrow.setOwner((Entity)this);
                    abstractArrow.setPos(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ());
                    abstractArrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
                    abstractArrow.setCritArrow(true);
                    abstractArrow.setBaseDamage((double)(velocity * 2.0f) + this.getRandom().nextGaussian() * 0.25 + (double)((float)this.level().getDifficulty().getId() * 0.11f));
                    if (!this.level().isClientSide()) {
                        this.level().addFreshEntity((Entity)abstractArrow);
                    }
                } else if (randomInt == 1) {
                    ThrownPotion thrownPotion = new ThrownPotion(this.level(), (LivingEntity)this);
                    ItemStack itemStack = PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.HARMING);
                    thrownPotion.setItem(itemStack);
                    if (target.getType().is(EntityTypeTags.UNDEAD)) {
                        itemStack = PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.HEALING);
                        thrownPotion.setItem(itemStack);
                    }
                    thrownPotion.setXRot(thrownPotion.getXRot() + 20.0f);
                    double d0 = target.getX() + target.getDeltaMovement().x - this.getX();
                    double d1 = target.getX() + 0.5 - this.getY();
                    double d2 = target.getZ() + target.getDeltaMovement().z - this.getZ();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                    thrownPotion.setPos(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ());
                    thrownPotion.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(d3 / 20.0));
                    if (!this.level().isClientSide()) {
                        this.level().addFreshEntity((Entity)thrownPotion);
                    }
                } else if (randomInt == 2) {
                    double d0 = target.getX() - this.getX();
                    double d1 = target.getBoundingBox().minY + (double)(target.getBbHeight() / 2.0f) - this.getY() + (double)(target.getBbHeight() / 2.0f);
                    double d2 = target.getZ() - this.getZ();
                    double d3 = Math.sqrt(Math.sqrt(this.distanceToSqr((Entity)target))) * 0.1;
                    if (!this.isSilent()) {
                        this.level().levelEvent(null, 1018, this.blockPosition(), 0);
                    }
                    SmallFireball smallFireball = new SmallFireball(this.level(), (LivingEntity)this, new Vec3(d0 + this.getRandom().nextGaussian() * d3, d1, d2 + this.getRandom().nextGaussian() * d3));
                    smallFireball.setPos(this.getX(), this.getY() + 1.6, this.getZ());
                    if (!this.level().isClientSide()) {
                        this.level().addFreshEntity((Entity)smallFireball);
                    }
                } else if (randomInt == 3) {
                    this.playSound(SoundEvents.SKELETON_DEATH, 1.0f, 0.5f);
                    this.level().playLocalSound(target.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.WEATHER, 4.0f, (1.0f + (this.level().getRandom().nextFloat() - this.level().getRandom().nextFloat()) * 0.2f) * 0.7f, false);
                    for (int i = 0; i < 256; ++i) {
                        ItemEntity itemEntity = new ItemEntity(this.level(), target.getX(), target.getY(), target.getZ(), new ItemStack((ItemLike)Items.BONE));
                        itemEntity.setPickUpDelay(6000);
                        itemEntity.lifespan = 40 + this.getRandom().nextInt(20);
                        itemEntity.push(0.0, 1.0, 0.0);
                        if (this.level().isClientSide()) continue;
                        this.level().addFreshEntity((Entity)itemEntity);
                    }
                    if (!this.level().isClientSide()) {
                        target.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 2));
                    }
                    target.hurt(this.damageSources().wither(), 5.0f);
                    target.invulnerableTime = 1;
                } else if (randomInt == 4) {
                    this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                    EntityHarcadiumArrow arrow = new EntityHarcadiumArrow(this.level());
                    double d0 = target.getX() - this.getX();
                    double d1 = target.getY(0.3333333333333333) - this.getY() - (double)this.getEyeHeight();
                    double d2 = target.getZ() - this.getZ();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                    arrow.setOwner((Entity)this);
                    arrow.setPos(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ());
                    arrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
                    arrow.setCritArrow(true);
                    if (!this.level().isClientSide()) {
                        this.level().addFreshEntity((Entity)arrow);
                    }
                }
            }
        } else {
            super.performRangedAttack(target, velocity);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.randomSoundDelay > 0 && this.randomSoundDelay-- == 0) {
            this.playSound(this.getHurtSound(null), this.getSoundVolume(), this.getVoicePitch() + 0.25f);
        }
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource damageSource) {
        Collection drops;
        boolean flag;
        if (this.getMinionType() == EnumMinionType.TEMPLAR && this.deathTicks <= 0) {
            return;
        }
        this.captureDrops(new ArrayList());
        boolean bl = flag = this.lastHurtByPlayerTime > 0;
        if (this.shouldDropLoot() && level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            int j;
            this.dropFromLootTable(damageSource, flag);
            this.dropCustomDeathLoot(level, damageSource, flag);
            int i = 0;
            Entity entity = damageSource.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                i = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(Enchantments.LOOTING), (ItemStack)player.getMainHandItem());
            }
            this.dropFewItems(flag, i);
            if (flag && (j = this.getRandom().nextInt(200) - i) < 5) {
                this.dropRareDrop(j <= 0 ? 1 : 0);
            }
        }
        this.dropEquipment();
        if (this.getMinionType() != EnumMinionType.TEMPLAR || this.getMinionType() == EnumMinionType.TEMPLAR && this.deathTicks == 200) {
            int reward = EventHooks.getExperienceDrop((LivingEntity)this, (Player)this.lastHurtByPlayer, (int)this.getExperienceReward(level, damageSource.getEntity()));
            ExperienceOrb.award((ServerLevel)((ServerLevel)this.level()), (Vec3)this.position(), (int)reward);
        }
        if (!CommonHooks.onLivingDrops((LivingEntity)this, (DamageSource)damageSource, (Collection)(drops = this.captureDrops(null)), (this.lastHurtByPlayerTime > 0 ? 1 : 0) != 0)) {
            for (ItemEntity drop : drops) {
                this.level().addFreshEntity((Entity)drop);
            }
        }
    }

    protected void tickDeath() {
        if (this.getMinionType() == EnumMinionType.TEMPLAR) {
            this.deathTime = 0;
            --this.tickCount;
            ++this.deathTicks;
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.move(MoverType.SELF, new Vec3(0.0, 0.1, 0.0));
            if (this.getMaster() != null) {
                double mx = this.getX() - this.getMaster().getX();
                double my = this.getY() + (double)(this.getBbHeight() / 2.0f) - (this.getMaster().getY() + (double)(this.getMaster().getBbHeight() / 2.0f));
                double mz = this.getZ() - this.getMaster().getZ();
                int particleCount = (int)(this.distanceTo((Entity)this.getMaster()) * 2.0f);
                for (int i = 0; i < particleCount; ++i) {
                    double d9 = (double)i / ((double)particleCount - 1.0);
                    double d6 = this.getX() + mx * -d9;
                    double d7 = this.getY() + (double)this.getEyeHeight() + my * -d9;
                    double d8 = this.getZ() + mz * -d9;
                    this.level().addParticle((ParticleOptions)ParticleTypes.FIREWORK, d6, d7, d8, this.getMaster().getDeltaMovement().x, this.getMaster().getDeltaMovement().y + 0.2, this.getMaster().getDeltaMovement().z);
                }
            }
            if (this.deathTicks == 1 && !this.isSilent()) {
                this.level().globalLevelEvent(1028, this.blockPosition(), 0);
            }
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0 && !this.level().isClientSide()) {
                this.dropAllDeathLoot((ServerLevel)this.level(), this.damageSources().generic());
            }
            if (this.deathTicks >= 180 && this.deathTicks <= 200) {
                float f3 = (this.getRandom().nextFloat() - 0.5f) * this.getBbWidth();
                float f4 = (this.getRandom().nextFloat() - 0.5f) * this.getBbHeight();
                float f5 = (this.getRandom().nextFloat() - 0.5f) * this.getBbWidth();
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX() + (double)f3, this.getY() + (double)this.getEyeHeight() + (double)f4, this.getZ() + (double)f5, 0.0, 0.0, 0.0);
            }
            float f = (this.getRandom().nextFloat() - 0.5f) * this.getBbWidth();
            float f1 = (this.getRandom().nextFloat() - 0.5f) * this.getBbHeight();
            float f2 = (this.getRandom().nextFloat() - 0.5f) * this.getBbWidth();
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + (double)this.getEyeHeight() + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, this.getX() + (double)f, this.getY() + (double)this.getEyeHeight() + (double)f1, this.getZ() + (double)f2, this.getRandom().nextGaussian(), this.getRandom().nextGaussian(), this.getRandom().nextGaussian());
            if (this.deathTicks == 200) {
                if (this.getMaster() != null) {
                    this.getMaster().heal(this.getMaster().getMaxHealth() / 100.0f);
                    for (int j = 0; j < 100; ++j) {
                        double d2 = this.getRandom().nextGaussian() * 0.02;
                        double d0 = this.getRandom().nextGaussian() * 0.02;
                        double d1 = this.getRandom().nextGaussian() * 0.02;
                        this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getMaster().getX() + (double)(this.getRandom().nextFloat() * this.getMaster().getBbWidth() * 2.0f) - (double)this.getMaster().getBbWidth(), this.getMaster().getY() + (double)(this.getRandom().nextFloat() * this.getMaster().getBbHeight()), this.getMaster().getZ() + (double)(this.getRandom().nextFloat() * this.getMaster().getBbWidth() * 2.0f) - (double)this.getMaster().getBbWidth(), d2, d0, d1);
                    }
                }
                if (!this.level().isClientSide() && !this.isRemoved()) {
                    this.dropAllDeathLoot((ServerLevel)this.level(), this.damageSources().generic());
                    this.level().broadcastEntityEvent((Entity)this, (byte)60);
                    this.remove(Entity.RemovalReason.KILLED);
                }
            }
        } else {
            super.tickDeath();
        }
    }

    public void tick() {
        block28: {
            block30: {
                EntitySkeletonTitanMinion skeletonTitanMinion;
                block29: {
                    block27: {
                        super.tick();
                        if (this.getMinionType() != EnumMinionType.PRIEST) break block27;
                        if (this.getEntityToHeal() != null && this.tickCount % 40 == 0) {
                            this.playSound(SoundEvents.WITHER_SHOOT, 1.0f, 3.0f);
                            if (this.getEntityToHeal().getHealth() < this.getEntityToHeal().getMaxHealth()) {
                                this.swing(InteractionHand.MAIN_HAND);
                                this.lookAt((Entity)this.getEntityToHeal(), 180.0f, this.getHeadRotSpeed());
                                this.getEntityToHeal().heal(4.0f);
                            } else {
                                this.setEntityToHeal(null);
                            }
                        }
                        break block28;
                    }
                    if (this.getMinionType() != EnumMinionType.ZEALOT) break block29;
                    if (this.getTarget() == null) break block28;
                    double d0 = this.distanceToSqr((Entity)this.getTarget());
                    if (d0 < 4.0) {
                        this.doHurtTarget((Entity)this.getTarget());
                    }
                    if (!this.onGround() || !(d0 < 256.0) || !(this.getTarget().getY() > this.getY() + 3.0) || this.getRandom().nextInt(40) != 0) break block28;
                    this.lookAt((Entity)this.getTarget(), 180.0f, 180.0f);
                    this.addEffect(new MobEffectInstance(MobEffects.JUMP, 60, 7));
                    double d01 = this.getTarget().getX() - this.getX();
                    double d1 = this.getTarget().getZ() - this.getZ();
                    float f2 = (float)Math.sqrt(d01 * d01 + d1 * d1);
                    this.jumpFromGround();
                    this.setDeltaMovement(d01 / (double)f2 * 0.75 * 0.75 + this.getDeltaMovement().x * 0.75, this.getDeltaMovement().y, d1 / (double)f2 * 0.75 * 0.75 + this.getDeltaMovement().z * 0.75);
                    break block28;
                }
                if (this.getMinionType() != EnumMinionType.BISHOP) break block30;
                if (this.getMaster() != null || !this.isAlive() || this.level().isClientSide() || this.level().getDifficulty() == Difficulty.PEACEFUL) break block28;
                float randomRate = this.getRandom().nextFloat() * 100.0f;
                if ((double)randomRate < (Double)TheTitansNeoConfigs.bishopSummonMinionSpawnRate.get()) {
                    skeletonTitanMinion = new EntitySkeletonTitanMinion(this.level());
                    skeletonTitanMinion.setPos(this.getX(), this.getY(), this.getZ());
                    skeletonTitanMinion.setYRot(this.getYRot());
                    skeletonTitanMinion.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(skeletonTitanMinion.blockPosition()), MobSpawnType.SPAWNER, null);
                    skeletonTitanMinion.setMinionType(0);
                    skeletonTitanMinion.setHealth(skeletonTitanMinion.getMaxHealth());
                    this.level().addFreshEntity((Entity)skeletonTitanMinion);
                }
                if (!((double)(randomRate = this.getRandom().nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.bishopSummonPriestSpawnRate.get())) break block28;
                skeletonTitanMinion = new EntitySkeletonTitanMinion(this.level());
                skeletonTitanMinion.setPos(this.getX(), this.getY(), this.getZ());
                skeletonTitanMinion.setYRot(this.getYRot());
                skeletonTitanMinion.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(skeletonTitanMinion.blockPosition()), MobSpawnType.SPAWNER, null);
                skeletonTitanMinion.setMinionType(1);
                skeletonTitanMinion.setHealth(skeletonTitanMinion.getMaxHealth());
                this.level().addFreshEntity((Entity)skeletonTitanMinion);
                break block28;
            }
            if (this.getMinionType() == EnumMinionType.TEMPLAR) {
                List entities;
                if (this.tickCount % 40 == 0) {
                    this.heal(1.0f);
                }
                if (this.level().getRandom().nextInt(150) == 1) {
                    this.heal(2.0f);
                }
                if (this.level().getRandom().nextInt(100) == 1 && (double)this.getHealth() < (double)this.getMaxHealth() * 0.75) {
                    this.heal(2.0f);
                }
                if (this.level().getRandom().nextInt(35) == 1 && (double)this.getHealth() < (double)this.getMaxHealth() * 0.5) {
                    this.heal(5.0f);
                }
                if (this.level().getRandom().nextInt(30) == 1 && (double)this.getHealth() < (double)this.getMaxHealth() * 0.25) {
                    this.heal(5.0f);
                }
                if (this.level().getRandom().nextInt(30) == 1 && (double)this.getHealth() < (double)this.getMaxHealth() * 0.05) {
                    this.heal(200.0f);
                }
                if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * 0.6, this.getDeltaMovement().z);
                }
                if (this.getMaster() == null && this.getHealth() > 0.0f && !this.level().isClientSide() && this.level().getDifficulty() != Difficulty.PEACEFUL) {
                    EntitySkeletonTitanMinion skeletonTitanMinion;
                    float randomRate = this.getRandom().nextFloat() * 100.0f;
                    if ((double)randomRate < (Double)TheTitansNeoConfigs.templarSummonMinionSpawnRate.get()) {
                        skeletonTitanMinion = new EntitySkeletonTitanMinion(this.level());
                        skeletonTitanMinion.setPos(this.getX(), this.getY(), this.getZ());
                        skeletonTitanMinion.setYRot(this.getYRot());
                        skeletonTitanMinion.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(skeletonTitanMinion.blockPosition()), MobSpawnType.SPAWNER, null);
                        skeletonTitanMinion.setMinionType(0);
                        skeletonTitanMinion.setHealth(skeletonTitanMinion.getMaxHealth());
                        this.level().addFreshEntity((Entity)skeletonTitanMinion);
                    }
                    if ((double)(randomRate = this.getRandom().nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.templarSummonPriestSpawnRate.get()) {
                        skeletonTitanMinion = new EntitySkeletonTitanMinion(this.level());
                        skeletonTitanMinion.setPos(this.getX(), this.getY(), this.getZ());
                        skeletonTitanMinion.setYRot(this.getYRot());
                        skeletonTitanMinion.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(skeletonTitanMinion.blockPosition()), MobSpawnType.SPAWNER, null);
                        skeletonTitanMinion.setMinionType(1);
                        skeletonTitanMinion.setHealth(skeletonTitanMinion.getMaxHealth());
                        this.level().addFreshEntity((Entity)skeletonTitanMinion);
                    }
                    if ((double)(randomRate = this.getRandom().nextFloat() * 100.0f) < (Double)TheTitansNeoConfigs.templarSummonZealotSpawnRate.get()) {
                        skeletonTitanMinion = new EntitySkeletonTitanMinion(this.level());
                        skeletonTitanMinion.setPos(this.getX(), this.getY(), this.getZ());
                        skeletonTitanMinion.setYRot(this.getYRot());
                        skeletonTitanMinion.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(skeletonTitanMinion.blockPosition()), MobSpawnType.SPAWNER, null);
                        skeletonTitanMinion.setMinionType(2);
                        skeletonTitanMinion.setHealth(skeletonTitanMinion.getMaxHealth());
                        this.level().addFreshEntity((Entity)skeletonTitanMinion);
                    }
                }
                if (!this.onGround()) {
                    for (int i = 0; i < 3; ++i) {
                        this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY(), this.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
                    }
                } else {
                    this.hasImpulse = false;
                }
                if (this.getTarget() != null && this.getRandom().nextInt(60) == 0) {
                    this.attackPattern = !this.onGround() ? 0 : 1;
                }
                --this.heightOffsetUpdateTime;
                if (this.heightOffsetUpdateTime <= 0) {
                    this.jumpFromGround();
                    this.heightOffsetUpdateTime = 100;
                    this.heightOffset = 0.5f + this.getRandom().nextFloat() * 3.0f;
                    this.attackPattern = 0;
                }
                if (this.attackPattern == 0 && this.getTarget() != null) {
                    if (this.getTarget().getY() + (double)this.getTarget().getEyeHeight() > this.getY() + (double)this.getEyeHeight() + (double)this.heightOffset) {
                        this.push(0.0, 0.4 - this.getDeltaMovement().y, 0.0);
                        this.hasImpulse = true;
                    }
                    this.getLookControl().setLookAt((Entity)this.getTarget(), 180.0f, 40.0f);
                    double d0 = this.getTarget().getX() - this.getX();
                    double d1 = this.getTarget().getZ() - this.getZ();
                    double d3 = d0 * d0 + d1 * d1;
                    if (d3 > (double)(this.getTarget().getBbWidth() * this.getTarget().getBbWidth() + this.getBbWidth() * this.getBbWidth()) + 16.0) {
                        double d5 = Math.sqrt(d3);
                        this.push(d0 / d5 * 0.6 - this.getDeltaMovement().y, 0.0, d1 / d5 * 0.6 - this.getDeltaMovement().z);
                    }
                }
                if (!(entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(8.0, 8.0, 8.0))).isEmpty() && !this.level().isClientSide() && this.isAlive() && this.tickCount % (this.getHealth() < this.getMaxHealth() / 2.0f ? 40 : 160) == 0) {
                    this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 8.0f, false, Level.ExplosionInteraction.MOB);
                    for (Entity entity : entities) {
                        LivingEntity liviingEntity;
                        if (entity == null || !(entity instanceof LivingEntity) || !this.canAttack(liviingEntity = (LivingEntity)entity)) continue;
                        liviingEntity.push(0.0, this.getRandom().nextDouble(), 0.0);
                        liviingEntity.addEffect(new MobEffectInstance(TheTitansNeoMobEffects.ELECTRIC_JUDGMENT, 10, 1));
                    }
                }
            }
        }
    }
}

