/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.minion;

import java.util.List;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.minion.IMinion;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityWitherzilla;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoPredicateTargets;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityWitherzillaMinion
extends WitherBoss
implements IMinion {
    private static final EntityDataAccessor<Integer> MINION_TYPE = SynchedEntityData.defineId(EntityWitherzillaMinion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public EntityTitan master;

    public EntityWitherzillaMinion(EntityType<? extends EntityWitherzillaMinion> entityType, Level level) {
        super(entityType, level);
        this.bossEvent.setVisible(false);
        this.xpReward = 20;
    }

    public EntityWitherzillaMinion(Level level) {
        this((EntityType<? extends EntityWitherzillaMinion>)((EntityType)TheTitansNeoEntities.WITHERZILLA_MINION.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WitherBoss.createAttributes().add(Attributes.MAX_HEALTH, 300.0).add(Attributes.MOVEMENT_SPEED, 0.6).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof AvoidEntityGoal);
        this.goalSelector.removeAllGoals(goal -> goal instanceof RangedAttackGoal);
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 64.0f));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, TheTitansNeoPredicateTargets.Witherzilla));
    }

    @Override
    public int getMinionTypeInt() {
        return (Integer)this.getEntityData().get(MINION_TYPE);
    }

    @Override
    public void setMinionType(int minionType) {
        this.getEntityData().set(MINION_TYPE, (Object)minionType);
        this.refreshAttributes();
    }

    @Override
    public EntityTitan getMaster() {
        return this.master;
    }

    @Override
    public void setMaster(EntityTitan master) {
        this.master = master;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MINION_TYPE, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setMinionType(tag.getInt("MinionType"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("MinionType", this.getMinionTypeInt());
    }

    private double getHeadX(int head) {
        if (head <= 0) {
            return this.getX();
        }
        float f = (this.yBodyRot + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.cos((float)f);
        return this.getX() + (double)f1 * 1.3 * (double)this.getScale();
    }

    private double getHeadY(int head) {
        float f = head <= 0 ? 3.0f : 2.2f;
        return this.getY() + (double)(f * this.getScale());
    }

    private double getHeadZ(int head) {
        if (head <= 0) {
            return this.getZ();
        }
        float f = (this.yBodyRot + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.sin((float)f);
        return this.getZ() + (double)f1 * 1.3 * (double)this.getScale();
    }

    @Override
    public EnumMinionType getMinionType() {
        return EnumMinionType.LOYALIST;
    }

    public boolean canAttackType(EntityType<?> entityType) {
        return entityType != TheTitansNeoEntities.WITHERZILLA.get() && entityType != TheTitansNeoEntities.WITHER_SKELETON_TITAN_MINION.get() && entityType != TheTitansNeoEntities.WITHER_TURRET.get() && entityType != TheTitansNeoEntities.WITHER_TURRET_GROUND.get() && entityType != TheTitansNeoEntities.WITHER_TURRET_MORTAR.get();
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean canAttack(LivingEntity target) {
        if (this.getMaster() != null) {
            return this.getMaster().canAttack(target);
        }
        return target.canBeSeenByAnyone();
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.WITHER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WITHER_DEATH;
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (this.getMaster() != null) {
            this.getMaster().retractMinionNumFromType(this.getMinionType());
        }
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target == this) {
            return;
        }
        if (this.getMaster() != null && !this.getMaster().canAttackEntity((Entity)target, true)) {
            return;
        }
        super.setTarget(target);
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        Entity entity = damageSource.getEntity();
        if (this.isInvulnerable()) {
            return false;
        }
        if (entity instanceof EntityWitherzillaMinion || entity instanceof EntityWitherzilla) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 32.0, 32.0));
            for (Entity entity1 : entities) {
                if (entity1 instanceof EntityWitherzillaMinion) {
                    EntityWitherzillaMinion witherzillaMinion = (EntityWitherzillaMinion)entity1;
                    witherzillaMinion.setTarget(livingEntity);
                    for (int i = 0; i < 3; ++i) {
                        witherzillaMinion.setAlternativeTarget(i, livingEntity.getId());
                    }
                }
                this.setTarget(livingEntity);
                for (int i = 0; i < 3; ++i) {
                    this.setAlternativeTarget(i, livingEntity.getId());
                }
            }
        }
        return super.hurt(damageSource, amount);
    }

    public void performRangedAttack(int head, double x, double y, double z, boolean isDangerous) {
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1024, this.blockPosition(), 0);
        }
        double d0 = this.getHeadX(head);
        double d1 = this.getHeadY(head);
        double d2 = this.getHeadZ(head);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        Vec3 vec3 = new Vec3(d3, d4, d5);
        WitherSkull witherskull = new WitherSkull(this.level(), (LivingEntity)this, vec3.normalize());
        witherskull.setOwner((Entity)this);
        if (isDangerous) {
            witherskull.setDangerous(true);
        }
        witherskull.setPosRaw(d0, d1, d2);
        this.level().addFreshEntity((Entity)witherskull);
    }

    public void performRangedAttack(int head, LivingEntity target) {
        this.performRangedAttack(head, target.getX(), target.getY() + (double)target.getEyeHeight() * 0.5, target.getZ(), head == 0 && this.getRandom().nextFloat() < 0.001f);
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        this.performRangedAttack(0, target);
    }

    public void aiStep() {
        block4: {
            block2: {
                block3: {
                    super.aiStep();
                    if (this.getMaster() == null) break block2;
                    if (this.getMaster().getTarget() == null) break block3;
                    this.setTarget(this.getMaster().getTarget());
                    break block4;
                }
                if (!(this.distanceToSqr((Entity)this.getMaster()) > 10000.0)) break block4;
                this.getMoveControl().setWantedPosition(this.getMaster().getX(), this.getMaster().getY(), this.getMaster().getZ(), 2.0);
                break block4;
            }
            List entities = this.level().getEntitiesOfClass(EntityTitan.class, this.getBoundingBox().inflate(256.0, 256.0, 256.0));
            if (!entities.isEmpty()) {
                for (EntityTitan entity : entities) {
                    if (entity == null || !(entity instanceof EntityWitherzilla)) continue;
                    this.setMaster(entity);
                }
            }
        }
    }
}

