/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.minion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.minion.EntityZombieTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.minion.IMinion;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityZombieTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityZombifiedPiglinTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoPredicateTargets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;

public class EntityZombieTitanGiantMinion
extends Giant
implements IMinion {
    private static final EntityDataAccessor<Integer> MINION_TYPE = SynchedEntityData.defineId(EntityZombieTitanGiantMinion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public EntityTitan master;

    public EntityZombieTitanGiantMinion(EntityType<? extends EntityZombieTitanGiantMinion> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 1000;
        this.setPersistenceRequired();
    }

    public EntityZombieTitanGiantMinion(Level level) {
        this((EntityType<? extends EntityZombieTitanGiantMinion>)((EntityType)TheTitansNeoEntities.ZOMBIE_TITAN_GIANT_MINION.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Giant.createAttributes().add(Attributes.MAX_HEALTH, 2000.0).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.STEP_HEIGHT, 3.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof AvoidEntityGoal);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, TheTitansNeoPredicateTargets.ZombieTitan));
    }

    @Override
    public int getMinionTypeInt() {
        return (Integer)this.getEntityData().get(MINION_TYPE);
    }

    @Override
    public void setMinionType(int minionType) {
        this.getEntityData().set(MINION_TYPE, (Object)minionType);
        this.refreshAttributes();
    }

    @Override
    public EntityTitan getMaster() {
        return this.master;
    }

    @Override
    public void setMaster(EntityTitan master) {
        this.master = master;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MINION_TYPE, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setMinionType(tag.getInt("MinionType"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("MinionType", this.getMinionTypeInt());
    }

    private LivingEntity doJumpDamage(double x, double y, double z, double dist, double damage, int knockback) {
        AABB bb = AABB.ofSize((Vec3)new Vec3(x - dist, y - 10.0, z - dist), (double)(x + dist), (double)(y + 10.0), (double)(z + dist));
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, bb, (Predicate)TheTitansNeoPredicateTargets.ZombieTitan);
        Collections.sort(entities, new TargetingSorter(this, (Entity)this));
        for (LivingEntity entity : entities) {
            if (entity == null || entity == this || !entity.isAlive() || entity instanceof EntityZombieTitan || entity instanceof EntityZombieTitanMinion || entity instanceof EntityZombieTitanGiantMinion) continue;
            entity.hurt(this.damageSources().explosion(null), (float)damage);
            entity.hurt(this.damageSources().fall(), (float)damage / 4.0f);
            this.level().playSound((Entity)entity, entity.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.MASTER, 0.85f, 1.0f + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.5f);
            if (knockback == 0) continue;
            double ks = 0.75 + this.getRandom().nextDouble() + this.getRandom().nextDouble();
            double inair = 0.75;
            float f3 = (float)Math.atan2(entity.getZ() - this.getZ(), entity.getX() - this.getX());
            entity.push(Math.cos(f3) * ks, inair, Math.sin(f3) * ks);
            if (this.getRandom().nextInt(5) != 0) continue;
            entity.invulnerableTime = 0;
        }
        return null;
    }

    protected void dropRareDrop(int count) {
    }

    protected void dropFewItems(boolean attackedRecently, int loottingLevel) {
        int k;
        int j = this.getRandom().nextInt(13) + this.getRandom().nextInt(1 + loottingLevel);
        for (k = 0; k < j; ++k) {
            this.spawnAtLocation((ItemLike)Items.FEATHER, 1);
        }
        j = this.getRandom().nextInt(13) + this.getRandom().nextInt(2 + loottingLevel);
        for (k = 0; k < j; ++k) {
            this.spawnAtLocation((ItemLike)Items.ROTTEN_FLESH, 1);
        }
        if (attackedRecently) {
            if (this.getRandom().nextInt(5) == 0 || this.getRandom().nextInt(1 + loottingLevel) > 0) {
                this.spawnAtLocation((ItemLike)Items.IRON_INGOT, 1);
            }
            if (this.getRandom().nextInt(5) == 0 || this.getRandom().nextInt(1 + loottingLevel) > 0) {
                this.spawnAtLocation((ItemLike)Items.CARROT, 1);
            }
            if (this.getRandom().nextInt(5) == 0 || this.getRandom().nextInt(1 + loottingLevel) > 0) {
                this.spawnAtLocation((ItemLike)Items.POTATO, 1);
            }
        }
    }

    @Override
    public EnumMinionType getMinionType() {
        return EnumMinionType.SPECIAL;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean canAttack(LivingEntity target) {
        if (this.getMaster() != null) {
            return this.getMaster().canAttack(target);
        }
        return target.canBeSeenByAnyone();
    }

    public boolean canAttackType(EntityType<?> entityType) {
        return entityType != TheTitansNeoEntities.ZOMBIE_TITAN.get() && entityType != TheTitansNeoEntities.ZOMBIE_TITAN_MINION.get() && entityType != TheTitansNeoEntities.ZOMBIE_TITAN_GIANT_MINION.get();
    }

    public int getArmorValue() {
        return 20;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return -this.level().getPathfindingCostFromLightLevels(pos);
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ZOMBIE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_DEATH;
    }

    public float getSoundVolume() {
        return 7.0f;
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.1f + 1.0f : (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.1f + 0.5f;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.IRON_GOLEM_STEP, 2.0f, 0.9f);
        double dx = this.getX() + 4.0 * -Math.sin(Math.toRadians(this.yBodyRot));
        double dz = this.getZ() - 4.0 * -Math.cos(Math.toRadians(this.yBodyRot));
        this.doJumpDamage(dx, this.getY(), dz, 6.0, 10 + this.getRandom().nextInt(90), 1);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (this.getMaster() != null) {
            this.getMaster().retractMinionNumFromType(this.getMinionType());
        }
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target == this) {
            return;
        }
        if (this.getMaster() != null && !this.getMaster().canAttackEntity((Entity)target, true)) {
            return;
        }
        super.setTarget(target);
    }

    public boolean killedEntity(ServerLevel level, LivingEntity entity) {
        if ((double)entity.getMaxHealth() <= 100.0) {
            entity.push(0.0, 15.0, 0.0);
        }
        this.heal(this.level().isDay() ? 5.0f + this.getRandom().nextFloat() * 15.0f : 15.0f + this.getRandom().nextFloat() * 30.0f);
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            EntityZombieTitanMinion zombieVillager = new EntityZombieTitanMinion((Level)level);
            zombieVillager.copyPosition((Entity)villager);
            zombieVillager.setBaby(villager.isBaby());
            zombieVillager.setNoAi(villager.isNoAi());
            if (villager.hasCustomName()) {
                zombieVillager.setCustomName(villager.getCustomName());
                zombieVillager.setCustomNameVisible(villager.isCustomNameVisible());
            }
            if (villager.isPersistenceRequired()) {
                zombieVillager.setPersistenceRequired();
            }
            zombieVillager.setInvulnerable(villager.isInvulnerable());
            this.level().addFreshEntity((Entity)zombieVillager);
            if (villager.isPassenger()) {
                Entity vehicle = villager.getVehicle();
                villager.stopRiding();
                zombieVillager.startRiding(vehicle, true);
            }
            if (!villager.isRemoved()) {
                villager.discard();
            }
            if (zombieVillager != null) {
                zombieVillager.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(zombieVillager.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true));
                zombieVillager.setVillager(true);
                EventHooks.onLivingConvert((LivingEntity)entity, (LivingEntity)zombieVillager);
                if (!this.isSilent()) {
                    level.levelEvent(null, 1026, this.blockPosition(), 0);
                }
                return false;
            }
        }
        return super.killedEntity(level, entity);
    }

    public boolean doHurtTarget(Entity entity) {
        boolean flag = super.doHurtTarget(entity);
        if (flag && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.onGround()) {
                double ks = 1.25;
                double inair = 1.25;
                float f3 = (float)Math.atan2(livingEntity.getZ() - this.getZ(), livingEntity.getX() - this.getX());
                livingEntity.push(Math.cos(f3) * ks, inair, Math.sin(f3) * ks);
            } else {
                double ks = 3.0;
                double inair = 0.25;
                float f3 = (float)Math.atan2(livingEntity.getZ() - this.getZ(), livingEntity.getX() - this.getX());
                livingEntity.push(Math.cos(f3) * ks, inair, Math.sin(f3) * ks);
            }
            return true;
        }
        return false;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        Entity entity = damageSource.getEntity();
        if (this.isInvulnerable()) {
            return false;
        }
        if (entity instanceof EntityZombieTitanMinion || entity instanceof EntityZombieTitan && !(entity instanceof EntityZombifiedPiglinTitan)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.setTarget(livingEntity);
            this.setYRot(this.yHeadRot);
            this.setYBodyRot(this.yHeadRot);
            this.push(0.0, 1.25, 0.0);
            this.setPos(this.getX(), this.getY() + (double)1.55f, this.getZ());
            double d1 = this.getTarget().getX() - this.getX();
            double d2 = this.getTarget().getZ() - this.getZ();
            float d = (float)Math.atan2(d2, d1);
            this.lookAt((Entity)this.getTarget(), 10.0f, this.getHeadRotSpeed());
            d1 = Math.sqrt(d1 * d1 + d2 * d2);
            if (this.distanceToSqr((Entity)this.getTarget()) > (double)((10.0f + this.getTarget().getBbWidth() / 2.0f) * (10.0f + this.getTarget().getBbWidth() / 2.0f)) + 45.0) {
                this.push(d1 * 0.05 * Math.cos(d), 0.0, d1 * 0.05 * Math.sin(d));
            }
        }
        return super.hurt(damageSource, amount);
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    public void aiStep() {
        block12: {
            block10: {
                block11: {
                    super.aiStep();
                    if (this.getDeltaMovement().y < -0.95) {
                        double df = 1.0;
                        if (this.getDeltaMovement().y < -1.5) {
                            df = 1.5;
                        }
                        this.doJumpDamage(this.getX(), this.getY(), this.getZ(), 12.0, 100.0 * df, 0);
                        this.doJumpDamage(this.getX(), this.getY(), this.getZ(), 14.0, 50.0 * df, 0);
                        this.doJumpDamage(this.getX(), this.getY(), this.getZ(), 16.0, 25.0 * df, 0);
                    }
                    if (this.getTarget() != null) {
                        this.getLookControl().setLookAt((Entity)this.getTarget(), 10.0f, 40.0f);
                        if (this.onGround()) {
                            this.getMoveControl().setWantedPosition(this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 1.0);
                        }
                        if (this.tickCount % 30 == 0 && this.level().getRandom().nextInt(3) == 0) {
                            this.setYRot(this.yHeadRot);
                            this.setYBodyRot(this.yHeadRot);
                            this.push(0.0, 1.25, 0.0);
                            this.setPos(this.getX(), this.getY() + (double)1.55f, this.getZ());
                            double d1 = this.getTarget().getX() - this.getX();
                            double d2 = this.getTarget().getZ() - this.getZ();
                            float d = (float)Math.atan2(d2, d1);
                            this.lookAt((Entity)this.getTarget(), 10.0f, this.getHeadRotSpeed());
                            d1 = Math.sqrt(d1 * d1 + d2 * d2);
                            if (this.distanceToSqr((Entity)this.getTarget()) > (double)((10.0f + this.getTarget().getBbWidth() / 2.0f) * (10.0f + this.getTarget().getBbWidth() / 2.0f)) + 45.0) {
                                this.push(d1 * 0.05 * Math.cos(d), 0.0, d1 * 0.05 * Math.sin(d));
                            }
                        }
                        if (this.tickCount % 20 == 0 && this.distanceToSqr((Entity)this.getTarget()) <= (double)((14.0f + this.getTarget().getBbWidth() / 2.0f) * (14.0f + this.getTarget().getBbWidth() / 2.0f))) {
                            this.doHurtTarget((Entity)this.getTarget());
                        }
                    }
                    if (this.getMaster() == null) break block10;
                    if (this.horizontalCollision) {
                        this.setDeltaMovement(this.getDeltaMovement().x, 0.2, this.getDeltaMovement().z);
                    }
                    if (this.getMaster().getTarget() == null) break block11;
                    this.setTarget(this.getMaster().getTarget());
                    break block12;
                }
                if (!(this.distanceToSqr((Entity)this.getMaster()) > 5000.0)) break block12;
                this.getMoveControl().setWantedPosition(this.getMaster().getX(), this.getMaster().getY(), this.getMaster().getZ(), 2.0);
                break block12;
            }
            List entities = this.level().getEntitiesOfClass(EntityTitan.class, this.getBoundingBox().inflate(100.0, 100.0, 100.0));
            if (!entities.isEmpty()) {
                for (EntityTitan entity : entities) {
                    if (entity == null || !(entity instanceof EntityZombieTitan)) continue;
                    this.setMaster(entity);
                }
            }
        }
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource damageSource) {
        boolean flag;
        this.captureDrops(new ArrayList());
        boolean bl = flag = this.lastHurtByPlayerTime > 0;
        if (this.shouldDropLoot() && level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            int j;
            this.dropFromLootTable(damageSource, flag);
            this.dropCustomDeathLoot(level, damageSource, flag);
            int i = 0;
            Entity entity = damageSource.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                i = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(Enchantments.LOOTING), (ItemStack)player.getMainHandItem());
            }
            this.dropFewItems(flag, i);
            if (flag && (j = this.getRandom().nextInt(200) - i) < 5) {
                this.dropRareDrop(j <= 0 ? 1 : 0);
            }
        }
        this.dropEquipment();
        int reward = EventHooks.getExperienceDrop((LivingEntity)this, (Player)this.lastHurtByPlayer, (int)this.getExperienceReward(level, damageSource.getEntity()));
        ExperienceOrb.award((ServerLevel)((ServerLevel)this.level()), (Vec3)this.position(), (int)reward);
        Collection drops = this.captureDrops(null);
        if (!CommonHooks.onLivingDrops((LivingEntity)this, (DamageSource)damageSource, (Collection)drops, (this.lastHurtByPlayerTime > 0 ? 1 : 0) != 0)) {
            for (ItemEntity drop : drops) {
                this.level().addFreshEntity((Entity)drop);
            }
        }
    }

    public void tick() {
        super.tick();
        this.noCulling = true;
        if (!(this.tickCount % 20 != 0 || this.level().isDay() && this.getRandom().nextInt(5) != 0)) {
            this.heal(this.level().isDay() ? 1.0f + this.getRandom().nextFloat() * 4.0f : 5.0f + this.getRandom().nextFloat() * 15.0f);
        }
        if (this.getDeltaMovement().x != 0.0 && this.getDeltaMovement().z != 0.0 && this.getRandom().nextInt(5) == 0) {
            int i = Mth.floor((double)this.getX());
            int j = Mth.floor((double)(this.getY() - (double)0.2f));
            int k = Mth.floor((double)this.getZ());
            BlockPos blockPos = new BlockPos(i, j, k);
            BlockState blockState = this.level().getBlockState(blockPos);
            if (!blockState.isAir()) {
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), this.getX() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth(), this.getBoundingBox().minY + 0.1, this.getZ() + ((double)this.getRandom().nextFloat() - 0.5) * (double)this.getBbWidth(), 4.0 * ((double)this.getRandom().nextFloat() - 0.5), 0.5, ((double)this.getRandom().nextFloat() - 0.5) * 4.0);
            }
        }
    }

    public class TargetingSorter
    implements Comparator<Entity> {
        private Entity entity;

        public TargetingSorter(EntityZombieTitanGiantMinion this$0, Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(Entity entity1, Entity entity2) {
            double weight = 0.0;
            double var3 = this.entity.distanceToSqr(entity1);
            if (entity1 instanceof Creeper) {
                var3 /= 2.0;
            }
            if ((weight = (double)(entity1.getBbHeight() * entity1.getBbWidth())) > 1.0) {
                var3 /= weight;
            }
            double var5 = this.entity.distanceToSqr(entity2);
            if (entity2 instanceof Creeper) {
                var5 /= 2.0;
            }
            if ((weight = (double)(entity2.getBbHeight() * entity2.getBbWidth())) > 1.0) {
                var5 /= weight;
            }
            return var3 > var5 ? 1 : (var3 < var5 ? -1 : 0);
        }
    }
}

