/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.projectile;

import java.util.List;
import net.byAqua3.thetitansneo.entity.EntityColorLightningBolt;
import net.byAqua3.thetitansneo.entity.projectile.IEntityProjectileTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossus;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class EntityLightningBall
extends AbstractHurtingProjectile
implements IEntityProjectileTitan,
ItemSupplier {
    public EntityLightningBall(EntityType<? extends EntityLightningBall> entityType, Level level) {
        super((EntityType)TheTitansNeoEntities.LIGHTNING_BALL.get(), level);
    }

    public EntityLightningBall(Level level, LivingEntity shooter) {
        this((EntityType<? extends EntityLightningBall>)((EntityType)TheTitansNeoEntities.LIGHTNING_BALL.get()), level);
        this.setOwner((Entity)shooter);
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)Items.SNOWBALL);
    }

    protected boolean shouldBurn() {
        return false;
    }

    protected boolean canHitEntity(Entity entity) {
        return this.getOwner() != null && entity == this.getOwner() ? false : super.canHitEntity(entity);
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        return false;
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity && this.getOwner() instanceof EntityTitan) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityTitan titan = (EntityTitan)this.getOwner();
            float amount = 2000.0f;
            titan.attackEntity(livingEntity, amount);
            if (!this.level().isClientSide()) {
                this.level().explode((Entity)(this.getOwner() != null ? this.getOwner() : this), this.getX(), this.getY(), this.getZ(), 7.0f, true, Level.ExplosionInteraction.MOB);
                this.discard();
            }
        }
        super.onHitEntity(result);
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide()) {
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        this.setRemainingFireTicks(4);
        if (this.tickCount % 600 == 0 && !this.level().isClientSide()) {
            this.level().explode((Entity)(this.getOwner() != null ? this.getOwner() : this), this.getX(), this.getY(), this.getZ(), 7.0f, true, Level.ExplosionInteraction.MOB);
            this.discard();
        }
        if (this.getRandom().nextInt(30) == 0) {
            EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
            colorLightningBolt.setPos(this.getX(), this.getY(), this.getZ());
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)colorLightningBolt);
            }
        }
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(8.0, 8.0, 8.0));
        for (Entity entity : entities) {
            if (entity == null || !entity.isAlive() || !(entity instanceof LivingEntity) || !(this.getOwner() instanceof EntityEnderColossus) || entity instanceof EntityEnderColossus) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityEnderColossus titan = (EntityEnderColossus)this.getOwner();
            float amount = 5.0f;
            boolean knockbackAmount = true;
            if (!titan.canAttackEntity((Entity)livingEntity)) continue;
            livingEntity.setRemainingFireTicks(15);
            livingEntity.hurt(this.damageSources().lightningBolt(), 100.0f);
            EntityColorLightningBolt colorLightningBolt1 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
            colorLightningBolt1.setPos(this.getX(), this.getY(), this.getZ());
            EntityColorLightningBolt colorLightningBolt2 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 1.0f);
            colorLightningBolt2.setPos(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)colorLightningBolt1);
                this.level().addFreshEntity((Entity)colorLightningBolt2);
            }
            titan.attackEntity(livingEntity, amount);
            titan.knockbackEntity(livingEntity, (float)knockbackAmount);
        }
    }
}

