/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.projectile;

import java.lang.reflect.Constructor;
import net.byAqua3.thetitansneo.entity.minion.IMinion;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoMinions;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class EntityProtoBall
extends ThrowableProjectile {
    public EntityProtoBall(EntityType<? extends EntityProtoBall> entityType, Level level) {
        super(entityType, level);
    }

    public EntityProtoBall(Level level) {
        super((EntityType)TheTitansNeoEntities.PROTO_BALL.get(), level);
    }

    public void summomMinions(EntityTitan titan, int minionNumber, int priestNumber, int zealotNumber, int bishopNumber) {
        ComponentContents componentContents = titan.getName().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            if (TheTitansNeoMinions.SPECIAL_MINIONS.containsKey(translatableContents.getKey()) && this.getRandom().nextInt(5) == 0) {
                try {
                    clazz = TheTitansNeoMinions.SPECIAL_MINIONS.get(translatableContents.getKey());
                    Constructor<? extends Entity> constructor = clazz.getDeclaredConstructor(Level.class);
                    Entity entity = constructor.newInstance(this.level());
                    if (entity instanceof Mob && entity instanceof IMinion) {
                        Mob mob = (Mob)entity;
                        IMinion minion = (IMinion)entity;
                        mob.setPos(this.getX(), this.getY(), this.getZ());
                        mob.setXRot(-this.getXRot());
                        mob.setYRot(-this.getYRot());
                        mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
                        minion.setMaster(titan);
                        minion.setMinionType(0);
                        titan.finalizeMinionSummon((Entity)mob, minion.getMinionType());
                        mob.setHealth(mob.getMaxHealth());
                        mob.push(0.0, 1.0, 0.0);
                        this.level().addFreshEntity((Entity)mob);
                        this.level().explode((Entity)mob, mob.getX(), mob.getY() + 6.0, mob.getZ(), 12.0f, false, Level.ExplosionInteraction.MOB);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (TheTitansNeoMinions.MINIONS.containsKey(translatableContents.getKey())) {
                try {
                    clazz = TheTitansNeoMinions.MINIONS.get(translatableContents.getKey());
                    int randomInt = this.getRandom().nextInt(4);
                    if (randomInt == 0) {
                        for (int i = 0; i <= minionNumber; ++i) {
                            Constructor<? extends Entity> constructor = clazz.getDeclaredConstructor(Level.class);
                            Entity entity = constructor.newInstance(this.level());
                            if (!(entity instanceof Mob) || !(entity instanceof IMinion)) continue;
                            Mob mob = (Mob)entity;
                            IMinion minion = (IMinion)entity;
                            mob.setPos(this.getX(), this.getY(), this.getZ());
                            mob.setXRot(-this.getXRot());
                            mob.setYRot(-this.getYRot());
                            mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
                            minion.setMaster(titan);
                            minion.setMinionType(0);
                            titan.finalizeMinionSummon((Entity)mob, minion.getMinionType());
                            mob.setHealth(mob.getMaxHealth());
                            this.level().addFreshEntity((Entity)mob);
                            this.level().explode((Entity)mob, mob.getX(), mob.getY() + 6.0, mob.getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                        }
                    } else if (randomInt == 1) {
                        for (int i = 0; i <= priestNumber; ++i) {
                            Constructor<? extends Entity> constructor = clazz.getDeclaredConstructor(Level.class);
                            Entity entity = constructor.newInstance(this.level());
                            if (!(entity instanceof Mob) || !(entity instanceof IMinion)) continue;
                            Mob mob = (Mob)entity;
                            IMinion minion = (IMinion)entity;
                            mob.setPos(this.getX(), this.getY(), this.getZ());
                            mob.setXRot(-this.getXRot());
                            mob.setYRot(-this.getYRot());
                            mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
                            minion.setMaster(titan);
                            minion.setMinionType(1);
                            titan.finalizeMinionSummon((Entity)mob, minion.getMinionType());
                            mob.setHealth(mob.getMaxHealth());
                            this.level().addFreshEntity((Entity)mob);
                            this.level().explode((Entity)mob, mob.getX(), mob.getY() + 6.0, mob.getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                        }
                    } else if (randomInt == 2) {
                        for (int i = 0; i <= zealotNumber; ++i) {
                            Constructor<? extends Entity> constructor = clazz.getDeclaredConstructor(Level.class);
                            Entity entity = constructor.newInstance(this.level());
                            if (!(entity instanceof Mob) || !(entity instanceof IMinion)) continue;
                            Mob mob = (Mob)entity;
                            IMinion minion = (IMinion)entity;
                            mob.setPos(this.getX(), this.getY(), this.getZ());
                            mob.setXRot(-this.getXRot());
                            mob.setYRot(-this.getYRot());
                            mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
                            minion.setMaster(titan);
                            minion.setMinionType(2);
                            titan.finalizeMinionSummon((Entity)mob, minion.getMinionType());
                            mob.setHealth(mob.getMaxHealth());
                            this.level().addFreshEntity((Entity)mob);
                            this.level().explode((Entity)mob, mob.getX(), mob.getY() + 6.0, mob.getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                        }
                    } else if (randomInt == 3) {
                        for (int i = 0; i <= bishopNumber; ++i) {
                            Constructor<? extends Entity> constructor = clazz.getDeclaredConstructor(Level.class);
                            Entity entity = constructor.newInstance(this.level());
                            if (!(entity instanceof Mob) || !(entity instanceof IMinion)) continue;
                            Mob mob = (Mob)entity;
                            IMinion minion = (IMinion)entity;
                            mob.setPos(this.getX(), this.getY(), this.getZ());
                            mob.setXRot(-this.getXRot());
                            mob.setYRot(-this.getYRot());
                            mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
                            minion.setMaster(titan);
                            minion.setMinionType(3);
                            titan.finalizeMinionSummon((Entity)mob, minion.getMinionType());
                            mob.setHealth(mob.getMaxHealth());
                            this.level().addFreshEntity((Entity)mob);
                            this.level().explode((Entity)mob, mob.getX(), mob.getY() + 6.0, mob.getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected boolean canHitEntity(Entity entity) {
        return this.getOwner() != null && entity == this.getOwner() ? false : super.canHitEntity(entity);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity && this.getOwner() instanceof EntityTitan) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityTitan titan = (EntityTitan)this.getOwner();
            titan.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
            float amount = 75.0f;
            boolean knockbackAmount = true;
            titan.attackEntity(livingEntity, amount);
            titan.knockbackEntity(livingEntity, (float)knockbackAmount);
            if (!this.level().isClientSide()) {
                this.discard();
            }
        }
        super.onHitEntity(result);
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide()) {
            if (this.level().getDifficulty() != Difficulty.PEACEFUL && this.getOwner() instanceof EntityTitan) {
                EntityTitan titan = (EntityTitan)this.getOwner();
                this.summomMinions(titan, (Integer)TheTitansNeoConfigs.protoBallMinionSpawnCap.get(), (Integer)TheTitansNeoConfigs.protoBallPriestSpawnCap.get(), (Integer)TheTitansNeoConfigs.protoBallZealotSpawnCap.get(), (Integer)TheTitansNeoConfigs.protoBallBishopSpawnCap.get());
            }
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        for (int i = 0; i < 15; ++i) {
            float f = (this.getRandom().nextFloat() - 0.5f) * this.getBbWidth();
            float f1 = (this.getRandom().nextFloat() - 0.5f) * this.getBbHeight();
            float f2 = (this.getRandom().nextFloat() - 0.5f) * this.getBbWidth();
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX() + (double)f, this.getY() + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + (double)f, this.getY() + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, this.getX() + (double)f, this.getY() + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
    }
}

