/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.util.UUID;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.minion.EntityCaveSpiderTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySpiderTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanPart;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoPredicateTargets;
import net.byAqua3.thetitansneo.util.AnimationUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityCaveSpiderTitan
extends EntitySpiderTitan {
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Player cachedOwner;
    public boolean isSubdued;

    public EntityCaveSpiderTitan(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        this.head = new EntityTitanPart(this, "head", 5.6f, 5.6f);
        this.thorax = new EntityTitanPart(this, "thorax", 4.2f, 4.2f);
        this.abdomen = new EntityTitanPart(this, "abdomen", 8.4f, 5.6f);
        this.leftlegs = new EntityTitanPart(this, "leftleg", 8.4f, 5.6f);
        this.rightlegs = new EntityTitanPart(this, "rightleg", 8.4f, 5.6f);
        this.parts = new EntityTitanPart[]{this.head, this.thorax, this.abdomen, this.leftlegs, this.rightlegs};
    }

    public EntityCaveSpiderTitan(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.CAVE_SPIDER_TITAN.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 24000.0).add(Attributes.ATTACK_DAMAGE, 225.0);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        if (this.isInvisible()) {
            return null;
        }
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/cave_spider_titan.png");
    }

    @Override
    public int getBossBarNameColor() {
        return 11013646;
    }

    @Override
    public int getBossBarWidth() {
        return 187;
    }

    @Override
    public int getBossBarHeight() {
        return 23;
    }

    @Override
    public int getBossBarInterval() {
        return 5;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 7;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.removeAllGoals(goal -> true);
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntitySnowGolemTitan>((Mob)this, EntitySnowGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityIronGolemTitan>((Mob)this, EntityIronGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, TheTitansNeoPredicateTargets.CaveSpiderTitan));
    }

    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null) {
            this.cachedOwner = this.level().getPlayerByUUID(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(Player owner) {
        if (owner != null) {
            this.ownerUUID = owner.getUUID();
            this.cachedOwner = owner;
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("Owner")) {
            this.ownerUUID = tag.getUUID("Owner");
            this.cachedOwner = null;
        }
        this.isSubdued = tag.getBoolean("IsSubdued");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.ownerUUID != null) {
            tag.putUUID("Owner", this.ownerUUID);
        }
        tag.putBoolean("IsSubdued", this.isSubdued);
    }

    @Override
    protected void refreshAttributes() {
        if (this.level().getDifficulty() == Difficulty.HARD) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(24000.0 + (double)this.getExtraPower() * 1600.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(225.0 + (double)this.getExtraPower() * 30.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(12000.0 + (double)this.getExtraPower() * 800.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(112.5 + (double)this.getExtraPower() * 15.0);
        }
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        return super.canAttackEntity(entity) && !(entity instanceof EntityCaveSpiderTitanMinion) && (!(entity instanceof Player) || !this.isSubdued);
    }

    @Override
    public int getMinionCap() {
        return (Integer)TheTitansNeoConfigs.caveSpiderTitanMinionSpawnCap.get();
    }

    @Override
    public int getPriestCap() {
        return (Integer)TheTitansNeoConfigs.caveSpiderTitanPriestSpawnCap.get();
    }

    @Override
    public int getZealotCap() {
        return (Integer)TheTitansNeoConfigs.caveSpiderTitanZealotSpawnCap.get();
    }

    @Override
    public int getBishopCap() {
        return (Integer)TheTitansNeoConfigs.caveSpiderTitanBishopSpawnCap.get();
    }

    @Override
    public int getTemplarCap() {
        return (Integer)TheTitansNeoConfigs.caveSpiderTitanTemplarSpawnCap.get();
    }

    @Override
    public boolean canSpawnMinion() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.caveSpiderTitanSummonMinionSpawnRate.get();
    }

    @Override
    public boolean canSpawnPriest() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.caveSpiderTitanSummonPriestSpawnRate.get();
    }

    @Override
    public boolean canSpawnZealot() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.caveSpiderTitanSummonZealotSpawnRate.get();
    }

    @Override
    public boolean canSpawnBishop() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.caveSpiderTitanSummonBishopSpawnRate.get();
    }

    @Override
    public boolean canSpawnTemplar() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.caveSpiderTitanSummonTemplarSpawnRate.get();
    }

    @Override
    public Vec3 getPassengerRidingPosition(Entity entity) {
        if (entity instanceof Player) {
            return this.position().add(0.0, 8.8 + (double)this.getExtraPower() * 0.1, 0.0);
        }
        return super.getPassengerRidingPosition(entity);
    }

    @Override
    public float getSpeed() {
        return (float)((this.getBonusID() == 1 ? 0.65 : 0.6) + (double)this.getExtraPower() * 0.001);
    }

    @Override
    public void setTarget(@Nullable LivingEntity target) {
        if (this.isSubdued) {
            super.setTarget(null);
            return;
        }
        super.setTarget(target);
    }

    @Override
    public void attackEntity(LivingEntity entity, float amount) {
        super.attackEntity(entity, amount);
        if (!entity.level().isClientSide()) {
            entity.addEffect(new MobEffectInstance(MobEffects.POISON, 800, 3));
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        if (this.isStunned && !this.isSubdued) {
            if (item == Items.GOLDEN_APPLE) {
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                player.swing(hand, true);
                float randomRate = this.getRandom().nextFloat() * 100.0f;
                if ((double)randomRate < (Double)TheTitansNeoConfigs.caveSpiderTitanSubdueRate.get()) {
                    this.playSound(SoundEvents.PLAYER_LEVELUP, 10.0f, 1.0f);
                    this.isSubdued = true;
                    this.setOwner(player);
                    player.sendSystemMessage((Component)Component.translatable((String)"entity.thetitansneo.titan.subdued", (Object[])new Object[]{this.getName(), player.getName()}));
                }
            }
        } else if (!this.isStunned && this.isSubdued && this.getOwner() == player) {
            if (!itemStack.isEmpty()) {
                if (this.getAnimationID() == 0) {
                    if (itemStack.getItem() == Items.COOKED_CHICKEN) {
                        if (!player.isCreative()) {
                            itemStack.shrink(1);
                        }
                        player.swing(hand, true);
                        AnimationUtils.sendPacket(this, 3);
                    }
                    if (itemStack.getItem() == Items.BONE) {
                        if (!player.isCreative()) {
                            itemStack.shrink(1);
                        }
                        player.swing(hand, true);
                        AnimationUtils.sendPacket(this, 9);
                    }
                }
            } else if (!player.isPassenger()) {
                player.swing(hand, true);
                player.startRiding((Entity)this);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void finalizeMinionSummon(Entity entity, EnumMinionType minionType) {
        if (minionType != EnumMinionType.SPECIAL && entity instanceof EntityCaveSpiderTitanMinion) {
            EntityCaveSpiderTitanMinion caveSpiderTitanMinion = (EntityCaveSpiderTitanMinion)entity;
            caveSpiderTitanMinion.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 40, 4, true, false));
        }
    }

    protected void updateRiddenMovement(Player player, Vec3 travelVector) {
        if (this.getAnimationID() == 10) {
            player.stopRiding();
            return;
        }
        this.setTarget(null);
        this.setYRot(player.getYRot());
        this.yRotO = player.yRotO;
        this.yHeadRot = player.yHeadRot;
        if (player.zza > 0.0f) {
            this.moveRelative(this.getSpeed(), new Vec3(0.0, 0.0, 1.0));
        } else if (player.zza < 0.0f) {
            this.moveRelative(-this.getSpeed() * 0.25f, new Vec3(0.0, 0.0, 1.0));
        }
        if (player.xxa != 0.0f) {
            this.moveRelative(this.getSpeed() * 0.5f * Math.signum(player.xxa), new Vec3(1.0, 0.0, 0.0));
        }
        if (this.onGround() && player.getXRot() < -80.0f) {
            this.jumpFromGround();
        }
        if (!this.isControlledByLocalInstance()) {
            this.calculateEntityAnimation(false);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.getPassengers().isEmpty() && this.getFirstPassenger() instanceof Player) {
            Player player = (Player)this.getFirstPassenger();
            this.updateRiddenMovement(player, new Vec3((double)this.xxa, (double)this.yya, (double)this.zza));
        }
    }
}

