/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.ghasttitan.EntityAIGhastTitanLook;
import net.byAqua3.thetitansneo.entity.ai.ghasttitan.EntityAIGhastTitanMoveControl;
import net.byAqua3.thetitansneo.entity.ai.ghasttitan.EntityAIGhastTitanRandomFloatAround;
import net.byAqua3.thetitansneo.entity.ai.ghasttitan.EntityAIGhastTitanShoot;
import net.byAqua3.thetitansneo.entity.minion.EntityGhastTitanMinion;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoPredicateTargets;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityGhastTitan
extends EntityTitan
implements IBossBarDisplay {
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.defineId(EntityGhastTitan.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int prevAttackCounter;
    public int attackCounter;

    public EntityGhastTitan(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new EntityAIGhastTitanMoveControl(this);
        this.shouldParticlesBeUpward = true;
        this.noPhysics = true;
    }

    public EntityGhastTitan(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.GHAST_TITAN.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 60000.0).add(Attributes.ATTACK_DAMAGE, 3000.0);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/ghast_titan.png");
    }

    @Override
    public int getBossBarNameColor() {
        return 0xBCBCBC;
    }

    @Override
    public int getBossBarWidth() {
        return 185;
    }

    @Override
    public int getBossBarHeight() {
        return 32;
    }

    @Override
    public int getBossBarInterval() {
        return 5;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 7;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.removeAllGoals(goal -> true);
        this.goalSelector.addGoal(5, (Goal)new EntityAIGhastTitanRandomFloatAround(this));
        this.goalSelector.addGoal(7, (Goal)new EntityAIGhastTitanLook(this));
        this.goalSelector.addGoal(7, (Goal)new EntityAIGhastTitanShoot(this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntitySnowGolemTitan>((Mob)this, EntitySnowGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityIronGolemTitan>((Mob)this, EntityIronGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, TheTitansNeoPredicateTargets.GhastTitan));
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.entityData.set(CHARGING, (Object)charging);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CHARGING, (Object)false);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public float rotlerp(float angle, float targetAngle, float maxIncrease) {
        float f = Mth.wrapDegrees((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        return groupData;
    }

    @Override
    protected void refreshAttributes() {
        if (this.level().getDifficulty() == Difficulty.HARD) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(60000.0 + (double)this.getExtraPower() * 2500.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(3000.0 + (double)this.getExtraPower() * 1800.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(30000.0 + (double)this.getExtraPower() * 1250.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(1500.0 + (double)this.getExtraPower() * 900.0);
        }
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        return super.canAttackEntity(entity) && !(entity instanceof EntityGhastTitanMinion);
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return !this.isInvulnerable();
    }

    @Override
    public boolean shouldMove() {
        return false;
    }

    @Override
    public int getRegenTime() {
        return 5;
    }

    @Override
    public int getMinionCap() {
        return (Integer)TheTitansNeoConfigs.ghastTitanMinionSpawnCap.get();
    }

    @Override
    public int getPriestCap() {
        return (Integer)TheTitansNeoConfigs.ghastTitanPriestSpawnCap.get();
    }

    @Override
    public int getZealotCap() {
        return (Integer)TheTitansNeoConfigs.ghastTitanZealotSpawnCap.get();
    }

    @Override
    public int getBishopCap() {
        return (Integer)TheTitansNeoConfigs.ghastTitanBishopSpawnCap.get();
    }

    @Override
    public int getTemplarCap() {
        return (Integer)TheTitansNeoConfigs.ghastTitanTemplarSpawnCap.get();
    }

    @Override
    public boolean canSpawnMinion() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.ghastTitanSummonMinionSpawnRate.get();
    }

    @Override
    public boolean canSpawnPriest() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.ghastTitanSummonPriestSpawnRate.get();
    }

    @Override
    public boolean canSpawnZealot() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.ghastTitanSummonZealotSpawnRate.get();
    }

    @Override
    public boolean canSpawnBishop() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.ghastTitanSummonBishopSpawnRate.get();
    }

    @Override
    public boolean canSpawnTemplar() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.ghastTitanSummonTemplarSpawnRate.get();
    }

    @Override
    public SimpleParticleType getParticles() {
        return ParticleTypes.LARGE_SMOKE;
    }

    @Override
    public int getParticleCount() {
        return 100;
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.GREATER;
    }

    @Override
    public float getSpeed() {
        return 0.5f + (float)this.getExtraPower() * 0.001f;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public boolean onClimbable() {
        return false;
    }

    public int getMaxHeadXRot() {
        return 180;
    }

    public int getMaxHeadYRot() {
        return 180;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TheTitansNeoSounds.TITAN_GHAST_LIVING.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)TheTitansNeoSounds.TITAN_GHAST_GRUNT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TheTitansNeoSounds.TITAN_GHAST_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    @Override
    public void move(MoverType type, Vec3 pos) {
        this.setPosRaw(this.getX() + pos.x, this.getY() + pos.y, this.getZ() + pos.z);
    }

    @Override
    public boolean hurt(DamageSource damageSource, float amount) {
        if (damageSource.is(DamageTypes.IN_FIRE) || damageSource.is(DamageTypes.ON_FIRE)) {
            this.heal(amount);
            return false;
        }
        return super.hurt(damageSource, amount);
    }

    @Override
    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    public void travel(Vec3 travelVector) {
        if (this.isControlledByLocalInstance()) {
            if (this.isInWater()) {
                this.moveRelative(0.02f, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setTitanDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setTitanDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                BlockPos ground = this.getBlockPosBelowThatAffectsMyMovement();
                float f = 0.91f;
                if (this.onGround()) {
                    f = this.level().getBlockState(ground).getFriction((LevelReader)this.level(), ground, (Entity)this) * 0.91f;
                }
                float f1 = 0.16277137f / (f * f * f);
                f = 0.91f;
                if (this.onGround()) {
                    f = this.level().getBlockState(ground).getFriction((LevelReader)this.level(), ground, (Entity)this) * 0.91f;
                }
                this.moveRelative(this.onGround() ? 0.1f * f1 : 0.02f, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setTitanDeltaMovement(this.getDeltaMovement().scale((double)f));
            }
        }
        this.calculateEntityAnimation(false);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.prevAttackCounter = this.attackCounter;
        if (this.getTarget() != null) {
            double d8 = 1024.0;
            if (this.distanceToSqr((Entity)this.getTarget()) < d8 * d8) {
                double d4 = this.getTarget().getX() - this.getX();
                double d5 = this.getTarget().getEyeY() - this.getEyeY();
                double d6 = this.getTarget().getZ() - this.getZ();
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f1 = -((float)Mth.atan2((double)d5, (double)d7) * 180.0f / (float)Math.PI);
                float f2 = -((float)Mth.atan2((double)d4, (double)d6) * 180.0f / (float)Math.PI);
                if (this.attackCounter < 0) {
                    this.setXRot(this.rotlerp(this.getXRot(), 0.0f, 180.0f));
                } else {
                    this.setXRot(this.rotlerp(this.getXRot(), f1, 180.0f));
                }
                if (!this.level().isClientSide()) {
                    this.setYRot(this.rotlerp(this.getYRot(), f2, 180.0f));
                    this.yBodyRot = this.getYRot();
                }
            }
        }
    }

    @Override
    protected void dropExperienceOrb() {
        for (int x = 0; x < 80; ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), 26000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
    }

    @Override
    protected void dropAllItem() {
        int count;
        ItemStack itemStack;
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> rateDrops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Items.GUNPOWDER), 512);
        drops.put(new ItemStack((ItemLike)Items.GHAST_TEAR), 512);
        drops.put(new ItemStack((ItemLike)Items.COAL), 256);
        drops.put(new ItemStack((ItemLike)Blocks.IRON_BLOCK), 256);
        drops.put(new ItemStack((ItemLike)Blocks.GOLD_BLOCK), 256);
        drops.put(new ItemStack((ItemLike)Blocks.EMERALD_BLOCK), 128);
        drops.put(new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK), 128);
        drops.put(new ItemStack((ItemLike)Blocks.DRAGON_EGG), 64);
        drops.put(new ItemStack((ItemLike)Items.BREWING_STAND), 64);
        drops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM.get()), 64);
        drops.put(new ItemStack((ItemLike)TheTitansNeoItems.VOID.get()), 32);
        drops.put(new ItemStack((ItemLike)Blocks.BEDROCK), 16);
        rateDrops.put(new ItemStack((ItemLike)Items.GUNPOWDER), 512);
        rateDrops.put(new ItemStack((ItemLike)Items.GHAST_TEAR), 512);
        rateDrops.put(new ItemStack((ItemLike)Items.COAL), 256);
        rateDrops.put(new ItemStack((ItemLike)Blocks.IRON_BLOCK), 256);
        rateDrops.put(new ItemStack((ItemLike)Blocks.GOLD_BLOCK), 256);
        rateDrops.put(new ItemStack((ItemLike)Blocks.EMERALD_BLOCK), 128);
        rateDrops.put(new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK), 128);
        rateDrops.put(new ItemStack((ItemLike)Blocks.DRAGON_EGG), 64);
        rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM.get()), 64);
        rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.VOID.get()), 32);
        rateDrops.put(new ItemStack((ItemLike)Blocks.BEDROCK), 16);
        for (Map.Entry entry : drops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
        for (Map.Entry entry : rateDrops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            int randomCount = this.getRandom().nextInt(count) + 1;
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, randomCount);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        if (this.deathTicks <= 200) {
            this.setXRot(this.rotlerp(this.getXRot(), 0.0f, 180.0f));
        }
        if (this.deathTicks > 200) {
            this.setInvulTime(this.getInvulTime() + 10);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.onDeath();
            if (!this.level().isClientSide() && !this.isRemoved()) {
                this.removeTitan(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public void tick() {
        Player player;
        int i;
        super.tick();
        for (i = 0; i < 90; ++i) {
            double d0 = this.getX() + (double)(this.getRandom().nextFloat() * 90.0f - 45.0f);
            double d1 = this.getY() + (double)(this.getRandom().nextFloat() * 30.0f);
            double d2 = this.getZ() + (double)(this.getRandom().nextFloat() * 90.0f - 45.0f);
            if (this.level().isEmptyBlock(new BlockPos((int)d0, (int)d1 + (int)this.getEyeHeight(), (int)d2)) || this.level().isClientSide()) continue;
            this.setPos(this.getX(), this.getY() + 0.1, this.getZ());
        }
        if (this.getTarget() != null && (player = this.level().getNearestPlayer((Entity)this, -1.0)) != null && this.getTarget() == player) {
            player.setRemainingFireTicks(50);
            if (this.getRandom().nextInt(200) == 0 && this.getHealth() <= this.getMaxHealth() / 100.0f) {
                player.hurt(this.damageSources().onFire(), Float.MAX_VALUE);
            }
            if (player.getAbsorptionAmount() <= 0.0f && this.tickCount % 10 == 0) {
                player.hurt(this.damageSources().onFire(), 12.0f);
                if (!this.level().isClientSide()) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 400, 9));
                    if (player.getHealth() <= 5.0f) {
                        player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 400, 1));
                    }
                }
            } else if (player.getAbsorptionAmount() >= 0.0f && this.tickCount % 20 == 0) {
                player.hurt(this.damageSources().onFire(), 12.0f);
            }
        }
        for (i = 0; i < this.getParticleCount(); ++i) {
            this.level().addParticle((ParticleOptions)this.getParticles(), this.getX() + (this.getRandom().nextDouble() - 0.5) * 96.0, this.getY() + this.getRandom().nextDouble() * 96.0, this.getZ() + (this.getRandom().nextDouble() - 0.5) * 96.0, 0.0, 0.5, 0.0);
        }
    }
}

