/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.byAqua3.thetitansneo.TheTitansNeo;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.DataComponentUtil;

public class EntityItemTitan
extends ItemEntity {
    public static final Codec<ItemStack> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(itemStack -> itemStack.getComponentsPatch())).apply((Applicative)instance, ItemStack::new)));
    private static final int LIFETIME = 6000;

    public EntityItemTitan(EntityType<? extends ItemEntity> entityType, Level level) {
        super((EntityType)TheTitansNeoEntities.ITEM_TITAN.get(), level);
    }

    public EntityItemTitan(Level level, double posX, double posY, double posZ, ItemStack itemStack, int count) {
        this(level, posX, posY, posZ, itemStack);
        itemStack.setCount(itemStack.getCount() * count);
    }

    public EntityItemTitan(Level level, double posX, double posY, double posZ, ItemStack itemStack) {
        this(level, posX, posY, posZ, itemStack, level.getRandom().nextDouble() * 0.2 - 0.1, 0.2, level.getRandom().nextDouble() * 0.2 - 0.1);
    }

    public EntityItemTitan(Level level, double posX, double posY, double posZ, ItemStack itemStack, double deltaX, double deltaY, double deltaZ) {
        this((EntityType<? extends ItemEntity>)((EntityType)TheTitansNeoEntities.ITEM_TITAN.get()), level);
        this.setPos(posX, posY, posZ);
        this.setDeltaMovement(deltaX, deltaY, deltaZ);
        this.setItem(itemStack);
        this.lifespan = itemStack.getItem() == null ? 6000 : itemStack.getEntityLifespan(level);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.health = tag.getShort("Health");
        this.age = tag.getShort("Age");
        if (tag.contains("PickupDelay")) {
            this.pickupDelay = tag.getShort("PickupDelay");
        }
        if (tag.contains("Lifespan")) {
            this.lifespan = tag.getInt("Lifespan");
        }
        if (tag.hasUUID("Owner")) {
            this.target = tag.getUUID("Owner");
        }
        if (tag.hasUUID("Thrower")) {
            this.thrower = tag.getUUID("Thrower");
            this.cachedThrower = null;
        }
        if (tag.contains("Item", 10)) {
            CompoundTag compoundTag = tag.getCompound("Item");
            ItemStack itemStack = CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag).resultOrPartial(error -> TheTitansNeo.LOGGER.error("Tried to load invalid item: '{}'", error)).orElse(ItemStack.EMPTY);
            this.setItem(itemStack);
        } else {
            this.setItem(ItemStack.EMPTY);
        }
        if (this.getItem().isEmpty()) {
            this.discard();
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("Health", (short)this.health);
        tag.putShort("Age", (short)this.age);
        tag.putShort("PickupDelay", (short)this.pickupDelay);
        tag.putInt("Lifespan", this.lifespan);
        if (this.thrower != null) {
            tag.putUUID("Thrower", this.thrower);
        }
        if (this.target != null) {
            tag.putUUID("Owner", this.target);
        }
        if (!this.getItem().isEmpty()) {
            tag.put("Item", DataComponentUtil.wrapEncodingExceptions((DataComponentHolder)this.getItem(), CODEC, (HolderLookup.Provider)this.registryAccess()));
        }
    }

    public boolean isMergable() {
        return this.isAlive() && this.pickupDelay != Short.MAX_VALUE && this.getAge() != Short.MIN_VALUE && this.getAge() < 6000;
    }

    public void tryToMerge(ItemEntity itemEntity) {
        super.tryToMerge(itemEntity);
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        return false;
    }

    public void updateFluidHeightAndDoFluidPushing() {
    }

    public void playerTouch(Player player) {
        if (this.level().isClientSide() || player.getInventory().getFreeSlot() == -1) {
            return;
        }
        ItemStack itemStack = this.getItem();
        Item item = itemStack.getItem();
        int count = itemStack.getCount();
        if (!this.hasPickUpDelay() && (this.getTarget() == null || this.getTarget().equals(player.getUUID())) && player.getInventory().add(itemStack)) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            ServerChunkCache serverChunkCache = serverLevel.getChunkSource();
            Holder holder = serverLevel.registryAccess().registryOrThrow(Registries.SOUND_EVENT).wrapAsHolder((Object)SoundEvents.ITEM_PICKUP);
            serverChunkCache.broadcastAndSend((Entity)player, (Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 5.0f, (this.random.nextFloat() - this.random.nextFloat()) * 1.4f + 2.0f, serverLevel.getServer().getWorldData().worldGenOptions().seed()));
            if (itemStack.isEmpty()) {
                this.discard();
            }
            player.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), count);
            player.onItemPickup((ItemEntity)this);
        }
    }
}

