/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.EntityColorLightningBolt;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanAntiTitanAttack;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanAttack1;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanAttack2;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanAttack3;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanAttack4;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanAttack5;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanCreation;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanDeath;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanLightningHand;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanLightningSword;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanRangedAttack1;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanRangedAttack2;
import net.byAqua3.thetitansneo.entity.ai.skeletontitan.AnimationSkeletonTitanStun;
import net.byAqua3.thetitansneo.entity.minion.EntitySkeletonTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EntityWitherMinion;
import net.byAqua3.thetitansneo.entity.minion.EntityWitherSkeletonTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.projectile.EntityArrowTitan;
import net.byAqua3.thetitansneo.entity.projectile.EntityHarcadiumArrow;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySpiderTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanPart;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.entity.titan.IEntityMultiPartTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoMobEffects;
import net.byAqua3.thetitansneo.loader.TheTitansNeoPredicateTargets;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.util.AnimationUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntitySkeletonTitan
extends EntityTitan
implements IEntityMultiPartTitan,
IBossBarDisplay {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(EntitySkeletonTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final EntityTitanPart head = new EntityTitanPart(this, "head", 8.0f, 8.0f);
    public final EntityTitanPart pelvis = new EntityTitanPart(this, "pelvis", 8.0f, 6.0f);
    public final EntityTitanPart spine = new EntityTitanPart(this, "spine", 2.0f, 12.0f);
    public final EntityTitanPart ribCage = new EntityTitanPart(this, "ribcage", 8.0f, 8.0f);
    public final EntityTitanPart leftArm = new EntityTitanPart(this, "leftarm", 2.0f, 2.0f);
    public final EntityTitanPart rightArm = new EntityTitanPart(this, "rightarm", 2.0f, 2.0f);
    public final EntityTitanPart leftLeg = new EntityTitanPart(this, "leftleg", 2.0f, 12.0f);
    public final EntityTitanPart rightLeg = new EntityTitanPart(this, "rightleg", 2.0f, 12.0f);
    public boolean isStunned;
    public boolean shouldBeWitherSkeleton;
    public int attackTimer;

    public EntitySkeletonTitan(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        this.parts = new EntityTitanPart[]{this.head, this.pelvis, this.spine, this.ribCage, this.leftArm, this.rightArm, this.leftLeg, this.rightLeg};
    }

    public EntitySkeletonTitan(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.SKELETON_TITAN.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 40000.0).add(Attributes.ATTACK_DAMAGE, 360.0);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        if (this.getSkeletonType() == 1) {
            return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/wither_skeleton_titan.png");
        }
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/skeleton_titan.png");
    }

    @Override
    public int getBossBarNameColor() {
        if (this.getSkeletonType() == 1) {
            return 0x494949;
        }
        return 0xC1C1C1;
    }

    @Override
    public int getBossBarWidth() {
        return 185;
    }

    @Override
    public int getBossBarHeight() {
        return 24;
    }

    @Override
    public int getBossBarInterval() {
        return 5;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 7;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.footID = 1;
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanCreation(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanDeath(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanAntiTitanAttack(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanAttack1(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanAttack2(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanAttack3(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanAttack4(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanAttack5(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanLightningHand(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanLightningSword(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanRangedAttack1(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanRangedAttack2(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSkeletonTitanStun(this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntitySnowGolemTitan>((Mob)this, EntitySnowGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityIronGolemTitan>((Mob)this, EntityIronGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, TheTitansNeoPredicateTargets.SkeletonTitan));
    }

    public int getSkeletonType() {
        return (Integer)this.entityData.get(TYPE);
    }

    public void setSkeletonType(int skeletonType) {
        this.entityData.set(TYPE, (Object)skeletonType);
        this.refreshAttributes();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE, (Object)0);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSkeletonType(tag.getInt("SkeletonType"));
        this.isStunned = tag.getBoolean("IsStunned");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("SkeletonType", this.getSkeletonType());
        tag.putBoolean("IsStunned", this.isStunned);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setWaiting(true);
        return groupData;
    }

    public Component getName() {
        if (this.getSkeletonType() == 1) {
            return Component.translatable((String)"entity.thetitansneo.wither_skeleton_titan");
        }
        return Component.translatable((String)"entity.thetitansneo.skeleton_titan");
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        float width = this.getSkeletonType() == 1 ? 14.0f : 8.0f;
        float height = this.getSkeletonType() == 1 ? 56.0f : 32.0f;
        float eyeHeight = this.getSkeletonType() == 1 ? 46.68f : 28.0f;
        return EntityDimensions.scalable((float)width, (float)height).withEyeHeight(eyeHeight);
    }

    @Override
    protected void refreshAttributes() {
        if (this.getSkeletonType() == 1) {
            if (this.level().getDifficulty() == Difficulty.HARD) {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(60000.0 + (double)this.getExtraPower() * 5000.0);
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(3000.0 + (double)this.getExtraPower() * 3000.0);
            } else {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(30000.0 + (double)this.getExtraPower() * 3000.0);
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(1500.0 + (double)this.getExtraPower() * 1500.0);
            }
        } else if (this.level().getDifficulty() == Difficulty.HARD) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(40000.0 + (double)this.getExtraPower() * 2000.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(360.0 + (double)this.getExtraPower() * 60.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(20000.0 + (double)this.getExtraPower() * 1000.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(180.0 + (double)this.getExtraPower() * 30.0);
        }
    }

    @Override
    public boolean canAttack() {
        return false;
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        if (this.getSkeletonType() == 1) {
            return super.canAttackEntity(entity) && !(entity instanceof EntityWitherSkeletonTitanMinion) && !(entity instanceof EntityWitherMinion);
        }
        return super.canAttackEntity(entity) && !(entity instanceof EntitySkeletonTitanMinion);
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return !this.isInvulnerable();
    }

    @Override
    public boolean shouldMove() {
        return this.getAnimationID() == 0 && !this.isStunned && !this.getWaiting() && this.getTarget() != null ? super.shouldMove() : false;
    }

    @Override
    public double getMeleeRange() {
        return (double)(this.getBbWidth() * this.getBbWidth() + (this.getTarget().getBbWidth() > 48.0f ? 2304.0f : this.getTarget().getBbWidth() * this.getTarget().getBbWidth())) + (this.getSkeletonType() == 1 ? 2000.0 : 800.0);
    }

    @Override
    public boolean canRegen() {
        return !this.isStunned;
    }

    @Override
    public boolean isArmored() {
        return this.deathTicks <= 0 && this.getTitanHealth() <= this.getMaxHealth() / 4.0f;
    }

    @Override
    public SimpleParticleType getParticles() {
        if (this.getSkeletonType() == 1) {
            this.shouldParticlesBeUpward = true;
            return ParticleTypes.LARGE_SMOKE;
        }
        return super.getParticles();
    }

    @Override
    public int getParticleCount() {
        if (this.getSkeletonType() == 1) {
            return 48;
        }
        return super.getParticleCount();
    }

    @Override
    public int getMinionCap() {
        if (this.getSkeletonType() == 1) {
            return (Integer)TheTitansNeoConfigs.witherSkeletonTitanMinionSpawnCap.get();
        }
        return (Integer)TheTitansNeoConfigs.skeletonTitanMinionSpawnCap.get();
    }

    @Override
    public int getPriestCap() {
        if (this.getSkeletonType() == 1) {
            return (Integer)TheTitansNeoConfigs.witherSkeletonTitanPriestSpawnCap.get();
        }
        return (Integer)TheTitansNeoConfigs.skeletonTitanPriestSpawnCap.get();
    }

    @Override
    public int getZealotCap() {
        if (this.getSkeletonType() == 1) {
            return (Integer)TheTitansNeoConfigs.witherSkeletonTitanZealotSpawnCap.get();
        }
        return (Integer)TheTitansNeoConfigs.skeletonTitanZealotSpawnCap.get();
    }

    @Override
    public int getBishopCap() {
        if (this.getSkeletonType() == 1) {
            return (Integer)TheTitansNeoConfigs.witherSkeletonTitanBishopSpawnCap.get();
        }
        return (Integer)TheTitansNeoConfigs.skeletonTitanBishopSpawnCap.get();
    }

    @Override
    public int getTemplarCap() {
        if (this.getSkeletonType() == 1) {
            return (Integer)TheTitansNeoConfigs.witherSkeletonTitanTemplarSpawnCap.get();
        }
        return (Integer)TheTitansNeoConfigs.skeletonTitanTemplarSpawnCap.get();
    }

    @Override
    public int getSpecialMinionCap() {
        if (this.getSkeletonType() == 1) {
            return (Integer)TheTitansNeoConfigs.witherSkeletonTitanSpecialSpawnCap.get();
        }
        return super.getSpecialMinionCap();
    }

    @Override
    public boolean canSpawnMinion() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        if (this.getSkeletonType() == 1) {
            return flag || (double)randomRate < (Double)TheTitansNeoConfigs.witherSkeletonTitanSummonMinionSpawnRate.get();
        }
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.skeletonTitanSummonMinionSpawnRate.get();
    }

    @Override
    public boolean canSpawnPriest() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        if (this.getSkeletonType() == 1) {
            return flag || (double)randomRate < (Double)TheTitansNeoConfigs.witherSkeletonTitanSummonPriestSpawnRate.get();
        }
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.skeletonTitanSummonPriestSpawnRate.get();
    }

    @Override
    public boolean canSpawnZealot() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        if (this.getSkeletonType() == 1) {
            return flag || (double)randomRate < (Double)TheTitansNeoConfigs.witherSkeletonTitanSummonZealotSpawnRate.get();
        }
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.skeletonTitanSummonZealotSpawnRate.get();
    }

    @Override
    public boolean canSpawnBishop() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        if (this.getSkeletonType() == 1) {
            return flag || (double)randomRate < (Double)TheTitansNeoConfigs.witherSkeletonTitanSummonBishopSpawnRate.get();
        }
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.skeletonTitanSummonBishopSpawnRate.get();
    }

    @Override
    public boolean canSpawnTemplar() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        if (this.getSkeletonType() == 1) {
            return flag || (double)randomRate < (Double)TheTitansNeoConfigs.witherSkeletonTitanSummonTemplarSpawnRate.get();
        }
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.skeletonTitanSummonTemplarSpawnRate.get();
    }

    @Override
    public boolean canSpawnSpecialMinion() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        if (this.getSkeletonType() == 1) {
            return flag || (double)randomRate < (Double)TheTitansNeoConfigs.witherSkeletonTitanSummonSpecialMinionSpawnRate.get();
        }
        return super.canSpawnSpecialMinion();
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        if (this.getSkeletonType() == 1) {
            return EnumTitanStatus.GREATER;
        }
        return EnumTitanStatus.AVERAGE;
    }

    @Override
    public int getFootStepModifer() {
        if (this.getSkeletonType() == 1) {
            return 2;
        }
        return 3;
    }

    @Override
    public float getSpeed() {
        if (this.getSkeletonType() == 1) {
            return (float)(0.4 + (double)this.getExtraPower() * 0.001);
        }
        return (float)(0.3 + (double)this.getExtraPower() * 0.001);
    }

    protected SoundEvent getAmbientSound() {
        if (!this.getWaiting() && this.getAnimationID() != 13) {
            if (this.getSkeletonType() == 1) {
                return (SoundEvent)TheTitansNeoSounds.TITAN_WITHER_SKELETON_LIVING.get();
            }
            return (SoundEvent)TheTitansNeoSounds.TITAN_SKELETON_LIVING.get();
        }
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        if (this.getSkeletonType() == 1) {
            return (SoundEvent)TheTitansNeoSounds.TITAN_WITHER_SKELETON_GRUNT.get();
        }
        return (SoundEvent)TheTitansNeoSounds.TITAN_SKELETON_GRUNT.get();
    }

    protected SoundEvent getDeathSound() {
        if (this.getSkeletonType() == 1) {
            return (SoundEvent)TheTitansNeoSounds.TITAN_WITHER_SKELETON_DEATH.get();
        }
        return (SoundEvent)TheTitansNeoSounds.TITAN_SKELETON_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.shakeNearbyPlayerCameras(4000.0);
        this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STEP.get(), 10.0f, 1.0f);
        this.playSound(SoundEvents.SKELETON_STEP, 10.0f, 0.5f);
        if (!this.getWaiting() && this.getAnimationID() != 13) {
            float f1 = this.getYRot() * (float)Math.PI / 180.0f;
            float f2 = Mth.sin((float)f1);
            float f3 = Mth.cos((float)f1);
            if (this.footID == 0) {
                this.collideWithEntities(this.leftLeg, this.level().getEntities((Entity)this, this.leftLeg.getBoundingBox().inflate(1.0, 1.0, 1.0).move((double)(f2 * 4.0f), 0.0, (double)(f3 * 4.0f))));
                this.destroyBlocksInAABB(this.leftLeg.getBoundingBox().move(0.0, -1.0, 0.0));
                ++this.footID;
            } else {
                this.collideWithEntities(this.rightLeg, this.level().getEntities((Entity)this, this.rightLeg.getBoundingBox().inflate(1.0, 1.0, 1.0).move((double)(f2 * 4.0f), 0.0, (double)(f3 * 4.0f))));
                this.destroyBlocksInAABB(this.rightLeg.getBoundingBox().move(0.0, -1.0, 0.0));
                this.footID = 0;
            }
        }
    }

    @Override
    public void attackEntity(LivingEntity entity, float amount) {
        if (this.isArmored()) {
            amount *= 2.0f;
        }
        if (this.getSkeletonType() == 1) {
            entity.addEffect(new MobEffectInstance(MobEffects.WITHER, 800, 3));
            entity.addEffect(new MobEffectInstance(TheTitansNeoMobEffects.ADVANCED_WITHER, 100, 3));
        }
        super.attackEntity(entity, amount);
    }

    @Override
    public boolean attackEntityFromPart(EntityTitanPart entityTitanPart, DamageSource damageSource, float amount) {
        if (entityTitanPart != this.head) {
            amount /= 3.0f;
        }
        this.hurt(damageSource, amount);
        return true;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float amount) {
        if (this.isArmored()) {
            amount /= 2.0f;
        }
        if (this.isStunned) {
            amount *= 3.0f;
        }
        return super.hurt(damageSource, amount);
    }

    @Override
    protected void dropExperienceOrb() {
        for (int x = 0; x < (this.getSkeletonType() == 1 ? 70 : 16); ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getSkeletonType() == 1 ? 24000 : 14000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
    }

    @Override
    protected void dropAllItem() {
        int count;
        ItemStack itemStack;
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> rateDrops = new HashMap<ItemStack, Integer>();
        if (this.getSkeletonType() == 1) {
            drops.put(new ItemStack((ItemLike)Items.DIAMOND), 16);
            drops.put(new ItemStack((ItemLike)Items.IRON_INGOT), 32);
            drops.put(new ItemStack((ItemLike)Items.BONE), 128);
            drops.put(new ItemStack((ItemLike)Items.COAL), 128);
            drops.put(new ItemStack((ItemLike)Items.EMERALD), 128);
            drops.put(new ItemStack((ItemLike)Items.DIAMOND), 128);
            drops.put(new ItemStack((ItemLike)Items.BLACK_DYE), 256);
            drops.put(new ItemStack(TheTitansNeoItems.HARCADIUM), 64);
            drops.put(new ItemStack(TheTitansNeoItems.VOID), 32);
            drops.put(new ItemStack((ItemLike)Blocks.BEDROCK), 16);
            rateDrops.put(new ItemStack((ItemLike)Items.BONE), 128);
            rateDrops.put(new ItemStack((ItemLike)Items.COAL), 128);
            rateDrops.put(new ItemStack((ItemLike)Items.EMERALD), 128);
            rateDrops.put(new ItemStack((ItemLike)Items.DIAMOND), 128);
            rateDrops.put(new ItemStack((ItemLike)Items.BLACK_DYE), 256);
            rateDrops.put(new ItemStack(TheTitansNeoItems.HARCADIUM), 64);
            rateDrops.put(new ItemStack(TheTitansNeoItems.VOID), 32);
            rateDrops.put(new ItemStack((ItemLike)Blocks.BEDROCK), 16);
        } else {
            drops.put(new ItemStack((ItemLike)Items.STICK), 48);
            drops.put(new ItemStack((ItemLike)Items.STRING), 48);
            drops.put(new ItemStack((ItemLike)Items.ARROW), 128);
            rateDrops.put(new ItemStack((ItemLike)Items.ARROW), 128);
            rateDrops.put(new ItemStack((ItemLike)Items.EMERALD), 16);
            rateDrops.put(new ItemStack((ItemLike)Items.DIAMOND), 16);
            rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM.get()), 4);
        }
        for (Map.Entry entry : drops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
        for (Map.Entry entry : rateDrops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            int randomCount = this.getRandom().nextInt(count) + 1;
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, randomCount);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        AnimationUtils.sendPacket(this, 10);
        this.isStunned = false;
        if (this.deathTicks >= 500) {
            this.setInvulTime(this.getInvulTime() + 8);
            this.setAnimationTick(this.getAnimationTick() - 1);
            float f = (this.random.nextFloat() - 0.5f) * 12.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 3.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 12.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.onDeath();
            if (!this.level().isClientSide() && !this.isRemoved()) {
                for (EntityTitanPart part : this.parts) {
                    part.remove(Entity.RemovalReason.KILLED);
                }
                this.removeTitan(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public void finalizeMinionSummon(Entity entity, EnumMinionType minionType) {
        if (minionType != EnumMinionType.SPECIAL) {
            if (entity instanceof EntitySkeletonTitanMinion) {
                EntitySkeletonTitanMinion skeletonTitanMinion = (EntitySkeletonTitanMinion)entity;
                skeletonTitanMinion.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 40, 4, true, false));
            } else if (entity instanceof EntityWitherSkeletonTitanMinion) {
                EntityWitherSkeletonTitanMinion witherSkeletonTitanMinion = (EntityWitherSkeletonTitanMinion)entity;
                witherSkeletonTitanMinion.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 40, 4, true, false));
            }
        }
    }

    public void animationTick() {
        EntityColorLightningBolt colorLightningBolt2;
        List entities;
        Object colorLightningBolt1;
        LivingEntity livingEntity;
        List entities2;
        int knockbackAmount;
        float amount;
        if (this.getAnimationID() == 13) {
            this.addDayTime(14000L, 50L);
            if (this.getAnimationTick() == 1) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_BIRTH.get(), 1000.0f, this.getSkeletonType() == 1 ? 0.875f : 1.0f);
            }
            if (this.getAnimationTick() == 10) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SKELETON_AWAKEN.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 100) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_RUMBLE.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 160) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SKELETON_BEGIN_MOVE.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 280) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_QUAKE.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 300) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_RUMBLE.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 520) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SKELETON_GETUP.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 230 || this.getAnimationTick() == 550 || this.getAnimationTick() == 590 || this.getAnimationTick() == 610) {
                this.playStepSound(new BlockPos(0, 0, 0), Blocks.STONE.defaultBlockState());
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PRESS.get(), this.getSoundVolume(), 1.0f);
            }
        }
        if (this.getAnimationID() == 1 && this.getAnimationTick() == 12 && this.getTarget() != null) {
            this.shakeNearbyPlayerCameras(20000.0);
            if (this.isArmored()) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.05f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.1f);
                for (int i = 0; i < 3; ++i) {
                    this.collideWithEntities(this.pelvis, this.level().getEntities((Entity)this, this.pelvis.getBoundingBox().inflate(26.0, 26.0, 26.0)));
                }
            }
            amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount = this.getKnockbackAmount();
            this.collideWithEntities(this.pelvis, this.level().getEntities((Entity)this, this.pelvis.getBoundingBox().inflate(48.0, 48.0, 48.0)));
            for (int i = 0; i < (this.getSkeletonType() == 1 ? 8 : 4); ++i) {
                this.attackEntity(this.getTarget(), amount);
            }
            this.knockbackEntity(this.getTarget(), knockbackAmount);
            entities2 = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(8.0, 8.0, 8.0));
            for (Entity entity : entities2) {
                if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                livingEntity = (LivingEntity)entity;
                for (int i = 0; i < 2; ++i) {
                    this.attackEntity(livingEntity, amount);
                }
                this.knockbackEntity(livingEntity, knockbackAmount);
            }
        }
        if (this.getAnimationID() == 2) {
            if (this.getAnimationTick() == 24) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 5.0f, 1.0f);
            }
            if (this.getAnimationTick() == 26 && this.getTarget() != null) {
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount();
                this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(4.0, 2.0, 4.0)));
                this.attackEntity(this.getTarget(), amount);
                this.knockbackEntity(this.getTarget(), knockbackAmount);
                entities2 = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(6.0, 2.0, 6.0));
                for (Entity entity : entities2) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity = (LivingEntity)entity;
                    this.attackEntity(livingEntity, amount);
                    this.knockbackEntity(livingEntity, knockbackAmount);
                }
            }
        }
        if (this.getAnimationID() == 3 && this.getAnimationTick() == 58) {
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, this.getSkeletonType() == 1 ? 1.0f : 0.9f);
            float d0 = this.getSkeletonType() == 1 ? 16.0f : 8.0f;
            float f3 = this.yBodyRot * (float)Math.PI / 180.0f;
            float f11 = Mth.sin((float)f3);
            float f4 = Mth.cos((float)f3);
            float amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            int knockbackAmount2 = this.getKnockbackAmount();
            if (!this.level().isClientSide()) {
                this.level().explode((Entity)this, this.getX() - (double)(f11 * d0), this.getY(), this.getZ() + (double)(f4 * d0), 5.0f, false, Level.ExplosionInteraction.MOB);
            }
            this.collideWithEntities(this.pelvis, this.level().getEntities((Entity)this, this.pelvis.getBoundingBox().inflate(16.0, 8.0, 16.0)));
            List entities3 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 2.0, 32.0).move((double)(-(f11 * d0)), -8.0, (double)(f4 * d0)));
            for (Entity entity : entities3) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity2 = (LivingEntity)entity;
                this.attackEntity(livingEntity2, amount2);
                this.knockbackEntity(livingEntity2, knockbackAmount2);
            }
        }
        if (this.getAnimationID() == 4) {
            if (this.getAnimationTick() == 24) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 5.0f, 1.0f);
            }
            if (this.getAnimationTick() == 26 && this.getTarget() != null) {
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount3 = this.getKnockbackAmount();
                this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(4.0, 2.0, 4.0)));
                for (int i = 0; i < 2; ++i) {
                    this.attackEntity(this.getTarget(), amount);
                }
                this.knockbackEntity(this.getTarget(), knockbackAmount3);
                List entities4 = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(6.0, 2.0, 6.0));
                for (Entity entity : entities4) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity3 = (LivingEntity)entity;
                    this.attackEntity(livingEntity3, amount);
                    this.knockbackEntity(livingEntity3, knockbackAmount3);
                }
            }
        }
        if (this.getAnimationID() == 5) {
            if (this.getAnimationTick() == 230 + this.getRandom().nextInt(100) && this.getTarget() != null) {
                double d8 = 46.0;
                Vec3 vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                if (!this.level().isClientSide()) {
                    this.level().explode((Entity)this, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                    this.level().explode((Entity)this, this.getX() + dx, this.getY() + (this.getSkeletonType() == 1 ? 32.0 : 16.0) + 4.0, this.getZ() + dz, 1.0f, false, Level.ExplosionInteraction.MOB);
                }
                for (int i = 0; i < 5; ++i) {
                    EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(this.level(), this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f);
                    colorLightningBolt.setPos(this.getX() + dx, this.getY() + (this.getSkeletonType() == 1 ? 32.0 : 16.0) + 4.0, this.getZ() + dz);
                    if (this.level().isClientSide()) continue;
                    this.level().addFreshEntity((Entity)colorLightningBolt);
                }
                colorLightningBolt1 = new EntityColorLightningBolt(this.level(), this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f);
                colorLightningBolt1.setPos(this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ());
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)colorLightningBolt1);
                }
                float amount3 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount4 = this.getKnockbackAmount();
                this.attackEntity(this.getTarget(), amount3 * 3.0f);
                this.knockbackEntity(this.getTarget(), knockbackAmount4);
                this.getTarget().push(0.0, 2.0 + this.getRandom().nextDouble(), 0.0);
                entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(16.0, 16.0, 16.0));
                for (Entity entity : entities) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity4 = (LivingEntity)entity;
                    for (int i = 0; i < 4; ++i) {
                        colorLightningBolt2 = new EntityColorLightningBolt(this.level(), this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f);
                        colorLightningBolt2.setPos(livingEntity4.getX(), livingEntity4.getY(), livingEntity4.getZ());
                        if (this.level().isClientSide()) continue;
                        this.level().addFreshEntity((Entity)colorLightningBolt2);
                    }
                    this.attackEntity(livingEntity4, amount3);
                    this.knockbackEntity(livingEntity4, knockbackAmount4);
                    livingEntity4.push(0.0, 2.0 + this.getRandom().nextDouble(), 0.0);
                }
            }
            if (this.getAnimationTick() >= 100 && this.getAnimationTick() <= 300 && this.getTarget() != null) {
                for (int i = 0; i < 8; ++i) {
                    this.playSound(SoundEvents.CROSSBOW_SHOOT, 3.0f, 1.9f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                    this.lookAt((Entity)this.getTarget(), 180.0f, 30.0f);
                    float dis = 10.0f;
                    float xfac = Mth.sin((float)(this.yBodyRot * (float)Math.PI / 180.0f));
                    float zfac = Mth.cos((float)(this.yBodyRot * (float)Math.PI / 180.0f));
                    double dx = xfac * dis;
                    double dz = zfac * dis;
                    double d0 = this.getX() - dx;
                    double d1 = this.getY() + 18.0;
                    double d2 = this.getZ() + dz;
                    double d3 = this.getTarget().getX() - d0;
                    double d4 = this.getTarget().getY() - d1;
                    double d5 = this.getTarget().getZ() - d2;
                    double d6 = Math.sqrt(d3 * d3 + d5 * d5);
                    int knockbackAmount5 = 5;
                    EntityHarcadiumArrow arrow = new EntityHarcadiumArrow(this, this.level()){

                        public void tick() {
                            super.tick();
                            if ((this.inGround || this.onGround()) && !this.level().isClientSide()) {
                                this.discard();
                            }
                        }
                    };
                    arrow.setOwner((Entity)this);
                    arrow.setPos(d0, d1, d2);
                    arrow.shoot(d3, d4 + d6, d5, (float)(d6 * 3.1415927410125732 / 180.0 * (double)1.6f), 36.0f);
                    arrow.setBaseDamage(90.0);
                    arrow.setCritArrow(true);
                    if (this.getSkeletonType() == 1) {
                        arrow.setRemainingFireTicks(10000);
                    }
                    if (!this.level().isClientSide()) {
                        this.level().addFreshEntity((Entity)arrow);
                    }
                    if (!(this.distanceToSqr((Entity)this.getTarget()) <= this.getMeleeRange())) continue;
                    this.attackEntity(this.getTarget(), 10.0f);
                    this.knockbackEntity(this.getTarget(), knockbackAmount5);
                }
            }
        }
        if (this.getAnimationID() == 6 && (this.getAnimationTick() == 60 || this.getAnimationTick() == 104)) {
            this.shakeNearbyPlayerCameras(20000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 100.0f, 1.0f);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PRESS.get(), 100.0f, 1.0f);
            float amount4 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            this.collideWithEntities(this.pelvis, this.level().getEntities((Entity)this, this.pelvis.getBoundingBox().inflate(16.0, 8.0, 16.0)));
            List entities5 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 8.0, 32.0));
            for (Entity entity : entities5) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity5 = (LivingEntity)entity;
                this.attackEntity(livingEntity5, amount4);
                livingEntity5.push(0.0, 1.0 + this.getRandom().nextDouble() + this.getRandom().nextDouble(), 0.0);
            }
        }
        if (this.getAnimationID() == 7) {
            if (this.getAnimationTick() == 90) {
                this.shakeNearbyPlayerCameras(20000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 100.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PRESS.get(), 100.0f, 1.0f);
                float d0 = this.getSkeletonType() == 1 ? 64.0f : 32.0f;
                float f3 = this.yBodyRot * (float)Math.PI / 180.0f;
                float f11 = Mth.sin((float)f3);
                float f4 = Mth.cos((float)f3);
                float amount5 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount6 = this.getKnockbackAmount();
                this.collideWithEntities(this.pelvis, this.level().getEntities((Entity)this, this.pelvis.getBoundingBox().inflate(16.0, 8.0, 16.0)));
                List entities6 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 2.0, 32.0).move((double)(-(f11 * d0)), -8.0, (double)(f4 * d0)));
                for (Entity entity : entities6) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity6 = (LivingEntity)entity;
                    this.attackEntity(livingEntity6, amount5 * 15.0f);
                    this.knockbackEntity(livingEntity6, knockbackAmount6);
                    livingEntity6.push(0.0, 2.0 + this.getRandom().nextDouble(), 0.0);
                }
            }
            if (this.getAnimationTick() == 92) {
                float dis = this.getSkeletonType() == 1 ? 32.0f : 16.0f;
                float xfac = Mth.sin((float)(this.yBodyRot * (float)Math.PI / 180.0f));
                float zfac = Mth.cos((float)(this.yBodyRot * (float)Math.PI / 180.0f));
                int x = Mth.floor((double)(this.getX() - (double)(xfac * dis * 2.0f)));
                int y = Mth.floor((double)this.getY());
                int z = Mth.floor((double)(this.getZ() + (double)(zfac * dis * 2.0f)));
                BlockPos blockPos = new BlockPos(x, y - 1, z);
                BlockState blockState = this.level().getBlockState(blockPos);
                if (!blockState.isAir()) {
                    this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
                    this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
                    this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PRESS.get(), 100.0f, 1.0f);
                }
                for (int rangeX = -4; rangeX <= 4; ++rangeX) {
                    for (int rangeY = -1; rangeY <= 1; ++rangeY) {
                        for (int rangeZ = -4; rangeZ <= 4; ++rangeZ) {
                            int posX = x + rangeX;
                            int posY = y + rangeY;
                            int posZ = z + rangeZ;
                            BlockPos pos = new BlockPos(posX, posY, posZ);
                            BlockState state = this.level().getBlockState(pos);
                            Block block = state.getBlock();
                            if (!state.isAir() && block == Blocks.GRASS_BLOCK) {
                                this.level().setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
                            }
                            if (!(block.getExplosionResistance() > 500.0f)) continue;
                            this.playSound(SoundEvents.ANVIL_LAND, 20.0f, 0.5f);
                            AnimationUtils.sendPacket(this, 8);
                            this.isStunned = true;
                        }
                    }
                }
            }
        }
        if (this.getAnimationID() == 8) {
            if (this.getAnimationTick() == 70) {
                this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 8.0f, 0.9f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 10.0f, 1.0f);
            }
            if (this.getAnimationTick() == 74) {
                this.playSound((SoundEvent)TheTitansNeoSounds.DISTANT_LARGE_FALL.get(), 10000.0f, 1.0f);
                this.playSound(this.getHurtSound(null), this.getSoundVolume(), this.getVoicePitch());
            }
            if (this.getAnimationTick() == 480) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 10.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STEP.get(), 10.0f, 1.0f);
                this.playSound(SoundEvents.SKELETON_STEP, 10.0f, 0.5f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STEP.get(), 10.0f, 1.0f);
                this.playSound(SoundEvents.SKELETON_STEP, 10.0f, 0.5f);
                for (int i = 0; i < 2; ++i) {
                    this.collideWithEntities(this.leftLeg, this.level().getEntities((Entity)this, this.leftLeg.getBoundingBox().inflate(16.0, 1.0, 16.0)));
                    this.collideWithEntities(this.rightLeg, this.level().getEntities((Entity)this, this.rightLeg.getBoundingBox().inflate(16.0, 1.0, 16.0)));
                }
            }
            if (this.getAnimationTick() == 450) {
                this.isStunned = false;
            } else {
                this.setTarget(null);
            }
        }
        if (this.getAnimationID() == 9) {
            if (this.getAnimationTick() == 48 && this.getTarget() != null) {
                double d8 = 46.0;
                Vec3 vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                if (!this.level().isClientSide()) {
                    this.level().explode((Entity)this, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                    this.level().explode((Entity)this, this.getX() + dx, this.getY() + (this.getSkeletonType() == 1 ? 32.0 : 16.0) + 4.0, this.getZ() + dz, 1.0f, false, Level.ExplosionInteraction.MOB);
                }
                for (int i = 0; i < 5; ++i) {
                    EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(this.level(), this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f);
                    colorLightningBolt.setPos(this.getX() + dx, this.getY() + (this.getSkeletonType() == 1 ? 32.0 : 16.0) + 4.0, this.getZ() + dz);
                    if (this.level().isClientSide()) continue;
                    this.level().addFreshEntity((Entity)colorLightningBolt);
                }
                colorLightningBolt1 = new EntityColorLightningBolt(this.level(), this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f);
                colorLightningBolt1.setPos(this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ());
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)colorLightningBolt1);
                }
                float amount6 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount7 = this.getKnockbackAmount();
                this.attackEntity(this.getTarget(), amount6 * 3.0f);
                this.knockbackEntity(this.getTarget(), knockbackAmount7);
                this.getTarget().push(0.0, 2.0 + this.getRandom().nextDouble(), 0.0);
                entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(16.0, 16.0, 16.0));
                for (Entity entity : entities) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity7 = (LivingEntity)entity;
                    for (int i = 0; i < 4; ++i) {
                        colorLightningBolt2 = new EntityColorLightningBolt(this.level(), this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f);
                        colorLightningBolt2.setPos(livingEntity7.getX(), livingEntity7.getY(), livingEntity7.getZ());
                        if (this.level().isClientSide()) continue;
                        this.level().addFreshEntity((Entity)colorLightningBolt2);
                    }
                    this.attackEntity(livingEntity7, amount6);
                    this.knockbackEntity(livingEntity7, knockbackAmount7);
                    livingEntity7.push(0.0, 2.0 + this.getRandom().nextDouble(), 0.0);
                }
            }
            if (this.getAnimationTick() >= 26 && this.getAnimationTick() <= 50) {
                float dis = this.getSkeletonType() == 1 ? 32.0f : 16.0f;
                double d8 = this.getAnimationTick() - 4;
                Vec3 vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(this.level(), this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f);
                colorLightningBolt.setPos(this.getX() - dx, this.getY() + (double)dis + 4.0, this.getZ() + dz);
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)colorLightningBolt);
                }
            }
        }
        if (this.getAnimationID() == 10) {
            if (this.getAnimationTick() == 30 || this.getAnimationTick() == 70) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STEP.get(), 10.0f, 1.0f);
            }
            if (this.getAnimationTick() == 190) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 20.0f, 1.0f);
                this.collideWithEntities(this.leftLeg, this.level().getEntities((Entity)this, this.leftLeg.getBoundingBox().inflate(16.0, 1.0, 16.0)));
                this.collideWithEntities(this.rightLeg, this.level().getEntities((Entity)this, this.rightLeg.getBoundingBox().inflate(16.0, 1.0, 16.0)));
            }
            if (this.getAnimationTick() == 200) {
                this.playSound((SoundEvent)TheTitansNeoSounds.DISTANT_LARGE_FALL.get(), 10000.0f, 1.0f);
            }
        }
        if (this.getAnimationID() == 11 && this.getAnimationTick() == 78 && this.getTarget() != null) {
            this.playSound(SoundEvents.CROSSBOW_SHOOT, 10.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.lookAt((Entity)this.getTarget(), 180.0f, 30.0f);
            float dis = 10.0f;
            float xfac = Mth.sin((float)(this.yBodyRot * (float)Math.PI / 180.0f));
            float zfac = Mth.cos((float)(this.yBodyRot * (float)Math.PI / 180.0f));
            double dx = xfac * dis;
            double dz = zfac * dis;
            double d0 = this.getX() - dx;
            double d1 = this.getY() + 17.0;
            double d2 = this.getZ() + dz;
            double d3 = this.getTarget().getX() - d0;
            double d4 = this.getTarget().getY() - d1;
            double d5 = this.getTarget().getZ() - d2;
            int knockbackAmount8 = 5;
            EntityArrowTitan arrowTitan = new EntityArrowTitan(this.level());
            arrowTitan.setOwner((Entity)this);
            arrowTitan.setPos(d0, d1, d2);
            arrowTitan.shoot(d3, d4, d5, 10.0f, 0.0f);
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)arrowTitan);
            }
            if (this.distanceToSqr((Entity)this.getTarget()) <= this.getMeleeRange()) {
                this.attackEntity(this.getTarget(), 10.0f);
                this.knockbackEntity(this.getTarget(), knockbackAmount8);
            }
        }
        if (this.getAnimationID() == 12 && this.getAnimationTick() == 40) {
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 20.0f, 2.0f);
            this.playSound(SoundEvents.WITHER_SHOOT, 20.0f, 1.0f);
            float dis = this.getSkeletonType() == 1 ? 32.0f : 16.0f;
            float xfac = Mth.sin((float)(this.yBodyRot * (float)Math.PI / 180.0f));
            float zfac = Mth.cos((float)(this.yBodyRot * (float)Math.PI / 180.0f));
            float amount7 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            int knockbackAmount9 = this.getKnockbackAmount();
            if (!this.level().isClientSide()) {
                this.level().explode((Entity)this, this.getX() - (double)(xfac * dis) * 0.9, this.getY() + (double)dis * 1.25, this.getZ() + (double)(zfac * dis) * 0.9, 3.0f, false, Level.ExplosionInteraction.MOB);
            }
            EntityColorLightningBolt colorLightningBolt12 = new EntityColorLightningBolt(this.level(), this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f);
            colorLightningBolt12.setPos(this.getX() - (double)(xfac * dis) * 0.9, this.getY() + (double)dis * 1.25, this.getZ() + (double)(zfac * dis) * 0.9);
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)colorLightningBolt12);
            }
            if (this.getTarget() != null) {
                if (!this.level().isClientSide()) {
                    this.level().explode((Entity)this, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 3.0f, false, Level.ExplosionInteraction.MOB);
                }
                EntityColorLightningBolt colorLightningBolt22 = new EntityColorLightningBolt(this.level(), this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f, this.getSkeletonType() == 1 ? 0.0f : 0.5f);
                colorLightningBolt22.setPos(this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ());
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)colorLightningBolt22);
                }
                this.getTarget().hurt(this.damageSources().lightningBolt(), amount7);
                this.attackEntity(this.getTarget(), amount7 * 5.0f);
                this.knockbackEntity(this.getTarget(), knockbackAmount9);
                this.getTarget().push(0.0, 1.0 + this.getRandom().nextDouble(), 0.0);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.refreshDimensions();
        this.checkWaiting(16.0);
        if (this.isPassenger() && this.getVehicle() instanceof EntitySpiderTitan) {
            EntitySpiderTitan spiderTitan = (EntitySpiderTitan)this.getVehicle();
            if (!this.getWaiting() && this.getAnimationID() == 13 && spiderTitan.getAnimationID() == 13) {
                spiderTitan.setYRot(this.getYRot());
                spiderTitan.yHeadRot = this.yHeadRot;
                spiderTitan.yBodyRot = this.yBodyRot;
            }
            if (spiderTitan.getTarget() == this) {
                spiderTitan.setTarget(null);
            }
            if (this.getTarget() != null) {
                if (this.getTarget() == spiderTitan) {
                    this.setTarget(null);
                } else {
                    spiderTitan.setTarget(this.getTarget());
                }
            }
        }
        if (!(this.getAnimationID() != 0 || this.isPassenger() || this.getWaiting() || this.isStunned)) {
            if (this.getTarget() != null) {
                double d = this.distanceToSqr((Entity)this.getTarget());
                double d2 = this.getMeleeRange();
                double d3 = !this.getTarget().onGround() ? 1000.0 : 8000.0;
                if (d > d2 + d3) {
                    if (this.getY() <= this.getTarget().getY() + 12.0 && this.getY() < 256.0 - (double)this.getBbHeight()) {
                        this.fallDistance = 0.0f;
                        this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.9 - this.getDeltaMovement().y, this.getDeltaMovement().z);
                        if (this.getDeltaMovement().y < 0.0) {
                            this.setTitanDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
                        }
                    }
                    this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * 0.6, this.getDeltaMovement().z);
                }
            }
            if (!this.onGround()) {
                float f3 = (this.getRandom().nextFloat() - 0.5f) * (this.getSkeletonType() == 1 ? 30.0f : 10.0f);
                float f4 = (this.getRandom().nextFloat() - 0.5f) * 1.0f;
                float f5 = (this.getRandom().nextFloat() - 0.5f) * (this.getSkeletonType() == 1 ? 30.0f : 10.0f);
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f3, this.getY() + 5.0 + (double)f4, this.getZ() + (double)f5, 0.0, 0.0, 0.0);
            }
        }
        if (this.tickCount > 5) {
            float f = this.yBodyRot * (float)Math.PI / 180.0f;
            float f1 = Mth.sin((float)f);
            float f2 = Mth.cos((float)f);
            if (this.getSkeletonType() == 1) {
                this.head.setSize(14.0f, 14.0f);
                this.pelvis.setSize(10.5f, 3.5f);
                this.spine.setSize(2.0f, 21.0f);
                this.ribCage.setSize(12.25f, 8.75f);
                this.leftArm.setSize(3.5f, 21.0f);
                this.rightArm.setSize(3.5f, 21.0f);
                this.leftLeg.setSize(3.5f, 21.0f);
                this.rightLeg.setSize(3.5f, 21.0f);
            } else {
                this.head.setSize(8.0f, 8.0f);
                this.pelvis.setSize(6.0f, 2.0f);
                this.spine.setSize(2.0f, 12.0f);
                this.ribCage.setSize(7.5f, 5.0f);
                this.leftArm.setSize(2.0f, 12.0f);
                this.rightArm.setSize(2.0f, 12.0f);
            }
            this.head.moveTo(this.getX(), this.getY() + (this.getSkeletonType() == 1 ? 42.0 : 24.0), this.getZ());
            this.pelvis.moveTo(this.getX(), this.getY() + (this.getSkeletonType() == 1 ? 21.0 : 12.0), this.getZ());
            this.spine.moveTo(this.getX() + (double)f1 * (this.getSkeletonType() == 1 ? 3.5 : 2.0), this.getY() + (this.getSkeletonType() == 1 ? 21.0 : 12.0), this.getZ() - (double)f2 * (this.getSkeletonType() == 1 ? 3.5 : 2.0));
            this.ribCage.moveTo(this.getX(), this.getY() + (this.getSkeletonType() == 1 ? 33.25 : 19.0), this.getZ());
            this.leftArm.moveTo(this.getX() - (double)f2 * (this.getSkeletonType() == 1 ? 8.75 : 5.0), this.getY() + (this.getSkeletonType() == 1 ? 20.125 : 11.5), this.getZ() - (double)f1 * (this.getSkeletonType() == 1 ? 8.75 : 5.0));
            this.rightArm.moveTo(this.getX() + (double)f2 * (this.getSkeletonType() == 1 ? 8.75 : 5.0), this.getY() + (this.getSkeletonType() == 1 ? 20.125 : 11.5), this.getZ() + (double)f1 * (this.getSkeletonType() == 1 ? 8.75 : 5.0));
            this.leftLeg.moveTo(this.getX() - (double)f2 * (this.getSkeletonType() == 1 ? 3.5 : 2.0), this.getY(), this.getZ() - (double)f1 * (this.getSkeletonType() == 1 ? 3.5 : 2.0));
            this.rightLeg.moveTo(this.getX() + (double)f2 * (this.getSkeletonType() == 1 ? 3.5 : 2.0), this.getY(), this.getZ() + (double)f1 * (this.getSkeletonType() == 1 ? 3.5 : 2.0));
            if (this.isAlive() && !this.isStunned) {
                this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                this.collideWithEntities(this.pelvis, this.level().getEntities((Entity)this, this.pelvis.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                this.collideWithEntities(this.spine, this.level().getEntities((Entity)this, this.spine.getBoundingBox()));
                this.collideWithEntities(this.ribCage, this.level().getEntities((Entity)this, this.ribCage.getBoundingBox()));
                this.collideWithEntities(this.leftArm, this.level().getEntities((Entity)this, this.leftArm.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                this.collideWithEntities(this.rightArm, this.level().getEntities((Entity)this, this.rightArm.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                this.collideWithEntities(this.leftLeg, this.level().getEntities((Entity)this, this.leftLeg.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                this.collideWithEntities(this.rightLeg, this.level().getEntities((Entity)this, this.rightLeg.getBoundingBox().inflate(1.0, 0.0, 1.0)));
            }
            for (EntityTitanPart part : this.parts) {
                this.destroyBlocksInAABB(part.getBoundingBox());
            }
        }
        if (this.getAnimationID() == 0 && this.getTarget() != null) {
            double d0 = this.distanceToSqr((Entity)this.getTarget());
            if (d0 < this.getMeleeRange()) {
                if (this.getTarget() instanceof EntityTitan || this.getTarget().getBbHeight() >= 6.0f || this.getTarget().getY() > this.getY() + 6.0) {
                    AnimationUtils.sendPacket(this, 1);
                } else {
                    switch (this.getRandom().nextInt(5)) {
                        case 0: {
                            AnimationUtils.sendPacket(this, 6);
                            break;
                        }
                        case 1: {
                            AnimationUtils.sendPacket(this, 3);
                            break;
                        }
                        case 2: {
                            AnimationUtils.sendPacket(this, 7);
                            break;
                        }
                        case 3: {
                            AnimationUtils.sendPacket(this, 2);
                            break;
                        }
                        case 4: {
                            AnimationUtils.sendPacket(this, 4);
                        }
                    }
                }
            } else if (this.getRandom().nextInt(80) == 0) {
                switch (this.getRandom().nextInt(6)) {
                    case 0: {
                        if (this.getSkeletonType() != 1) {
                            AnimationUtils.sendPacket(this, 5);
                            break;
                        }
                        AnimationUtils.sendPacket(this, 9);
                        break;
                    }
                    case 1: {
                        AnimationUtils.sendPacket(this, 12);
                        break;
                    }
                    case 2: {
                        if (this.getSkeletonType() != 1) {
                            AnimationUtils.sendPacket(this, 11);
                            break;
                        }
                        AnimationUtils.sendPacket(this, 12);
                    }
                }
            }
        }
        if (this.isStunned) {
            this.setTarget(null);
            AnimationUtils.sendPacket(this, 8);
        }
        if (this.isStunned || this.deathTicks > 0) {
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
        }
        if (this.getAnimationID() == 5 || this.getAnimationID() == 11) {
            if (this.getAnimationTick() >= 40) {
                ++this.attackTimer;
            }
        } else if (this.getAnimationID() != 5 && this.getAnimationID() != 11) {
            this.attackTimer = 0;
        }
        if (this.attackTimer < 0) {
            this.attackTimer = 0;
        }
        this.meleeTitan = true;
        this.animationTick();
    }
}

