/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityMagmaCubeTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoPredicateTargets;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntitySlimeTitan
extends EntityTitan
implements IBossBarDisplay {
    private static final EntityDataAccessor<Integer> SLIME_SIZE = SynchedEntityData.defineId(EntitySlimeTitan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private int slimeJumpDelay;
    private boolean wasOnGround;
    public boolean doubleJumped;

    public EntitySlimeTitan(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        this.setSlimeSize(4);
    }

    public EntitySlimeTitan(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.SLIME_TITAN.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 4000.0).add(Attributes.ATTACK_DAMAGE, 30.0);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/slime_titan.png");
    }

    @Override
    public int getBossBarNameColor() {
        return 5349438;
    }

    @Override
    public int getBossBarWidth() {
        return 190;
    }

    @Override
    public int getBossBarHeight() {
        return 22;
    }

    @Override
    public int getBossBarInterval() {
        return 2;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 14;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntitySnowGolemTitan>((Mob)this, EntitySnowGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityIronGolemTitan>((Mob)this, EntityIronGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, TheTitansNeoPredicateTargets.SlimeTitan));
    }

    public int getSlimeSize() {
        return (Integer)this.entityData.get(SLIME_SIZE);
    }

    public void setSlimeSize(int slimeSize) {
        this.entityData.set(SLIME_SIZE, (Object)slimeSize);
        this.refreshAttributes();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.85f;
    }

    public int getJumpDelay() {
        return this.getRandom().nextInt(40) + 20;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SLIME_SIZE, (Object)0);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSlimeSize(tag.getInt("SlimeSize"));
        this.wasOnGround = tag.getBoolean("wasOnGround");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("SlimeSize", this.getSlimeSize());
        tag.putBoolean("wasOnGround", this.wasOnGround);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        int i = this.getRandom().nextInt(3);
        if (i < 2 && this.getRandom().nextFloat() < 0.5f) {
            ++i;
        }
        int j = 1 << i;
        this.setSlimeSize(j);
        this.setTitanHealth(this.getMaxHealth());
        return groupData;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        float width = 8.0f * (float)this.getSlimeSize();
        float height = 8.0f * (float)this.getSlimeSize();
        float eyeHeight = 0.625f * height;
        return EntityDimensions.scalable((float)width, (float)height).withEyeHeight(eyeHeight);
    }

    @Override
    protected void refreshAttributes() {
        if (this.level().getDifficulty() == Difficulty.HARD) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)this.getSlimeSize() * 2000.0 + (double)this.getExtraPower() * 200.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)this.getSlimeSize() * 60.0 + (double)this.getExtraPower() * 18.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)this.getSlimeSize() * 1000.0 + (double)this.getExtraPower() * 100.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)this.getSlimeSize() * 30.0 + (double)this.getExtraPower() * 9.0);
        }
    }

    @Override
    public boolean canAttack() {
        return true;
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        if (this.getClass() != EntitySlimeTitan.class) {
            return super.canAttackEntity(entity);
        }
        return super.canAttackEntity(entity) && !(entity instanceof EntitySlimeTitan) && !(entity instanceof Slime);
    }

    @Override
    public boolean shouldMove() {
        return false;
    }

    @Override
    public boolean canRegen() {
        return false;
    }

    @Override
    public SimpleParticleType getParticles() {
        return ParticleTypes.ITEM_SLIME;
    }

    @Override
    public int getParticleCount() {
        return 4;
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.LESSER;
    }

    public int getMaxHeadXRot() {
        return 30;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.SLIME_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SLIME_DEATH;
    }

    protected SoundEvent getSquishSound() {
        return SoundEvents.SLIME_SQUISH;
    }

    public SoundEvent getJumpSound() {
        return SoundEvents.SLIME_JUMP;
    }

    @Override
    public float getSoundVolume() {
        return 1.0f * (float)this.getSlimeSize();
    }

    public float getSoundPitch() {
        float f = 1.4f;
        return ((this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.0f) * f;
    }

    @Override
    public void push(Entity entity) {
        if (entity instanceof EntityTitan) {
            super.push(entity);
        }
        float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
        int knockbackAmount = this.getKnockbackAmount();
        if (entity != null && entity instanceof LivingEntity && this.canAttackEntity(entity)) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.isAlive() && this.tickCount % 5 == 0) {
                this.attackEntity(livingEntity, amount);
                this.knockbackEntity(livingEntity, knockbackAmount);
                if (!entity.isAlive() && !(entity instanceof EntityTitan)) {
                    this.playSound(SoundEvents.SLIME_ATTACK, 100.0f, 0.5f);
                    if (!this.level().isClientSide()) {
                        this.level().broadcastEntityEvent(entity, (byte)60);
                        entity.remove(Entity.RemovalReason.KILLED);
                        MagmaCube slime = this instanceof EntityMagmaCubeTitan ? new MagmaCube(EntityType.MAGMA_CUBE, this.level()) : new Slime(EntityType.SLIME, this.level());
                        this.setPos(this.getX(), this.getY(), this.getZ());
                        this.setYRot(this.getYRot());
                        slime.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(slime.blockPosition()), MobSpawnType.CONVERSION, null);
                        slime.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 4, true, false));
                        this.level().addFreshEntity((Entity)slime);
                    }
                }
            }
        }
    }

    public void playerTouch(Player player) {
    }

    @Override
    public void jumpFromGround() {
        this.setTitanDeltaMovement(this.getDeltaMovement().x, 1.5 + (double)((float)this.getSlimeSize() * 0.2f), this.getDeltaMovement().z);
        this.hasImpulse = true;
        if (this.getTarget() != null) {
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getZ() - this.getZ();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            double hor = 1.5 + (double)this.getSlimeSize() * 0.25;
            this.setTitanDeltaMovement(d0 / d2 * hor * hor + this.getDeltaMovement().x * hor, this.getDeltaMovement().y, d1 / d2 * hor * hor + this.getDeltaMovement().z * hor);
        }
    }

    @Override
    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        this.setOnGround(true);
        this.hasImpulse = false;
        if (fallDistance <= 0.0f) {
            return false;
        }
        MobEffectInstance mobEffectInstance = this.getEffect(MobEffects.JUMP);
        float f1 = mobEffectInstance != null ? (float)(mobEffectInstance.getAmplifier() + 1) : 0.0f;
        int i = Mth.ceil((float)(fallDistance - 12.0f - f1));
        if (i > 0) {
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 5.0f * (float)this.getSlimeSize(), 2.0f - (float)(this.getSlimeSize() / 4));
            this.playSound(SoundEvents.SLIME_JUMP, 5.0f * (float)this.getSlimeSize(), 2.0f - (float)(this.getSlimeSize() / 8));
            float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(6.0 * (double)this.getSlimeSize(), 6.0 * (double)this.getSlimeSize(), 6.0 * (double)this.getSlimeSize()));
            for (Entity entity : entities) {
                double d3;
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity) || !(this.distanceToSqr(entity) <= (double)(this.getBbWidth() * this.getBbWidth() + this.getBbWidth() * this.getBbWidth()))) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                this.attackEntity(livingEntity, amount);
                double d0 = this.getBoundingBox().minX + this.getBoundingBox().maxX;
                double d1 = this.getBoundingBox().minZ + this.getBoundingBox().maxZ;
                double d2 = entity.getX() - d0;
                double d4 = d2 * d2 + (d3 = entity.getZ() - d1) * d3;
                if (!(d4 >= 0.01)) continue;
                double d5 = d2 / d4 * (8.0 * (this.doubleJumped ? 2.0 : 1.0));
                double d6 = 1.0 * (this.doubleJumped ? 2.0 : 1.0);
                double d7 = d3 / d4 * (8.0 * (this.doubleJumped ? 2.0 : 1.0));
                livingEntity.push(d5, d6, d7);
            }
        }
        return true;
    }

    public void kill() {
        super.kill();
        this.setTitanHealth(0.0f);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        LivingEntity entity = this.getTarget();
        if (this.onGround()) {
            this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
            if (this.slimeJumpDelay-- <= 0 && this.getInvulTime() <= 0) {
                this.slimeJumpDelay = this.getJumpDelay();
                if (entity != null) {
                    this.slimeJumpDelay /= 3;
                    this.getLookControl().setLookAt((Entity)entity, 180.0f, 60.0f);
                }
                this.jumpFromGround();
                this.playSound(this.getJumpSound(), this.getSoundVolume(), this.getSoundPitch());
            } else {
                this.xxa = 0.0f;
                this.zza = 0.0f;
                this.setSpeed(0.0f);
            }
        } else {
            this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
        }
    }

    @Override
    protected void dropExperienceOrb() {
        for (int x = 0; x < this.getSlimeSize(); ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), 1000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
    }

    @Override
    protected void dropAllItem() {
        int count;
        ItemStack itemStack;
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> rateDrops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Items.SLIME_BALL), 64);
        drops.put(new ItemStack((ItemLike)Items.COAL), 16);
        rateDrops.put(new ItemStack((ItemLike)Items.SLIME_BALL), 64);
        rateDrops.put(new ItemStack((ItemLike)Items.COAL), 16);
        rateDrops.put(new ItemStack((ItemLike)Items.EMERALD), 8);
        rateDrops.put(new ItemStack((ItemLike)Items.DIAMOND), 8);
        rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM_WAFLET.get()), 4);
        for (Map.Entry entry : drops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
        for (Map.Entry entry : rateDrops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            int randomCount = this.getRandom().nextInt(count) + 1;
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, randomCount);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        this.animateHurt(180.0f);
        this.destroyBlocksInAABB(this.getBoundingBox());
        if (this.deathTicks >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().explode((Entity)this, this.getX(), this.getY() + 3.0, this.getZ(), 0.0f, false, Level.ExplosionInteraction.MOB);
            int i = this.getSlimeSize();
            if (i > 1) {
                try {
                    int j = 2 + this.getRandom().nextInt(3);
                    for (int k = 0; k < j; ++k) {
                        float f = ((float)(k % 2) - 0.5f) * ((float)i * 6.0f);
                        float f1 = ((float)(k / 2) - 0.5f) * ((float)i * 6.0f);
                        Constructor<?> constructor = this.getClass().getDeclaredConstructor(Level.class);
                        EntitySlimeTitan slimeTitan = (EntitySlimeTitan)constructor.newInstance(this.level());
                        slimeTitan.setPos(this.getX() + (double)f, this.getY() + 0.5, this.getZ() + (double)f1);
                        slimeTitan.setXRot(this.getRandom().nextFloat() * 360.0f);
                        if (this.hasCustomName()) {
                            slimeTitan.setCustomName(this.getCustomName());
                        }
                        slimeTitan.setSlimeSize(i / 2);
                        slimeTitan.setTitanHealth(slimeTitan.getMaxHealth());
                        this.level().addFreshEntity((Entity)slimeTitan);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.onDeath();
            }
            this.removeTitan(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.refreshDimensions();
        this.yBodyRot = this.getYRot();
        this.destroyBlocksInAABB(this.getBoundingBox().move(this.getDeltaMovement().x, this.getDeltaMovement().y > 0.0 ? this.getDeltaMovement().y : 0.0, this.getDeltaMovement().z));
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        if (this.onGround() && !this.wasOnGround) {
            int i = this.getSlimeSize();
            for (int j = 0; j < i * 32; ++j) {
                float f = this.getRandom().nextFloat() * (float)Math.PI * 2.0f;
                float f1 = this.getRandom().nextFloat() * 8.0f + 8.0f;
                float f2 = (float)(Math.sin(f) * (double)i * 0.5 * (double)f1);
                float f3 = (float)(Math.cos(f) * (double)i * 0.5 * (double)f1);
                this.level().addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, this.getX() + (double)f2, this.getBoundingBox().minY, this.getZ() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.onGround() && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.onGround();
        this.alterSquishAmount();
        if (this.getTarget() != null) {
            this.lookAt((Entity)this.getTarget(), 180.0f, 40.0f);
            if (!this.onGround() && !this.doubleJumped && this.getRandom().nextInt(100) == 0) {
                this.squishAmount = 2.0f;
                this.jumpFromGround();
                this.doubleJumped = true;
                this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
        } else if (this.doubleJumped) {
            this.doubleJumped = false;
        }
        if (this.onGround()) {
            this.doubleJumped = false;
        }
    }
}

