/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.EntityColorLightningBolt;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.spidertitan.AnimationSpiderTitanAntiTitanAttack;
import net.byAqua3.thetitansneo.entity.ai.spidertitan.AnimationSpiderTitanAttack1;
import net.byAqua3.thetitansneo.entity.ai.spidertitan.AnimationSpiderTitanAttack2;
import net.byAqua3.thetitansneo.entity.ai.spidertitan.AnimationSpiderTitanAttack3;
import net.byAqua3.thetitansneo.entity.ai.spidertitan.AnimationSpiderTitanAttack4;
import net.byAqua3.thetitansneo.entity.ai.spidertitan.AnimationSpiderTitanCreation;
import net.byAqua3.thetitansneo.entity.ai.spidertitan.AnimationSpiderTitanDeath;
import net.byAqua3.thetitansneo.entity.ai.spidertitan.AnimationSpiderTitanShootLightning;
import net.byAqua3.thetitansneo.entity.ai.spidertitan.AnimationSpiderTitanShootWeb;
import net.byAqua3.thetitansneo.entity.ai.spidertitan.AnimationSpiderTitanSpit;
import net.byAqua3.thetitansneo.entity.ai.spidertitan.AnimationSpiderTitanStunned;
import net.byAqua3.thetitansneo.entity.minion.EntitySkeletonTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EntitySpiderTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EntityWitherSkeletonTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.minion.IMinion;
import net.byAqua3.thetitansneo.entity.projectile.EntityWebShot;
import net.byAqua3.thetitansneo.entity.titan.EntityCaveSpiderTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySkeletonTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanPart;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.entity.titan.IEntityMultiPartTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoPredicateTargets;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.util.AnimationUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntitySpiderTitan
extends EntityTitan
implements IEntityMultiPartTitan,
IBossBarDisplay {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(EntitySpiderTitan.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> BONUS_ID = SynchedEntityData.defineId(EntitySpiderTitan.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public EntityTitanPart head = new EntityTitanPart(this, "head", 8.0f, 8.0f);
    public EntityTitanPart thorax = new EntityTitanPart(this, "thorax", 6.0f, 6.0f);
    public EntityTitanPart abdomen = new EntityTitanPart(this, "abdomen", 12.0f, 8.0f);
    public EntityTitanPart leftlegs = new EntityTitanPart(this, "leftleg", 12.0f, 8.0f);
    public EntityTitanPart rightlegs = new EntityTitanPart(this, "rightleg", 12.0f, 8.0f);
    public int damageToLegs;
    public boolean isStunned;

    public EntitySpiderTitan(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        this.parts = new EntityTitanPart[]{this.head, this.thorax, this.abdomen, this.leftlegs, this.rightlegs};
    }

    public EntitySpiderTitan(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.SPIDER_TITAN.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 32000.0).add(Attributes.ATTACK_DAMAGE, 270.0);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        if (this.isInvisible()) {
            return null;
        }
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/spider_titan.png");
    }

    @Override
    public int getBossBarNameColor() {
        return 11013646;
    }

    @Override
    public int getBossBarWidth() {
        return 187;
    }

    @Override
    public int getBossBarHeight() {
        return 23;
    }

    @Override
    public int getBossBarInterval() {
        return 5;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 7;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AnimationSpiderTitanCreation(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSpiderTitanDeath(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSpiderTitanAntiTitanAttack(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSpiderTitanAttack1(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSpiderTitanAttack2(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSpiderTitanAttack3(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSpiderTitanAttack4(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSpiderTitanShootLightning(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSpiderTitanShootWeb(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSpiderTitanSpit(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationSpiderTitanStunned(this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntitySnowGolemTitan>((Mob)this, EntitySnowGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityIronGolemTitan>((Mob)this, EntityIronGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, TheTitansNeoPredicateTargets.SpiderTitan));
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)b0);
    }

    public int getBonusID() {
        return ((Byte)this.entityData.get(BONUS_ID)).byteValue();
    }

    public void setBonusID(int bonusID) {
        this.entityData.set(BONUS_ID, (Object)((byte)bonusID));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
        builder.define(BONUS_ID, (Object)0);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setBonusID(tag.getInt("SpawnedBonusID"));
        this.damageToLegs = tag.getInt("DamageToLegs");
        this.isStunned = tag.getBoolean("IsStunned");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("SpawnedBonusID", this.getBonusID());
        tag.putInt("DamageToLegs", this.damageToLegs);
        tag.putBoolean("IsStunned", this.isStunned);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setWaiting(true);
        if (this.level().getRandom().nextInt(10) == 0) {
            this.setBonusID(this.getRandom().nextInt(5));
        }
        return groupData;
    }

    @Override
    protected void refreshAttributes() {
        if (this.level().getDifficulty() == Difficulty.HARD) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(32000.0 + (double)this.getExtraPower() * 2000.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(270.0 + (double)this.getExtraPower() * 30.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(16000.0 + (double)this.getExtraPower() * 1000.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(135.0 + (double)this.getExtraPower() * 15.0);
        }
    }

    @Override
    public boolean canAttack() {
        return false;
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        if (this.getClass() != EntitySpiderTitan.class) {
            return super.canAttackEntity(entity);
        }
        return super.canAttackEntity(entity) && !(entity instanceof EntitySpiderTitanMinion);
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return !this.isInvulnerable();
    }

    @Override
    public boolean shouldMove() {
        return this.getAnimationID() == 0 && !this.isStunned && this.getTarget() != null ? this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) > this.getMeleeRange() : false;
    }

    @Override
    public boolean canRegen() {
        return !this.isStunned;
    }

    @Override
    public boolean isArmored() {
        return this.deathTicks <= 0 && this.getTitanHealth() <= this.getMaxHealth() / 4.0f;
    }

    @Override
    public int getMinionCap() {
        return (Integer)TheTitansNeoConfigs.spiderTitanMinionSpawnCap.get();
    }

    @Override
    public int getPriestCap() {
        return (Integer)TheTitansNeoConfigs.spiderTitanPriestSpawnCap.get();
    }

    @Override
    public int getZealotCap() {
        return (Integer)TheTitansNeoConfigs.spiderTitanZealotSpawnCap.get();
    }

    @Override
    public int getBishopCap() {
        return (Integer)TheTitansNeoConfigs.spiderTitanBishopSpawnCap.get();
    }

    @Override
    public int getTemplarCap() {
        return (Integer)TheTitansNeoConfigs.spiderTitanTemplarSpawnCap.get();
    }

    @Override
    public boolean canSpawnMinion() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.spiderTitanSummonMinionSpawnRate.get();
    }

    @Override
    public boolean canSpawnPriest() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.spiderTitanSummonPriestSpawnRate.get();
    }

    @Override
    public boolean canSpawnZealot() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.spiderTitanSummonZealotSpawnRate.get();
    }

    @Override
    public boolean canSpawnBishop() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.spiderTitanSummonBishopSpawnRate.get();
    }

    @Override
    public boolean canSpawnTemplar() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.spiderTitanSummonTemplarSpawnRate.get();
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.LESSER;
    }

    @Override
    public float getSpeed() {
        return (float)((this.getBonusID() == 1 ? 0.6 : 0.55) + (double)this.getExtraPower() * 0.001);
    }

    public boolean isInvisible() {
        return this.getBonusID() == 4;
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position();
    }

    protected SoundEvent getAmbientSound() {
        if (!this.isStunned && !this.getWaiting() && this.getAnimationID() != 13) {
            return (SoundEvent)TheTitansNeoSounds.TITAN_SPIDER_LIVING.get();
        }
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)TheTitansNeoSounds.TITAN_SPIDER_GRUNT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TheTitansNeoSounds.TITAN_SPIDER_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        for (int i = 0; i < 2; ++i) {
            this.shakeNearbyPlayerCameras(4000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STEP.get(), 10.0f, 1.5f);
        }
    }

    @Override
    public boolean addEffect(MobEffectInstance mobEffectInstance, Entity entity) {
        if (mobEffectInstance.is(MobEffects.INVISIBILITY)) {
            this.setBonusID(4);
            return true;
        }
        return super.addEffect(mobEffectInstance, entity);
    }

    @Override
    public void attackEntity(LivingEntity entity, float amount) {
        if (this.getBonusID() == 2) {
            amount *= 2.0f;
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
        }
        super.attackEntity(entity, amount);
    }

    @Override
    public boolean attackEntityFromPart(EntityTitanPart entityTitanPart, DamageSource damageSource, float amount) {
        if (entityTitanPart == this.head) {
            amount *= 2.0f;
        }
        if (this.hurt(damageSource, amount) && damageSource.getEntity() != null && damageSource.getEntity() instanceof Player && this.damageToLegs < 8 && !this.isStunned && (entityTitanPart == this.leftlegs || entityTitanPart == this.rightlegs)) {
            ++this.damageToLegs;
            this.hurt(damageSource, 100.0f);
            this.setTarget((LivingEntity)damageSource.getEntity());
            if (this.damageToLegs >= 8) {
                this.playSound(this.getDeathSound(), this.getSoundVolume(), this.getVoicePitch());
                this.isStunned = true;
                this.damageToLegs = 0;
            }
        }
        return true;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float amount) {
        if (this.isArmored()) {
            amount /= 2.0f;
        }
        if (this.isStunned) {
            amount *= 3.0f;
        }
        return super.hurt(damageSource, amount);
    }

    @Override
    protected void dropExperienceOrb() {
        for (int x = 0; x < 8; ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this instanceof EntityCaveSpiderTitan ? 3000 : 4000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
    }

    @Override
    protected void dropAllItem() {
        int count;
        ItemStack itemStack;
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> rateDrops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Items.STRING), 256);
        drops.put(new ItemStack((ItemLike)Items.SPIDER_EYE), 64);
        drops.put(new ItemStack((ItemLike)Items.FERMENTED_SPIDER_EYE), 24);
        drops.put(new ItemStack((ItemLike)Items.LEATHER), 36);
        drops.put(new ItemStack((ItemLike)Blocks.COBWEB), 24);
        drops.put(new ItemStack((ItemLike)Blocks.MOSSY_COBBLESTONE), 24);
        drops.put(new ItemStack((ItemLike)Items.COAL), 32);
        drops.put(new ItemStack((ItemLike)Items.IRON_INGOT), 48);
        drops.put(new ItemStack((ItemLike)Items.EMERALD), 8);
        drops.put(new ItemStack((ItemLike)Items.DIAMOND), 8);
        rateDrops.put(new ItemStack((ItemLike)Items.STRING), 256);
        rateDrops.put(new ItemStack((ItemLike)Items.SPIDER_EYE), 64);
        rateDrops.put(new ItemStack((ItemLike)Items.FERMENTED_SPIDER_EYE), 24);
        rateDrops.put(new ItemStack((ItemLike)Items.LEATHER), 36);
        rateDrops.put(new ItemStack((ItemLike)Blocks.COBWEB), 24);
        rateDrops.put(new ItemStack((ItemLike)Blocks.MOSSY_COBBLESTONE), 24);
        rateDrops.put(new ItemStack((ItemLike)Items.COAL), 32);
        rateDrops.put(new ItemStack((ItemLike)Items.IRON_INGOT), 48);
        rateDrops.put(new ItemStack((ItemLike)Items.EMERALD), 8);
        rateDrops.put(new ItemStack((ItemLike)Items.DIAMOND), 8);
        rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM_NUGGET.get()), 4);
        for (Map.Entry entry : drops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
        for (Map.Entry entry : rateDrops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            int randomCount = this.getRandom().nextInt(count) + 1;
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, randomCount);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
        if (this.getRandom().nextInt(10) == 0) {
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), new ItemStack((ItemLike)Blocks.BEDROCK), 1);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        AnimationUtils.sendPacket(this, 10);
        this.isStunned = false;
        if (this.deathTicks >= 500) {
            this.setInvulTime(this.getInvulTime() + 8);
            this.setAnimationTick(this.getAnimationTick() - 1);
            float f = (this.random.nextFloat() - 0.5f) * 12.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 3.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 12.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.onDeath();
            if (!this.level().isClientSide() && !this.isRemoved()) {
                for (EntityTitanPart part : this.parts) {
                    part.remove(Entity.RemovalReason.KILLED);
                }
                this.removeTitan(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public void finalizeMinionSummon(Entity entity, EnumMinionType minionType) {
        if (minionType != EnumMinionType.SPECIAL && entity instanceof EntitySpiderTitanMinion) {
            EntitySpiderTitanMinion spiderTitanMinion = (EntitySpiderTitanMinion)entity;
            spiderTitanMinion.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 40, 4, true, false));
            if (this.getFirstPassenger() != null && this.getFirstPassenger() instanceof EntitySkeletonTitan) {
                EntitySkeletonTitan skeletonTitan = (EntitySkeletonTitan)this.getFirstPassenger();
                RangedAttackMob mob = skeletonTitan.getSkeletonType() == 1 ? new EntityWitherSkeletonTitanMinion(this.level()) : new EntitySkeletonTitanMinion(this.level());
                mob.setPos(spiderTitanMinion.getX(), spiderTitanMinion.getY(), spiderTitanMinion.getZ());
                mob.setYRot(spiderTitanMinion.getYRot());
                mob.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.SPAWNER, null);
                if (mob instanceof IMinion) {
                    IMinion minion = mob;
                    minion.setMinionType(spiderTitanMinion.getMinionTypeInt());
                }
                mob.setHealth(mob.getMaxHealth());
                this.level().addFreshEntity((Entity)mob);
                mob.startRiding((Entity)spiderTitanMinion);
            }
        }
    }

    public void animationTick() {
        int knockbackAmount;
        if (this.getAnimationID() == 13) {
            this.addDayTime(14000L, 50L);
            if (this.getAnimationTick() == 1) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_BIRTH.get(), 100.0f, 1.25f);
            }
            if (this.getAnimationTick() == 30) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SPIDER_LIVING.get(), this.getSoundVolume(), 0.8f);
            }
            if (this.getAnimationTick() == 40) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_RUMBLE.get(), 10.0f, 1.0f);
            }
            if (this.getAnimationTick() == 135 || this.getAnimationTick() == 155) {
                this.playStepSound(new BlockPos(0, 0, 0), Blocks.STONE.defaultBlockState());
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PRESS.get(), this.getSoundVolume(), 1.0f);
            }
        }
        if (this.getAnimationID() == 1 && this.getAnimationTick() == 12 && this.getTarget() != null) {
            this.shakeNearbyPlayerCameras(20000.0);
            if (this.isArmored()) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.05f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.1f);
                for (int i = 0; i < 3; ++i) {
                    this.collideWithEntities(this.thorax, this.level().getEntities((Entity)this, this.thorax.getBoundingBox().inflate(26.0, 26.0, 26.0)));
                }
            }
            float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount = this.getKnockbackAmount();
            this.collideWithEntities(this.thorax, this.level().getEntities((Entity)this, this.thorax.getBoundingBox().inflate(48.0, 48.0, 48.0)));
            for (int i = 0; i < 4; ++i) {
                this.attackEntity(this.getTarget(), amount);
            }
            this.knockbackEntity(this.getTarget(), knockbackAmount);
            List entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(8.0, 8.0, 8.0));
            for (Entity entity : entities) {
                if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                for (int i = 0; i < 2; ++i) {
                    this.attackEntity(livingEntity, amount);
                }
                this.knockbackEntity(livingEntity, knockbackAmount);
            }
        }
        if (this.getAnimationID() == 2) {
            if (this.getTarget() != null) {
                List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(64.0, 64.0, 64.0));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.invulnerableTime = 0;
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 1));
                }
            }
            if (this.getAnimationTick() <= 70 && this.getAnimationTick() >= 60 && this.getTarget() != null) {
                this.playSound(SoundEvents.WITHER_SHOOT, 5.0f, 1.0f);
                this.attackEntity(this.getTarget(), 25.0f);
                for (int j = 0; j < 300; ++j) {
                    double d8 = 5.0;
                    float xfac = Mth.sin((float)(this.yBodyRot * (float)Math.PI / 180.0f));
                    float zfac = Mth.cos((float)(this.yBodyRot * (float)Math.PI / 180.0f));
                    double dx = (double)xfac * d8;
                    double dz = (double)zfac * d8;
                    double d0 = this.head.getX() - dx;
                    double d1 = this.head.getY() + 4.0;
                    double d2 = this.head.getZ() + dz;
                    double d3 = this.getTarget().getX() - d0;
                    double d4 = this.getTarget().getY() - d1;
                    double d5 = this.getTarget().getZ() - d2;
                    double d6 = Math.sqrt(d3 * d3 + d5 * d5);
                    ThrownPotion thrownPotion = new ThrownPotion(this.level(), (LivingEntity)this);
                    ItemStack itemStack = PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.LONG_POISON);
                    thrownPotion.setItem(itemStack);
                    thrownPotion.setPos(d0, d1, d2);
                    thrownPotion.shoot(d3, d4 + d6 * 0.2, d5, 1.6f, 1.0f + (float)(this.getAnimationTick() * 2 - 60));
                    if (this.level().isClientSide()) continue;
                    this.level().addFreshEntity((Entity)thrownPotion);
                }
            }
        }
        if (this.getAnimationID() == 3 && this.getAnimationTick() == 54) {
            this.shakeNearbyPlayerCameras(20000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
            float d0 = 12.0f;
            float f3 = this.yBodyRot * (float)Math.PI / 180.0f;
            float f11 = Mth.sin((float)f3);
            float f4 = Mth.cos((float)f3);
            float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            int knockbackAmount2 = this.getKnockbackAmount();
            this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(48.0, 12.0, 48.0).move((double)(-(f11 * d0)), -8.0, (double)(f4 * d0))));
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 2.0, 32.0).move((double)(-(f11 * d0)), -4.0, (double)(f4 * d0)));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                this.attackEntity(livingEntity, amount * 5.0f);
                this.knockbackEntity(livingEntity, knockbackAmount2);
                livingEntity.push(0.0, 1.0 + this.getRandom().nextDouble() + this.getRandom().nextDouble(), 0.0);
            }
        }
        if (this.getAnimationID() == 4) {
            if (this.getAnimationTick() == 20) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_ENDER_COLOSUS_CHOMP.get(), 5.0f, 1.1f);
            }
            if (this.getAnimationTick() == 26 && this.getTarget() != null) {
                float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount() * 2;
                this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(8.0, 8.0, 8.0)));
                this.attackEntity(this.getTarget(), amount);
                this.knockbackEntity(this.getTarget(), knockbackAmount);
                List entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(8.0, 8.0, 8.0));
                for (Entity entity : entities) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    this.attackEntity(livingEntity, amount);
                    this.knockbackEntity(livingEntity, knockbackAmount);
                }
            }
        }
        if (this.getAnimationID() == 5 && this.getAnimationTick() == 20) {
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 5.0f, 1.1f);
            if (this.getTarget() != null) {
                float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount();
                this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(4.0, 2.0, 4.0)));
                this.attackEntity(this.getTarget(), amount);
                this.knockbackEntity(this.getTarget(), knockbackAmount);
                List entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(6.0, 2.0, 6.0));
                for (Entity entity : entities) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    this.attackEntity(livingEntity, amount);
                    this.knockbackEntity(livingEntity, knockbackAmount);
                }
            }
        }
        if (this.getAnimationID() == 6 && this.getAnimationTick() <= 100 && this.getAnimationTick() >= 30 && this.getAnimationTick() % 5 == 0 && this.getTarget() != null) {
            this.playSound(SoundEvents.WITHER_SHOOT, 5.0f, 1.0f);
            double d8 = 2.0;
            float xfac = Mth.sin((float)(this.yBodyRot * (float)Math.PI / 180.0f));
            float zfac = Mth.cos((float)(this.yBodyRot * (float)Math.PI / 180.0f));
            double d0 = this.getX() - (double)xfac * d8;
            double d1 = this.getY() + 1.0;
            double d2 = this.getZ() + (double)zfac * d8;
            double d3 = this.getTarget().getX() - d0;
            double d4 = this.getTarget().getY() - 1.0 - d1;
            double d5 = this.getTarget().getZ() - d2;
            EntityWebShot webShot = new EntityWebShot(this.level());
            webShot.setOwner((Entity)this);
            webShot.setPos(d0, d1, d2);
            webShot.shoot(d3, d4, d5, 1.0f, 0.0f);
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)webShot);
            }
        }
        if (this.getAnimationID() == 7 && this.getAnimationTick() == 68) {
            EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(this.level(), 0.6f, 0.1f, 0.2f);
            colorLightningBolt.setPos(this.getX(), this.getY() + 5.0, this.getZ());
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)colorLightningBolt);
            }
            if (this.getTarget() != null) {
                double d8 = -2.0;
                Vec3 vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                if (!this.level().isClientSide()) {
                    this.level().explode((Entity)this, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                    this.level().explode((Entity)this, this.getX() + dx, this.getY() + 8.0, this.getZ() + dz, 1.0f, false, Level.ExplosionInteraction.MOB);
                }
                EntityColorLightningBolt colorLightningBolt1 = new EntityColorLightningBolt(this.level(), 0.6f, 0.1f, 0.2f);
                EntityColorLightningBolt colorLightningBolt2 = new EntityColorLightningBolt(this.level(), 0.6f, 0.1f, 0.2f);
                colorLightningBolt1.setPos(this.getX() + dx, this.getY() + 3.0, this.getZ() + dz);
                colorLightningBolt2.setPos(this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ());
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)colorLightningBolt1);
                    this.level().addFreshEntity((Entity)colorLightningBolt2);
                }
                float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount3 = this.getKnockbackAmount();
                this.attackEntity(this.getTarget(), amount);
                this.knockbackEntity(this.getTarget(), knockbackAmount3);
                this.getTarget().push(0.0, 2.0, 0.0);
                List entities = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(6.0, 3.0, 6.0));
                for (Entity entity : entities) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (!this.level().isClientSide()) {
                        this.level().explode((Entity)this, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                    }
                    EntityColorLightningBolt colorLightningBolt3 = new EntityColorLightningBolt(this.level(), 0.6f, 0.1f, 0.2f);
                    colorLightningBolt3.setPos(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
                    if (!this.level().isClientSide()) {
                        this.level().addFreshEntity((Entity)colorLightningBolt3);
                    }
                    this.attackEntity(livingEntity, amount);
                    this.knockbackEntity(livingEntity, knockbackAmount3);
                }
            }
        }
        if (this.getAnimationID() == 8) {
            if (this.getAnimationTick() == 58) {
                this.playSound((SoundEvent)TheTitansNeoSounds.LARGE_FALL.get(), 8.0f, 0.9f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 10.0f, 1.0f);
            }
            if (this.getAnimationTick() == 60) {
                this.playSound((SoundEvent)TheTitansNeoSounds.DISTANT_LARGE_FALL.get(), 10000.0f, 1.0f);
            }
            if (this.getAnimationTick() == 420) {
                this.isStunned = false;
            } else {
                this.setTarget(null);
            }
        }
        if (this.getAnimationID() == 9 && this.getAnimationTick() == 24) {
            this.shakeNearbyPlayerCameras(20000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
            float d0 = 12.0f;
            float f3 = this.yBodyRot * (float)Math.PI / 180.0f;
            float f11 = Mth.sin((float)f3);
            float f4 = Mth.cos((float)f3);
            float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            int knockbackAmount4 = this.getKnockbackAmount();
            this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(18.0, 12.0, 18.0).move((double)(-(f11 * d0)), -8.0, (double)(f4 * d0))));
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(12.0, 8.0, 12.0).move((double)(-(f11 * d0)), -4.0, (double)(f4 * d0)));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                this.attackEntity(livingEntity, amount * 2.0f);
                this.knockbackEntity(livingEntity, knockbackAmount4);
            }
        }
        if (this.getAnimationID() == 10) {
            if (this.getAnimationTick() == 80 || this.getAnimationTick() == 210 || this.getAnimationTick() == 250 || this.getAnimationTick() == 260) {
                this.shakeNearbyPlayerCameras(10000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.DISTANT_LARGE_FALL.get(), 10000.0f, 1.0f);
                this.collideWithEntities(this.leftlegs, this.level().getEntities((Entity)this, this.leftlegs.getBoundingBox().inflate(24.0, 1.0, 24.0)));
                this.collideWithEntities(this.rightlegs, this.level().getEntities((Entity)this, this.rightlegs.getBoundingBox().inflate(24.0, 1.0, 24.0)));
            }
            if (this.getAnimationTick() == 420) {
                this.isStunned = false;
            } else {
                this.setTarget(null);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.checkWaiting(16.0);
        this.stuckSpeedMultiplier = Vec3.ZERO;
        if (!this.level().isClientSide()) {
            this.setClimbing(this.horizontalCollision);
        }
        if (!(this.getAnimationID() != 0 || this.isPassenger() || this.getWaiting() || this.isStunned)) {
            if (this.getTarget() != null) {
                double d = this.distanceToSqr((Entity)this.getTarget());
                double d2 = this.getMeleeRange();
                double d3 = !this.getTarget().onGround() ? 1000.0 : 8000.0;
                if (d > d2 + d3) {
                    if (this.getY() <= this.getTarget().getY() + 12.0 && this.getY() < 256.0 - (double)this.getBbHeight()) {
                        this.fallDistance = 0.0f;
                        this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.9 - this.getDeltaMovement().y, this.getDeltaMovement().z);
                        if (this.getDeltaMovement().y < 0.0) {
                            this.setTitanDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
                        }
                    }
                    this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * 0.6, this.getDeltaMovement().z);
                }
            }
            if (!this.onGround()) {
                float f3 = (this.getRandom().nextFloat() - 0.5f) * 10.0f;
                float f4 = (this.getRandom().nextFloat() - 0.5f) * 1.0f;
                float f5 = (this.getRandom().nextFloat() - 0.5f) * 10.0f;
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f3, this.getY() + 5.0 + (double)f4, this.getZ() + (double)f5, 0.0, 0.0, 0.0);
            }
        }
        if (this.tickCount > 5) {
            float size = this instanceof EntityCaveSpiderTitan ? 0.7f : 1.0f;
            float f = this.yBodyRot * (float)Math.PI / 180.0f;
            float f1 = Mth.sin((float)f);
            float f2 = Mth.cos((float)f);
            this.head.moveTo(this.getX() - Math.sin(f) * 7.0 * (double)size, this.getY() + (this.getAnimationID() == 8 ? 0.0 : 5.0) * (double)size - Math.sin((double)this.getYRot() * Math.PI / 180.0) * 4.0 * (double)size, this.getZ() + Math.cos(f) * 7.0 * (double)size);
            this.thorax.moveTo(this.getX(), this.getY() + (this.getAnimationID() == 8 ? 1.0 : 6.25) * (double)size, this.getZ());
            this.abdomen.moveTo(this.getX() + (double)(f1 * 9.0f * size), this.getY() + (this.getAnimationID() == 8 ? 1.0 : 5.0) * (double)size, this.getZ() - (double)(f2 * 9.0f * size));
            this.leftlegs.moveTo(this.getX() - (double)(f2 * 10.0f * size), this.getY(), this.getZ() - (double)(f1 * 10.0f * size));
            this.rightlegs.moveTo(this.getX() + (double)(f2 * 10.0f * size), this.getY(), this.getZ() + (double)(f1 * 10.0f * size));
            if (this.isAlive() && !this.isStunned) {
                this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                this.collideWithEntities(this.thorax, this.level().getEntities((Entity)this, this.thorax.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                this.collideWithEntities(this.abdomen, this.level().getEntities((Entity)this, this.abdomen.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                this.collideWithEntities(this.leftlegs, this.level().getEntities((Entity)this, this.leftlegs.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                this.collideWithEntities(this.rightlegs, this.level().getEntities((Entity)this, this.rightlegs.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                if (this.isArmored()) {
                    for (int i = 0; i < 3; ++i) {
                        this.collideWithEntities(this.leftlegs, this.level().getEntities((Entity)this, this.leftlegs.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                        this.collideWithEntities(this.rightlegs, this.level().getEntities((Entity)this, this.rightlegs.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                    }
                }
            }
            for (EntityTitanPart part : this.parts) {
                this.destroyBlocksInAABB(part.getBoundingBox());
            }
        }
        if (this.getAnimationID() == 0 && this.getTarget() != null && !this.isStunned) {
            double d0 = this.distanceToSqr((Entity)this.getTarget());
            if (d0 < this.getMeleeRange()) {
                if (this.getTarget() instanceof EntityTitan || this.getTarget().getBbHeight() >= 6.0f || this.getTarget().getY() > this.getY() + 6.0) {
                    AnimationUtils.sendPacket(this, 1);
                } else {
                    switch (this.getRandom().nextInt(4)) {
                        case 0: {
                            AnimationUtils.sendPacket(this, 3);
                            break;
                        }
                        case 1: {
                            AnimationUtils.sendPacket(this, 9);
                            break;
                        }
                        case 2: {
                            AnimationUtils.sendPacket(this, 5);
                            break;
                        }
                        case 3: {
                            AnimationUtils.sendPacket(this, 6);
                        }
                    }
                }
            } else if (this.getRandom().nextInt(100) == 0) {
                switch (this.getRandom().nextInt(3)) {
                    case 0: {
                        AnimationUtils.sendPacket(this, 2);
                        break;
                    }
                    case 1: {
                        AnimationUtils.sendPacket(this, 7);
                        break;
                    }
                    case 2: {
                        AnimationUtils.sendPacket(this, 6);
                    }
                }
            }
        }
        if (this.getAnimationID() == 0 && this.getRandom().nextInt(120) == 0 && this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) > 512.0 && this.onGround()) {
            this.lookAt((Entity)this.getTarget(), 180.0f, 180.0f);
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getZ() - this.getZ();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            double hor = 2.0;
            double ver = 2.0;
            this.setTitanDeltaMovement(d0 / d2 * hor * hor + this.getDeltaMovement().x * hor, ver, d1 / d2 * hor * hor + this.getDeltaMovement().z * hor);
            for (int i = 0; i < 3; ++i) {
                this.collideWithEntities(this.leftlegs, this.level().getEntities((Entity)this, this.leftlegs.getBoundingBox().inflate(6.0, 6.0, 6.0)));
                this.collideWithEntities(this.rightlegs, this.level().getEntities((Entity)this, this.rightlegs.getBoundingBox().inflate(6.0, 6.0, 6.0)));
            }
            if (this.distanceToSqr((Entity)this.getTarget()) < 2000.0) {
                float amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount = this.getKnockbackAmount() * 2;
                this.attackEntity(this.getTarget(), amount);
                this.knockbackEntity(this.getTarget(), knockbackAmount);
            }
        }
        if (this.isStunned) {
            this.setTarget(null);
            AnimationUtils.sendPacket(this, 8);
        }
        this.meleeTitan = true;
        this.animationTick();
    }
}

