/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.util.UUID;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.IEntityMultiPartTitan;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.entity.PartEntity;

public class EntityTitanPart
extends PartEntity<EntityTitan> {
    private static final EntityDataAccessor<String> PART_NAME = SynchedEntityData.defineId(EntityTitanPart.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Float> WIDTH = SynchedEntityData.defineId(EntityTitanPart.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.defineId(EntityTitanPart.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;

    public EntityTitanPart(EntityTitan parent, String partName, float width, float height) {
        super((Entity)parent);
        this.setOwner((Entity)parent);
        this.setPartName(partName);
        this.setSize(width, height);
    }

    public String getPartName() {
        return (String)this.entityData.get(PART_NAME);
    }

    public void setPartName(String partName) {
        this.entityData.set(PART_NAME, (Object)partName);
    }

    public float getWidth() {
        return ((Float)this.entityData.get(WIDTH)).floatValue();
    }

    public void setWidth(float width) {
        this.entityData.set(WIDTH, (Object)Float.valueOf(width));
    }

    public float getHeight() {
        return ((Float)this.entityData.get(HEIGHT)).floatValue();
    }

    public void setHeight(float height) {
        this.entityData.set(HEIGHT, (Object)Float.valueOf(height));
    }

    public void setSize(float width, float height) {
        this.setWidth(width);
        this.setHeight(height);
        this.refreshDimensions();
    }

    @Nullable
    public Entity getOwner() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.cachedOwner = serverlevel.getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(@Nullable Entity owner) {
        if (owner != null) {
            this.ownerUUID = owner.getUUID();
            this.cachedOwner = owner;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(PART_NAME, (Object)"");
        builder.define(WIDTH, (Object)Float.valueOf(1.0f));
        builder.define(HEIGHT, (Object)Float.valueOf(1.0f));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        if (tag.hasUUID("Owner")) {
            this.ownerUUID = tag.getUUID("Owner");
            this.cachedOwner = null;
        }
        this.setPartName(tag.getString("PartName"));
        this.setWidth(tag.getFloat("Width"));
        this.setHeight(tag.getFloat("Height"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        if (this.ownerUUID != null) {
            tag.putUUID("Owner", this.ownerUUID);
        }
        tag.putString("PartName", this.getPartName());
        tag.putFloat("Width", this.getWidth());
        tag.putFloat("Height", this.getHeight());
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, serverEntity, entity == null ? 0 : entity.getId());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        Entity entity = this.level().getEntity(packet.getData());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    public Component getName() {
        return super.getName().copy().append("-").append(this.getPartName());
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)this.getWidth(), (float)this.getHeight());
    }

    public boolean is(Entity entity) {
        return this == entity || this.getOwner() == entity;
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public void updateFluidHeightAndDoFluidPushing() {
    }

    public void remove(Entity.RemovalReason reason) {
        EntityTitan titan;
        if (reason == Entity.RemovalReason.KILLED && this.level().hasChunkAt(this.blockPosition()) && this.getOwner() != null && this.getOwner() instanceof EntityTitan && !(titan = (EntityTitan)this.getOwner()).isRemoved()) {
            return;
        }
        super.remove(reason);
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (!this.isInvulnerableTo(damageSource) && this.getOwner() != null && this.getOwner() instanceof IEntityMultiPartTitan) {
            IEntityMultiPartTitan multiPartTitan = (IEntityMultiPartTitan)this.getOwner();
            return multiPartTitan.attackEntityFromPart(this, damageSource, amount);
        }
        return false;
    }

    public void tick() {
        super.tick();
        Entity entity = this.getOwner();
        if (entity != null) {
            this.setSharedFlagOnFire(entity.isOnFire());
        }
    }
}

