/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.EntityColorLightningBolt;
import net.byAqua3.thetitansneo.entity.EntityWitherTurret;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.minion.EntityWitherzillaMinion;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossus;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanPart;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.item.ItemOptimaAxe;
import net.byAqua3.thetitansneo.item.ItemTitanSpawnEgg;
import net.byAqua3.thetitansneo.item.ItemUltimaBlade;
import net.byAqua3.thetitansneo.loader.TheTitansNeoBlocks;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoDimensions;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoPredicateTargets;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class EntityWitherzilla
extends EntityTitan
implements RangedAttackMob,
IBossBarDisplay {
    private static final EntityDataAccessor<Integer> DATA_TARGET_A = SynchedEntityData.defineId(EntityWitherzilla.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TARGET_B = SynchedEntityData.defineId(EntityWitherzilla.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TARGET_C = SynchedEntityData.defineId(EntityWitherzilla.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final List<EntityDataAccessor<Integer>> DATA_TARGETS = ImmutableList.of(DATA_TARGET_A, DATA_TARGET_B, DATA_TARGET_C);
    private float[] xRotHeads = new float[2];
    private float[] yRotHeads = new float[2];
    private float[] xRotOHeads = new float[2];
    private float[] yRotOHeads = new float[2];
    private int[] nextHeadUpdate = new int[2];
    private int[] idleHeadUpdates = new int[2];
    private int blockBreakCounter;
    public int affectTicks;
    private int attackTimer;
    public int omegaCounter;

    public EntityWitherzilla(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
        this.playSound((SoundEvent)TheTitansNeoSounds.WITHERZILLA_SPAWN.get(), Float.MAX_VALUE, 1.0f);
    }

    public EntityWitherzilla(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.WITHERZILLA.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 2.0E7).add(Attributes.ATTACK_DAMAGE, 3.4028234663852886E38).add(Attributes.MOVEMENT_SPEED, 0.5);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/witherzilla.png");
    }

    @Override
    public int getBossBarNameColor() {
        return 0xF000F0 - (int)(Mth.cos((float)((float)this.tickCount * 0.05f)) * 1.572888E7f);
    }

    @Override
    public int getBossBarHealthColor() {
        return 0xF000F0 - (int)(Mth.cos((float)((float)this.tickCount * 0.05f)) * 1.572888E7f);
    }

    @Override
    public int getBossBarWidth() {
        return 185;
    }

    @Override
    public int getBossBarHeight() {
        return 32;
    }

    @Override
    public int getBossBarInterval() {
        return 5;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 7;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.removeAllGoals(goal -> true);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, TheTitansNeoPredicateTargets.Witherzilla));
    }

    public int getAlternativeTarget(int head) {
        return (Integer)this.entityData.get(DATA_TARGETS.get(head));
    }

    public void setAlternativeTarget(int targetOffset, int newId) {
        this.entityData.set(DATA_TARGETS.get(targetOffset), (Object)newId);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TARGET_A, (Object)0);
        builder.define(DATA_TARGET_B, (Object)0);
        builder.define(DATA_TARGET_C, (Object)0);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public boolean isInOmegaForm() {
        return this.level().dimension() != TheTitansNeoDimensions.THE_VOID;
    }

    protected double getHeadX(int head) {
        if (head <= 0) {
            return this.getX();
        }
        float f = (this.yBodyRot + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float f2 = Mth.cos((float)f);
        return this.getX() + (double)f2 * 1.3 * (double)(this.isInOmegaForm() ? 256.0f : 128.0f);
    }

    protected double getHeadY(int head) {
        return this.getEyeY();
    }

    protected double getHeadZ(int head) {
        if (head <= 0) {
            return this.getZ();
        }
        float f = (this.yBodyRot + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float f2 = Mth.sin((float)f);
        return this.getZ() + (double)f2 * 1.3 * (double)(this.isInOmegaForm() ? 256.0f : 128.0f);
    }

    public float getHeadXRot(int head) {
        return this.xRotHeads[head];
    }

    public float getHeadYRot(int head) {
        return this.yRotHeads[head];
    }

    private float rotlerp(float angle, float targetAngle, float max) {
        float f = Mth.wrapDegrees((float)(targetAngle - angle));
        if (f > max) {
            f = max;
        }
        if (f < -max) {
            f = -max;
        }
        return angle + f;
    }

    private void createBeaconPortal(int x, int z) {
        int b0 = this.level().getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
        int b1 = 4;
        for (int k = b0 - 1; k <= b0 + 32; ++k) {
            for (int l = x - b1; l <= x + b1; ++l) {
                for (int i1 = z - b1; i1 <= z + b1; ++i1) {
                    double d0 = l - x;
                    double d1 = i1 - z;
                    double d2 = d0 * d0 + d1 * d1;
                    if (!(d2 <= ((double)b1 - 0.5) * ((double)b1 - 0.5))) continue;
                    if (k < b0) {
                        if (!(d2 <= ((double)(b1 - 1) - 0.5) * ((double)(b1 - 1) - 0.5))) continue;
                        this.level().setBlockAndUpdate(new BlockPos(l, k, i1), Blocks.BEDROCK.defaultBlockState());
                        continue;
                    }
                    if (k > b0) {
                        this.level().setBlockAndUpdate(new BlockPos(l, k, i1), Blocks.AIR.defaultBlockState());
                        continue;
                    }
                    if (d2 > ((double)(b1 - 1) - 0.5) * ((double)(b1 - 1) - 0.5)) {
                        this.level().setBlockAndUpdate(new BlockPos(l, k, i1), Blocks.BEDROCK.defaultBlockState());
                        continue;
                    }
                    this.level().setBlockAndUpdate(new BlockPos(l, k, i1), Blocks.END_PORTAL.defaultBlockState());
                }
            }
        }
        this.level().setBlockAndUpdate(new BlockPos(x, b0 + 0, z), Blocks.BEDROCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x, b0 + 1, z), Blocks.BEDROCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x, b0 + 2, z), Blocks.BEDROCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x - 1, b0 + 2, z), (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)Direction.WEST));
        this.level().setBlockAndUpdate(new BlockPos(x + 1, b0 + 2, z), (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)Direction.EAST));
        this.level().setBlockAndUpdate(new BlockPos(x, b0 + 2, z - 1), (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)Direction.NORTH));
        this.level().setBlockAndUpdate(new BlockPos(x, b0 + 2, z + 1), (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)Direction.SOUTH));
        this.level().setBlockAndUpdate(new BlockPos(x, b0 + 3, z), Blocks.BEDROCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x, b0 + 4, z), Blocks.DIAMOND_BLOCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x + 1, b0 + 4, z + 1), Blocks.DIAMOND_BLOCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x + 1, b0 + 4, z), Blocks.DIAMOND_BLOCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x + 1, b0 + 4, z - 1), Blocks.DIAMOND_BLOCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x - 1, b0 + 4, z + 1), Blocks.DIAMOND_BLOCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x - 1, b0 + 4, z), Blocks.DIAMOND_BLOCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x - 1, b0 + 4, z - 1), Blocks.DIAMOND_BLOCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x, b0 + 4, z + 1), Blocks.DIAMOND_BLOCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x, b0 + 4, z - 1), Blocks.DIAMOND_BLOCK.defaultBlockState());
        this.level().setBlockAndUpdate(new BlockPos(x, b0 + 5, z), Blocks.BEACON.defaultBlockState());
    }

    protected void performRangedAttack(int head, double x, double y, double z, boolean isDangerous) {
        double d0 = this.getHeadX(head);
        double d2 = this.getHeadY(head);
        double d3 = this.getHeadZ(head);
        double d4 = x - d0;
        double d5 = y - d2;
        double d6 = z - d3;
        Vec3 vec3 = new Vec3(d4, d5, d6);
        WitherSkull witherskull = new WitherSkull(this.level(), (LivingEntity)this, vec3.normalize());
        witherskull.setOwner((Entity)this);
        if (isDangerous) {
            witherskull.setDangerous(true);
        }
        witherskull.setPosRaw(d0, d2, d3);
        this.level().addFreshEntity((Entity)witherskull);
    }

    protected void performRangedAttack(int head, LivingEntity target) {
        this.performRangedAttack(head, target.getX(), target.getY() + (double)(target.getEyeHeight() * 0.5f), target.getZ(), head == 0 && this.random.nextFloat() < 0.001f);
        this.attackEntity(target, 20.0f);
        target.invulnerableTime = 0;
    }

    public void doLightningAttackTo(Entity entity) {
        if (entity != null && entity.isAlive() && !(entity instanceof EntityTitanPart)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.sendSystemMessage((Component)Component.literal((String)String.valueOf(this.getRandom().nextInt(1234567890))).withStyle(ChatFormatting.OBFUSCATED));
            }
            if (entity instanceof LivingEntity && !(entity instanceof EntityTitan)) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.attackEntity(livingEntity, 20.0f);
                EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(livingEntity.level(), this.getRandom().nextFloat(), this.getRandom().nextFloat(), this.getRandom().nextFloat());
                colorLightningBolt.setPos(entity.getX(), entity.getY(), entity.getZ());
                if (!livingEntity.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)colorLightningBolt);
                }
                if (livingEntity.getBbHeight() >= 6.0f || livingEntity.isInvulnerable()) {
                    livingEntity.setHealth(0.0f);
                    livingEntity.hurt(this.damageSources().fellOutOfWorld(), Float.MAX_VALUE);
                    livingEntity.die(this.damageSources().fellOutOfWorld());
                    livingEntity.discard();
                }
                if (livingEntity.getBbHeight() >= 6.0f || this.affectTicks >= 600) {
                    livingEntity.setHealth(0.0f);
                    for (int i = 0; i < 50; ++i) {
                        this.attackEntity(livingEntity, Float.MAX_VALUE);
                    }
                }
            }
            if (entity instanceof EntityTitan) {
                EntityTitan titan = (EntityTitan)entity;
                titan.setInvulTime(titan.getInvulTime() - 20);
                this.attackEntity((LivingEntity)titan, 5000.0f);
            } else {
                entity.push(0.0, 0.5, 0.0);
            }
            entity.invulnerableTime = 1;
        }
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        return groupData;
    }

    public Component getName() {
        if (this.tickCount % 20 < 3 + this.getRandom().nextInt(3) || this.getInvulTime() >= 1000) {
            return Component.literal((String)"Regnator");
        }
        return Component.translatable((String)"entity.thetitansneo.witherzilla").withStyle(ChatFormatting.BOLD);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        float width = this.isInOmegaForm() ? 128.0f : 64.0f;
        float height = this.isInOmegaForm() ? 448.0f : 224.0f;
        float eyeHeight = this.isInOmegaForm() ? 380.8f : 190.4f;
        return EntityDimensions.scalable((float)width, (float)height).withEyeHeight(eyeHeight);
    }

    @Override
    protected void refreshAttributes() {
        if (this.isInOmegaForm()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(2.0E7);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(3.4028234663852886E38);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(1.0E7);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(3.4028234663852886E38);
        }
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        EntityWitherTurret witherTurret;
        return super.canAttackEntity(entity) && !(entity instanceof EntityWitherzillaMinion) && (!(entity instanceof EntityWitherTurret) || (witherTurret = (EntityWitherTurret)entity).isPlayerCreated());
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return !this.isInvulnerable() && this.level().getDifficulty() != Difficulty.PEACEFUL;
    }

    @Override
    public boolean shouldMove() {
        return false;
    }

    @Override
    public boolean isArmored() {
        return this.deathTicks <= 0 && this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    @Override
    public int getMinionCap() {
        return (Integer)TheTitansNeoConfigs.witherzillaMinionSpawnCap.get();
    }

    @Override
    public boolean canSpawnMinion() {
        boolean flag = this.getInvulTime() > 1 && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.witherzillaSummonMinionSpawnRate.get();
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.GOD;
    }

    @Override
    public int getThreashHold() {
        return 210;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TheTitansNeoSounds.WITHERZILLA_LIVING.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)TheTitansNeoSounds.WITHERZILLA_GRUNT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TheTitansNeoSounds.WITHERZILLA_DEATH.get();
    }

    @Override
    protected void pushEntities() {
    }

    public void setDeltaMovement(Vec3 deltaMovement) {
    }

    @Override
    public void setTitanDeltaMovement(Vec3 deltaMovement) {
    }

    @Override
    public void destroyBlocksInAABB(AABB aabb) {
        this.destroyBlocksInAABBGriefingBypass(aabb);
    }

    @Override
    public boolean hurt(DamageSource damageSource, float amount) {
        if (amount >= 100000.0f) {
            amount = 100000.0f;
        }
        if (this.blockBreakCounter <= 0) {
            this.blockBreakCounter = 1;
        }
        ++this.tickCount;
        return super.hurt(damageSource, amount);
    }

    public void kill() {
        if (!this.level().players().isEmpty()) {
            for (Player player : this.level().players()) {
                player.sendSystemMessage((Component)Component.translatable((String)"entity.thetitansneo.witherzilla.killattempt"));
            }
        }
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        if (target instanceof EntityTitan || target.getBbHeight() >= 6.0f) {
            double d0 = this.distanceToSqr((Entity)target);
            int knockbackAmount = 2;
            if (d0 < 1000.0 && this.attackTimer <= 0) {
                this.attackTimer = 1 + this.getRandom().nextInt(9);
                for (int i = 0; i < 10; ++i) {
                    EntityTitan titan;
                    this.attackEntity(target, Float.MAX_VALUE);
                    if (!(target instanceof EntityTitan) || (titan = (EntityTitan)target).getInvulTime() <= 1) continue;
                    titan.setInvulTime(titan.getInvulTime() - 20);
                }
                this.knockbackEntity(target, knockbackAmount);
            }
        } else {
            this.performRangedAttack(0, target);
        }
    }

    @Override
    public void aiStep() {
        --this.attackTimer;
        if (this.getInvulTime() > 0) {
            if (this.tickCount % 1 == 0) {
                this.heal(this.getMaxHealth() / 800.0f);
            }
            int i = this.getInvulTime() - 1;
            this.setInvulTime(i);
            if (i <= 0) {
                this.blockBreakCounter = 1;
                if (!this.level().players().isEmpty()) {
                    for (Player player : this.level().players()) {
                        this.level().playLocalSound(player.blockPosition(), (SoundEvent)TheTitansNeoSounds.WITHERZILLA_SPAWN.get(), SoundSource.MASTER, 10.0f, 1.0f, false);
                    }
                }
            }
        } else {
            super.aiStep();
            if (this.isInOmegaForm()) {
                Player player;
                this.omegaCounter = 600;
                if (this.tickCount % 400 == 0 && (player = this.level().getNearestPlayer((Entity)this, -1.0)) != null && !player.getAbilities().invulnerable) {
                    this.setTarget((LivingEntity)player);
                }
            }
            for (int i = 1; i < 3; ++i) {
                int k;
                if (this.tickCount < this.nextHeadUpdate[i - 1] || this.getTarget() == null) continue;
                this.nextHeadUpdate[i - 1] = this.tickCount + this.random.nextInt(20);
                int n = i - 1;
                int n2 = this.idleHeadUpdates[n];
                this.idleHeadUpdates[n] = n2 + 1;
                if (n2 > 15) {
                    for (int i2 = 0; i2 < 100; ++i2) {
                        float f = 100.0f;
                        float f2 = 20.0f;
                        double d0 = Mth.nextDouble((RandomSource)this.getRandom(), (double)(this.getX() - (double)f), (double)(this.getX() + (double)f));
                        double d2 = Mth.nextDouble((RandomSource)this.getRandom(), (double)(this.getY() - (double)f2), (double)(this.getY() + (double)f2));
                        double d3 = Mth.nextDouble((RandomSource)this.getRandom(), (double)(this.getZ() - (double)f), (double)(this.getZ() + (double)f));
                        this.performRangedAttack(i + 1, d0, d2, d3, true);
                    }
                    this.idleHeadUpdates[i - 1] = 0;
                }
                if ((k = this.getAlternativeTarget(i)) > 0) {
                    LivingEntity livingEntity = (LivingEntity)this.level().getEntity(k);
                    if (livingEntity != null && livingEntity.isAlive()) {
                        this.performRangedAttack(i + 1, livingEntity);
                        this.nextHeadUpdate[i - 1] = this.tickCount;
                        this.idleHeadUpdates[i - 1] = 0;
                        continue;
                    }
                    this.setAlternativeTarget(i, 0);
                    continue;
                }
                if (this.getTarget() != null && this.getTarget().isAlive()) {
                    this.setAlternativeTarget(i, this.getTarget().getId());
                    continue;
                }
                this.setAlternativeTarget(i, 0);
            }
            if (this.getTarget() != null) {
                this.setAlternativeTarget(0, this.getTarget().getId());
            } else {
                this.setAlternativeTarget(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
                    boolean flag = false;
                    int l = Mth.floor((float)32.0f);
                    for (BlockPos blockPos : BlockPos.betweenClosed((int)(this.getBlockX() - l), (int)(this.getBlockY() - 32), (int)(this.getBlockZ() - l), (int)(this.getBlockX() + l), (int)(this.getBlockY() + 246), (int)(this.getBlockZ() + l))) {
                        BlockState blockState = this.level().getBlockState(blockPos);
                        if (!blockState.canEntityDestroy((BlockGetter)this.level(), blockPos, (Entity)this) || !EventHooks.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockPos, (BlockState)blockState)) continue;
                        flag = this.level().destroyBlock(blockPos, false, (Entity)this) || flag;
                    }
                    if (flag) {
                        this.level().levelEvent(null, 1022, this.blockPosition(), 0);
                        this.destroyBlocksInAABB(this.getBoundingBox());
                    }
                }
            }
        }
    }

    @Override
    protected void dropExperienceOrb() {
        for (int x = 0; x < 250; ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), 32000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
    }

    @Override
    protected void dropAllItem() {
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Blocks.COAL_BLOCK), 1024);
        drops.put(new ItemStack((ItemLike)Blocks.IRON_BLOCK), 512);
        drops.put(new ItemStack((ItemLike)Blocks.GOLD_BLOCK), 512);
        drops.put(new ItemStack((ItemLike)Blocks.EMERALD_BLOCK), 256);
        drops.put(new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK), 256);
        drops.put(new ItemStack((ItemLike)Blocks.DRAGON_EGG), 256);
        drops.put(new ItemStack((ItemLike)TheTitansNeoBlocks.HARCADIUM_BLOCK_BLOCK_ITEM.get()), 128);
        drops.put(new ItemStack((ItemLike)TheTitansNeoBlocks.VOID_BLOCK_BLOCK_ITEM.get()), 128);
        drops.put(new ItemStack((ItemLike)TheTitansNeoBlocks.BEDROCK_COMPACT_BLOCK_ITEM.get()), 128);
        drops.put(new ItemStack((ItemLike)TheTitansNeoItems.ULTIMA_BLADE.get()), 1);
        int i = 0;
        while (i < 256) {
            Item item = (Item)BuiltInRegistries.ITEM.byId(this.getRandom().nextInt(BuiltInRegistries.ITEM.size()));
            if (item == null || item instanceof ItemUltimaBlade || item instanceof ItemOptimaAxe || item instanceof ItemTitanSpawnEgg) continue;
            ++i;
            drops.put(new ItemStack((ItemLike)item), 1);
        }
        i = 0;
        while (i < 256) {
            Block block = (Block)BuiltInRegistries.BLOCK.byId(this.getRandom().nextInt(BuiltInRegistries.BLOCK.size()));
            if (block == null) continue;
            ++i;
            drops.put(new ItemStack((ItemLike)block), 1);
        }
        for (Map.Entry entry : drops.entrySet()) {
            ItemStack itemStack = (ItemStack)entry.getKey();
            int count = (Integer)entry.getValue();
            if (count > 1) {
                EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
                itemTitan.setPickUpDelay(40);
                this.level().addFreshEntity((Entity)itemTitan);
                continue;
            }
            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack);
            itemEntity.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemEntity);
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        if (!this.isInOmegaForm()) {
            this.setPos(0.0, 120.0, 0.0);
            this.setYRot(this.deathTicks * 10);
            this.yHeadRot = this.getYRot();
            this.yBodyRot = this.getYRot();
        }
        if (this.deathTicks == 1 && !this.level().players().isEmpty()) {
            for (Player player : this.level().players()) {
                if (this.level().isClientSide()) continue;
                if (this.isInOmegaForm()) {
                    player.sendSystemMessage((Component)Component.translatable((String)"entity.thetitansneo.witherzilla.defeat"));
                    continue;
                }
                player.sendSystemMessage((Component)Component.translatable((String)"entity.thetitansneo.witherzilla.death"));
            }
        }
        if (this.deathTicks > 180 && this.deathTicks % 1 == 0) {
            float f = (this.getRandom().nextFloat() - 0.5f) * 24.0f;
            float f2 = (this.getRandom().nextFloat() - 0.5f) * 80.0f;
            float f3 = (this.getRandom().nextFloat() - 0.5f) * 24.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + 2.0 + (double)f2, this.getZ() + (double)f3, 0.0, 0.0, 0.0);
        }
        if (this.deathTicks >= 200) {
            this.setInvulTime(2000);
        }
        if (this.deathTicks >= 400) {
            this.onDeath();
            this.createBeaconPortal(Mth.floor((double)this.getX()), Mth.floor((double)this.getZ()));
            if (!this.level().isClientSide() && !this.isRemoved()) {
                this.removeTitan(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public void tick() {
        Entity entity;
        Object serverLevel;
        super.tick();
        this.refreshAttributes();
        this.refreshDimensions();
        if (this.isInOmegaForm()) {
            if (!this.level().isClientSide()) {
                serverLevel = (ServerLevel)this.level();
                ChunkPos chunkPos = this.chunkPosition();
                serverLevel.getChunkSource().addRegionTicket(TicketType.PLAYER, chunkPos, 3, (Object)chunkPos);
                if (this.getTarget() != null && this.getTarget() instanceof EntityEnderColossus) {
                    serverLevel.setWeatherParameters(0, 0, false, false);
                } else {
                    serverLevel.setWeatherParameters(0, 1000000, true, true);
                }
            }
            if (this.getRandom().nextInt(2) == 0) {
                for (int l = 0; l < 20; ++l) {
                    int m = Mth.floor((double)this.getX());
                    int n = Mth.floor((double)this.getY());
                    int k = Mth.floor((double)this.getZ());
                    int i1 = m + Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)10, (int)100) * Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)-1, (int)1);
                    int j1 = n + Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)10, (int)100) * Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)-1, (int)1);
                    int k2 = k + Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)10, (int)100) * Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)-1, (int)1);
                    EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(this.level(), this.getRandom().nextFloat(), this.getRandom().nextFloat(), this.getRandom().nextFloat());
                    colorLightningBolt.setPos(i1, j1, k2);
                    if (this.getRandom().nextInt(5) != 0 || this.level().isClientSide()) continue;
                    this.level().addFreshEntity((Entity)colorLightningBolt);
                }
            }
        } else {
            List entities;
            if (this.distanceToSqr(0.0, 200.0, 0.0) > 50000.0) {
                this.setPos(0.0, 200.0, 0.0);
            }
            if (!(entities = this.level().getEntitiesOfClass(EntityWitherTurret.class, this.getBoundingBox().inflate(20000.0, 20000.0, 20000.0))).isEmpty()) {
                for (EntityWitherTurret entity2 : entities) {
                    if (entity2 == null || !entity2.isAlive() || entity2.isPlayerCreated()) continue;
                    this.setPos(0.0, 200.0, 0.0);
                    this.setYRot(0.0f);
                    this.yHeadRot = 0.0f;
                    this.yBodyRot = 0.0f;
                    this.setTarget(null);
                    for (int i = 0; i < 3; ++i) {
                        this.setAlternativeTarget(i, 0);
                    }
                }
            } else if (this.getY() > 100.0) {
                this.setPos(this.getX(), this.getY() - 1.0, this.getZ());
            }
        }
        ++this.affectTicks;
        if (this.affectTicks >= 800) {
            this.setInvisible(true);
        } else {
            this.setInvisible(false);
        }
        if (this.affectTicks >= 1010) {
            this.affectTicks = 0;
        }
        --this.omegaCounter;
        if (!this.level().isClientSide()) {
            serverLevel = (ServerLevel)this.level();
            serverLevel.setDayTime(18000L);
        }
        if (this.getTarget() != null && !this.getTarget().isAlive()) {
            this.setTarget(null);
        }
        if (!this.isArmored()) {
            this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * 0.1, this.getDeltaMovement().z);
        } else {
            this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * 0.9, this.getDeltaMovement().z);
        }
        if (!this.level().players().isEmpty() && this.getRandom().nextInt(4) == 0) {
            for (Object player : this.level().players()) {
                if (this.getRandom().nextInt(100) != 0) continue;
                this.playAmbientSound();
                if (this.isInOmegaForm()) {
                    this.attackEntity((LivingEntity)player, 10.0f);
                    player.sendSystemMessage((Component)Component.translatable((String)("entity.thetitansneo.witherzilla.taunt." + this.getRandom().nextInt(6))));
                    continue;
                }
                player.sendSystemMessage((Component)Component.translatable((String)("entity.thetitansneo.witherzilla.plead." + this.getRandom().nextInt(6))));
            }
        }
        if (this.isInOmegaForm()) {
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(20000.0, 20000.0, 20000.0));
            for (Entity entity3 : entities) {
                if (entity3 == null || !entity3.isAlive() || entity3 instanceof LightningBolt || entity3 instanceof WitherSkull || entity3 instanceof EntityWitherTurret || entity3 instanceof EntityTitan || entity3 instanceof Player) continue;
                if (this.getInvulTime() > 1) {
                    if (entity3 instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity3;
                        if (livingEntity instanceof Mob) {
                            Mob mob = (Mob)livingEntity;
                            mob.getNavigation().stop();
                        }
                        livingEntity.push(0.0, 0.05 - this.getDeltaMovement().y * 0.2, 0.0);
                        livingEntity.xxa = (float)this.getRandom().nextGaussian();
                        livingEntity.zza = (float)this.getRandom().nextGaussian();
                        livingEntity.setYRot(livingEntity.getYRot() + (float)this.getRandom().nextGaussian() * 10.0f);
                        livingEntity.yHeadRot = livingEntity.getYRot();
                        livingEntity.yBodyRot = livingEntity.getYRot();
                        livingEntity.invulnerableTime = (int)this.getRandom().nextGaussian() * 20;
                        continue;
                    }
                    entity3.push(this.getRandom().nextGaussian() * 0.5, this.getRandom().nextGaussian() * 0.5, this.getRandom().nextGaussian() * 0.5);
                    entity3.setYRot(entity3.getYRot() + 10.0f);
                    entity3.invulnerableTime = (int)this.getRandom().nextGaussian() * 20;
                    continue;
                }
                this.doLightningAttackTo(entity3);
            }
        }
        if (this.getTarget() != null && (this.affectTicks >= 600 || this.getTarget().getBbHeight() > 6.0f && !(this.getTarget() instanceof EntityTitan))) {
            if (this.getRandom().nextInt(120) == 0 && !this.level().isClientSide()) {
                this.level().explode((Entity)this, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 14.0f, true, Level.ExplosionInteraction.MOB);
            }
            this.doLightningAttackTo((Entity)this.getTarget());
            for (int i = 0; i < 19; ++i) {
                this.doLightningAttackTo((Entity)this.getTarget());
                this.getTarget().hurt(this.damageSources().fellOutOfWorld(), 1.0f);
            }
        }
        if (this.getAlternativeTarget(0) > 0 && (entity = this.level().getEntity(this.getAlternativeTarget(0))) != null) {
            double d0 = entity.getX() - this.getX();
            double d1 = entity.getY() + (this.isArmored() ? 2.0 : 12.0) - this.getY();
            double d2 = entity.getZ() - this.getZ();
            double d3 = d0 * d0 + d1 * d1 + d2 * d2;
            this.getLookControl().setLookAt(entity, 180.0f, 40.0f);
            if (entity instanceof LivingEntity && d3 < 10000.0) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.performRangedAttack(livingEntity, 0.0f);
            }
            if (d3 > 64.0) {
                double d4 = Math.sqrt(d3);
                this.setTitanDeltaMovement(this.getDeltaMovement().add(d0 / d4 * 1.5 - this.getDeltaMovement().x, d1 / d4 * 1.5 - this.getDeltaMovement().y, d2 / d4 * 1.5 - this.getDeltaMovement().z));
                this.setYRot((float)Math.atan2(this.getDeltaMovement().z, this.getDeltaMovement().x) * 180.0f / (float)Math.PI - 90.0f);
                this.yBodyRot = this.getYRot();
            }
        }
        for (int i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotHeads[i];
            this.xRotOHeads[i] = this.xRotHeads[i];
        }
        for (int j = 0; j < 2; ++j) {
            int k = this.getAlternativeTarget(j + 1);
            Entity entity4 = null;
            if (k > 0) {
                entity4 = this.level().getEntity(k);
            }
            if (entity4 != null) {
                double d6 = this.getHeadX(j + 1);
                double d7 = this.getHeadY(j + 1);
                double d4 = this.getHeadZ(j + 1);
                double d8 = entity4.getX() - d6;
                double d9 = entity4.getEyeY() - d7;
                double d10 = entity4.getZ() - d4;
                double d11 = Math.sqrt(d8 * d8 + d10 * d10);
                float f1 = (float)(Mth.atan2((double)d10, (double)d8) * 180.0 / 3.1415927410125732) - 90.0f;
                float f2 = (float)(-(Mth.atan2((double)d9, (double)d11) * 180.0 / 3.1415927410125732));
                this.xRotHeads[j] = this.rotlerp(this.xRotHeads[j], f2, 5.0f);
                this.yRotHeads[j] = this.rotlerp(this.yRotHeads[j], f1, 5.0f);
                continue;
            }
            if (this.getRandom().nextInt(120) == 0) {
                for (k = 0; k < 36; ++k) {
                    this.xRotHeads[j] = this.rotlerp(this.xRotHeads[j], this.getRandom().nextFloat() * 360.0f - 180.0f, 5.0f);
                }
            }
            if (this.getRandom().nextInt(120) != 0) continue;
            for (k = 0; k < 36; ++k) {
                this.yRotHeads[j] = this.rotlerp(this.yRotHeads[j], this.getRandom().nextFloat() * 360.0f - 180.0f, 5.0f);
            }
        }
        boolean flag = this.isArmored();
        for (int l = 0; l < 100; ++l) {
            double d12 = this.getHeadX(l);
            double d13 = this.getHeadY(l);
            double d14 = this.getHeadZ(l);
            float f = 0.3f * this.getScale();
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, d12 + this.random.nextGaussian() * (double)f, d13 + this.random.nextGaussian() * (double)f, d14 + this.random.nextGaussian() * (double)f, 0.0, 0.0, 0.0);
            if (!flag || this.level().random.nextInt(4) != 0) continue;
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.7f, (float)0.7f, (float)0.5f), d12 + this.random.nextGaussian() * (double)f, d13 + this.random.nextGaussian() * (double)f, d14 + this.random.nextGaussian() * (double)f, 0.0, 0.0, 0.0);
        }
    }
}

