/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.entity.titan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.byAqua3.thetitansneo.entity.EntityColorLightningBolt;
import net.byAqua3.thetitansneo.entity.IBossBarDisplay;
import net.byAqua3.thetitansneo.entity.ai.EntityAINearestTargetTitan;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanAntiTitanAttack;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanAttack1;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanAttack2;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanAttack3;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanAttack4;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanAttack5;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanAttack6;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanCreation;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanDeath;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanLightningAttack;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanRangedAttack;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanRoar;
import net.byAqua3.thetitansneo.entity.ai.zombifiedpiglintitan.AnimationZombifiedPiglinTitanStun;
import net.byAqua3.thetitansneo.entity.minion.EntityGhastGuardMinion;
import net.byAqua3.thetitansneo.entity.minion.EntityZombifiedPiglinTitanMinion;
import net.byAqua3.thetitansneo.entity.minion.EnumMinionType;
import net.byAqua3.thetitansneo.entity.projectile.EntityProtoBall;
import net.byAqua3.thetitansneo.entity.titan.EntityExperienceOrbTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityIronGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanPart;
import net.byAqua3.thetitansneo.entity.titan.EnumTitanStatus;
import net.byAqua3.thetitansneo.entity.titan.IEntityMultiPartTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoPredicateTargets;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.util.AnimationUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityZombifiedPiglinTitan
extends EntityTitan
implements IEntityMultiPartTitan,
IBossBarDisplay {
    private static final EntityDataAccessor<Boolean> BABY = SynchedEntityData.defineId(EntityZombifiedPiglinTitan.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final EntityTitanPart head = new EntityTitanPart(this, "head", 8.0f, 8.0f);
    public final EntityTitanPart body = new EntityTitanPart(this, "body", 8.0f, 12.0f);
    public final EntityTitanPart leftArm = new EntityTitanPart(this, "leftarm", 4.0f, 4.0f);
    public final EntityTitanPart rightArm = new EntityTitanPart(this, "rightarm", 4.0f, 4.0f);
    public final EntityTitanPart leftLeg = new EntityTitanPart(this, "leftleg", 4.0f, 12.0f);
    public final EntityTitanPart rightLeg = new EntityTitanPart(this, "rightleg", 4.0f, 12.0f);
    public boolean isStunned;

    public EntityZombifiedPiglinTitan(EntityType<? extends EntityTitan> entityType, Level level) {
        super(entityType, level);
        this.parts = new EntityTitanPart[]{this.head, this.body, this.leftArm, this.rightArm, this.leftLeg, this.rightLeg};
    }

    public EntityZombifiedPiglinTitan(Level level) {
        this((EntityType<? extends EntityTitan>)((EntityType)TheTitansNeoEntities.ZOMBIFIED_PIGLIN_TITAN.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return EntityTitan.createAttributes().add(Attributes.MAX_HEALTH, 40000.0).add(Attributes.ATTACK_DAMAGE, 1800.0);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/gui/bossbar/zombified_piglin_titan.png");
    }

    @Override
    public int getBossBarNameColor() {
        return 15373203;
    }

    @Override
    public int getBossBarWidth() {
        return 185;
    }

    @Override
    public int getBossBarHeight() {
        return 27;
    }

    @Override
    public int getBossBarInterval() {
        return 7;
    }

    @Override
    public int getBossBarVOffset() {
        return 0;
    }

    @Override
    public int getBossBarVHeight() {
        return 0;
    }

    @Override
    public int getBossBarTextOffset() {
        return 7;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.footID = 1;
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanCreation(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanDeath(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanAntiTitanAttack(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanAttack1(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanAttack2(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanAttack3(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanAttack4(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanAttack5(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanAttack6(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanLightningAttack(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanRangedAttack(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanRoar(this));
        this.goalSelector.addGoal(1, (Goal)new AnimationZombifiedPiglinTitanStun(this));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntitySnowGolemTitan>((Mob)this, EntitySnowGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<EntityIronGolemTitan>((Mob)this, EntityIronGolemTitan.class, false));
        this.targetSelector.addGoal(0, new EntityAINearestTargetTitan<LivingEntity>((Mob)this, LivingEntity.class, 0, false, false, TheTitansNeoPredicateTargets.ZombifiedPiglinTitan));
    }

    public boolean isBaby() {
        return (Boolean)this.entityData.get(BABY);
    }

    public void setBaby(boolean baby) {
        this.entityData.set(BABY, (Object)baby);
        this.refreshAttributes();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BABY, (Object)false);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setBaby(tag.getBoolean("IsBaby"));
        this.isStunned = tag.getBoolean("IsStunned");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("IsBaby", this.isBaby());
        tag.putBoolean("IsStunned", this.isStunned);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData groupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setWaiting(true);
        if (level.getRandom().nextFloat() < 0.05f) {
            this.setBaby(true);
        }
        return groupData;
    }

    public Component getName() {
        if (!this.isBaby()) {
            return Component.translatable((String)"entity.thetitansneo.zombified_piglin_titan");
        }
        return Component.translatable((String)"entity.thetitansneo.zombified_piglin_baby_titan");
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        float width = this.isBaby() ? 6.0f : 8.0f;
        float height = this.isBaby() ? 18.0f : 32.0f;
        float eyeHeight = this.isBaby() ? 14.8f : 27.6f;
        return EntityDimensions.scalable((float)width, (float)height).withEyeHeight(eyeHeight);
    }

    @Override
    protected void refreshAttributes() {
        if (this.level().getDifficulty() == Difficulty.HARD) {
            if (this.isBaby()) {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(20000.0 + (double)this.getExtraPower() * 1000.0);
            } else {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(40000.0 + (double)this.getExtraPower() * 2000.0);
            }
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(1800.0 + (double)this.getExtraPower() * 180.0);
        } else {
            if (this.isBaby()) {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(10000.0 + (double)this.getExtraPower() * 500.0);
            } else {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(20000.0 + (double)this.getExtraPower() * 1000.0);
            }
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(900.0 + (double)this.getExtraPower() * 90.0);
        }
    }

    @Override
    public boolean canAttack() {
        return true;
    }

    @Override
    public boolean canAttackEntity(Entity entity) {
        return super.canAttackEntity(entity) && !(entity instanceof EntityZombifiedPiglinTitanMinion) && !(entity instanceof EntityGhastGuardMinion);
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return !this.isInvulnerable();
    }

    @Override
    public boolean shouldMove() {
        return this.getAnimationID() == 0 && !this.isStunned && !this.getWaiting() && this.getTarget() != null ? super.shouldMove() : false;
    }

    @Override
    public boolean canRegen() {
        return !this.isStunned;
    }

    @Override
    public int getRegenTime() {
        return 5;
    }

    @Override
    public boolean isArmored() {
        return this.deathTicks <= 0 && this.getTitanHealth() <= this.getMaxHealth() / 4.0f;
    }

    @Override
    public SimpleParticleType getParticles() {
        if (this.level().getRandom().nextFloat() < 0.25f) {
            return ParticleTypes.POOF;
        }
        return ParticleTypes.SMOKE;
    }

    @Override
    public int getParticleCount() {
        return 6;
    }

    @Override
    public int getMinionCap() {
        int spawnCap = (Integer)TheTitansNeoConfigs.zombifiedPiglinTitanMinionSpawnCap.get();
        if (this.getAnimationID() == 11 && this.getAnimationTick() > 80) {
            spawnCap *= 3;
        }
        return spawnCap;
    }

    @Override
    public int getPriestCap() {
        int spawnCap = (Integer)TheTitansNeoConfigs.zombifiedPiglinTitanPriestSpawnCap.get();
        if (this.getAnimationID() == 11 && this.getAnimationTick() > 80) {
            spawnCap *= 3;
        }
        return spawnCap;
    }

    @Override
    public int getZealotCap() {
        int spawnCap = (Integer)TheTitansNeoConfigs.zombifiedPiglinTitanZealotSpawnCap.get();
        if (this.getAnimationID() == 11 && this.getAnimationTick() > 80) {
            spawnCap *= 2;
        }
        return spawnCap;
    }

    @Override
    public int getBishopCap() {
        int spawnCap = (Integer)TheTitansNeoConfigs.zombifiedPiglinTitanBishopSpawnCap.get();
        if (this.getAnimationID() == 11 && this.getAnimationTick() > 80) {
            spawnCap *= 2;
        }
        return spawnCap;
    }

    @Override
    public int getTemplarCap() {
        int spawnCap = (Integer)TheTitansNeoConfigs.zombifiedPiglinTitanTemplarSpawnCap.get();
        if (this.getAnimationID() == 11 && this.getAnimationTick() > 80) {
            spawnCap *= 2;
        }
        return spawnCap;
    }

    @Override
    public int getSpecialMinionCap() {
        return (Integer)TheTitansNeoConfigs.zombifiedPiglinTitanSpecialSpawnCap.get();
    }

    @Override
    public boolean canSpawnMinion() {
        boolean flag = (this.getInvulTime() > 1 || this.getAnimationID() == 11 && this.getAnimationTick() > 80) && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.zombifiedPiglinTitanSummonMinionSpawnRate.get();
    }

    @Override
    public boolean canSpawnPriest() {
        boolean flag = (this.getInvulTime() > 1 || this.getAnimationID() == 11 && this.getAnimationTick() > 80) && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.zombifiedPiglinTitanSummonPriestSpawnRate.get();
    }

    @Override
    public boolean canSpawnZealot() {
        boolean flag = (this.getInvulTime() > 1 || this.getAnimationID() == 11 && this.getAnimationTick() > 80) && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.zombifiedPiglinTitanSummonZealotSpawnRate.get();
    }

    @Override
    public boolean canSpawnBishop() {
        boolean flag = (this.getInvulTime() > 1 || this.getAnimationID() == 11 && this.getAnimationTick() > 80) && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.zombifiedPiglinTitanSummonBishopSpawnRate.get();
    }

    @Override
    public boolean canSpawnTemplar() {
        boolean flag = (this.getInvulTime() > 1 || this.getAnimationID() == 11 && this.getAnimationTick() > 80) && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.zombifiedPiglinTitanSummonTemplarSpawnRate.get();
    }

    @Override
    public boolean canSpawnSpecialMinion() {
        boolean flag = (this.getInvulTime() > 1 || this.getAnimationID() == 11 && this.getAnimationTick() > 80) && this.tickCount % 20 == 0;
        float randomRate = this.getRandom().nextFloat() * 100.0f;
        return flag || (double)randomRate < (Double)TheTitansNeoConfigs.zombifiedPiglinTitanSummonSpecialMinionSpawnRate.get();
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.AVERAGE;
    }

    @Override
    public int getFootStepModifer() {
        return 5;
    }

    @Override
    public float getSpeed() {
        return this.isBaby() ? 0.6f + (float)this.getExtraPower() * 0.001f : (this.isArmored() ? 0.45f + (float)this.getExtraPower() * 0.001f : 0.3f + (float)this.getExtraPower() * 0.001f);
    }

    protected SoundEvent getAmbientSound() {
        if (!this.getWaiting() && this.getAnimationID() != 13 && !this.isStunned) {
            return (SoundEvent)TheTitansNeoSounds.TITAN_ZOMBIFIED_PIGLIN_LIVING.get();
        }
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)TheTitansNeoSounds.TITAN_ZOMBIFIED_PIGLIN_GRUNT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TheTitansNeoSounds.TITAN_ZOMBIFIED_PIGLIN_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.shakeNearbyPlayerCameras(4000.0);
        this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STEP.get(), 10.0f, 1.0f);
        if (!this.getWaiting() && this.getAnimationID() != 13) {
            float f1 = this.getYRot() * (float)Math.PI / 180.0f;
            float f2 = Mth.sin((float)f1);
            float f3 = Mth.cos((float)f1);
            if (this.footID == 0) {
                this.collideWithEntities(this.leftLeg, this.level().getEntities((Entity)this, this.leftLeg.getBoundingBox().inflate(1.0, 1.0, 1.0).move((double)(f2 * 4.0f), 0.0, (double)(f3 * 4.0f))));
                this.destroyBlocksInAABB(this.leftLeg.getBoundingBox().move(0.0, -1.0, 0.0));
                ++this.footID;
            } else {
                this.collideWithEntities(this.rightLeg, this.level().getEntities((Entity)this, this.rightLeg.getBoundingBox().inflate(1.0, 1.0, 1.0).move((double)(f2 * 4.0f), 0.0, (double)(f3 * 4.0f))));
                this.destroyBlocksInAABB(this.rightLeg.getBoundingBox().move(0.0, -1.0, 0.0));
                this.footID = 0;
            }
        }
    }

    @Override
    public void attackEntity(LivingEntity entity, float amount) {
        if (this.isArmored()) {
            amount *= 2.0f;
        }
        super.attackEntity(entity, amount);
    }

    @Override
    public boolean attackEntityFromPart(EntityTitanPart entityTitanPart, DamageSource damageSource, float amount) {
        if (entityTitanPart != this.head) {
            amount /= 3.0f;
        }
        this.hurt(damageSource, amount);
        return true;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float amount) {
        if (this.isArmored()) {
            amount /= 3.0f;
        }
        if (this.isStunned) {
            amount *= 3.0f;
        }
        if (amount > 25.0f && damageSource.getEntity() instanceof LivingEntity && !this.isInvulnerable()) {
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(256.0, 256.0, 256.0));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity instanceof EntityTitan) {
                    if (!(livingEntity instanceof EntityZombifiedPiglinTitan)) continue;
                    EntityZombifiedPiglinTitan titan = (EntityZombifiedPiglinTitan)livingEntity;
                    titan.setTarget((LivingEntity)damageSource.getEntity());
                    continue;
                }
                if (!(livingEntity instanceof Mob)) continue;
                Mob mob = (Mob)livingEntity;
                mob.setTarget((LivingEntity)damageSource.getEntity());
            }
        }
        return super.hurt(damageSource, amount);
    }

    @Override
    protected void dropExperienceOrb() {
        for (int x = 0; x < 24; ++x) {
            EntityExperienceOrbTitan experienceOrbTitan = new EntityExperienceOrbTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), 20000);
            experienceOrbTitan.push(0.0, 1.0, 0.0);
            this.level().addFreshEntity((Entity)experienceOrbTitan);
        }
    }

    @Override
    protected void dropRateItem() {
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Blocks.GOLD_BLOCK), 64);
        Map.Entry entry = (Map.Entry)drops.entrySet().stream().toList().get(this.getRandom().nextInt(drops.entrySet().size()));
        ItemStack itemStack = (ItemStack)entry.getKey();
        int count = (Integer)entry.getValue();
        EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
        itemTitan.setPickUpDelay(40);
        this.level().addFreshEntity((Entity)itemTitan);
    }

    @Override
    protected void dropAllItem() {
        int count;
        ItemStack itemStack;
        HashMap<ItemStack, Integer> drops = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> rateDrops = new HashMap<ItemStack, Integer>();
        drops.put(new ItemStack((ItemLike)Items.ROTTEN_FLESH), 128);
        drops.put(new ItemStack((ItemLike)Items.GOLD_NUGGET), 128);
        drops.put(new ItemStack((ItemLike)Items.BONE), 32);
        drops.put(new ItemStack((ItemLike)Items.COAL), 32);
        drops.put(new ItemStack((ItemLike)Items.GOLD_INGOT), 64);
        drops.put(new ItemStack((ItemLike)Items.STICK), 16);
        drops.put(new ItemStack((ItemLike)Items.EMERALD), 12);
        drops.put(new ItemStack((ItemLike)Items.DIAMOND), 12);
        rateDrops.put(new ItemStack((ItemLike)Items.ROTTEN_FLESH), 128);
        rateDrops.put(new ItemStack((ItemLike)Items.GOLD_NUGGET), 128);
        rateDrops.put(new ItemStack((ItemLike)Items.BONE), 32);
        rateDrops.put(new ItemStack((ItemLike)Items.COAL), 32);
        rateDrops.put(new ItemStack((ItemLike)Items.GOLD_INGOT), 32);
        rateDrops.put(new ItemStack((ItemLike)Items.EMERALD), 12);
        rateDrops.put(new ItemStack((ItemLike)Items.DIAMOND), 12);
        rateDrops.put(new ItemStack((ItemLike)TheTitansNeoItems.HARCADIUM.get()), 8);
        for (Map.Entry entry : drops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, count);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
        for (Map.Entry entry : rateDrops.entrySet()) {
            itemStack = (ItemStack)entry.getKey();
            count = (Integer)entry.getValue();
            int randomCount = this.getRandom().nextInt(count) + 1;
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), itemStack, randomCount);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
        if (this.getRandom().nextInt(5) == 0) {
            EntityItemTitan itemTitan = new EntityItemTitan(this.level(), this.getX() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), this.getY() + 4.0, this.getZ() + (double)(this.getRandom().nextFloat() * 12.0f - 6.0f), new ItemStack((ItemLike)Blocks.BEDROCK), this.getRandom().nextInt(2) + 1);
            itemTitan.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)itemTitan);
        }
    }

    @Override
    protected void tickTitanDeath() {
        super.tickTitanDeath();
        AnimationUtils.sendPacket(this, 10);
        this.isStunned = false;
        if (this.deathTicks >= 500) {
            this.setInvulTime(this.getInvulTime() + 8);
            this.setAnimationTick(this.getAnimationTick() - 1);
            float f = (this.random.nextFloat() - 0.5f) * 12.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 3.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 12.0f;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.onDeath();
            if (!this.level().isClientSide() && !this.isRemoved()) {
                for (EntityTitanPart part : this.parts) {
                    part.remove(Entity.RemovalReason.KILLED);
                }
                this.removeTitan(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public void finalizeMinionSummon(Entity entity, EnumMinionType minionType) {
        if (minionType != EnumMinionType.SPECIAL && entity instanceof EntityZombifiedPiglinTitanMinion) {
            EntityZombifiedPiglinTitanMinion zombifiedPiglinTitanMinion = (EntityZombifiedPiglinTitanMinion)entity;
            zombifiedPiglinTitanMinion.setBaby(this.isBaby());
            zombifiedPiglinTitanMinion.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 40, 4, true, false));
            zombifiedPiglinTitanMinion.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, Integer.MAX_VALUE, 0, true, false));
        }
    }

    public void animationTick() {
        Object livingEntity;
        List entities;
        int knockbackAmount;
        float amount;
        Vec3 vec3;
        LivingEntity livingEntity2;
        List entities2;
        int knockbackAmount2;
        float amount2;
        if (this.getAnimationID() == 13) {
            this.addDayTime(14000L, 50L);
            if (this.getAnimationTick() == 1) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_BIRTH.get(), 1000.0f, 1.0f);
            }
            if (this.getAnimationTick() == 40) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_RUMBLE.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 130) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SKELETON_GETUP.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 240) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_ZOMBIE_ROAR.get(), this.getSoundVolume(), 1.0f);
            }
            if (this.getAnimationTick() == 110 || this.getAnimationTick() == 150 || this.getAnimationTick() == 170) {
                this.playStepSound(new BlockPos(0, 0, 0), Blocks.STONE.defaultBlockState());
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PRESS.get(), this.getSoundVolume(), 1.0f);
            }
        }
        if (this.getAnimationID() == 1 && this.getAnimationTick() == 12 && this.getTarget() != null) {
            this.shakeNearbyPlayerCameras(20000.0);
            if (this.isArmored()) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.05f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.1f);
                for (int i = 0; i < 3; ++i) {
                    this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(26.0, 26.0, 26.0)));
                }
            }
            amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount2 = this.getKnockbackAmount();
            this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(48.0, 48.0, 48.0)));
            for (int i = 0; i < 6; ++i) {
                this.attackEntity(this.getTarget(), amount2);
            }
            this.knockbackEntity(this.getTarget(), knockbackAmount2);
            entities2 = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(8.0, 8.0, 8.0));
            for (Entity entity : entities2) {
                if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                livingEntity2 = (LivingEntity)entity;
                for (int i = 0; i < 2; ++i) {
                    this.attackEntity(livingEntity2, amount2 * 2.0f);
                }
                this.knockbackEntity(livingEntity2, knockbackAmount2);
            }
        }
        if (this.getAnimationID() == 2) {
            if (this.getAnimationTick() == 24) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 5.0f, 1.25f);
            }
            if (this.getAnimationTick() == 26 && this.getTarget() != null) {
                amount2 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount2 = this.getKnockbackAmount();
                this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(4.0, 2.0, 4.0)));
                for (int i = 0; i < 2; ++i) {
                    this.attackEntity(this.getTarget(), amount2);
                }
                this.knockbackEntity(this.getTarget(), knockbackAmount2);
                this.getTarget().push(0.0, 2.0, 0.0);
                entities2 = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(6.0, 2.0, 6.0));
                for (Entity entity : entities2) {
                    if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity2 = (LivingEntity)entity;
                    this.attackEntity(livingEntity2, amount2);
                    this.knockbackEntity(livingEntity2, knockbackAmount2);
                    livingEntity2.push(0.0, 2.0, 0.0);
                }
            }
        }
        if (this.getAnimationID() == 3) {
            if (this.getAnimationTick() == 24) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 5.0f, 1.25f);
            }
            if (this.getAnimationTick() == 32) {
                this.shakeNearbyPlayerCameras(20000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
                double d8 = 8.0;
                vec3 = this.getViewVector(1.0f);
                double dx = vec3.x * d8;
                double dz = vec3.z * d8;
                amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                knockbackAmount = this.getKnockbackAmount();
                this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(16.0, 8.0, 16.0)));
                entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 2.0, 32.0).move(dx, -4.0, dz));
                for (Entity entity : entities) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity = (LivingEntity)entity;
                    this.attackEntity((LivingEntity)livingEntity, amount);
                    this.knockbackEntity((LivingEntity)livingEntity, knockbackAmount);
                }
            }
        }
        if (this.getAnimationID() == 4 && this.getAnimationTick() == 54) {
            this.shakeNearbyPlayerCameras(20000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
            double d8 = 8.0;
            vec3 = this.getViewVector(1.0f);
            double dx = vec3.x * d8;
            double dz = vec3.z * d8;
            amount = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            knockbackAmount = this.getKnockbackAmount();
            this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(16.0, 8.0, 16.0)));
            entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 2.0, 32.0).move(dx, -4.0, dz));
            for (Entity entity : entities) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                livingEntity = (LivingEntity)entity;
                this.attackEntity((LivingEntity)livingEntity, amount * 3.0f);
                this.knockbackEntity((LivingEntity)livingEntity, knockbackAmount);
            }
        }
        if (this.getAnimationID() == 5) {
            if (this.getAnimationTick() == 34) {
                this.playSound((SoundEvent)TheTitansNeoSounds.LIGHTNING_CHARGE.get(), 100.0f, 1.0f);
            }
            if (this.getAnimationTick() <= 50 && this.getAnimationTick() >= 20) {
                float ex = this.isBaby() ? 4.5f : 9.5f;
                float fl = this.yBodyRot * (float)Math.PI / 180.0f;
                float fl1 = Mth.sin((float)fl);
                float fl2 = Mth.cos((float)fl);
                EntityColorLightningBolt colorLightningBolt1 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 0.0f);
                EntityColorLightningBolt colorLightningBolt2 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 0.0f);
                colorLightningBolt1.setPos(this.getX() - (double)(fl2 * ex), this.getY() + (this.isBaby() ? 13.0 : 26.0), this.getZ() - (double)(fl1 * ex));
                colorLightningBolt2.setPos(this.getX() + (double)(fl2 * ex), this.getY() + (this.isBaby() ? 13.0 : 26.0), this.getZ() + (double)(fl1 * ex));
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)colorLightningBolt1);
                    this.level().addFreshEntity((Entity)colorLightningBolt2);
                }
                if (this.getTarget() == null) {
                    this.heal(50.0f);
                }
            }
            if (this.getAnimationTick() == 64) {
                this.playSound((SoundEvent)TheTitansNeoSounds.LIGHTNING_THROW.get(), 100.0f, 1.0f);
                double d8 = this.isBaby() ? 6.0 : 12.0;
                Vec3 vec32 = this.getViewVector(1.0f);
                double dx = vec32.x * d8;
                double dz = vec32.z * d8;
                if (!this.level().isClientSide()) {
                    this.level().explode((Entity)this, this.getX() + dx, this.getY() + 26.0, this.getZ() + dz, 1.0f, false, Level.ExplosionInteraction.MOB);
                }
                EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 0.0f);
                colorLightningBolt.setPos(this.getX() + dx, this.getY() + (this.isBaby() ? 9.0 : 18.0), this.getZ() + dz);
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)colorLightningBolt);
                }
                if (this.getTarget() != null) {
                    if (!this.level().isClientSide()) {
                        this.level().explode((Entity)this, this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                    }
                    EntityColorLightningBolt colorLightningBolt1 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 0.0f);
                    colorLightningBolt1.setPos(this.getTarget().getX(), this.getTarget().getY(), this.getTarget().getZ());
                    if (!this.level().isClientSide()) {
                        this.level().addFreshEntity((Entity)colorLightningBolt1);
                    }
                    float amount3 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                    int knockbackAmount3 = this.getKnockbackAmount();
                    this.attackEntity(this.getTarget(), amount3 * 3.0f);
                    this.knockbackEntity(this.getTarget(), knockbackAmount3);
                    this.getTarget().push(0.0, 1.0 + this.getRandom().nextDouble(), 0.0);
                    List entities3 = this.level().getEntities((Entity)this.getTarget(), this.getTarget().getBoundingBox().inflate(12.0, 12.0, 12.0));
                    for (Entity entity : entities3) {
                        if (entity == null || entity == this || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                        LivingEntity livingEntity3 = (LivingEntity)entity;
                        if (!this.level().isClientSide()) {
                            this.level().explode((Entity)this, livingEntity3.getX(), livingEntity3.getY(), livingEntity3.getZ(), 2.0f, false, Level.ExplosionInteraction.MOB);
                        }
                        EntityColorLightningBolt colorLightningBolt2 = new EntityColorLightningBolt(this.level(), 1.0f, 0.0f, 0.0f);
                        colorLightningBolt2.setPos(livingEntity3.getX(), livingEntity3.getY(), livingEntity3.getZ());
                        if (!this.level().isClientSide()) {
                            this.level().addFreshEntity((Entity)colorLightningBolt2);
                        }
                        this.attackEntity(livingEntity3, amount3);
                        this.knockbackEntity(livingEntity3, knockbackAmount3);
                        livingEntity3.push(0.0, 1.0 + this.getRandom().nextDouble(), 0.0);
                    }
                }
            }
        }
        if (this.getAnimationID() == 6 && (this.getAnimationTick() == 60 || this.getAnimationTick() == 104)) {
            this.shakeNearbyPlayerCameras(20000.0);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 100.0f, 1.0f);
            this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PRESS.get(), 100.0f, 1.0f);
            float amount4 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(16.0, 8.0, 16.0)));
            List entities4 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(32.0, 2.0, 32.0));
            for (Entity entity : entities4) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity4 = (LivingEntity)entity;
                this.attackEntity(livingEntity4, amount4);
                livingEntity4.push(0.0, 1.0 + this.getRandom().nextDouble() + this.getRandom().nextDouble(), 0.0);
            }
        }
        if (this.getAnimationID() == 7) {
            if (this.getAnimationTick() == 120) {
                this.shakeNearbyPlayerCameras(20000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 100.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PRESS.get(), 100.0f, 1.0f);
                double d8 = 36.0;
                Vec3 vec33 = this.getViewVector(1.0f);
                double dx = vec33.x * d8;
                double dz = vec33.z * d8;
                float amount5 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                int knockbackAmount4 = this.getKnockbackAmount();
                this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(16.0, 8.0, 16.0)));
                List entities5 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(24.0, 2.0, 24.0).move(dx, -2.0, dz));
                for (Entity entity : entities5) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    livingEntity = (LivingEntity)entity;
                    this.attackEntity((LivingEntity)livingEntity, amount5 * 15.0f);
                    this.knockbackEntity((LivingEntity)livingEntity, knockbackAmount4);
                }
            }
            if (this.getAnimationTick() == 122) {
                double d8 = this.isBaby() ? 16.0 : 32.0;
                Vec3 vec34 = this.getViewVector(1.0f);
                double dx = vec34.x * d8;
                double dz = vec34.z * d8;
                int x = Mth.floor((double)(this.getX() + dx));
                int y = Mth.floor((double)this.getY());
                int z = Mth.floor((double)(this.getZ() + dz));
                BlockPos blockPos = new BlockPos(x, y, z);
                BlockState blockState = this.level().getBlockState(blockPos);
                if (!blockState.isAir()) {
                    this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_STRIKE.get(), 20.0f, 1.0f);
                    this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SLAM.get(), 20.0f, 1.0f);
                }
                for (int rangeX = -4; rangeX <= 4; ++rangeX) {
                    for (int rangeY = -1; rangeY <= 1; ++rangeY) {
                        for (int rangeZ = -4; rangeZ <= 4; ++rangeZ) {
                            int posX = x + rangeX;
                            int posY = y + rangeY;
                            int posZ = z + rangeZ;
                            BlockPos pos = new BlockPos(posX, posY, posZ);
                            BlockState state = this.level().getBlockState(pos);
                            Block block = state.getBlock();
                            if (!state.isAir() && block == Blocks.GRASS_BLOCK) {
                                this.level().setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
                            }
                            if (!(block.getExplosionResistance() <= 1.5f) || state.isAir() || block == Blocks.NETHERRACK || block == Blocks.DIRT || block == Blocks.GRASS_BLOCK || block == Blocks.GLASS || block == Blocks.GLASS_PANE) continue;
                            this.playSound(SoundEvents.ANVIL_LAND, 20.0f, 0.5f);
                            AnimationUtils.sendPacket(this, 8);
                            this.isStunned = true;
                        }
                    }
                }
            }
        }
        if (this.getAnimationID() == 8) {
            if (this.getAnimationTick() == 140 || this.getAnimationTick() == 300 || this.getAnimationTick() == 330) {
                this.playSound((SoundEvent)TheTitansNeoSounds.SLASH_FLESH.get(), 20.0f, 1.0f);
                this.attackEntityFromPart(this.head, this.damageSources().generic(), 1000.0f);
            }
            if (this.getAnimationTick() == 400) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_ZOMBIE_ROAR.get(), 1000.0f, 0.95f);
            }
            if (this.getAnimationTick() == 530) {
                this.isStunned = false;
            }
        }
        if (this.getAnimationID() == 9 && this.getAnimationTick() >= 104 && this.getAnimationTick() <= 106) {
            this.playSound((SoundEvent)TheTitansNeoSounds.SLASH_FLESH.get(), 10.0f, 1.0f);
            double d8 = 24.0;
            Vec3 vec35 = this.getViewVector(1.0f);
            double dx = vec35.x * d8;
            double dz = vec35.z * d8;
            float amount6 = (float)this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            int knockbackAmount5 = this.getKnockbackAmount();
            this.collideWithEntities(this.body, this.level().getEntities((Entity)this, this.body.getBoundingBox().inflate(16.0, 8.0, 16.0)));
            List entities6 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(16.0, 1.0, 16.0).move(dx, 0.0, dz));
            for (Entity entity : entities6) {
                if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                LivingEntity livingEntity5 = (LivingEntity)entity;
                this.attackEntity(livingEntity5, amount6 * 4.0f);
                this.knockbackEntity(livingEntity5, knockbackAmount5);
            }
        }
        if (this.getAnimationID() == 10) {
            if (this.getAnimationTick() == 30 || this.getAnimationTick() == 70) {
                this.playStepSound(new BlockPos(0, 0, 0), Blocks.STONE.defaultBlockState());
            }
            if (this.getAnimationTick() == 190) {
                this.shakeNearbyPlayerCameras(10000.0);
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_FALL.get(), 20.0f, 1.0f);
                this.playSound((SoundEvent)TheTitansNeoSounds.GROUND_SMASH.get(), 20.0f, 1.0f);
                for (int i = 0; i < 2; ++i) {
                    this.collideWithEntities(this.leftLeg, this.level().getEntities((Entity)this, this.leftLeg.getBoundingBox().inflate(48.0, 48.0, 48.0)));
                    this.collideWithEntities(this.rightLeg, this.level().getEntities((Entity)this, this.rightLeg.getBoundingBox().inflate(48.0, 48.0, 48.0)));
                }
            }
            if (this.getAnimationTick() == 200) {
                this.playSound((SoundEvent)TheTitansNeoSounds.DISTANT_LARGE_FALL.get(), 10000.0f, 1.0f);
            }
        }
        if (this.getAnimationID() == 11) {
            if (this.getAnimationTick() == 20) {
                this.playSound((SoundEvent)TheTitansNeoSounds.TITAN_ZOMBIE_ROAR.get(), 1000.0f, 1.0f);
                this.collideWithEntities(this.head, this.level().getEntities((Entity)this, this.head.getBoundingBox().inflate(64.0, 64.0, 64.0)));
                List entities7 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(64.0, 64.0, 64.0));
                for (Entity entity : entities7) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity6 = (LivingEntity)entity;
                    this.attackEntity(livingEntity6, 40.0f);
                }
            }
            if (this.getAnimationTick() >= 20) {
                List entities8 = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(64.0, 64.0, 64.0));
                for (Entity entity : entities8) {
                    if (entity == null || !(entity instanceof LivingEntity) || !this.canAttackEntity(entity)) continue;
                    LivingEntity livingEntity7 = (LivingEntity)entity;
                    if (this.level().isClientSide()) continue;
                    livingEntity7.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 4));
                }
            }
        }
        if (this.getAnimationID() == 12 && this.getAnimationTick() == 55 && this.getTarget() != null) {
            for (int i = 0; i < 4 + 2 * this.level().getDifficulty().getId(); ++i) {
                double d8 = 12.0;
                Vec3 vec36 = this.getViewVector(1.0f);
                double dx = vec36.x * d8;
                double dz = vec36.z * d8;
                double d0 = this.head.getX() + dx;
                double d1 = this.head.getY();
                double d2 = this.head.getZ() + dz;
                double d3 = this.getTarget().getX() + this.getTarget().getDeltaMovement().x - d0;
                double d4 = this.getTarget().getY() + (double)this.getTarget().getEyeHeight() - 8.0 - d1;
                double d5 = this.getTarget().getZ() + this.getTarget().getDeltaMovement().z - d2;
                double d6 = Math.sqrt(d3 * d3 + d5 * d5);
                int knockbackAmount6 = 5;
                EntityProtoBall entityProtoBall = new EntityProtoBall(this.level());
                entityProtoBall.setPos(d0, d1, d2);
                entityProtoBall.shoot(d3, d4 + d6, d5, 0.95f, 45.0f - (float)this.level().getDifficulty().getId() * 5.0f);
                entityProtoBall.setDeltaMovement(entityProtoBall.getDeltaMovement().x * 1.5, entityProtoBall.getDeltaMovement().y, entityProtoBall.getDeltaMovement().z * 1.5);
                entityProtoBall.setOwner((Entity)this);
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)entityProtoBall);
                }
                if (!(this.distanceToSqr((Entity)this.getTarget()) < 400.0)) continue;
                this.attackEntity(this.getTarget(), 10.0f);
                this.knockbackEntity(this.getTarget(), knockbackAmount6);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.refreshDimensions();
        this.checkWaiting(16.0);
        if (!(this.getAnimationID() != 0 || this.isPassenger() || this.getWaiting() || this.isStunned)) {
            if (this.getTarget() != null) {
                double d = this.distanceToSqr((Entity)this.getTarget());
                double d2 = this.getMeleeRange();
                double d3 = !this.getTarget().onGround() ? 1000.0 : 8000.0;
                if (d > d2 + d3) {
                    if (this.getY() <= this.getTarget().getY() + 12.0 && this.getY() < 256.0 - (double)this.getBbHeight()) {
                        this.fallDistance = 0.0f;
                        this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.9 - this.getDeltaMovement().y, this.getDeltaMovement().z);
                        if (this.getDeltaMovement().y < 0.0) {
                            this.setTitanDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
                        }
                    }
                    this.setTitanDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * 0.6, this.getDeltaMovement().z);
                }
            }
            if (!this.onGround()) {
                float f3 = (this.getRandom().nextFloat() - 0.5f) * 10.0f;
                float f4 = (this.getRandom().nextFloat() - 0.5f) * 1.0f;
                float f5 = (this.getRandom().nextFloat() - 0.5f) * 10.0f;
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f3, this.getY() + 5.0 + (double)f4, this.getZ() + (double)f5, 0.0, 0.0, 0.0);
            }
        }
        if (this.tickCount > 5) {
            float f = this.yBodyRot * (float)Math.PI / 180.0f;
            float f1 = Mth.sin((float)f);
            float f2 = Mth.cos((float)f);
            if (this.isBaby()) {
                this.head.setSize(6.0f, 6.0f);
                this.body.setSize(3.5f, 6.0f);
                this.leftArm.setSize(2.0f, 2.0f);
                this.rightArm.setSize(2.0f, 2.0f);
                this.leftLeg.setSize(2.0f, 6.0f);
                this.rightLeg.setSize(2.0f, 6.0f);
            } else {
                this.head.setSize(8.0f, 8.0f);
                this.body.setSize(7.0f, 12.0f);
                this.leftArm.setSize(4.0f, 4.0f);
                this.rightArm.setSize(4.0f, 4.0f);
                this.leftLeg.setSize(4.0f, 12.0f);
                this.rightLeg.setSize(4.0f, 12.0f);
            }
            this.head.moveTo(this.getX(), this.getY() + (this.isBaby() ? 12.0 : 24.0), this.getZ());
            this.body.moveTo(this.getX(), this.getY() + (this.isBaby() ? 6.0 : 12.0), this.getZ());
            this.leftArm.moveTo(this.getX() - (double)f2 * (this.isBaby() ? 3.0 : 6.0), this.getY() + (this.isBaby() ? 10.0 : 20.0), this.getZ() - (double)f1 * (this.isBaby() ? 3.0 : 6.0));
            this.rightArm.moveTo(this.getX() + (double)f2 * (this.isBaby() ? 3.0 : 6.0), this.getY() + (this.isBaby() ? 10.0 : 20.0), this.getZ() + (double)f1 * (this.isBaby() ? 3.0 : 6.0));
            this.leftLeg.moveTo(this.getX() - (double)f2 * (this.isBaby() ? 1.0 : 2.0), this.getY(), this.getZ() - (double)f1 * (this.isBaby() ? 1.0 : 2.0));
            this.rightLeg.moveTo(this.getX() + (double)f2 * (this.isBaby() ? 1.0 : 2.0), this.getY(), this.getZ() + (double)f1 * (this.isBaby() ? 1.0 : 2.0));
            if (this.isAlive() && !this.isStunned) {
                for (EntityTitanPart part : this.parts) {
                    this.collideWithEntities(part, this.level().getEntities((Entity)this, part.getBoundingBox().inflate(1.0, 0.0, 1.0)));
                }
            }
            this.destroyBlocksInAABB(this.head.getBoundingBox());
            this.destroyBlocksInAABB(this.body.getBoundingBox());
            this.destroyBlocksInAABB(this.leftArm.getBoundingBox());
            this.destroyBlocksInAABB(this.rightArm.getBoundingBox());
            this.destroyBlocksInAABB(this.leftLeg.getBoundingBox().inflate(1.0, 0.0, 1.0));
            this.destroyBlocksInAABB(this.rightLeg.getBoundingBox().inflate(1.0, 0.0, 1.0));
        }
        if (this.getAnimationID() == 0 && this.getTarget() != null && !this.isStunned) {
            double d0 = this.distanceToSqr((Entity)this.getTarget());
            if (d0 < this.getMeleeRange()) {
                if (this.getTarget() instanceof EntityTitan || this.getTarget().getBbHeight() >= 6.0f || this.getTarget().getY() > this.getY() + 6.0) {
                    AnimationUtils.sendPacket(this, 1);
                } else {
                    switch (this.getRandom().nextInt(7)) {
                        case 0: {
                            AnimationUtils.sendPacket(this, 11);
                            break;
                        }
                        case 1: {
                            AnimationUtils.sendPacket(this, 3);
                            break;
                        }
                        case 2: {
                            AnimationUtils.sendPacket(this, 4);
                            break;
                        }
                        case 3: {
                            AnimationUtils.sendPacket(this, 6);
                            break;
                        }
                        case 4: {
                            AnimationUtils.sendPacket(this, 7);
                            break;
                        }
                        case 5: {
                            AnimationUtils.sendPacket(this, 9);
                            break;
                        }
                        case 6: {
                            AnimationUtils.sendPacket(this, 2);
                        }
                    }
                }
            } else if (this.getRandom().nextInt(100) == 0) {
                switch (this.getRandom().nextInt(3)) {
                    case 0: {
                        AnimationUtils.sendPacket(this, 5);
                        break;
                    }
                    case 1: {
                        AnimationUtils.sendPacket(this, 12);
                        break;
                    }
                    case 2: {
                        if (this.getRandom().nextInt(4) == 0) {
                            AnimationUtils.sendPacket(this, 11);
                            break;
                        }
                        AnimationUtils.sendPacket(this, 5);
                    }
                }
            }
        }
        if (this.isStunned) {
            this.setTarget(null);
            AnimationUtils.sendPacket(this, 8);
        }
        if (this.getAnimationID() == 0 && this.getRandom().nextInt(120) == 0 && this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) > 512.0 && this.onGround()) {
            this.playSound(this.getHurtSound(null), this.getSoundVolume(), this.getVoicePitch());
            if (this.getRandom().nextInt(4) == 0) {
                this.jumpFromGround();
                double d0 = this.getTarget().getX() - this.getX();
                double d1 = this.getTarget().getZ() - this.getZ();
                double d2 = Math.sqrt(d0 * d0 + d1 * d1);
                double hor = 2.0;
                this.setTitanDeltaMovement(d0 / d2 * hor * hor + this.getDeltaMovement().x * hor, this.getDeltaMovement().y, d1 / d2 * hor * hor + this.getDeltaMovement().z * hor);
            } else {
                this.jumpAtEntity(this.getTarget());
            }
        }
        this.animationTick();
    }
}

