/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.event;

import java.util.ArrayList;
import java.util.List;
import net.byAqua3.thetitansneo.damage.DamageSourceTitanAttack;
import net.byAqua3.thetitansneo.entity.EntityColorLightningBolt;
import net.byAqua3.thetitansneo.entity.projectile.IEntityProjectileTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossus;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEnchantments;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoMobEffects;
import net.byAqua3.thetitansneo.loader.TheTitansNeoTriggers;
import net.byAqua3.thetitansneo.trigger.TriggerRoot;
import net.byAqua3.thetitansneo.util.ItemUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerHeartTypeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ExplosionKnockbackEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class TheTitansNeoEvent {
    @SubscribeEvent
    public void onLivingTick(EntityTickEvent.Post event) {
        Level level = event.getEntity().level();
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((TriggerRoot)((Object)TheTitansNeoTriggers.ROOT.get())).trigger(serverPlayer);
            }
            if (ItemUtils.hasItem(player.getInventory(), (Item)TheTitansNeoItems.ULTIMA_BLADE.get()) && ItemUtils.hasItem(player.getInventory(), (Item)TheTitansNeoItems.OPTIMA_AXE.get())) {
                boolean flag = true;
                List entities = level.getEntities((Entity)player, player.getBoundingBox().inflate(200.0, 200.0, 200.0));
                for (Entity entity : entities) {
                    if (entity == null || !entity.isAlive() || !(entity instanceof EntityEnderColossus)) continue;
                    flag = false;
                }
                if (flag && !level.isClientSide()) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.setWeatherParameters(0, ServerLevel.THUNDER_DURATION.sample(serverLevel.getRandom()), true, true);
                }
                if (level.random.nextInt(60) == 0) {
                    for (Entity entity : entities) {
                        if (entity == null || !(entity instanceof LivingEntity) || !entity.isAlive()) continue;
                        EntityColorLightningBolt colorLightningBolt = new EntityColorLightningBolt(level, level.getRandom().nextFloat(), level.getRandom().nextFloat(), level.getRandom().nextFloat());
                        colorLightningBolt.setPos(entity.getX(), entity.getY() + (double)entity.getBbHeight(), entity.getZ());
                        if (level.isClientSide()) continue;
                        level.addFreshEntity((Entity)colorLightningBolt);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingDamageEvent.Post event) {
        Player player;
        ItemStack itemStack;
        DamageSource damageSource = event.getSource();
        Entity entity = damageSource.getEntity();
        if (entity instanceof Player && !(itemStack = (player = (Player)entity).getMainHandItem()).isEmpty()) {
            int b;
            int a = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.level().registryAccess().holderOrThrow(TheTitansNeoEnchantments.KNOCK_UP), (ItemStack)itemStack);
            if (a > 0) {
                event.getEntity().setOnGround(false);
                event.getEntity().push(0.0, 1.0 * (double)a, 0.0);
            }
            if ((b = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.level().registryAccess().holderOrThrow(TheTitansNeoEnchantments.TITAN_KILLER), (ItemStack)itemStack)) > 0 && !(damageSource instanceof DamageSourceTitanAttack) && event.getEntity() instanceof EntityTitan) {
                EntityTitan titan = (EntityTitan)event.getEntity();
                titan.hurt(new DamageSourceTitanAttack((Entity)player), (float)b * 100.0f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockPos blockPos = event.getPos();
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        InteractionHand hand = event.getHand();
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.getItem();
        Tool tool = (Tool)itemStack.get(DataComponents.TOOL);
        if (ItemUtils.isAdminiumTool(item)) {
            if (!level.isClientSide() && !player.isCreative()) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                List blockDrops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)level), (BlockPos)blockPos, null);
                if (!blockDrops.isEmpty()) {
                    drops.addAll(blockDrops);
                } else {
                    drops.add(new ItemStack((ItemLike)block));
                }
                level.destroyBlock(blockPos, false);
                if (!drops.isEmpty()) {
                    for (ItemStack stack : drops) {
                        ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), stack);
                        itemEntity.setDefaultPickUpDelay();
                        level.addFreshEntity((Entity)itemEntity);
                    }
                }
                itemStack.hurtAndBreak(tool.damagePerBlock(), (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
        } else if (ItemUtils.isUltimateTool(item)) {
            itemStack.mineBlock(level, blockState, blockPos, player);
        }
    }

    @SubscribeEvent
    public void onPlayerHeartType(PlayerHeartTypeEvent event) {
        Player player = event.getEntity();
        if (player.hasEffect(TheTitansNeoMobEffects.RADIATION)) {
            event.setType(Gui.HeartType.POISIONED);
        } else if (player.hasEffect(TheTitansNeoMobEffects.ADVANCED_WITHER)) {
            event.setType(Gui.HeartType.WITHERED);
        }
    }

    @SubscribeEvent
    public void onExplosionKnockback(ExplosionKnockbackEvent event) {
        IEntityProjectileTitan projectileTitan;
        Entity entity = event.getAffectedEntity();
        if (entity instanceof IEntityProjectileTitan && !(projectileTitan = (IEntityProjectileTitan)entity).canExplosionKnockback()) {
            event.setKnockbackVelocity(new Vec3(0.0, 0.0, 0.0));
        }
    }
}

