/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import net.byAqua3.thetitansneo.TheTitansNeo;
import net.byAqua3.thetitansneo.loader.TheTitansNeoBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class FeatureNowhere
extends Feature<NoneFeatureConfiguration> {
    public FeatureNowhere(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public void generateMelons(WorldGenLevel level, RandomSource random, int x, int y, int z) {
        for (int l = 0; l < 64; ++l) {
            int k1;
            int j1;
            int i1 = x + random.nextInt(8) - random.nextInt(8);
            BlockPos blockPos = new BlockPos(i1, j1 = y + random.nextInt(4) - random.nextInt(4), k1 = z + random.nextInt(8) - random.nextInt(8));
            BlockState blockState = level.getBlockState(blockPos);
            if (!blockState.isAir() || !level.getBlockState(blockPos.below()).isSolid()) continue;
            level.setBlock(blockPos, Blocks.MELON.defaultBlockState(), 0, 2);
        }
    }

    public void generatePumpkins(WorldGenLevel level, RandomSource random, int x, int y, int z) {
        for (int l = 0; l < 64; ++l) {
            int k1;
            int j1;
            int i1 = x + random.nextInt(8) - random.nextInt(8);
            BlockPos blockPos = new BlockPos(i1, j1 = y + random.nextInt(4) - random.nextInt(4), k1 = z + random.nextInt(8) - random.nextInt(8));
            BlockState blockState = level.getBlockState(blockPos);
            if (!blockState.isAir() || !level.getBlockState(blockPos.below()).isSolid()) continue;
            level.setBlock(blockPos, Blocks.PUMPKIN.defaultBlockState(), random.nextInt(4), 2);
        }
    }

    public void generateObsidianSpike(WorldGenLevel level, RandomSource random, int x, int y, int z) {
        while (level.getBlockState(new BlockPos(x, y, z)).isAir() && y > 0) {
            --y;
        }
        if (level.getBlockState(new BlockPos(x, y, z)).getBlock() == Blocks.OBSIDIAN) {
            int k1;
            int j1;
            int l = random.nextInt(15) + 5;
            int i1 = l / 4 + random.nextInt(2);
            if (i1 > 1 && random.nextInt(50) == 0) {
                if (random.nextFloat() > 0.5f) {
                    y += 30 + random.nextInt(30);
                } else {
                    l += 140;
                }
            }
            for (j1 = 0; j1 < l; ++j1) {
                float f = (1.0f - (float)j1 / (float)l) * (float)i1;
                k1 = Mth.ceil((float)f);
                for (int l1 = -k1; l1 <= k1; ++l1) {
                    float f1 = (float)Mth.abs((int)l1) - 0.25f;
                    for (int i2 = -k1; i2 <= k1; ++i2) {
                        float f2 = (float)Mth.abs((int)i2) - 0.25f;
                        if ((l1 != 0 || i2 != 0) && !(f1 * f1 + f2 * f2 <= f * f) || (l1 == -k1 || l1 == k1 || i2 == -k1 || i2 == k1) && !(random.nextFloat() <= 0.25f)) continue;
                        BlockPos blockPos1 = new BlockPos(x + l1, y + j1, z + i2);
                        BlockState blockState1 = level.getBlockState(blockPos1);
                        Block block1 = blockState1.getBlock();
                        if (blockState1.isAir() || block1 == Blocks.OBSIDIAN) {
                            this.setBlock((LevelWriter)level, blockPos1, Blocks.OBSIDIAN.defaultBlockState());
                        }
                        if (j1 == 0 || k1 <= 1) continue;
                        BlockPos blockPos2 = new BlockPos(x + l1, y - j1, z + i2);
                        BlockState blockState2 = level.getBlockState(blockPos2);
                        Block block2 = blockState2.getBlock();
                        if (!blockState2.isAir() && block2 != Blocks.OBSIDIAN) continue;
                        this.setBlock((LevelWriter)level, blockPos2, Blocks.OBSIDIAN.defaultBlockState());
                    }
                }
            }
            j1 = i1 - 1;
            if (j1 < 0) {
                j1 = 0;
            } else if (j1 > 1) {
                j1 = 1;
            }
            for (int j2 = -j1; j2 <= j1; ++j2) {
                for (k1 = -j1; k1 <= j1; ++k1) {
                    int k2 = 50;
                    if (Math.abs(j2) == 1 && Math.abs(k1) == 1) {
                        k2 = random.nextInt(5);
                    }
                    for (int l1 = y - 1; l1 > 50; --l1) {
                        BlockPos blockPos = new BlockPos(x + j2, l1, z + k1);
                        BlockState blockState = level.getBlockState(blockPos);
                        Block block = blockState.getBlock();
                        if (!blockState.isAir() && block != Blocks.OBSIDIAN) continue;
                        this.setBlock((LevelWriter)level, blockPos, Blocks.OBSIDIAN.defaultBlockState());
                        if (--k2 > 0) continue;
                        l1 -= random.nextInt(5) + 1;
                        k2 = random.nextInt(5);
                    }
                }
            }
        }
    }

    public void generateNowhereDungeon(WorldGenLevel level, RandomSource random, int x, int y, int z) {
        BlockPos blockPos;
        int i2;
        int l1;
        int k1;
        int b0 = 6;
        int l = 6;
        int i1 = 6;
        int j1 = 0;
        for (k1 = x - l - 1; k1 <= x + l + 1; ++k1) {
            for (l1 = y - 1; l1 <= y + b0 + 1; ++l1) {
                for (i2 = z - i1 - 1; i2 <= z + i1 + 1; ++i2) {
                    blockPos = new BlockPos(k1, l1, i2);
                    BlockState blockState = level.getBlockState(blockPos);
                    if (l1 == y - 1 && !blockState.isSolid()) {
                        return;
                    }
                    if (l1 == y + b0 + 1 && !blockState.isSolid()) {
                        return;
                    }
                    if (k1 != x - l - 1 && k1 != x + l + 1 && i2 != z - i1 - 1 && i2 != z + i1 + 1 || l1 != y || !level.getBlockState(new BlockPos(k1, l1, i2)).isAir() || !level.getBlockState(new BlockPos(k1, l1 + 1, i2)).isAir()) continue;
                    ++j1;
                }
            }
        }
        if (j1 >= 1 && j1 <= 5) {
            for (k1 = x - l - 1; k1 <= x + l + 1; ++k1) {
                for (l1 = y + b0; l1 >= y - 1; --l1) {
                    for (i2 = z - i1 - 1; i2 <= z + i1 + 1; ++i2) {
                        blockPos = new BlockPos(k1, l1, i2);
                        if (k1 != x - l - 1 && l1 != y - 1 && i2 != z - i1 - 1 && k1 != x + l + 1 && l1 != y + b0 + 1 && i2 != z + i1 + 1) {
                            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
                            continue;
                        }
                        if (l1 >= 0 && !level.getBlockState(new BlockPos(k1, l1 - 1, i2)).isSolid()) {
                            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
                            continue;
                        }
                        if (!level.getBlockState(new BlockPos(k1, l1, i2)).isSolid()) continue;
                        level.setBlock(blockPos, Blocks.OBSIDIAN.defaultBlockState(), 0, 2);
                    }
                }
            }
            block6: for (k1 = 0; k1 < 2; ++k1) {
                for (l1 = 0; l1 < 3; ++l1) {
                    int j2;
                    i2 = x + random.nextInt(l * 2 + 1) - l;
                    BlockPos blockPos2 = new BlockPos(i2, y, j2 = z + random.nextInt(i1 * 2 + 1) - i1);
                    if (!level.getBlockState(blockPos2).isAir()) continue;
                    int k2 = 0;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        if (!level.getBlockState(blockPos2.relative(direction)).isSolid()) continue;
                        ++k2;
                    }
                    if (k2 != true) continue;
                    level.setBlock(blockPos2, Blocks.CHEST.defaultBlockState(), 0, 2);
                    RandomizableContainer.setBlockEntityLootTable((BlockGetter)level, (RandomSource)random, (BlockPos)blockPos2, (ResourceKey)BuiltInLootTables.SIMPLE_DUNGEON);
                    continue block6;
                }
            }
            for (int i = 0; i < 3; ++i) {
                level.setBlock(new BlockPos(x, y + i, z), Blocks.SPAWNER.defaultBlockState(), 0, 2);
                BlockEntity blockEntity = level.getBlockEntity(new BlockPos(x, y + i, z));
                if (blockEntity instanceof SpawnerBlockEntity) {
                    SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                    spawnerBlockEntity.setEntityId(EntityType.ENDERMAN, random);
                    continue;
                }
                TheTitansNeo.LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{x, y, z});
            }
        }
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int k;
        int j;
        int i;
        int k1;
        int k2;
        int j2;
        int i2;
        WorldGenLevel worldGenLevel = context.level();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        RandomSource randomSource = context.random();
        BlockPos blockPos = context.origin();
        if (randomSource.nextInt(10) == 0) {
            i2 = blockPos.getX() + randomSource.nextInt(16) + 8;
            j2 = blockPos.getZ() + randomSource.nextInt(16) + 8;
            k2 = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i2, j2);
            this.generateMelons(worldGenLevel, randomSource, i2, k2, j2);
        }
        if (randomSource.nextInt(10) == 0) {
            i2 = blockPos.getX() + randomSource.nextInt(16) + 8;
            j2 = blockPos.getZ() + randomSource.nextInt(16) + 8;
            k2 = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i2, j2);
            this.generatePumpkins(worldGenLevel, randomSource, i2, k2, j2);
        }
        if (randomSource.nextInt(1000) == 0) {
            i2 = blockPos.getX() + randomSource.nextInt(16) + 8;
            j2 = blockPos.getZ() + randomSource.nextInt(16) + 8;
            k2 = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i2, j2);
            Feature.DESERT_WELL.place((FeatureConfiguration)FeatureConfiguration.NONE, worldGenLevel, chunkGenerator, randomSource, new BlockPos(i2, k2, j2));
        }
        if (randomSource.nextInt(4) == 0) {
            i2 = blockPos.getX() + randomSource.nextInt(16) + 8;
            j2 = blockPos.getZ() + randomSource.nextInt(16) + 8;
            k2 = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i2, j2);
            this.generateObsidianSpike(worldGenLevel, randomSource, i2, k2, j2);
        }
        if (randomSource.nextInt(4) == 0) {
            i2 = blockPos.getX() + randomSource.nextInt(16) + 8;
            j2 = blockPos.getZ() + randomSource.nextInt(16) + 8;
            k2 = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i2, j2);
            int l = randomSource.nextInt(0, 10);
            int i1 = 2 + l / 4;
            int j1 = 76 + l * 3;
            boolean flag = l == 1 || l == 2;
            Feature.END_SPIKE.place((FeatureConfiguration)new SpikeConfiguration(false, List.of(new SpikeFeature.EndSpike(i2, j2, i1, j1, flag)), null), worldGenLevel, chunkGenerator, randomSource, new BlockPos(i2, k2, j2));
        }
        for (k1 = 0; k1 < 100; ++k1) {
            i = blockPos.getX() + randomSource.nextInt(16) + 8;
            j = blockPos.getZ() + randomSource.nextInt(16) + 8;
            k = randomSource.nextInt(256);
            this.generateNowhereDungeon(worldGenLevel, randomSource, i, k, j);
        }
        for (k1 = 0; k1 < 800; ++k1) {
            i = blockPos.getX() + randomSource.nextInt(16) + 8;
            j = blockPos.getZ() + randomSource.nextInt(16) + 8;
            k = randomSource.nextInt(256);
            Feature.MONSTER_ROOM.place((FeatureConfiguration)FeatureConfiguration.NONE, worldGenLevel, chunkGenerator, randomSource, new BlockPos(i, k, j));
        }
        if (blockPos.getX() == 0 && blockPos.getZ() == 0) {
            int k3 = worldGenLevel.getHeight(Heightmap.Types.WORLD_SURFACE, blockPos.getX(), blockPos.getZ());
            worldGenLevel.setBlock(new BlockPos(0, k3, 0), ((Block)TheTitansNeoBlocks.ADAMANTIUM_ORE_BLOCK.get()).defaultBlockState(), 0, 3);
            worldGenLevel.setBlock(new BlockPos(0, k3 + 1, 0), ((Block)TheTitansNeoBlocks.ADAMANTIUM_ORE_BLOCK.get()).defaultBlockState(), 0, 3);
        }
        return true;
    }
}

