/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.byAqua3.thetitansneo.gen.IChunkGeneratorGenStructures;
import net.byAqua3.thetitansneo.gen.NoiseGeneratorOctaves;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.blending.Blender;

public class ChunkGeneratorVoid
extends NoiseBasedChunkGenerator
implements IChunkGeneratorGenStructures {
    public static final MapCodec<ChunkGeneratorVoid> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(generator -> generator.getBiomeSource()), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(generator -> generator.settings)).apply((Applicative)instance, instance.stable(ChunkGeneratorVoid::new)));
    private final Holder<NoiseGeneratorSettings> settings;
    public Random voidRNG;
    public NoiseGeneratorOctaves surfaceNoiseGenerator;
    public NoiseGeneratorOctaves depthNoiseGenerator;
    public NoiseGeneratorOctaves mainNoiseGenerator;
    public NoiseGeneratorOctaves scaleNoiseGenerator;
    public NoiseGeneratorOctaves biomeDepthNoiseGenerator;
    public double[] surfaceNoiseBuffer;
    public double[] depthNoiseBuffer;
    public double[] mainNoiseBuffer;
    public double[] scaleNoiseBuffer;
    public double[] biomeDepthNoiseBuffer;
    public double[] densities;

    public ChunkGeneratorVoid(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource, settings);
        this.settings = settings;
        this.voidRNG = new Random();
        this.setSeed(RandomSupport.generateUniqueSeed());
    }

    private void initNoiseGenerators() {
        this.surfaceNoiseGenerator = new NoiseGeneratorOctaves(this.voidRNG, 16);
        this.depthNoiseGenerator = new NoiseGeneratorOctaves(this.voidRNG, 16);
        this.mainNoiseGenerator = new NoiseGeneratorOctaves(this.voidRNG, 8);
        this.scaleNoiseGenerator = new NoiseGeneratorOctaves(this.voidRNG, 10);
        this.biomeDepthNoiseGenerator = new NoiseGeneratorOctaves(this.voidRNG, 16);
    }

    public void setSeed(long seed) {
        this.voidRNG.setSeed(seed);
        this.initNoiseGenerators();
    }

    private double[] getHeights(double[] heightBuffer, int chunkX, int minY, int chunkZ, int sizeX, int sizeY, int sizeZ) {
        if (heightBuffer == null) {
            heightBuffer = new double[sizeX * sizeY * sizeZ];
        }
        double noiseScaleX = 684.412;
        double noiseScaleZ = 684.412;
        this.scaleNoiseBuffer = this.scaleNoiseGenerator.generateNoiseOctaves(this.scaleNoiseBuffer, chunkX, chunkZ, sizeX, sizeZ, 1.121, 1.121, 0.5);
        this.biomeDepthNoiseBuffer = this.biomeDepthNoiseGenerator.generateNoiseOctaves(this.biomeDepthNoiseBuffer, chunkX, chunkZ, sizeX, sizeZ, 200.0, 200.0, 0.5);
        this.mainNoiseBuffer = this.mainNoiseGenerator.generateNoiseOctaves(this.mainNoiseBuffer, chunkX, minY, chunkZ, sizeX, sizeY, sizeZ, (noiseScaleX *= 2.0) / 80.0, noiseScaleZ / 160.0, noiseScaleX / 80.0);
        this.surfaceNoiseBuffer = this.surfaceNoiseGenerator.generateNoiseOctaves(this.surfaceNoiseBuffer, chunkX, minY, chunkZ, sizeX, sizeY, sizeZ, noiseScaleX, noiseScaleZ, noiseScaleX);
        this.depthNoiseBuffer = this.depthNoiseGenerator.generateNoiseOctaves(this.depthNoiseBuffer, chunkX, minY, chunkZ, sizeX, sizeY, sizeZ, noiseScaleX, noiseScaleZ, noiseScaleX);
        int bufferIndex = 0;
        int noiseIndex = 0;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                double depthVariation;
                double scaleFactor = (this.scaleNoiseBuffer[noiseIndex] + 256.0) / 512.0;
                if (scaleFactor > 1.0) {
                    scaleFactor = 1.0;
                }
                if ((depthVariation = this.biomeDepthNoiseBuffer[noiseIndex] / 8000.0) < 0.0) {
                    depthVariation = -depthVariation * 0.3;
                }
                depthVariation = depthVariation * 3.0 - 2.0;
                float distanceX = (float)(x + chunkX - 0) / 1.0f;
                float distanceZ = (float)(z + chunkZ - 0) / 1.0f;
                float distanceFactor = 100.0f - Mth.sqrt((float)(distanceX * distanceX + distanceZ * distanceZ)) * 8.0f;
                if (distanceFactor > 80.0f) {
                    distanceFactor = 80.0f;
                }
                if (distanceFactor < -100.0f) {
                    distanceFactor = -100.0f;
                }
                if (depthVariation > 1.0) {
                    depthVariation = 1.0;
                }
                depthVariation /= 8.0;
                depthVariation = 0.0;
                if (scaleFactor < 0.0) {
                    scaleFactor = 0.0;
                }
                scaleFactor += 0.5;
                depthVariation = depthVariation * (double)sizeY / 16.0;
                ++noiseIndex;
                double centerY = (double)sizeY / 2.0;
                for (int y = 0; y < sizeY; ++y) {
                    int bottomTransitionRange;
                    double heightValue = 0.0;
                    double verticalScale = ((double)y - centerY) * 8.0 / scaleFactor;
                    if (verticalScale < 0.0) {
                        verticalScale *= -1.0;
                    }
                    double surfaceNoise = this.surfaceNoiseBuffer[bufferIndex] / 512.0;
                    double depthNoise = this.depthNoiseBuffer[bufferIndex] / 512.0;
                    double noiseBlend = (this.mainNoiseBuffer[bufferIndex] / 10.0 + 1.0) / 2.0;
                    heightValue = noiseBlend < 0.0 ? surfaceNoise : (noiseBlend > 1.0 ? depthNoise : surfaceNoise + (depthNoise - surfaceNoise) * noiseBlend);
                    heightValue -= 8.0;
                    heightValue += (double)distanceFactor;
                    int topTransitionRange = 2;
                    if (y > sizeY / 2 - topTransitionRange) {
                        double topTransition = (float)(y - sizeY / 2 - topTransitionRange) / 64.0f;
                        if (topTransition < 0.0) {
                            topTransition = 0.0;
                        }
                        if (topTransition > 1.0) {
                            topTransition = 1.0;
                        }
                        heightValue = heightValue * (1.0 - topTransition) + -3000.0 * topTransition;
                    }
                    if (y < (bottomTransitionRange = 8)) {
                        double bottomTransition = (float)(bottomTransitionRange - y) / ((float)bottomTransitionRange - 1.0f);
                        heightValue = heightValue * (1.0 - bottomTransition) + -30.0 * bottomTransition;
                    }
                    heightBuffer[bufferIndex] = heightValue;
                    ++bufferIndex;
                }
            }
        }
        return heightBuffer;
    }

    public BlockState[] getBaseColumn(int x, int z, RandomState random) {
        BlockState[] blockState = new BlockState[32768];
        int samplingFactor = 2;
        int sampleSizeX = samplingFactor + 1;
        int sampleSizeY = 33;
        int sampleSizeZ = samplingFactor + 1;
        this.densities = this.getHeights(this.densities, x * samplingFactor, 0, z * samplingFactor, sampleSizeX, sampleSizeY, sampleSizeZ);
        for (int xSample = 0; xSample < samplingFactor; ++xSample) {
            for (int zSample = 0; zSample < samplingFactor; ++zSample) {
                for (int ySample = 0; ySample < 32; ++ySample) {
                    double interpolationStep = 0.25;
                    double density000 = this.densities[((xSample + 0) * sampleSizeZ + zSample + 0) * sampleSizeY + ySample + 0];
                    double density001 = this.densities[((xSample + 0) * sampleSizeZ + zSample + 1) * sampleSizeY + ySample + 0];
                    double density100 = this.densities[((xSample + 1) * sampleSizeZ + zSample + 0) * sampleSizeY + ySample + 0];
                    double density101 = this.densities[((xSample + 1) * sampleSizeZ + zSample + 1) * sampleSizeY + ySample + 0];
                    double densityDelta000 = (this.densities[((xSample + 0) * sampleSizeZ + zSample + 0) * sampleSizeY + ySample + 1] - density000) * interpolationStep;
                    double densityDelta001 = (this.densities[((xSample + 0) * sampleSizeZ + zSample + 1) * sampleSizeY + ySample + 1] - density001) * interpolationStep;
                    double densityDelta100 = (this.densities[((xSample + 1) * sampleSizeZ + zSample + 0) * sampleSizeY + ySample + 1] - density100) * interpolationStep;
                    double densityDelta101 = (this.densities[((xSample + 1) * sampleSizeZ + zSample + 1) * sampleSizeY + ySample + 1] - density101) * interpolationStep;
                    for (int ySubSample = 0; ySubSample < 4; ++ySubSample) {
                        double xInterpolationStep = 0.25;
                        double currentDensity000 = density000;
                        double currentDensity001 = density001;
                        double xDensityDelta000 = (density100 - density000) * xInterpolationStep;
                        double xDensityDelta001 = (density101 - density001) * xInterpolationStep;
                        for (int xSubSample = 0; xSubSample < 8; ++xSubSample) {
                            int blockIndex = xSubSample + xSample * 8 << 11 | 0 + zSample * 8 << 7 | ySubSample + ySample * 4;
                            int blockIncrement = 128;
                            double zInterpolationStep = 0.25;
                            double currentDensity = currentDensity000;
                            double zDensityDelta = (currentDensity001 - currentDensity000) * zInterpolationStep;
                            for (int zSubSample = 0; zSubSample < 8; ++zSubSample) {
                                Block block = Blocks.AIR;
                                if (currentDensity > 0.0) {
                                    block = Blocks.BEDROCK;
                                }
                                blockState[blockIndex] = block.defaultBlockState();
                                blockIndex += blockIncrement;
                                currentDensity += zDensityDelta;
                            }
                            currentDensity000 += xDensityDelta000;
                            currentDensity001 += xDensityDelta001;
                        }
                        density000 += densityDelta000;
                        density001 += densityDelta001;
                        density100 += densityDelta100;
                        density101 += densityDelta101;
                    }
                }
            }
        }
        return blockState;
    }

    @Override
    public IChunkGeneratorGenStructures.GenStructuresBoolean shouldGenerateStructures() {
        return IChunkGeneratorGenStructures.GenStructuresBoolean.TRUE;
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunk) {
        BlockState[] blockStates = this.getBaseColumn(chunk.getPos().x, chunk.getPos().z, randomState);
        BlockPos.MutableBlockPos blockPos$mutableBlockPos = new BlockPos.MutableBlockPos();
        Heightmap heightmap = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        int height = ((NoiseGeneratorSettings)this.settings.value()).noiseSettings().height();
        for (int i = 0; i < height; ++i) {
            int j = chunk.getMinBuildHeight() + i;
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    BlockState blockState = blockStates[k << 11 | l << 7 | i];
                    if (blockState == null) continue;
                    chunk.setBlockState((BlockPos)blockPos$mutableBlockPos.set(k, j, l), blockState, false);
                    heightmap.update(k, j, l, blockState);
                    heightmap1.update(k, j, l, blockState);
                }
            }
        }
        return CompletableFuture.completedFuture(chunk);
    }
}

