/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.gen;

import java.util.Random;
import net.byAqua3.thetitansneo.gen.NoiseGenerator;
import net.byAqua3.thetitansneo.gen.NoiseGeneratorImproved;
import net.minecraft.util.Mth;

public class NoiseGeneratorOctaves
extends NoiseGenerator {
    private final NoiseGeneratorImproved[] noiseGenerators;
    private final int octaveCount;

    public NoiseGeneratorOctaves(Random random, int octaveCount) {
        this.octaveCount = octaveCount;
        this.noiseGenerators = new NoiseGeneratorImproved[octaveCount];
        for (int i = 0; i < octaveCount; ++i) {
            this.noiseGenerators[i] = new NoiseGeneratorImproved(random);
        }
    }

    public double[] generateNoiseOctaves(double[] noiseArray, int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale) {
        if (noiseArray == null) {
            noiseArray = new double[xSize * ySize * zSize];
        } else {
            for (int i = 0; i < noiseArray.length; ++i) {
                noiseArray[i] = 0.0;
            }
        }
        double amplitude = 1.0;
        for (int octave = 0; octave < this.octaveCount; ++octave) {
            double sampleX = (double)xOffset * amplitude * xScale;
            double sampleY = (double)yOffset * amplitude * yScale;
            double sampleZ = (double)zOffset * amplitude * zScale;
            long floorX = Mth.lfloor((double)sampleX);
            long floorZ = Mth.lfloor((double)sampleZ);
            sampleX -= (double)floorX;
            sampleZ -= (double)floorZ;
            this.noiseGenerators[octave].populateNoiseArray(noiseArray, sampleX += (double)(floorX %= 0x1000000L), sampleY, sampleZ += (double)(floorZ %= 0x1000000L), xSize, ySize, zSize, xScale * amplitude, yScale * amplitude, zScale * amplitude, amplitude);
            amplitude /= 2.0;
        }
        return noiseArray;
    }

    public double[] generateNoiseOctaves(double[] noiseArray, int xOffset, int zOffset, int xSize, int zSize, double xScale, double zScale, double amplitude) {
        return this.generateNoiseOctaves(noiseArray, xOffset, 10, zOffset, xSize, 1, zSize, xScale, 1.0, zScale);
    }
}

