/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.item;

import java.util.ArrayList;
import java.util.List;
import net.byAqua3.thetitansneo.entity.projectile.EntityHarcadiumArrow;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoAttributes;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoDamageTypes;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoMobEffects;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class ItemAdminiumArmor
extends ArmorItem {
    public ItemAdminiumArmor(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties.attributes(ItemAdminiumArmor.createAttributes(type)));
    }

    public static ItemAttributeModifiers createAttributes(ArmorItem.Type type) {
        ItemAttributeModifiers.Builder itemAttributeModifiers$builder = ItemAttributeModifiers.builder();
        if (type == ArmorItem.Type.HELMET) {
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 14.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_KNOCKBACK_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 15.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 1250.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.ARMOR, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 100000.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
        } else if (type == ArmorItem.Type.CHESTPLATE) {
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 26.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_KNOCKBACK_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 40.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 2000.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.ARMOR, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 100000.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
        } else if (type == ArmorItem.Type.LEGGINGS) {
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_KNOCKBACK_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 30.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 1750.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.ARMOR, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 100000.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
        } else if (type == ArmorItem.Type.BOOTS) {
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 10.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_KNOCKBACK_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 15.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 1000.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.ARMOR, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 100000.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
        }
        return itemAttributeModifiers$builder.build();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            stack.setDamageValue(stack.getDamageValue() - 10);
            if (this.getEquipmentSlot() == EquipmentSlot.HEAD && slotId == 39) {
                player.playSound((SoundEvent)TheTitansNeoSounds.HARCACADIUM_HUM.get(), 5.0f, 0.5f);
                player.removeEffect(MobEffects.BLINDNESS);
                player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 300, 0));
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0));
            } else if (this.getEquipmentSlot() == EquipmentSlot.CHEST && slotId == 38) {
                player.playSound((SoundEvent)TheTitansNeoSounds.HARCACADIUM_HUM.get(), 5.0f, 0.5f);
                player.removeEffect(MobEffects.WEAKNESS);
                player.removeEffect(MobEffects.DIG_SLOWDOWN);
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 300, 99));
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300, 3));
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 300, 999));
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 300, 0));
            } else if (this.getEquipmentSlot() == EquipmentSlot.LEGS && slotId == 37) {
                player.playSound((SoundEvent)TheTitansNeoSounds.HARCACADIUM_HUM.get(), 5.0f, 0.0f);
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 300, 199));
                player.removeEffect(MobEffects.CONFUSION);
                player.removeEffect(MobEffects.HUNGER);
                player.removeEffect(MobEffects.POISON);
            } else if (this.getEquipmentSlot() == EquipmentSlot.FEET && slotId == 36) {
                player.playSound((SoundEvent)TheTitansNeoSounds.HARCACADIUM_HUM.get(), 5.0f, 0.5f);
                player.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
                player.addEffect(new MobEffectInstance(MobEffects.JUMP, 300, 19));
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 300, 39));
            }
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == TheTitansNeoItems.ADMINIUM_HELMET.get() && player.getItemBySlot(EquipmentSlot.CHEST).getItem() == TheTitansNeoItems.ADMINIUM_CHESTPLATE.get() && player.getItemBySlot(EquipmentSlot.LEGS).getItem() == TheTitansNeoItems.ADMINIUM_LEGGINGS.get() && player.getItemBySlot(EquipmentSlot.FEET).getItem() == TheTitansNeoItems.ADMINIUM_BOOTS.get()) {
                for (int i = 0; i < 2; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, player.getX() + (player.getRandom().nextDouble() - 0.5) * (double)player.getBbWidth(), player.getY() - 1.8 + player.getRandom().nextDouble() * (double)player.getBbHeight(), player.getZ() + (player.getRandom().nextDouble() - 0.5) * (double)player.getBbWidth(), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ParticleTypes.PORTAL, player.getX() + (player.getRandom().nextDouble() - 0.5) * (double)player.getBbWidth(), player.getY() - 1.8 + player.getRandom().nextDouble() * (double)player.getBbHeight(), player.getZ() + (player.getRandom().nextDouble() - 0.5) * (double)player.getBbWidth(), (player.getRandom().nextDouble() - 0.5) * 2.0, -player.getRandom().nextDouble(), (player.getRandom().nextDouble() - 0.5) * 2.0);
                }
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 300, 399));
                player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 300, 199));
                player.invulnerableDuration = 40;
                player.extinguishFire();
                player.fallDistance = 0.0f;
                player.heal(player.getHealth() < player.getMaxHealth() / 4.0f ? 50.0f : 10.0f);
                if (player.getY() <= -100.0) {
                    int y = level.getHeight(Heightmap.Types.WORLD_SURFACE, Mth.floor((double)player.getX()), Mth.floor((double)player.getZ()));
                    player.setPos(player.getX(), (double)y, player.getZ());
                }
                if (player.getDeltaMovement().y > 3.0) {
                    player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
                }
                if (player.getHealth() < player.getMaxHealth()) {
                    player.addEffect(new MobEffectInstance(MobEffects.HEAL, 300, 2));
                }
                List entities = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(10.0, 10.0, 10.0));
                for (Entity radiatedEntity : entities) {
                    if (radiatedEntity == null || !radiatedEntity.isAlive() || entity.tickCount % 10 != 0 || !(radiatedEntity instanceof LivingEntity) || radiatedEntity instanceof EntityTitan || radiatedEntity instanceof AbstractGolem || radiatedEntity instanceof OwnableEntity || radiatedEntity instanceof Villager) continue;
                    LivingEntity livingEntity = (LivingEntity)radiatedEntity;
                    if (level.isClientSide() || ((Boolean)TheTitansNeoConfigs.adminiumArmorRadiationPlayer.get()).booleanValue() && livingEntity instanceof Player) continue;
                    Holder.Reference damageType = entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(TheTitansNeoDamageTypes.RADIATION);
                    livingEntity.hurt(new DamageSource((Holder)damageType), 10.0f);
                    livingEntity.invulnerableTime = 0;
                    livingEntity.addEffect(new MobEffectInstance(TheTitansNeoMobEffects.RADIATION, 5000, 1));
                }
                if (!level.isClientSide()) {
                    if (((Boolean)TheTitansNeoConfigs.adminiumArmorExplode.get()).booleanValue()) {
                        entities = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(32.0, 8.0, 32.0));
                        BlockPos blockPos = player.blockPosition().below();
                        BlockState blockState = level.getBlockState(blockPos);
                        if (!player.onGround() && blockState.isSolid()) {
                            if (player.getBoundingBox() != null && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                                int minX = Mth.floor((double)(player.getBoundingBox().minX - 3.0));
                                int minY = Mth.floor((double)(player.getBoundingBox().minY - 1.0));
                                int minZ = Mth.floor((double)(player.getBoundingBox().minZ - 3.0));
                                int maxX = Mth.floor((double)(player.getBoundingBox().maxX + 3.0));
                                int maxY = Mth.floor((double)(player.getBoundingBox().maxY + 1.0));
                                int maxZ = Mth.floor((double)(player.getBoundingBox().maxZ + 3.0));
                                ArrayList<BlockPos> fallBlocks = new ArrayList<BlockPos>();
                                for (int y = minY; y <= maxY; ++y) {
                                    for (int x = minX; x <= maxX; ++x) {
                                        for (int z = minZ; z <= maxZ; ++z) {
                                            BlockPos rangePos = new BlockPos(x, y, z);
                                            BlockState rangeState = level.getBlockState(rangePos);
                                            Block rangeBlock = rangeState.getBlock();
                                            if (player.tickCount <= 5 || !level.hasChunkAt(rangePos) || rangeState.isAir() || !(rangeState.getDestroySpeed((BlockGetter)level, rangePos) >= 0.0f)) continue;
                                            if (rangeBlock instanceof LiquidBlock || rangeBlock == Blocks.FIRE || rangeBlock == Blocks.COBWEB) {
                                                level.setBlockAndUpdate(rangePos, Blocks.AIR.defaultBlockState());
                                                continue;
                                            }
                                            if (player.getRandom().nextInt(3) == 0) {
                                                fallBlocks.add(rangePos.immutable());
                                                continue;
                                            }
                                            if (level.getNearestPlayer((Entity)player, 16.0) != null) {
                                                level.destroyBlock(rangePos, true);
                                                continue;
                                            }
                                            level.setBlockAndUpdate(rangePos, Blocks.AIR.defaultBlockState());
                                        }
                                    }
                                }
                                for (BlockPos rangePos : fallBlocks) {
                                    BlockState rangeState = level.getBlockState(rangePos);
                                    if (rangeState.isAir() || !(rangeState.getDestroySpeed((BlockGetter)level, rangePos) >= 0.0f) || !(player.getRandom().nextDouble() < 1.0 * Math.pow(fallBlocks.size(), (Double)TheTitansNeoConfigs.titanFallBlockDecayFactor.get()))) continue;
                                    FallingBlockEntity fallingBlock = FallingBlockEntity.fall((Level)level, (BlockPos)rangePos, (BlockState)rangeState);
                                    double d0 = (player.getBoundingBox().minX + player.getBoundingBox().maxX) / 2.0;
                                    double d1 = (player.getBoundingBox().minZ + player.getBoundingBox().maxZ) / 2.0;
                                    double d2 = fallingBlock.getX() - d0;
                                    double d3 = fallingBlock.getZ() - d1;
                                    double d4 = d2 * d2 + d3 * d3;
                                    fallingBlock.setRemainingFireTicks(10);
                                    if (!(d4 >= 0.01)) continue;
                                    double d5 = d2 / d4 * 10.0;
                                    double d6 = 2.0 + player.getRandom().nextGaussian();
                                    double d7 = d3 / d4 * 10.0;
                                    fallingBlock.push(d5, d6, d7);
                                }
                                fallBlocks.clear();
                                level.explode((Entity)player, player.getX(), player.getY() - 2.0, player.getZ(), 3.0f, Level.ExplosionInteraction.MOB);
                            }
                            for (Entity hurtEntity : entities) {
                                if (hurtEntity == null || !(hurtEntity instanceof LivingEntity) || hurtEntity instanceof EntityTitan || hurtEntity instanceof AbstractGolem || hurtEntity instanceof OwnableEntity || hurtEntity instanceof Villager) continue;
                                LivingEntity livingEntity = (LivingEntity)hurtEntity;
                                livingEntity.hurt(livingEntity.damageSources().explosion((Entity)livingEntity, (Entity)player), 300.0f);
                                livingEntity.push(0.0, 1.0, 0.0);
                            }
                        }
                    }
                    if (((Boolean)TheTitansNeoConfigs.adminiumArmorGravity.get()).booleanValue()) {
                        entities = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(48.0, 48.0, 48.0));
                        for (Entity attractedEntity : entities) {
                            double d2;
                            double d1;
                            double d0;
                            double d3;
                            double d4;
                            if (attractedEntity == null || attractedEntity instanceof EntityTitan || attractedEntity instanceof EntityItemTitan || attractedEntity instanceof EntityHarcadiumArrow || !((d4 = 1.0 - (d3 = Math.sqrt((d0 = (player.getX() - attractedEntity.getX()) / 48.0) * d0 + (d1 = (player.getY() + 1.0 - attractedEntity.getY()) / 48.0) * d1 + (d2 = (player.getZ() - attractedEntity.getZ()) / 48.0) * d2))) > 0.0)) continue;
                            d4 *= d4;
                            double d5 = d0 / d3 * d4 * 0.1;
                            double d6 = d1 / d3 * d4 * 0.1;
                            double d7 = d2 / d3 * d4 * 0.1;
                            attractedEntity.push(d5, d6, d7);
                        }
                    }
                }
                player.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
            } else {
                player.invulnerableDuration = 20;
                player.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(0.0);
            }
        }
    }
}

