/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.item;

import java.util.List;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.loader.TheTitansNeoTiers;
import net.byAqua3.thetitansneo.util.EntityUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ItemAdminiumSword
extends SwordItem {
    public ItemAdminiumSword(Item.Properties properties) {
        super((Tier)TheTitansNeoTiers.ADMINIUM, properties.attributes(ItemAdminiumSword.createAttributes(1.0E9f, Float.MAX_VALUE)));
    }

    public static ItemAttributeModifiers createAttributes(float attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_SPEED, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"attack_speed"), (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"attack_damage"), (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        itemEntity.setInvulnerable(true);
        return super.onEntityItemUpdate(stack, itemEntity);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity entity, LivingEntity attacker) {
        if (entity != null) {
            entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
            if (entity instanceof EntityTitan) {
                EntityTitan titan = (EntityTitan)entity;
                if (titan.canBeHurtByPlayer() && titan.getInvulTime() <= 0) {
                    titan.setTarget(attacker);
                }
            } else {
                entity.invulnerableTime = 0;
                entity.hurt(entity.damageSources().mobAttack(attacker), Float.MAX_VALUE);
                entity.setHealth(0.0f);
                entity.push(0.0, 1.0, 0.0);
            }
        }
        return super.hurtEnemy(stack, entity, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)stack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int time) {
        Player player = (Player)livingEntity;
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        int max = this.getUseDuration(stack, livingEntity);
        int j = max - time;
        float f = (float)j / 60.0f;
        if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
            return;
        }
        if ((double)f > 1.0) {
            f = 1.0f;
        }
        player.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 1.0f, 2.0f);
        stack.hurtAndBreak(tool.damagePerBlock(), (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
        player.swing(player.getUsedItemHand());
        double d8 = 4.0;
        Vec3 vec3 = player.getViewVector(1.0f);
        double dx = vec3.x * d8;
        double dy = vec3.y * d8 + (double)player.getEyeHeight();
        double dz = vec3.z * d8;
        List entities = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(d8, d8, d8).move(dx, dy, dz));
        List<Entity> bigEntities = EntityUtils.getEntities(entities, player, d8, d8, d8, dx, dy, dz);
        if (!bigEntities.isEmpty()) {
            entities.addAll(bigEntities);
        }
        for (Entity entity : entities) {
            if (entity == null) continue;
            entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
            if (entity instanceof EntityTitan) {
                EntityTitan titan = (EntityTitan)entity;
                if (!titan.canBeHurtByPlayer() || titan.getInvulTime() > 0) continue;
                entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
                titan.animateHurt(180.0f);
                titan.setTitanHealth(Math.max(titan.getTitanHealth() - 2000.0f * (f + 1.0f), 0.0f));
                titan.setTarget((LivingEntity)player);
                continue;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity hurtEntity = (LivingEntity)entity;
            hurtEntity.animateHurt(180.0f);
            hurtEntity.setHealth(Math.max(hurtEntity.getHealth() - 2000.0f * Math.max(f, 0.5f), 0.0f));
            if (hurtEntity.getHealth() <= 0.0f) {
                hurtEntity.die(entity.damageSources().playerAttack(player));
            }
            hurtEntity.push(0.0, 1.0, 0.0);
        }
    }
}

