/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.item;

import java.util.ArrayList;
import java.util.List;
import net.byAqua3.thetitansneo.damage.DamageSourceTitanAttack;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.loader.TheTitansNeoTiers;
import net.byAqua3.thetitansneo.util.EntityUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class ItemOptimaAxe
extends SwordItem {
    public ItemOptimaAxe(Item.Properties properties) {
        super((Tier)TheTitansNeoTiers.ULTIMA, properties.attributes(ItemOptimaAxe.createAttributes(TheTitansNeoTiers.ULTIMA, 0.0f, Float.MAX_VALUE, 12.0f)));
    }

    public static ItemAttributeModifiers createAttributes(Tier tier, float attackDamage, float attackSpeed, float range) {
        return ItemAttributeModifiers.builder().add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_block_interaction_range"), (double)range, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(attackDamage + tier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        itemEntity.setInvulnerable(true);
        return super.onEntityItemUpdate(stack, itemEntity);
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"item.thetitansneo.optima_axe.info1").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.translatable((String)"item.thetitansneo.optima_axe.info2").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.translatable((String)"item.thetitansneo.optima_axe.info3").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_AQUA));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)TheTitansNeoConfigs.optimaAxeShowParticles.get()).booleanValue()) {
                for (int i = 0; i < 3; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.PORTAL, player.getX() + (level.random.nextDouble() - 0.5) * (double)player.getBbWidth(), player.getY() + level.random.nextDouble() * (double)player.getBbHeight(), player.getZ() + (level.random.nextDouble() - 0.5) * (double)player.getBbWidth(), (level.random.nextDouble() - 0.5) * 2.0, 1.0, (level.random.nextDouble() - 0.5) * 2.0);
                    level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, player.getX() + (level.random.nextDouble() - 0.5) * (double)player.getBbWidth(), player.getY() + level.random.nextDouble() * (double)player.getBbHeight(), player.getZ() + (level.random.nextDouble() - 0.5) * (double)player.getBbWidth(), (level.random.nextDouble() - 0.5) * 2.0, 1.0, (level.random.nextDouble() - 0.5) * 2.0);
                }
            }
            if (player.getY() < -100.0) {
                player.push(0.0, 10.0, 0.0);
            }
            player.heal(player.getMaxHealth());
            if (!level.isClientSide()) {
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 5, 249, false, false));
            }
        }
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 10.0f, 1.0f);
            for (int y = -2; y <= 2; ++y) {
                for (int x = -4; x <= 4; ++x) {
                    for (int z = -4; z <= 4; ++z) {
                        BlockPos rangePos = new BlockPos(Mth.floor((float)(pos.getX() + x)), Mth.floor((float)(pos.getY() + y)), Mth.floor((float)(pos.getZ() + z)));
                        BlockState rangeState = level.getBlockState(rangePos);
                        Block rangeBlock = rangeState.getBlock();
                        if (rangeState.isAir()) continue;
                        if (!level.isClientSide() && !player.isCreative()) {
                            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                            List blockDrops = Block.getDrops((BlockState)rangeState, (ServerLevel)((ServerLevel)level), (BlockPos)rangePos, null);
                            if (!blockDrops.isEmpty()) {
                                drops.addAll(blockDrops);
                            } else {
                                drops.add(new ItemStack((ItemLike)rangeBlock));
                            }
                            if (!drops.isEmpty()) {
                                for (ItemStack drop : drops) {
                                    ItemEntity itemEntity = new ItemEntity(level, (double)rangePos.getX(), (double)rangePos.getY(), (double)rangePos.getZ(), drop);
                                    itemEntity.setDefaultPickUpDelay();
                                    itemEntity.push(-Math.sin((double)player.getYRot() * Math.PI / 180.0) * 1.0, 0.75, Math.cos((double)player.getYRot() * Math.PI / 180.0) * 1.0);
                                    level.addFreshEntity((Entity)itemEntity);
                                }
                            }
                        }
                        if (!(rangeBlock instanceof BaseFireBlock)) {
                            level.levelEvent(2001, rangePos, Block.getId((BlockState)rangeState));
                        }
                        level.setBlockAndUpdate(rangePos, Blocks.AIR.defaultBlockState());
                        level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, rangePos, GameEvent.Context.of((Entity)player, (BlockState)rangeState));
                    }
                }
            }
        }
        return super.mineBlock(stack, level, state, pos, livingEntity);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity livingEntity) {
        block14: {
            Level level = livingEntity.level();
            if (!(livingEntity instanceof Player)) break block14;
            Player player = (Player)livingEntity;
            player.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 10.0f, 1.0f);
            if (!player.isCrouching()) {
                for (int i = 0; i < 12; ++i) {
                    double d8 = 12.0;
                    Vec3 vec3 = player.getViewVector(1.0f);
                    double dx = vec3.x * (double)i;
                    double dy = vec3.y * (double)i + (double)player.getEyeHeight();
                    double dz = vec3.z * (double)i;
                    List entities = level.getEntities((Entity)player, player.getBoundingBox().inflate(d8, 8.0, d8).move(dx, dy, dz));
                    List<Entity> bigEntities = EntityUtils.getEntities(entities, player, d8, 8.0, d8, dx, dy, dz);
                    if (!bigEntities.isEmpty()) {
                        entities.addAll(bigEntities);
                    }
                    for (Entity entity : entities) {
                        if (entity == null) continue;
                        DamageSourceTitanAttack damageSource = new DamageSourceTitanAttack((Entity)player);
                        player.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 2.0f, 0.5f + level.random.nextFloat() * 0.25f);
                        player.playSound((SoundEvent)TheTitansNeoSounds.SLASH_FLESH.get(), 10.0f, 1.0f);
                        if (entity instanceof EntityTitan) {
                            player.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
                            EntityTitan titan = (EntityTitan)entity;
                            titan.hurt(damageSource, 2000.0f);
                            continue;
                        }
                        if (entity instanceof PrimedTnt) {
                            if (level.isClientSide()) continue;
                            level.explode((Entity)player, entity.getX(), entity.getY(), entity.getZ(), 4.0f, false, Level.ExplosionInteraction.MOB);
                            entity.remove(Entity.RemovalReason.KILLED);
                            continue;
                        }
                        if (entity instanceof Fireball) {
                            if (level.isClientSide()) continue;
                            level.explode((Entity)player, entity.getX(), entity.getY(), entity.getZ(), 0.0f, false, Level.ExplosionInteraction.MOB);
                            entity.remove(Entity.RemovalReason.KILLED);
                            continue;
                        }
                        if (!(entity instanceof LivingEntity)) continue;
                        entity.setRemainingFireTicks(Integer.MAX_VALUE);
                        if (!entity.hurt((DamageSource)damageSource, 20000.0f)) {
                            ((LivingEntity)entity).setHealth(0.0f);
                        }
                        entity.push(-Math.sin((double)player.getYRot() * Math.PI / 180.0) * 6.0, 6.0, Math.cos((double)player.getYRot() * Math.PI / 180.0) * 6.0);
                    }
                }
            } else {
                double d8 = 64.0;
                List entities = level.getEntities((Entity)player, player.getBoundingBox().inflate(d8, d8, d8));
                List<Entity> bigEntities = EntityUtils.getEntities(entities, player, d8, d8, d8);
                if (!bigEntities.isEmpty()) {
                    entities.addAll(bigEntities);
                }
                for (Entity entity : entities) {
                    if (entity == null) continue;
                    DamageSourceTitanAttack damageSource = new DamageSourceTitanAttack((Entity)player);
                    player.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 2.0f, 0.5f + level.random.nextFloat() * 0.25f);
                    player.playSound((SoundEvent)TheTitansNeoSounds.SLASH_FLESH.get(), 10.0f, 1.0f);
                    if (entity instanceof EntityTitan) {
                        player.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
                        EntityTitan titan = (EntityTitan)entity;
                        titan.hurt(damageSource, 2000.0f);
                        continue;
                    }
                    if (entity instanceof LivingEntity) {
                        entity.setRemainingFireTicks(Integer.MAX_VALUE);
                        if (!entity.hurt((DamageSource)damageSource, Float.MAX_VALUE)) {
                            ((LivingEntity)entity).setHealth(0.0f);
                        }
                        entity.push(-Math.sin((double)player.getYRot() * Math.PI / 180.0) * 6.0, 6.0, Math.cos((double)player.getYRot() * Math.PI / 180.0) * 6.0);
                        continue;
                    }
                    entity.hurt(entity.damageSources().playerAttack(player), 20000.0f);
                }
            }
        }
        return false;
    }
}

