/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.item;

import java.util.List;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoAttributes;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoItems;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;

public class ItemVoidArmor
extends ArmorItem {
    public ItemVoidArmor(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties.attributes(ItemVoidArmor.createAttributes(type)));
    }

    public static ItemAttributeModifiers createAttributes(ArmorItem.Type type) {
        ItemAttributeModifiers.Builder itemAttributeModifiers$builder = ItemAttributeModifiers.builder();
        if (type == ArmorItem.Type.HELMET) {
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 10.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_KNOCKBACK_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 250.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.ARMOR, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 11.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
        } else if (type == ArmorItem.Type.CHESTPLATE) {
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 18.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_KNOCKBACK_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 400.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.ARMOR, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 17.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
        } else if (type == ArmorItem.Type.LEGGINGS) {
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 14.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_KNOCKBACK_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 15.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 350.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.ARMOR, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 13.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
        } else if (type == ArmorItem.Type.BOOTS) {
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(TheTitansNeoAttributes.TITAN_KNOCKBACK_RESISTANCE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 7.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 200.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
            itemAttributeModifiers$builder.add(Attributes.ARMOR, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type.getName())), 9.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot()));
        }
        return itemAttributeModifiers$builder.build();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.getEquipmentSlot() == EquipmentSlot.HEAD && slotId == 39) {
                player.playSound((SoundEvent)TheTitansNeoSounds.HARCACADIUM_HUM.get(), 5.0f, 0.5f);
                player.removeEffect(MobEffects.BLINDNESS);
                player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 300, 0));
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0));
            } else if (this.getEquipmentSlot() == EquipmentSlot.CHEST && slotId == 38) {
                player.playSound((SoundEvent)TheTitansNeoSounds.HARCACADIUM_HUM.get(), 5.0f, 0.5f);
                player.removeEffect(MobEffects.WEAKNESS);
                player.removeEffect(MobEffects.DIG_SLOWDOWN);
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 300, 99));
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300, 3));
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 300, 49));
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 300, 0));
            } else if (this.getEquipmentSlot() == EquipmentSlot.LEGS && slotId == 37) {
                player.playSound((SoundEvent)TheTitansNeoSounds.HARCACADIUM_HUM.get(), 5.0f, 0.0f);
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 300, 199));
                player.removeEffect(MobEffects.CONFUSION);
                player.removeEffect(MobEffects.HUNGER);
                player.removeEffect(MobEffects.POISON);
            } else if (this.getEquipmentSlot() == EquipmentSlot.FEET && slotId == 36) {
                player.playSound((SoundEvent)TheTitansNeoSounds.HARCACADIUM_HUM.get(), 5.0f, 0.5f);
                player.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
                player.addEffect(new MobEffectInstance(MobEffects.JUMP, 300, 5));
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 300, 19));
            }
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == TheTitansNeoItems.VOID_HELMET.get() && player.getItemBySlot(EquipmentSlot.CHEST).getItem() == TheTitansNeoItems.VOID_CHESTPLATE.get() && player.getItemBySlot(EquipmentSlot.LEGS).getItem() == TheTitansNeoItems.VOID_LEGGINGS.get() && player.getItemBySlot(EquipmentSlot.FEET).getItem() == TheTitansNeoItems.VOID_BOOTS.get()) {
                for (int i = 0; i < 4; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, player.getX() + (player.getRandom().nextDouble() - 0.5) * (double)player.getBbWidth() * 2.0, player.getY() - 1.75 + player.getRandom().nextDouble() * (double)player.getBbHeight(), player.getZ() + (player.getRandom().nextDouble() - 0.5) * (double)player.getBbWidth() * 2.0, 0.0, 0.05, 0.0);
                }
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 300, 199));
                player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 300, 99));
                player.fallDistance = 0.0f;
                List entities = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(4.0, 4.0, 4.0));
                for (Entity radiatedEntity : entities) {
                    if (radiatedEntity == null || !(radiatedEntity instanceof LivingEntity) || radiatedEntity instanceof EntityTitan || radiatedEntity instanceof AbstractGolem || radiatedEntity instanceof OwnableEntity || radiatedEntity instanceof Villager) continue;
                    LivingEntity livingEntity = (LivingEntity)radiatedEntity;
                    if (level.isClientSide() || ((Boolean)TheTitansNeoConfigs.voidArmorRadiationPlayer.get()).booleanValue() && livingEntity instanceof Player) continue;
                    livingEntity.hurt(livingEntity.damageSources().fellOutOfWorld(), 4.0f);
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 5000, 1));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 5000, 1));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 5000, 9));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 5000, 3));
                }
            }
        }
    }
}

