/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.item;

import java.util.List;
import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoSounds;
import net.byAqua3.thetitansneo.loader.TheTitansNeoTiers;
import net.byAqua3.thetitansneo.util.EntityUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ItemVoidSword
extends SwordItem {
    public ItemVoidSword(Item.Properties properties) {
        super((Tier)TheTitansNeoTiers.VOID, properties.attributes(SwordItem.createAttributes((Tier)TheTitansNeoTiers.VOID, (int)1500, (float)-2.4f)));
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pEntity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity entity, LivingEntity attacker) {
        if (entity != null) {
            entity.playSound((SoundEvent)TheTitansNeoSounds.SLASH_FLESH.get(), 2.0f, 1.3f + entity.getRandom().nextFloat() * 0.5f);
            if (entity.getBbHeight() >= 6.0f || entity instanceof EntityTitan || !entity.onGround()) {
                entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
                entity.hurt(entity.damageSources().mobAttack(attacker), 1500.0f);
            }
        }
        return super.hurtEnemy(stack, entity, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)stack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int time) {
        Player player = (Player)livingEntity;
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        int max = this.getUseDuration(stack, livingEntity);
        int j = max - time;
        float f = (float)j / 60.0f;
        if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
            return;
        }
        if ((double)f > 1.0) {
            f = 1.0f;
        }
        player.playSound((SoundEvent)TheTitansNeoSounds.TITAN_SWING.get(), 1.0f, 2.0f);
        stack.hurtAndBreak(tool.damagePerBlock(), (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
        player.swing(player.getUsedItemHand());
        double d8 = 4.0;
        Vec3 vec3 = player.getViewVector(1.0f);
        double dx = vec3.x * d8;
        double dy = vec3.y * d8 + (double)player.getEyeHeight();
        double dz = vec3.z * d8;
        List entities = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(d8, d8, d8).move(dx, dy, dz));
        List<Entity> bigEntities = EntityUtils.getEntities(entities, player, d8, d8, d8, dx, dy, dz);
        if (!bigEntities.isEmpty()) {
            entities.addAll(bigEntities);
        }
        for (Entity entity : entities) {
            if (entity == null || !(entity instanceof LivingEntity)) continue;
            entity.playSound((SoundEvent)TheTitansNeoSounds.TITAN_PUNCH.get(), 10.0f, 1.0f);
            entity.playSound((SoundEvent)TheTitansNeoSounds.SLASH_FLESH.get(), 2.0f, 1.25f);
            entity.hurt(entity.damageSources().mobAttack((LivingEntity)player), 2000.0f * Math.max(f, 0.5f));
        }
    }
}

