/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.thetitansneo.entity.titan.EntityTitanPart;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.entity.PartEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public class MixinEntityRenderDispatcher {
    @Inject(method={"renderHitbox"}, at={@At(value="TAIL")})
    private static void renderHitbox(PoseStack poseStack, VertexConsumer vertexConsumer, Entity entity, float red, float green, float blue, float alpha, CallbackInfo callbackInfo) {
        if (entity.isMultipartEntity()) {
            for (PartEntity partEntity : entity.getParts()) {
                if (!(partEntity instanceof EntityTitanPart)) continue;
                poseStack.pushPose();
                AABB aabb = partEntity.getBoundingBox().move(-partEntity.getX(), -partEntity.getY(), -partEntity.getZ());
                double d0 = -Mth.lerp((double)red, (double)entity.xOld, (double)entity.getX());
                double d1 = -Mth.lerp((double)red, (double)entity.yOld, (double)entity.getY());
                double d2 = -Mth.lerp((double)red, (double)entity.zOld, (double)entity.getZ());
                double d3 = d0 + Mth.lerp((double)red, (double)partEntity.xOld, (double)partEntity.getX());
                double d4 = d1 + Mth.lerp((double)red, (double)partEntity.yOld, (double)partEntity.getY());
                double d5 = d2 + Mth.lerp((double)red, (double)partEntity.zOld, (double)partEntity.getZ());
                int boxRed = (Integer)TheTitansNeoConfigs.titanPartBoxRed.get();
                int boxGreen = (Integer)TheTitansNeoConfigs.titanPartBoxGreen.get();
                int boxBlue = (Integer)TheTitansNeoConfigs.titanPartBoxBlue.get();
                poseStack.translate(d3, d4, d5);
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)aabb, (float)((float)boxRed / 255.0f), (float)((float)boxGreen / 255.0f), (float)((float)boxBlue / 255.0f), (float)1.0f);
                poseStack.popPose();
            }
        }
    }
}

