/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.mixin;

import net.byAqua3.thetitansneo.entity.titan.EntityTitan;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public class MixinGameRenderer {
    @Inject(method={"pick"}, at={@At(value="HEAD")}, cancellable=true)
    public void pick(float partialTicks, CallbackInfo callbackInfo) {
        Minecraft mc = Minecraft.getInstance();
        Entity cameraEntity = mc.getCameraEntity();
        if (cameraEntity instanceof Player) {
            Player player = (Player)cameraEntity;
            double reachDistance = player.entityInteractionRange();
            Vec3 viewVector = player.getViewVector(partialTicks);
            Vec3 start = player.getEyePosition(partialTicks);
            Vec3 end = start.add(viewVector.scale(reachDistance));
            for (Entity entity : player.level().getEntities((Entity)player, player.getBoundingBox().inflate(20000.0, 20000.0, 20000.0))) {
                EntityTitan titan;
                if (!(entity instanceof EntityTitan) || !(titan = (EntityTitan)entity).getBoundingBox().intersects(start, end)) continue;
                callbackInfo.cancel();
                mc.hitResult = new EntityHitResult((Entity)titan);
                mc.crosshairPickEntity = titan;
                return;
            }
        }
    }
}

