/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.thetitansneo.entity.titan.EntityBlazeTitan;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ModelBlazeTitan
extends EntityModel<EntityBlazeTitan> {
    private ModelPart blazeHead;
    private ModelPart[] blazeSticks = new ModelPart[12];

    public ModelBlazeTitan(float grow) {
        ModelPart root = ModelBlazeTitan.createBodyLayer(grow).bakeRoot();
        this.blazeHead = root.getChild("blazeHead");
        for (int i = 0; i < this.blazeSticks.length; ++i) {
            this.blazeSticks[i] = root.getChild("blazeStick" + i);
        }
    }

    public static LayerDefinition createBodyLayer(float grow) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        CubeDeformation cubeDeformation = new CubeDeformation(grow);
        partDefinition.addOrReplaceChild("blazeHead", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        for (int i = 0; i < 12; ++i) {
            partDefinition.addOrReplaceChild("blazeStick" + i, CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityBlazeTitan entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        int i;
        float f6 = ageInTicks * (float)Math.PI * -0.008f;
        for (i = 0; i < 4; ++i) {
            this.blazeSticks[i].y = 4.0f + Mth.cos((float)(((float)(i * 2) + ageInTicks) * 0.03f));
            this.blazeSticks[i].x = Mth.cos((float)f6) * 10.0f;
            this.blazeSticks[i].z = Mth.sin((float)f6) * 10.0f;
            this.blazeSticks[i].yRot = Mth.sin((float)f6) * 8.0f;
            if (entity.isCharged()) {
                this.blazeSticks[i].xRot = Mth.cos((float)(ageInTicks * 0.1f)) * (float)Math.PI;
                this.blazeSticks[i].zRot = Mth.sin((float)(ageInTicks * 0.1f)) * (float)Math.PI;
            } else {
                this.blazeSticks[i].xRot = 0.0f;
                this.blazeSticks[i].zRot = 0.0f;
            }
            f6 += 1.0f;
        }
        f6 = 0.7853982f + ageInTicks * (float)Math.PI * 0.005f;
        for (i = 4; i < 8; ++i) {
            this.blazeSticks[i].y = 10.0f + Mth.cos((float)(((float)(i * 3) + ageInTicks) * 0.05f));
            this.blazeSticks[i].x = Mth.cos((float)f6) * 7.0f;
            this.blazeSticks[i].z = Mth.sin((float)f6) * 7.0f;
            this.blazeSticks[i].yRot = Mth.sin((float)f6) * 12.0f;
            f6 += 1.0f;
        }
        f6 = 0.47123894f + ageInTicks * (float)Math.PI * -0.003f;
        for (i = 8; i < 12; ++i) {
            this.blazeSticks[i].y = 17.0f + Mth.cos((float)(((float)i * 1.5f + ageInTicks) * 0.02f));
            this.blazeSticks[i].x = Mth.cos((float)f6) * 4.0f;
            this.blazeSticks[i].z = Mth.sin((float)f6) * 4.0f;
            this.blazeSticks[i].yRot = Mth.sin((float)f6) * 20.0f;
            f6 += 1.0f;
        }
        this.blazeHead.yRot = headYaw * (float)Math.PI / 180.0f;
        this.blazeHead.xRot = headPitch * (float)Math.PI / 180.0f;
        this.blazeHead.y = 0.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.blazeHead.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        for (ModelPart blazeStick : this.blazeSticks) {
            blazeStick.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        }
    }
}

