/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.thetitansneo.animation.Animator;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ModelEnderColossus
extends EntityModel<EntityEnderColossus> {
    private Animator animator;
    public ModelPart bodyBottom;
    public ModelPart leftThigh;
    public ModelPart rightThigh;
    public ModelPart bodyMiddle;
    public ModelPart bodyTop;
    public ModelPart leftShoulder;
    public ModelPart rightShoulder;
    public ModelPart mouth;
    public ModelPart leftForeArm;
    public ModelPart rightForeArm;
    public ModelPart head;
    public ModelPart horn1;
    public ModelPart horn2;
    public ModelPart horn3;
    public ModelPart horn4;
    public ModelPart leftFemur;
    public ModelPart rightFemur;
    public boolean isAttacking;

    public ModelEnderColossus() {
        ModelPart root = ModelEnderColossus.createBodyLayer().bakeRoot();
        this.bodyBottom = root.getChild("bodyBottom");
        this.bodyMiddle = root.getChild("bodyBottom").getChild("bodyMiddle");
        this.bodyTop = root.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop");
        this.leftShoulder = root.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("leftShoulder");
        this.leftForeArm = root.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("leftShoulder").getChild("leftForeArm");
        this.rightShoulder = root.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("rightShoulder");
        this.rightForeArm = root.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("rightShoulder").getChild("rightForeArm");
        this.mouth = root.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("mouth");
        this.head = root.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("mouth").getChild("head");
        this.horn1 = root.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("mouth").getChild("head").getChild("horn1");
        this.horn3 = root.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("mouth").getChild("head").getChild("horn1").getChild("horn3");
        this.horn2 = root.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("mouth").getChild("head").getChild("horn2");
        this.horn4 = root.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("mouth").getChild("head").getChild("horn2").getChild("horn4");
        this.leftThigh = root.getChild("leftThigh");
        this.leftFemur = root.getChild("leftThigh").getChild("leftFemur");
        this.rightThigh = root.getChild("rightThigh");
        this.rightFemur = root.getChild("rightThigh").getChild("rightFemur");
        this.animator = new Animator(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        CubeDeformation cubeDeformation = new CubeDeformation(0.0f);
        partDefinition.addOrReplaceChild("bodyBottom", CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, -4.0f, -2.0f, 8.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").addOrReplaceChild("bodyMiddle", CubeListBuilder.create().texOffs(0, 40).addBox(-4.0f, -4.0f, -2.0f, 8.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").getChild("bodyMiddle").addOrReplaceChild("bodyTop", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, -4.0f, -2.0f, 8.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").addOrReplaceChild("leftShoulder", CubeListBuilder.create().texOffs(32, 0).mirror().addBox(-1.0f, -2.0f, -1.0f, 2.0f, 15.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)5.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("leftShoulder").addOrReplaceChild("leftForeArm", CubeListBuilder.create().texOffs(32, 17).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").addOrReplaceChild("rightShoulder", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 15.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)-5.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("rightShoulder").addOrReplaceChild("rightForeArm", CubeListBuilder.create().texOffs(32, 17).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -7.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("mouth").addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("mouth").getChild("head").addOrReplaceChild("horn1", CubeListBuilder.create().texOffs(24, 38).addBox(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)4.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("mouth").getChild("head").getChild("horn1").addOrReplaceChild("horn3", CubeListBuilder.create().texOffs(36, 36).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("mouth").getChild("head").addOrReplaceChild("horn2", CubeListBuilder.create().texOffs(24, 38).addBox(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)-4.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("bodyBottom").getChild("bodyMiddle").getChild("bodyTop").getChild("mouth").getChild("head").getChild("horn2").addOrReplaceChild("horn4", CubeListBuilder.create().texOffs(36, 36).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("leftThigh", CubeListBuilder.create().texOffs(32, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)2.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("leftThigh").addOrReplaceChild("leftFemur", CubeListBuilder.create().texOffs(32, 17).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("rightThigh", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)-2.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("rightThigh").addOrReplaceChild("rightFemur", CubeListBuilder.create().texOffs(32, 17).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 15.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityEnderColossus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.animate(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.bodyBottom.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftThigh.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightThigh.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setAngles() {
        this.bodyBottom.setPos(0.0f, -4.0f, 0.0f);
        this.leftShoulder.setPos(5.0f, -2.0f, 0.0f);
        this.rightShoulder.setPos(-5.0f, -2.0f, 0.0f);
        this.mouth.setPos(0.0f, -4.0f, 0.0f);
        this.horn1.setPos(4.25f, -4.5f, 0.0f);
        this.horn2.setPos(-4.25f, -4.5f, 0.0f);
        this.leftThigh.setPos(2.0f, -6.0f, 0.0f);
        this.rightThigh.setPos(-2.0f, -6.0f, 0.0f);
    }

    public void animate(EntityEnderColossus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        this.animator.update(entity);
        this.setAngles();
        if (this.isAttacking) {
            this.head.setPos(0.0f, -7.0f, 0.0f);
        } else {
            this.head.setPos(0.0f, 0.0f, 0.0f);
        }
        float f6 = Mth.cos((float)(ageInTicks * 0.1f));
        this.leftThigh.xRot = -0.09f;
        this.rightThigh.xRot = -0.09f;
        this.leftFemur.xRot = 0.18f;
        this.rightFemur.xRot = 0.18f;
        if (entity.deathTicks <= 0) {
            if (!this.riding) {
                this.leftThigh.xRot = -0.09f + Mth.cos((float)(limbSwing * 0.33f + 2.6415927f)) * 0.75f * limbSwingAmount;
                this.rightThigh.xRot = -0.09f + Mth.cos((float)(limbSwing * 0.33f - 0.5f)) * 0.75f * limbSwingAmount;
                this.leftFemur.xRot = 0.18f + Mth.cos((float)(limbSwing * 0.33f)) * 0.75f * limbSwingAmount;
                this.rightFemur.xRot = 0.18f + Mth.cos((float)(limbSwing * 0.33f + (float)Math.PI)) * 0.75f * limbSwingAmount;
                if (this.leftFemur.xRot < 0.0f) {
                    this.leftFemur.xRot = 0.0f;
                }
                if (this.rightFemur.xRot < 0.0f) {
                    this.rightFemur.xRot = 0.0f;
                }
            }
            float faceYaw = headYaw * (float)Math.PI / 180.0f;
            float facePitch = headPitch * (float)Math.PI / 180.0f;
            if (entity.getAnimationID() == 0) {
                this.bodyMiddle.xRot = (0.0f + -0.01f * f6) * (float)Math.PI;
                this.bodyTop.xRot = (0.0f + -0.01f * f6) * (float)Math.PI;
                this.head.xRot = (-0.01f + -0.01f * f6) * (float)Math.PI;
                this.mouth.xRot = (0.01f + 0.01f * f6) * (float)Math.PI;
                this.bodyBottom.zRot = Mth.cos((float)(limbSwing * 0.33f)) * 0.125f * limbSwingAmount;
                this.bodyMiddle.zRot = Mth.cos((float)(limbSwing * 0.33f)) * 0.125f * limbSwingAmount;
                this.bodyTop.zRot = Mth.cos((float)(limbSwing * 0.33f)) * 0.125f * limbSwingAmount;
                this.mouth.zRot = Mth.cos((float)(limbSwing * 0.33f + (float)Math.PI)) * 0.375f * limbSwingAmount;
                this.leftForeArm.xRot = Mth.cos((float)(limbSwing * 0.33f)) * 0.75f * limbSwingAmount - 0.3f;
                this.rightForeArm.xRot = Mth.cos((float)(limbSwing * 0.33f + (float)Math.PI)) * 0.75f * limbSwingAmount - 0.3f;
            }
            this.leftShoulder.xRot = 0.09f + Mth.cos((float)(limbSwing * 0.33f)) * 0.75f * limbSwingAmount;
            this.rightShoulder.xRot = 0.09f + Mth.cos((float)(limbSwing * 0.33f + (float)Math.PI)) * 0.75f * limbSwingAmount;
            this.leftShoulder.yRot = -0.08f;
            this.rightShoulder.yRot = 0.08f;
            this.leftShoulder.zRot = -0.10471976f + (-0.005f + -0.005f * f6) * (float)Math.PI;
            this.rightShoulder.zRot = 0.10471976f - (0.005f + 0.005f * f6) * (float)Math.PI;
            if (entity.getAnimationID() == 0 && entity.getEyeLaserTime() < 0) {
                this.mouth.xRot += facePitch * 0.3f;
                this.mouth.yRot += faceYaw * 0.3f;
                this.bodyTop.xRot += facePitch * 0.3f;
                this.bodyTop.yRot += faceYaw * 0.3f;
                this.bodyMiddle.xRot += facePitch * 0.3f;
                this.bodyMiddle.yRot += faceYaw * 0.3f;
                this.leftShoulder.xRot -= facePitch * 0.6f;
                this.rightShoulder.xRot -= facePitch * 0.6f;
            } else {
                this.mouth.xRot += facePitch * 0.9f;
                this.mouth.yRot += faceYaw * 0.9f;
            }
            if (this.leftForeArm.xRot > -0.3f) {
                this.leftForeArm.xRot = -0.3f;
            }
            if (this.rightForeArm.xRot > -0.3f) {
                this.rightForeArm.xRot = -0.3f;
            }
            if (!entity.onGround() && !this.riding) {
                this.bodyTop.zRot = 0.0f;
                this.bodyMiddle.zRot = 0.0f;
                this.bodyBottom.zRot = 0.0f;
                this.mouth.zRot = 0.0f;
                this.bodyBottom.zRot = 0.0f;
                this.bodyMiddle.zRot = 0.0f;
                this.bodyTop.zRot = 0.0f;
                this.head.zRot = 0.0f;
                this.rightShoulder.xRot = 0.09f;
                this.leftShoulder.xRot = 0.09f;
                this.rightForeArm.xRot = 0.09f;
                this.leftForeArm.xRot = 0.09f;
                this.mouth.xRot -= entity.walkAnimation.speed(partialTicks);
                this.bodyBottom.xRot += entity.walkAnimation.speed(partialTicks);
                this.leftThigh.xRot = Mth.cos((float)(ageInTicks * 0.1f - 3.6415927f)) * 0.25f - (float)(entity.getDeltaMovement().y / 5.0) + entity.walkAnimation.speed(partialTicks);
                this.rightThigh.xRot = Mth.cos((float)(ageInTicks * 0.1f - 0.5f)) * 0.25f - (float)(entity.getDeltaMovement().y / 5.0) + entity.walkAnimation.speed(partialTicks);
                this.leftFemur.xRot = 0.5f - Mth.cos((float)(ageInTicks * 0.1f - (float)Math.PI)) * 0.5f;
                this.rightFemur.xRot = 0.5f - Mth.cos((float)(ageInTicks * 0.1f)) * 0.5f;
            }
            if (entity.getAnimationID() == 8 && entity.getAnimationTick() > 20 && entity.getAnimationTick() < 60) {
                this.bodyTop.yRot = Mth.cos((float)ageInTicks) * 0.5f;
                this.mouth.yRot = Mth.cos((float)ageInTicks) * 0.25f;
                this.bodyTop.xRot = Mth.cos((float)(ageInTicks * 0.25f - 2.0f)) * 0.25f;
                this.bodyMiddle.xRot = Mth.cos((float)(ageInTicks * 0.25f - 1.0f)) * 0.25f;
                this.bodyBottom.xRot = Mth.cos((float)(ageInTicks * 0.25f)) * 0.25f;
            }
            if (entity.getAnimationID() == 8 && entity.getAnimationTick() > 100 && entity.getAnimationTick() < 340) {
                this.mouth.yRot = Mth.cos((float)(ageInTicks * 0.05f)) * 0.2f;
            }
            if (entity.getAnimationID() == 1) {
                switch (entity.getAntiTitanAttackAnimationID()) {
                    case 0: {
                        this.animateAntiTitanAttack1();
                        break;
                    }
                    case 1: {
                        this.animateAntiTitanAttack2();
                        break;
                    }
                    case 2: {
                        this.animateAntiTitanAttack3();
                        break;
                    }
                    case 3: {
                        this.animateAntiTitanAttack4();
                    }
                }
            }
            this.animateStomp();
            this.animateSwat();
            this.animateSlam();
            this.animateMeteor();
            this.animateChainLightning();
            this.animateLightning();
            this.animateLightningBall();
            this.animateDragonBall();
            this.animateScream();
            this.animateStunned();
            if (this.head.y < -7.0f) {
                this.head.y = -7.0f;
            }
            if (entity.getAnimationID() == 3 && entity.getAnimationTick() > 30 && entity.getAnimationTick() < 50) {
                this.leftForeArm.xRot -= 0.1f * Mth.cos((float)ageInTicks) * (float)Math.PI;
                this.rightForeArm.xRot += 0.1f * Mth.cos((float)ageInTicks) * (float)Math.PI;
            }
        } else {
            this.animateDeath();
        }
    }

    private void animateAntiTitanAttack1() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.head, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 1.0f, -1.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 1.0f, 1.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 2.0f, -12.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, -12.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, -12.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.0f, -1.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(10);
    }

    private void animateAntiTitanAttack2() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 5.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.bodyMiddle, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.bodyTop, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, 1.6f, 0.0f, 2.0f);
        this.animator.rotate(this.rightForeArm, -0.9f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 2.0f, -12.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, -12.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, -12.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(0);
    }

    private void animateAntiTitanAttack3() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 5.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -4.0f, 0.0f, -0.25f);
        this.animator.rotate(this.leftShoulder, -4.0f, 0.0f, 0.25f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 2.0f, -12.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, -12.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, -12.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 1.0f, 0.0f, -0.25f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, 0.25f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(0);
    }

    private void animateAntiTitanAttack4() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, 2.0f, 0.2f, 1.5f);
        this.animator.rotate(this.rightFemur, 1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.0f, -1.0f, -0.2f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, -0.2f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, -0.2f);
        this.animator.rotate(this.bodyBottom, -1.0f, 1.0f, 0.6f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, 0.75f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.leftShoulder, -1.5f, 0.0f, -0.75f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.5f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 2.0f, -12.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, -13.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, -11.0f);
        this.animator.rotate(this.rightThigh, -3.0f, 0.2f, 1.5f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.0f, 0.0f, -0.25f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.5f, -0.25f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.5f, -0.25f);
        this.animator.rotate(this.bodyBottom, -1.0f, -1.0f, 0.75f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, 0.75f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.leftShoulder, -1.5f, 0.0f, -0.75f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.5f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(0);
    }

    private void animateMeteor() {
        this.animator.setAnimationID(2);
        this.animator.startPhase(30);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 5.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.bodyMiddle, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.bodyTop, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, 0.5f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.leftShoulder, -1.5f, 0.0f, -0.5f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.5f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(40);
    }

    private void animateLightningBall() {
        this.animator.setAnimationID(4);
        this.animator.startPhase(30);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 5.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.bodyMiddle, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.bodyTop, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, 0.5f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.leftShoulder, -1.5f, 0.0f, -0.5f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.5f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(40);
    }

    private void animateChainLightning() {
        this.animator.setAnimationID(3);
        this.animator.startPhase(30);
        this.animator.rotate(this.mouth, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, 0.75f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, -0.25f);
        this.animator.rotate(this.leftShoulder, -1.5f, 0.0f, -0.75f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.25f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(30);
        this.animator.startPhase(10);
        this.animator.rotate(this.mouth, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, -0.5f);
        this.animator.endPhase();
        this.animator.resetPhase(30);
    }

    private void animateDragonBall() {
        this.animator.setAnimationID(11);
        this.animator.startPhase(30);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 5.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.bodyMiddle, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.bodyTop, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, 0.5f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.leftShoulder, -1.5f, 0.0f, -0.5f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.5f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(40);
    }

    private void animateLightning() {
        this.animator.setAnimationID(13);
        this.animator.startPhase(20);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForeArm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bodyBottom, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, -1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.mouth, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animateScream() {
        this.animator.setAnimationID(5);
        this.animator.startPhase(25);
        this.animator.move(this.bodyBottom, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForeArm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(25);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 5.0f);
        this.animator.rotate(this.head, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 1.0f, -1.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 1.0f, 1.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.startPhase(10);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.head, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -1.5f, 0.0f, 0.5f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.5f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.5f);
        this.animator.rotate(this.bodyBottom, 0.5f, 0.0f, 1.5f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 1.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, -1.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(100);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.head, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -1.5f, 0.0f, -0.5f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, -0.5f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, -0.5f);
        this.animator.rotate(this.bodyBottom, 0.5f, 0.0f, -1.5f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 1.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, -1.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animateSlam() {
        this.animator.setAnimationID(6);
        this.animator.startPhase(15);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForeArm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(15);
        this.animator.move(this.bodyBottom, 0.0f, -1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, -1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, -1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -2.0f, 0.2f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.1f, 0.2f, 0.0f);
        this.animator.rotate(this.rightFemur, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -4.0f, 0.0f, -0.25f);
        this.animator.rotate(this.leftShoulder, -4.0f, 0.0f, 0.25f);
        this.animator.rotate(this.rightForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 16.0f, 1.0f);
        this.animator.move(this.rightThigh, 0.0f, 16.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 16.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -2.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -0.75f, 0.0f, -0.25f);
        this.animator.rotate(this.leftForeArm, -0.75f, 0.0f, 0.25f);
        this.animator.endPhase();
        this.animator.resetPhase(30);
    }

    private void animateStomp() {
        this.animator.setAnimationID(7);
        this.animator.startPhase(25);
        this.animator.move(this.bodyBottom, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForeArm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(25);
        this.animator.move(this.bodyBottom, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, -2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -2.0f, 0.2f, 0.75f);
        this.animator.rotate(this.leftThigh, 0.0f, 0.2f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.leftFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 1.0f, 0.0f, 0.5f);
        this.animator.rotate(this.bodyTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.0f, 0.0f, 0.25f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, -0.75f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForeArm, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -0.3f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bodyBottom, 0.0f, 4.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 4.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -1.0f, 0.0f, 0.5f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.0f, 0.0f, -0.4f);
        this.animator.rotate(this.rightShoulder, 0.5f, 0.0f, 0.25f);
        this.animator.rotate(this.leftShoulder, 0.5f, 0.0f, -0.25f);
        this.animator.rotate(this.rightForeArm, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -0.3f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(5);
        this.animator.startPhase(20);
        this.animator.move(this.bodyBottom, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, -2.0f, 0.0f);
        this.animator.move(this.head, 0.0f, -2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -2.0f, 0.0f, -0.75f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.5f);
        this.animator.rotate(this.mouth, 1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.bodyTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.0f, 0.0f, -0.25f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, 0.8f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForeArm, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -0.8f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.bodyBottom, 0.0f, 4.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 4.0f, 0.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, -1.0f, 0.0f, 0.5f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.0f, 0.0f, 0.4f);
        this.animator.rotate(this.rightShoulder, 0.75f, 0.0f, 0.25f);
        this.animator.rotate(this.leftShoulder, 0.75f, 0.0f, -0.25f);
        this.animator.rotate(this.rightForeArm, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -0.75f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.resetPhase(20);
    }

    private void animateStunned() {
        this.animator.setAnimationID(8);
        this.animator.startPhase(10);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForeArm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.move(this.bodyBottom, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 5.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -2.0f, 0.0f, 0.5f);
        this.animator.rotate(this.rightForeArm, -1.5f, 0.0f, -1.0f);
        this.animator.rotate(this.leftShoulder, -2.0f, 0.0f, -0.5f);
        this.animator.rotate(this.leftForeArm, -1.5f, 0.0f, 1.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(40);
        this.animator.startPhase(40);
        this.animator.move(this.bodyBottom, 0.0f, 19.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 19.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 19.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 2.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -2.0f, 0.5f, -0.25f);
        this.animator.rotate(this.rightForeArm, -0.75f, -0.5f, 0.0f);
        this.animator.rotate(this.leftShoulder, -2.0f, -0.5f, 0.25f);
        this.animator.rotate(this.leftForeArm, -0.75f, 0.5f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(240);
        this.animator.startPhase(20);
        this.animator.move(this.bodyBottom, 0.0f, 14.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 14.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 14.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.8f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, -0.25f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(40);
    }

    private void animateSwat() {
        this.animator.setAnimationID(9);
        this.animator.startPhase(15);
        this.animator.move(this.bodyBottom, 0.0f, 4.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 4.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 4.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.375f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 1.0f, 1.0f, 1.5f);
        this.animator.rotate(this.leftShoulder, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForeArm, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(25);
        this.animator.move(this.bodyBottom, 0.0f, 16.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 16.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 16.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -1.0f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.0f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -2.0f, 0.0f, -0.5f);
        this.animator.rotate(this.leftShoulder, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -0.25f, 0.0f, -1.0f);
        this.animator.rotate(this.leftForeArm, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animateDeath() {
        this.animator.setAnimationID(10);
        this.animator.startPhase(40);
        this.animator.move(this.bodyBottom, 0.0f, 4.0f, -6.0f);
        this.animator.move(this.rightThigh, 0.0f, 4.0f, -6.0f);
        this.animator.move(this.leftThigh, 0.0f, 4.0f, -6.0f);
        this.animator.move(this.head, 0.0f, -2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -0.5f, 0.0f, -0.5f);
        this.animator.rotate(this.leftForeArm, -0.5f, 0.0f, -0.3f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.bodyBottom, 0.0f, 4.0f, -16.0f);
        this.animator.move(this.rightThigh, 0.0f, 4.0f, -16.0f);
        this.animator.move(this.leftThigh, 0.0f, 4.0f, -16.0f);
        this.animator.move(this.head, 0.0f, -5.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyTop, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyMiddle, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForeArm, -0.5f, 0.0f, -0.75f);
        this.animator.rotate(this.leftForeArm, -0.5f, 0.0f, -0.3f);
        this.animator.endPhase();
        this.animator.startPhase(80);
        this.animator.move(this.bodyBottom, 0.0f, 28.0f, 16.0f);
        this.animator.move(this.rightThigh, 0.0f, 28.0f, 16.0f);
        this.animator.move(this.leftThigh, 0.0f, 28.0f, 16.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, 0.5f);
        this.animator.rotate(this.leftShoulder, -1.5f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForeArm, 0.0f, 0.0f, -0.25f);
        this.animator.rotate(this.leftForeArm, 0.0f, 0.0f, 0.25f);
        this.animator.endPhase();
        this.animator.startPhase(80);
        this.animator.move(this.bodyBottom, 0.0f, 26.0f, 16.0f);
        this.animator.move(this.rightThigh, 0.0f, 28.0f, 16.0f);
        this.animator.move(this.leftThigh, 0.0f, 28.0f, 16.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -2.0f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -2.0f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, -1.55f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForeArm, 0.0f, 0.0f, -0.25f);
        this.animator.rotate(this.leftForeArm, 0.0f, 0.0f, 0.25f);
        this.animator.endPhase();
        this.animator.startPhase(200);
        this.animator.move(this.bodyBottom, 0.0f, 26.0f, 16.0f);
        this.animator.move(this.rightThigh, 0.0f, 28.0f, 16.0f);
        this.animator.move(this.leftThigh, 0.0f, 28.0f, 16.0f);
        this.animator.move(this.head, 0.0f, -7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -1.55f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.55f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.mouth, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.bodyBottom, -1.55f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForeArm, 0.0f, 0.0f, -0.3f);
        this.animator.rotate(this.leftForeArm, 0.0f, 0.0f, 0.3f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(1520);
        this.animator.resetPhase(0);
    }
}

