/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.thetitansneo.animation.Animator;
import net.byAqua3.thetitansneo.entity.titan.EntitySkeletonTitan;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ModelSkeletonTitan
extends EntityModel<EntitySkeletonTitan> {
    private Animator animator;
    public boolean isWither;
    public ModelPart hips;
    public ModelPart leftThigh;
    public ModelPart rightThigh;
    public ModelPart spine1;
    public ModelPart spine2;
    public ModelPart spine3;
    public ModelPart spine4;
    public ModelPart spine5;
    public ModelPart spine6;
    public ModelPart ribs;
    public ModelPart head;
    public ModelPart leftShoulder;
    public ModelPart rightShoulder;
    public ModelPart leftForearm;
    public ModelPart rightForearm;
    public ModelPart heldItem;
    public ModelPart heldItem2;
    public ModelPart leftFemur;
    public ModelPart rightFemur;

    public ModelSkeletonTitan(float grow) {
        ModelPart root = ModelSkeletonTitan.createBodyLayer(grow).bakeRoot();
        this.hips = root.getChild("hips");
        this.spine1 = root.getChild("hips").getChild("spine1");
        this.spine2 = root.getChild("hips").getChild("spine1").getChild("spine2");
        this.spine3 = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3");
        this.spine4 = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4");
        this.spine5 = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5");
        this.spine6 = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6");
        this.ribs = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs");
        this.head = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").getChild("head");
        this.leftShoulder = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").getChild("leftShoulder");
        this.leftForearm = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").getChild("leftShoulder").getChild("leftForearm");
        this.rightShoulder = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").getChild("rightShoulder");
        this.rightForearm = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").getChild("rightShoulder").getChild("rightForearm");
        this.heldItem = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").getChild("rightShoulder").getChild("rightForearm").getChild("heldItem");
        this.heldItem2 = root.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").getChild("rightShoulder").getChild("rightForearm").getChild("heldItem2");
        this.leftThigh = root.getChild("leftThigh");
        this.leftFemur = root.getChild("leftThigh").getChild("leftFemur");
        this.rightThigh = root.getChild("rightThigh");
        this.rightFemur = root.getChild("rightThigh").getChild("rightFemur");
        this.animator = new Animator(root);
    }

    public static LayerDefinition createBodyLayer(float grow) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        CubeDeformation cubeDeformation = new CubeDeformation(grow);
        partDefinition.addOrReplaceChild("hips", CubeListBuilder.create().texOffs(16, 27).addBox(-4.0f, -2.0f, -2.0f, 8.0f, 2.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").addOrReplaceChild("spine1", CubeListBuilder.create().texOffs(10, 30).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(10, 28).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").addOrReplaceChild("spine3", CubeListBuilder.create().texOffs(10, 26).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").addOrReplaceChild("spine4", CubeListBuilder.create().texOffs(10, 24).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").addOrReplaceChild("spine5", CubeListBuilder.create().texOffs(10, 23).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").addOrReplaceChild("spine6", CubeListBuilder.create().texOffs(10, 22).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").addOrReplaceChild("ribs", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, -3.0f, -2.0f, 8.0f, 7.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").addOrReplaceChild("leftShoulder", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -1.0f, 2.0f, 6.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)5.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").getChild("leftShoulder").addOrReplaceChild("leftForearm", CubeListBuilder.create().texOffs(40, 24).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").addOrReplaceChild("rightShoulder", CubeListBuilder.create().texOffs(40, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 6.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)-5.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").getChild("rightShoulder").addOrReplaceChild("rightForearm", CubeListBuilder.create().texOffs(40, 24).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").getChild("rightShoulder").getChild("rightForearm").addOrReplaceChild("heldItem", CubeListBuilder.create().texOffs(32, -16).addBox(0.0f, -6.0f, -10.0f, 0.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("hips").getChild("spine1").getChild("spine2").getChild("spine3").getChild("spine4").getChild("spine5").getChild("spine6").getChild("ribs").getChild("rightShoulder").getChild("rightForearm").addOrReplaceChild("heldItem2", CubeListBuilder.create().texOffs(32, 17).addBox(0.0f, -12.5f, -12.5f, 0.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("leftThigh", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)1.9f, (float)12.0f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("leftThigh").addOrReplaceChild("leftFemur", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("rightThigh", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("rightThigh").addOrReplaceChild("rightFemur", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(EntitySkeletonTitan entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        if (entity.getSkeletonType() == 1) {
            this.isWither = true;
            this.heldItem.visible = false;
            if (((Boolean)TheTitansNeoConfigs.titanWeaponOldModel.get()).booleanValue()) {
                this.heldItem2.visible = true;
            }
        } else {
            this.isWither = false;
            if (((Boolean)TheTitansNeoConfigs.titanWeaponOldModel.get()).booleanValue()) {
                this.heldItem.visible = true;
            }
            this.heldItem2.visible = false;
        }
        this.animate(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.hips.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftThigh.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightThigh.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setAngles() {
        this.head.x = 0.0f;
        this.head.y = -3.0f;
        this.head.z = 0.0f;
        this.heldItem.x = 0.0f;
        this.heldItem.y = 4.0f;
        this.heldItem.z = 0.0f;
        this.heldItem2.z = 0.0f;
        this.heldItem2.x = 0.0f;
        this.heldItem2.y = 4.0f;
        this.hips.x = 0.0f;
        this.rightThigh.x = -2.0f;
        this.leftThigh.x = 2.0f;
        this.hips.z = 0.0f;
        this.rightThigh.z = 0.0f;
        this.leftThigh.z = 0.0f;
        this.hips.y = 12.0f;
        this.rightThigh.y = 12.0f;
        this.leftThigh.y = 12.0f;
        this.leftForearm.setRotation(-0.17453292f, 0.0f, 0.0f);
        this.leftShoulder.setRotation(0.08726646f, -0.08726646f, -0.08726646f);
        this.rightFemur.setRotation(0.13962634f, 0.0f, 0.0f);
        this.rightForearm.setRotation(-0.17453292f, 0.0f, 0.0f);
        this.leftFemur.setRotation(0.13962634f, 0.0f, 0.0f);
        this.leftThigh.setRotation(-0.06981317f, -0.06981317f, 0.0f);
        this.rightThigh.setRotation(-0.08726646f, 0.06981317f, 0.0f);
        this.rightShoulder.setRotation(0.08726646f, 0.08726646f, 0.08726646f);
        this.heldItem.setRotation(-2.3561945f, 0.0f, 0.0f);
        this.heldItem2.setRotation(0.7853982f, 0.0f, 0.0f);
    }

    public void animate(EntitySkeletonTitan entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        this.animator.update(entity);
        this.setAngles();
        float fo = 0.6662f / (entity.getSkeletonType() == 1 ? 2.5f : 4.0f);
        if (entity.deathTicks <= 0) {
            float f6 = (float)Math.cos(ageInTicks * 0.1f);
            if (entity.getAnimationID() == 0) {
                this.spine3.xRot = (0.001f + 0.0025f * f6) * (float)Math.PI;
                this.spine4.xRot = (0.001f + 0.0025f * f6) * (float)Math.PI;
                this.spine5.xRot = (0.001f + 0.0025f * f6) * (float)Math.PI;
                this.spine6.xRot = (0.001f + 0.0025f * f6) * (float)Math.PI;
                this.head.xRot = (0.001f + 0.005f * f6) * (float)Math.PI;
                this.rightShoulder.yRot = (0.025f + 0.025f * f6) * (float)Math.PI;
                this.leftShoulder.yRot = (-0.025f + -0.025f * f6) * (float)Math.PI;
            }
            if (this.riding) {
                this.rightThigh.xRot = -1.5707964f;
                this.leftThigh.xRot = -1.5707964f;
                this.rightThigh.yRot = 0.31415927f;
                this.leftThigh.yRot = -0.31415927f;
                this.rightFemur.xRot = 1.0471976f;
                this.leftFemur.xRot = 1.0471976f;
            } else if (entity.getAnimationID() == 0) {
                this.hips.y = 12.0f - Mth.cos((float)(limbSwing * fo * 2.0f + 1.0f)) * 2.0f * limbSwingAmount;
                this.rightThigh.y = 12.0f - Mth.cos((float)(limbSwing * fo * 2.0f + 1.0f)) * 2.0f * limbSwingAmount;
                this.leftThigh.y = 12.0f - Mth.cos((float)(limbSwing * fo * 2.0f + 1.0f)) * 2.0f * limbSwingAmount;
                this.head.yRot = Mth.cos((float)(limbSwing * fo + 3.25f)) * 0.3f * limbSwingAmount;
                this.spine6.yRot = Mth.cos((float)(limbSwing * fo - 3.0f)) * 0.1f * limbSwingAmount;
                this.spine5.yRot = Mth.cos((float)(limbSwing * fo - 2.5f)) * 0.1f * limbSwingAmount;
                this.spine4.yRot = Mth.cos((float)(limbSwing * fo - 2.0f)) * 0.1f * limbSwingAmount;
                this.spine3.yRot = Mth.cos((float)(limbSwing * fo - 1.5f)) * 0.1f * limbSwingAmount;
                this.spine2.yRot = Mth.cos((float)(limbSwing * fo - 1.0f)) * 0.1f * limbSwingAmount;
                this.spine1.yRot = Mth.cos((float)(limbSwing * fo - 0.5f)) * 0.1f * limbSwingAmount;
                this.hips.yRot = Mth.cos((float)(limbSwing * fo)) * 0.2f * limbSwingAmount;
                this.rightThigh.xRot = -0.08726646f + Mth.cos((float)(limbSwing * fo - 0.5f)) * 0.75f * limbSwingAmount;
                this.leftThigh.xRot = -0.08726646f + Mth.cos((float)(limbSwing * fo + 2.6415927f)) * 0.75f * limbSwingAmount;
                this.rightFemur.xRot = 0.13962634f + Mth.cos((float)(limbSwing * fo + (float)Math.PI)) * 0.75f * limbSwingAmount;
                this.leftFemur.xRot = 0.13962634f + Mth.cos((float)(limbSwing * fo)) * 0.75f * limbSwingAmount;
                if (this.rightFemur.xRot < 0.13962634f) {
                    this.rightFemur.xRot = 0.13962634f;
                }
                if (this.leftFemur.xRot < 0.13962634f) {
                    this.leftFemur.xRot = 0.13962634f;
                }
                if (!this.riding) {
                    this.rightShoulder.xRot = 0.08726646f + Mth.cos((float)(limbSwing * fo + (float)Math.PI)) * 1.0f * limbSwingAmount;
                    this.leftShoulder.xRot = 0.08726646f + Mth.cos((float)(limbSwing * fo)) * 1.0f * limbSwingAmount;
                    this.rightForearm.xRot = -0.17453292f + Mth.cos((float)(limbSwing * fo + 2.1415927f)) * 1.0f * limbSwingAmount;
                    this.leftForearm.xRot = -0.17453292f + Mth.cos((float)(limbSwing * fo - 1.0f)) * 1.0f * limbSwingAmount;
                    if (this.rightForearm.xRot > -0.17453292f) {
                        this.rightForearm.xRot = -0.17453292f;
                    }
                    if (this.leftForearm.xRot > -0.17453292f) {
                        this.leftForearm.xRot = -0.17453292f;
                    }
                }
            }
            float faceYaw = headYaw * (float)Math.PI / 180.0f;
            float facePitch = headPitch * (float)Math.PI / 180.0f;
            if (entity.getAnimationID() == 0) {
                this.head.xRot += facePitch * 0.5f;
                this.head.yRot += faceYaw * 0.5f;
                this.spine6.xRot += facePitch * 0.1f;
                this.spine6.yRot += faceYaw * 0.1f;
                this.spine5.xRot += facePitch * 0.1f;
                this.spine5.yRot += faceYaw * 0.1f;
                this.spine4.xRot += facePitch * 0.1f;
                this.spine4.yRot += faceYaw * 0.1f;
                this.spine3.xRot += facePitch * 0.1f;
                this.spine3.yRot += faceYaw * 0.1f;
                this.rightShoulder.xRot -= facePitch * 0.4f;
                this.leftShoulder.xRot -= facePitch * 0.4f;
            } else {
                this.head.xRot += facePitch * 0.9f;
                this.head.yRot += faceYaw * 0.9f;
            }
            if (!entity.onGround() && !this.riding) {
                this.spine6.yRot = 0.0f;
                this.spine5.yRot = 0.0f;
                this.spine4.yRot = 0.0f;
                this.spine3.yRot = 0.0f;
                this.spine2.zRot = 0.0f;
                this.spine1.zRot = 0.0f;
                this.hips.yRot = 0.0f;
                this.head.yRot = 0.0f;
                this.rightShoulder.xRot = -entity.walkAnimation.speed(partialTicks);
                this.leftShoulder.xRot = -entity.walkAnimation.speed(partialTicks);
                this.rightForearm.xRot = -(entity.walkAnimation.speed(partialTicks) / 2.0f);
                this.leftForearm.xRot = -(entity.walkAnimation.speed(partialTicks) / 2.0f);
                this.head.xRot -= entity.walkAnimation.speed(partialTicks);
                this.hips.xRot += entity.walkAnimation.speed(partialTicks);
                this.rightThigh.yRot = 0.25f;
                this.leftThigh.yRot = -0.25f;
                this.rightThigh.yRot = -0.25f;
                this.leftThigh.yRot = 0.25f;
                this.rightThigh.xRot = Mth.cos((float)(ageInTicks * 0.2f)) * 0.25f - (float)(entity.getDeltaMovement().y / 5.0) + entity.walkAnimation.speed(partialTicks);
                this.leftThigh.xRot = Mth.cos((float)(ageInTicks * 0.2f - (float)Math.PI)) * 0.25f - (float)(entity.getDeltaMovement().y / 5.0) + entity.walkAnimation.speed(partialTicks);
                this.rightFemur.xRot = 0.5f - Mth.cos((float)(ageInTicks * 0.2f + 0.5f)) * 0.5f;
                this.leftFemur.xRot = 0.5f - Mth.cos((float)(ageInTicks * 0.2f - 2.6415927f)) * 0.5f;
            }
            if (entity.getAnimationID() == 5 && entity.getAnimationTick() > 100 && entity.getAnimationTick() < 300) {
                this.leftForearm.xRot = -Mth.cos((float)(ageInTicks * 4.0f)) * 0.5f;
            }
            if (entity.getAnimationID() == 1) {
                switch (entity.getAntiTitanAttackAnimationID()) {
                    case 0: {
                        this.animateAntiTitanAttack1();
                        break;
                    }
                    case 1: {
                        this.animateAntiTitanAttack2();
                        break;
                    }
                    case 2: {
                        this.animateAntiTitanAttack3();
                        break;
                    }
                    case 3: {
                        this.animateAntiTitanAttack4();
                    }
                }
            }
            this.animatePunch();
            this.animateBackhand();
            this.animateSwat();
            this.animateShot();
            this.animateStomp();
            this.animateDownwardSlash();
            this.animateStun();
            this.animateLightning();
            this.animateGiantShot();
            this.animateLightningHand();
            this.animateBirth();
        } else {
            this.animateDeath();
        }
    }

    private void animateStun() {
        this.animator.setAnimationID(8);
        this.animator.startPhase(0);
        this.animator.move(this.heldItem, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 1.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine2, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine1, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.hips, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -3.0f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(30);
        this.animator.move(this.heldItem, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.spine6, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine5, -0.25f, 0.5f, 0.0f);
        this.animator.rotate(this.spine4, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine3, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.hips, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.0f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForearm, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.75f);
        this.animator.rotate(this.heldItem, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(30);
        this.animator.move(this.heldItem, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 8.0f);
        this.animator.rotate(this.rightThigh, -2.0f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -2.6f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(30);
        this.animator.move(this.heldItem, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 9.8f, 8.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 8.0f);
        this.animator.rotate(this.rightThigh, -1.6f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.6f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.3f, 0.0f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.3f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForearm, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.6f, 1.6f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(200);
        this.animator.startPhase(70);
        this.animator.move(this.heldItem, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 9.8f, 8.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 8.0f);
        this.animator.rotate(this.rightThigh, -1.6f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.6f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.3f, 0.0f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.3f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForearm, -0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.6f, 1.6f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(60);
        this.animator.move(this.heldItem, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 9.8f, 8.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 8.0f);
        this.animator.rotate(this.rightThigh, -4.0f, -0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -4.0f, 0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.2f, 0.0f, 0.5f);
        this.animator.rotate(this.leftShoulder, -0.2f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForearm, -0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.6f, 1.6f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.hips, 0.0f, -20.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, -20.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, -20.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, -0.75f, 0.0f, 0.75f);
        this.animator.rotate(this.rightForearm, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.3f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.hips, 0.0f, 4.0f, 2.0f);
        this.animator.move(this.rightThigh, 0.0f, 4.0f, 2.0f);
        this.animator.move(this.leftThigh, 0.0f, 4.0f, 2.0f);
        this.animator.rotate(this.rightThigh, -0.9f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.9f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.ribs, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.8f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(10);
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 4.0f, 2.0f);
        this.animator.move(this.rightThigh, 0.0f, 4.0f, 2.0f);
        this.animator.move(this.leftThigh, 0.0f, 4.0f, 2.0f);
        this.animator.rotate(this.rightThigh, -0.9f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.9f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.ribs, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.head, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.8f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(30);
    }

    private void animateSwat() {
        this.animator.setAnimationID(2);
        this.animator.startPhase(20);
        this.animator.move(this.hips, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.ribs, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.head, -1.0f, 1.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -2.0f, 0.75f, 1.5f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.25f, -1.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.hips, 0.0f, 6.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 6.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 6.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -1.0f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.0f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.ribs, 0.5f, 0.0f, -0.5f);
        this.animator.rotate(this.head, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -2.0f, -1.25f, -1.5f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.375f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.375f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.375f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.375f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.375f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.375f, 1.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animateBackhand() {
        this.animator.setAnimationID(4);
        this.animator.startPhase(20);
        this.animator.move(this.hips, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.ribs, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.head, -1.0f, 1.0f, 0.5f);
        this.animator.rotate(this.leftShoulder, -2.5f, -0.75f, -1.5f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.25f, 1.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.hips, 0.0f, 6.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 6.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 6.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -1.0f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.0f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.ribs, 0.5f, 0.0f, -0.5f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -2.5f, 0.75f, 1.5f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.375f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.375f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.375f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.375f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.375f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.375f, -1.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animatePunch() {
        this.animator.setAnimationID(3);
        this.animator.startPhase(20);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.1f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.ribs, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.hips, 0.0f, 4.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 4.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 4.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.6f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.6f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.2f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.ribs, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.resetPhase(20);
    }

    private void animateLightning() {
        this.animator.setAnimationID(9);
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, 0.8f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.45f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.45f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.25f, -0.6f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.35f, -0.25f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.25f, 0.6f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.35f, 0.25f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.6f, 0.0f, 0.5f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.startPhase(5);
        this.animator.move(this.hips, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.45f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.45f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.0f, -0.6f, 0.0f);
        this.animator.rotate(this.rightForearm, -1.0f, -0.25f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.0f, 0.6f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.25f, 0.0f);
        this.animator.rotate(this.heldItem2, -1.0f, 0.0f, 0.5f);
        this.animator.rotate(this.spine6, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(5);
        this.animator.move(this.hips, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.45f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.45f, -0.6f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.25f, -0.6f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.35f, -0.25f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.25f, 0.6f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.35f, 0.25f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.6f, 0.0f, 0.5f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(10);
        this.animator.resetPhase(10);
    }

    private void animateAntiTitanAttack1() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 2.0f, 4.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 4.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 4.0f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, -1.0f, 0.0f);
        this.animator.rotate(this.spine6, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine5, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine4, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine3, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.9f, 0.0f, 1.0f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 1.0f);
        this.animator.rotate(this.heldItem2, 1.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.heldItem, 0.0f, 100.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -8.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -8.0f);
        this.animator.rotate(this.rightThigh, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 1.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -2.0f, 0.5f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 2.0f, 10.0f, 0.0f);
        this.animator.rotate(this.heldItem, 100.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.heldItem, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(0);
    }

    private void animateAntiTitanAttack2() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 2.0f, 4.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 4.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 4.0f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.25f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.25f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 2.0f, -8.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, -8.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, -8.0f);
        this.animator.rotate(this.rightThigh, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, -0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, -0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.6f, -0.4f, 0.0f);
        this.animator.rotate(this.leftShoulder, -0.5f, 0.4f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(0);
    }

    private void animateAntiTitanAttack3() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 2.0f, 4.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 4.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 4.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.5f, -1.5f, 0.0f);
        this.animator.rotate(this.spine6, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine5, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine4, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine3, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine2, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine1, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.0f, 0.0f, 0.5f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.0f, 0.5f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 2.0f, -8.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, -8.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, -8.0f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 1.5f, 0.0f);
        this.animator.rotate(this.spine6, 0.0f, -0.25f, 0.0f);
        this.animator.rotate(this.spine5, 0.0f, -0.25f, 0.0f);
        this.animator.rotate(this.spine4, 0.0f, -0.25f, 0.0f);
        this.animator.rotate(this.spine3, 0.0f, -0.25f, 0.0f);
        this.animator.rotate(this.spine2, 0.0f, -0.25f, 0.0f);
        this.animator.rotate(this.spine1, 0.0f, -0.25f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.5f, -0.5f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.75f);
        this.animator.rotate(this.leftForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(0);
    }

    private void animateAntiTitanAttack4() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(8);
        this.animator.move(this.hips, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.25f, -0.4f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.25f, 0.4f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.0f, 0.5f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(12);
        this.animator.move(this.hips, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.0f);
        this.animator.rotate(this.rightThigh, 1.8f, -10.0f, 0.5f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.5f);
        this.animator.rotate(this.leftThigh, -0.5f, -10.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.25f, -0.4f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.25f, 0.4f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 1.75f, -10.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, 0.0f, -12.6f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, -12.6f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, -12.6f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(0);
    }

    private void animateShot() {
        this.animator.setAnimationID(5);
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, 0.8f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.45f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.45f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.35f, 0.5f, -1.5f);
        this.animator.rotate(this.leftShoulder, -1.2f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, -0.3f);
        this.animator.rotate(this.leftForearm, -0.4f, 0.0f, 1.5f);
        this.animator.rotate(this.heldItem, 1.0f, 2.5f, 1.0f);
        this.animator.rotate(this.spine1, 0.0f, -1.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 1.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(300);
        this.animator.resetPhase(30);
    }

    private void animateStomp() {
        this.animator.setAnimationID(6);
        this.animator.startPhase(25);
        this.animator.move(this.hips, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.0f, 0.5f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(25);
        this.animator.move(this.hips, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, -2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -2.6f, 0.2f, 0.75f);
        this.animator.rotate(this.leftThigh, 0.0f, 0.2f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.5f, 0.0f, -0.5f);
        this.animator.rotate(this.leftFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.5f);
        this.animator.rotate(this.spine6, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, 0.0f, 0.8f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, 0.8f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.0f, 0.5f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.hips, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.5f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, 0.0f, -0.8f);
        this.animator.rotate(this.rightShoulder, 0.75f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, 0.75f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.0f, 0.5f, 0.75f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(5);
        this.animator.startPhase(20);
        this.animator.move(this.hips, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, -2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -2.6f, 0.0f, -0.75f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.5f, 0.0f, 0.5f);
        this.animator.rotate(this.head, 1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.spine6, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, 0.0f, -0.8f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, 0.8f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.0f, 0.5f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.hips, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.5f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, 0.0f, 0.8f);
        this.animator.rotate(this.rightShoulder, 0.75f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, 0.75f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.0f, 0.5f, 0.75f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.resetPhase(20);
    }

    private void animateDownwardSlash() {
        this.animator.setAnimationID(7);
        this.animator.startPhase(60);
        this.animator.move(this.heldItem, 0.0f, 2.0f, -6.0f);
        this.animator.move(this.hips, 0.0f, 2.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 5.5f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 5.5f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, -1.0f, 0.0f);
        this.animator.rotate(this.spine6, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine5, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine4, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.spine3, -0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.hips, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.75f);
        this.animator.rotate(this.heldItem2, 0.5f, 0.5f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(10);
        this.animator.startPhase(30);
        this.animator.move(this.heldItem, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 1.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine2, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine1, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.hips, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -3.0f, 0.0f, -0.875f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(50);
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, -0.125f, 0.0f);
        this.animator.rotate(this.hips, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -3.0f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 50.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 3.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.hips, 0.0f, 2.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 5.5f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 5.5f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.spine6, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(40);
    }

    private void animateDeath() {
        this.animator.setAnimationID(10);
        this.animator.startPhase(40);
        this.animator.move(this.hips, 0.0f, 2.0f, 6.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 6.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 6.0f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.0707964f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, -1.0707964f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.hips, 0.0f, 2.0f, 12.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 12.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 12.0f);
        this.animator.rotate(this.rightThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.0707964f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, -1.0707964f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.hips, 0.0f, 2.0f, 12.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 12.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 12.0f);
        this.animator.rotate(this.rightThigh, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.5f, 0.5f);
        this.animator.rotate(this.spine6, -0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.25f, -0.4f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.25f, 0.4f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 2.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(80);
        this.animator.move(this.hips, 0.0f, 10.0f, -3.0f);
        this.animator.move(this.head, 0.0f, -12.0f, 2.5f);
        this.animator.move(this.rightThigh, 0.0f, 11.0f, 0.0f);
        this.animator.move(this.leftThigh, 10.0f, 11.0f, 12.0f);
        this.animator.rotate(this.rightThigh, 1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, 0.0f, 1.5f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 14.4f, 14.4f, 0.0f);
        this.animator.rotate(this.spine6, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 1.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.5f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, -3.0f, 0.0f, 0.75f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 2.0f, 1.0f, 10.0f);
        this.animator.move(this.heldItem, 0.0f, 0.0f, -10.0f);
        this.animator.move(this.heldItem2, 0.0f, 0.0f, -10.0f);
        this.animator.endPhase();
        this.animator.startPhase(100);
        this.animator.move(this.hips, 0.0f, 10.0f, -3.0f);
        this.animator.move(this.head, 0.0f, -12.0f, -1.0f);
        this.animator.move(this.rightThigh, 0.0f, 11.0f, 0.0f);
        this.animator.move(this.leftThigh, 10.0f, 11.0f, 12.0f);
        this.animator.rotate(this.rightThigh, 1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, 0.0f, 1.5f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 14.4f, 14.4f, 0.0f);
        this.animator.rotate(this.spine6, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 1.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, -3.0f, 0.0f, 0.75f);
        this.animator.rotate(this.rightForearm, 0.15f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.15f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 2.0f, 1.0f, 10.0f);
        this.animator.move(this.heldItem, 0.0f, 0.0f, -10.0f);
        this.animator.move(this.heldItem2, 0.0f, 0.0f, -10.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(1700);
        this.animator.resetPhase(0);
    }

    private void animateGiantShot() {
        this.animator.setAnimationID(11);
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, 0.8f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.hips, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.45f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.45f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.35f, 0.5f, -1.5f);
        this.animator.rotate(this.leftShoulder, -1.2f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, -0.3f);
        this.animator.rotate(this.leftForearm, -0.4f, 0.0f, 1.5f);
        this.animator.rotate(this.heldItem, 1.0f, 2.5f, 1.0f);
        this.animator.rotate(this.spine1, 0.0f, -1.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 1.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(50);
        this.animator.startPhase(5);
        this.animator.move(this.hips, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.45f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.45f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.35f, 0.5f, -1.5f);
        this.animator.rotate(this.leftShoulder, -1.6f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, -0.3f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 1.5f);
        this.animator.rotate(this.heldItem, 1.0f, 2.5f, 1.0f);
        this.animator.rotate(this.spine1, 0.0f, -1.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 1.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(5);
        this.animator.move(this.hips, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.45f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.45f, -0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.35f, 0.5f, -1.5f);
        this.animator.rotate(this.leftShoulder, -1.2f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, -0.3f);
        this.animator.rotate(this.leftForearm, -0.4f, 0.0f, 1.5f);
        this.animator.rotate(this.heldItem, 1.0f, 2.5f, 1.0f);
        this.animator.rotate(this.spine1, 0.0f, -1.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 1.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(10);
        this.animator.resetPhase(20);
    }

    private void animateLightningHand() {
        this.animator.setAnimationID(12);
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, 0.8f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.rightThigh, 2.0f, 0.0f, 2.0f);
        this.animator.move(this.leftThigh, -2.0f, 0.0f, -2.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 1.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.0f, -1.8f, 0.0f);
        this.animator.rotate(this.rightForearm, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, 1.8f, 0.0f);
        this.animator.rotate(this.head, 0.0f, -1.8f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(10);
        this.animator.startPhase(2);
        this.animator.move(this.rightThigh, 2.0f, 0.0f, 2.0f);
        this.animator.move(this.leftThigh, -2.0f, 0.0f, -2.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 1.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -2.0f, -1.8f, 0.0f);
        this.animator.rotate(this.rightForearm, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, 1.8f, 0.0f);
        this.animator.rotate(this.head, 0.25f, -1.8f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(8);
        this.animator.move(this.rightThigh, 2.0f, 0.0f, 2.0f);
        this.animator.move(this.leftThigh, -2.0f, 0.0f, -2.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 1.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.5f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.0f, -1.8f, 0.0f);
        this.animator.rotate(this.rightForearm, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, 1.8f, 0.0f);
        this.animator.rotate(this.head, 0.0f, -1.8f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(10);
        this.animator.resetPhase(10);
    }

    private void animateBirth() {
        this.animator.setAnimationID(13);
        this.animator.startPhase(0);
        this.animator.move(this.heldItem, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 8.0f);
        this.animator.rotate(this.rightThigh, -1.4f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.9f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, -1.55f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.1f, 0.0f, 0.25f);
        this.animator.rotate(this.leftShoulder, 0.1f, 0.0f, -0.25f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.6f, 1.6f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(160);
        this.animator.startPhase(60);
        this.animator.move(this.heldItem, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 9.5f, 8.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 8.0f);
        this.animator.rotate(this.rightThigh, -1.5f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.9f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, -1.55f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.1f, 0.0f, 0.25f);
        this.animator.rotate(this.leftShoulder, 2.5f, 2.5f, 0.25f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.6f, 1.6f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.heldItem, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.hips, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 8.0f);
        this.animator.rotate(this.rightThigh, -1.4f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.9f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, -1.55f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.1f, 0.0f, 0.25f);
        this.animator.rotate(this.leftShoulder, 2.5f, 1.5f, 0.2f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem2, 1.6f, 1.6f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(40);
        this.animator.startPhase(60);
        this.animator.move(this.hips, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 8.0f);
        this.animator.rotate(this.rightThigh, -1.9f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.9f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 1.5f, 0.75f, 0.25f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(60);
        this.animator.move(this.hips, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 8.0f);
        this.animator.rotate(this.rightThigh, -1.9f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.9f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(120);
        this.animator.move(this.hips, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 8.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 8.0f);
        this.animator.rotate(this.rightThigh, -2.0f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -2.0f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.25f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, -0.125f, 0.125f, 0.0f);
        this.animator.rotate(this.spine5, -0.125f, 0.125f, 0.0f);
        this.animator.rotate(this.spine4, -0.125f, 0.125f, 0.0f);
        this.animator.rotate(this.spine3, -0.125f, 0.125f, 0.0f);
        this.animator.rotate(this.spine2, -0.125f, 0.125f, 0.0f);
        this.animator.rotate(this.spine1, -0.125f, 0.125f, 0.0f);
        this.animator.rotate(this.hips, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, -0.5f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.hips, 0.0f, 4.0f, 3.0f);
        this.animator.move(this.rightThigh, 0.0f, 4.0f, 3.0f);
        this.animator.move(this.leftThigh, 0.0f, 4.0f, 3.0f);
        this.animator.rotate(this.rightThigh, -1.25f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.hips, 0.0f, 1.0f, -2.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -2.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -2.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.hips, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.rotate(this.rightThigh, -0.125f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.125f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.spine6, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.125f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.125f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, -0.125f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.125f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.spine6, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.1f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(10);
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, -0.125f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.125f, -0.25f, 0.0f);
        this.animator.rotate(this.rightFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftFemur, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.3f, -0.5f, 0.0f);
        this.animator.rotate(this.spine6, 0.05f, 0.0f, 0.0f);
        this.animator.rotate(this.spine5, 0.05f, 0.0f, 0.0f);
        this.animator.rotate(this.spine4, 0.05f, 0.0f, 0.0f);
        this.animator.rotate(this.spine3, 0.05f, 0.0f, 0.0f);
        this.animator.rotate(this.spine2, 0.05f, 0.0f, 0.0f);
        this.animator.rotate(this.spine1, 0.05f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(10);
        this.animator.resetPhase(40);
    }
}

