/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.thetitansneo.entity.titan.EntitySlimeTitan;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class ModelSlimeTitan
extends EntityModel<EntitySlimeTitan> {
    public ModelPart slimeBodies;
    public ModelPart slimeLeftEye;
    public ModelPart slimeRightEye;
    public ModelPart slimeMouth;

    public ModelSlimeTitan(int y) {
        ModelPart root = ModelSlimeTitan.createBodyLayer(y).bakeRoot();
        this.slimeBodies = root.getChild("slimeBodies");
        if (y > 0) {
            this.slimeLeftEye = root.getChild("slimeLeftEye");
            this.slimeRightEye = root.getChild("slimeRightEye");
            this.slimeMouth = root.getChild("slimeMouth");
        }
    }

    public static LayerDefinition createBodyLayer(int y) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        CubeDeformation cubeDeformation = new CubeDeformation(0.0f);
        partDefinition.addOrReplaceChild("slimeBodies", CubeListBuilder.create().texOffs(0, y).addBox(-4.0f, 16.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        if (y > 0) {
            partDefinition.addOrReplaceChild("slimeBodies", CubeListBuilder.create().texOffs(0, y).addBox(-3.0f, 17.0f, -3.0f, 6.0f, 6.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("slimeLeftEye", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)-2.25f, (float)19.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("slimeRightEye", CubeListBuilder.create().texOffs(32, 4).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)2.25f, (float)19.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("slimeMouth", CubeListBuilder.create().texOffs(32, 8).addBox(0.0f, 21.0f, -3.5f, 1.0f, 1.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void setupAnim(EntitySlimeTitan entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        if (this.slimeLeftEye != null) {
            this.slimeLeftEye.yRot = headYaw * (float)Math.PI / 180.0f;
            this.slimeLeftEye.xRot = headPitch * (float)Math.PI / 180.0f;
        }
        if (this.slimeRightEye != null) {
            this.slimeRightEye.yRot = headYaw * (float)Math.PI / 180.0f;
            this.slimeRightEye.xRot = headPitch * (float)Math.PI / 180.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.slimeBodies.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        if (this.slimeLeftEye != null) {
            this.slimeLeftEye.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
            this.slimeRightEye.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
            this.slimeMouth.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        }
    }
}

