/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.thetitansneo.animation.Animator;
import net.byAqua3.thetitansneo.entity.titan.EntityZombifiedPiglinTitan;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ModelZombifiedPiglinTitan
extends EntityModel<EntityZombifiedPiglinTitan> {
    public Animator animator;
    public ModelPart torso;
    public ModelPart leftThigh;
    public ModelPart rightThigh;
    public ModelPart middleBody;
    public ModelPart topBody;
    public ModelPart head;
    public ModelPart leftEar;
    public ModelPart rightEar;
    public ModelPart leftShoulder;
    public ModelPart rightShoulder;
    public ModelPart leftForearm;
    public ModelPart rightForearm;
    public ModelPart heldItem;
    public ModelPart leftCalf;
    public ModelPart rightCalf;

    public ModelZombifiedPiglinTitan(float grow) {
        ModelPart root = ModelZombifiedPiglinTitan.createBodyLayer(grow).bakeRoot();
        this.torso = root.getChild("torso");
        this.leftThigh = root.getChild("leftThigh");
        this.rightThigh = root.getChild("rightThigh");
        this.middleBody = root.getChild("torso").getChild("middleBody");
        this.topBody = root.getChild("torso").getChild("middleBody").getChild("topBody");
        this.head = root.getChild("torso").getChild("middleBody").getChild("topBody").getChild("head");
        this.leftEar = root.getChild("torso").getChild("middleBody").getChild("topBody").getChild("head").getChild("leftEar");
        this.rightEar = root.getChild("torso").getChild("middleBody").getChild("topBody").getChild("head").getChild("rightEar");
        this.leftShoulder = root.getChild("torso").getChild("middleBody").getChild("topBody").getChild("leftShoulder");
        this.rightShoulder = root.getChild("torso").getChild("middleBody").getChild("topBody").getChild("rightShoulder");
        this.leftForearm = root.getChild("torso").getChild("middleBody").getChild("topBody").getChild("leftShoulder").getChild("leftForearm");
        this.rightForearm = root.getChild("torso").getChild("middleBody").getChild("topBody").getChild("rightShoulder").getChild("rightForearm");
        this.heldItem = root.getChild("torso").getChild("middleBody").getChild("topBody").getChild("rightShoulder").getChild("rightForearm").getChild("heldItem");
        this.leftCalf = root.getChild("leftThigh").getChild("leftCalf");
        this.rightCalf = root.getChild("rightThigh").getChild("rightCalf");
        this.animator = new Animator(root);
    }

    public static LayerDefinition createBodyLayer(float grow) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        CubeDeformation cubeDeformation = new CubeDeformation(grow);
        partDefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, -4.0f, -2.0f, 8.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").addOrReplaceChild("middleBody", CubeListBuilder.create().texOffs(16, 24).addBox(-4.0f, -4.0f, -2.0f, 8.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("leftThigh", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("leftThigh").addOrReplaceChild("leftCalf", CubeListBuilder.create().mirror().texOffs(0, 26).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("rightThigh", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("rightThigh").addOrReplaceChild("rightCalf", CubeListBuilder.create().texOffs(0, 26).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("middleBody").addOrReplaceChild("topBody", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, -4.0f, -2.0f, 8.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("middleBody").getChild("topBody").addOrReplaceChild("leftShoulder", CubeListBuilder.create().mirror().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)6.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("middleBody").getChild("topBody").getChild("leftShoulder").addOrReplaceChild("leftForearm", CubeListBuilder.create().mirror().texOffs(40, 26).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("middleBody").getChild("topBody").addOrReplaceChild("rightShoulder", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)-6.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("middleBody").getChild("topBody").getChild("rightShoulder").addOrReplaceChild("rightForearm", CubeListBuilder.create().texOffs(40, 26).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("middleBody").getChild("topBody").getChild("rightShoulder").getChild("rightForearm").addOrReplaceChild("heldItem", CubeListBuilder.create().texOffs(32, 32).addBox(0.0f, -12.0f, -12.0f, 0.0f, 16.0f, 16.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("middleBody").getChild("topBody").addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, cubeDeformation).texOffs(31, 1).addBox(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f, cubeDeformation).texOffs(2, 4).addBox(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, cubeDeformation).texOffs(2, 0).addBox(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.getChild("torso").getChild("middleBody").getChild("topBody").getChild("head").addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(51, 6).addBox(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5235988f));
        partDefinition.getChild("torso").getChild("middleBody").getChild("topBody").getChild("head").addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(39, 6).addBox(-1.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)-4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5235988f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityZombifiedPiglinTitan entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.animate(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        float f = 1.2f;
        float f1 = ageInTicks * 0.1f + limbSwing * 0.5f;
        float f2 = 0.08f + limbSwingAmount * 0.4f;
        this.leftEar.zRot = -0.5235988f - Mth.cos((float)(f1 * f)) * f2;
        this.rightEar.zRot = 0.5235988f + Mth.cos((float)f1) * f2;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        if (this.young) {
            float f6 = 2.0f;
            poseStack.pushPose();
            poseStack.scale(1.0f / f6, 1.0f / f6, 1.0f / f6);
            poseStack.translate(0.0f, 1.5f, 0.0f);
            this.torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
            this.leftThigh.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
            this.rightThigh.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
            poseStack.popPose();
        } else {
            this.torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
            this.leftThigh.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
            this.rightThigh.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        }
    }

    public void setAngles() {
        this.leftShoulder.xRot = -1.5707964f;
        this.rightShoulder.xRot = -1.5707964f;
        this.heldItem.xRot = 0.7853982f;
        this.rightThigh.z = 0.0f;
        this.leftThigh.z = 0.0f;
        this.torso.z = 0.0f;
        this.torso.x = 0.0f;
        this.torso.y = 12.0f;
        this.heldItem.z = 0.0f;
        this.heldItem.x = 0.0f;
        this.heldItem.y = 4.0f;
        this.rightThigh.y = 12.0f;
        this.leftThigh.y = 12.0f;
    }

    public void animate(EntityZombifiedPiglinTitan entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        if (!entity.onGround()) {
            limbSwingAmount = 0.0f;
        }
        this.animator.update(entity);
        this.setAngles();
        float fo = 0.16655f;
        if (entity.deathTicks <= 0) {
            float f6 = Mth.cos((float)(ageInTicks * 0.1f));
            if (entity.getAnimationID() == 0) {
                this.middleBody.xRot = (0.001f + 0.005f * f6) * (float)Math.PI;
                this.topBody.xRot = (0.001f + 0.005f * f6) * (float)Math.PI;
                this.head.xRot = (0.001f + 0.0075f * f6) * (float)Math.PI;
                this.rightShoulder.yRot = (-0.001f + 0.01f * f6) * (float)Math.PI;
                this.leftShoulder.yRot = (0.001f + -0.01f * f6) * (float)Math.PI;
            }
            if (this.riding) {
                this.rightThigh.xRot = -1.5707964f;
                this.leftThigh.xRot = -1.5707964f;
                this.rightThigh.yRot = 0.31415927f;
                this.leftThigh.yRot = -0.31415927f;
                this.rightCalf.xRot = 1.0471976f;
                this.leftCalf.xRot = 1.0471976f;
            } else if (entity.getAnimationID() == 0) {
                this.torso.zRot = Mth.cos((float)(limbSwing * fo)) * 0.2f * limbSwingAmount;
                this.middleBody.zRot = Mth.cos((float)(limbSwing * fo - 1.0f)) * 0.2f * limbSwingAmount;
                this.topBody.zRot = Mth.cos((float)(limbSwing * fo - 2.0f)) * 0.2f * limbSwingAmount;
                this.rightThigh.xRot = Mth.cos((float)(limbSwing * fo - 0.5f)) * 0.75f * limbSwingAmount;
                this.leftThigh.xRot = Mth.cos((float)(limbSwing * fo + 2.6415927f)) * 0.75f * limbSwingAmount;
                this.rightCalf.xRot = Mth.cos((float)(limbSwing * fo + (float)Math.PI)) * 0.75f * limbSwingAmount;
                this.leftCalf.xRot = Mth.cos((float)(limbSwing * fo)) * 0.75f * limbSwingAmount;
                this.torso.y = 12.0f - Mth.cos((float)(limbSwing * fo * 2.0f + 1.0f)) * 2.0f * limbSwingAmount;
                this.rightThigh.y = 12.0f - Mth.cos((float)(limbSwing * fo * 2.0f + 1.0f)) * 2.0f * limbSwingAmount;
                this.leftThigh.y = 12.0f - Mth.cos((float)(limbSwing * fo * 2.0f + 1.0f)) * 2.0f * limbSwingAmount;
                if (this.rightCalf.xRot < 0.0f) {
                    this.rightCalf.xRot = 0.0f;
                }
                if (this.leftCalf.xRot < 0.0f) {
                    this.leftCalf.xRot = 0.0f;
                }
            }
            float faceYaw = headYaw * (float)Math.PI / 180.0f;
            float facePitch = headPitch * (float)Math.PI / 180.0f;
            if (entity.getAnimationID() == 0) {
                this.head.xRot += facePitch * 0.3f;
                this.head.yRot += faceYaw * 0.3f;
                this.topBody.xRot += facePitch * 0.3f;
                this.topBody.yRot += faceYaw * 0.3f;
                this.middleBody.xRot += facePitch * 0.3f;
                this.middleBody.yRot += faceYaw * 0.3f;
            } else {
                this.head.xRot += facePitch * 0.9f;
                this.head.yRot += faceYaw * 0.9f;
            }
            if (!entity.onGround() && !this.riding && entity.getY() > -63.0) {
                this.torso.zRot = 0.0f;
                this.middleBody.zRot = 0.0f;
                this.topBody.zRot = 0.0f;
                this.head.zRot = 0.0f;
                this.rightShoulder.xRot -= entity.walkAnimation.speed(partialTicks);
                this.leftShoulder.xRot -= entity.walkAnimation.speed(partialTicks);
                this.head.xRot -= entity.walkAnimation.speed(partialTicks);
                this.torso.xRot += entity.walkAnimation.speed(partialTicks);
                this.rightThigh.zRot = 0.25f;
                this.leftThigh.zRot = -0.25f;
                this.rightThigh.yRot = -0.25f;
                this.leftThigh.yRot = 0.25f;
                this.rightThigh.xRot = Mth.cos((float)(ageInTicks * 0.2f)) * 0.25f - (float)(entity.getDeltaMovement().y / 5.0) + entity.walkAnimation.speed(partialTicks);
                this.leftThigh.xRot = Mth.cos((float)(ageInTicks * 0.2f - (float)Math.PI)) * 0.25f - (float)(entity.getDeltaMovement().y / 5.0) + entity.walkAnimation.speed(partialTicks);
                this.rightCalf.xRot = 0.5f - Mth.cos((float)(ageInTicks * 0.2f + 0.5f)) * 0.5f;
                this.leftCalf.xRot = 0.5f - Mth.cos((float)(ageInTicks * 0.2f - 2.6415927f)) * 0.5f;
            }
            if (entity.getAnimationID() == 11 && entity.getAnimationTick() > 30 && entity.getAnimationTick() < 160) {
                this.head.zRot = Mth.cos((float)(ageInTicks * 0.25f - 3.0f)) * 0.5f;
                this.topBody.zRot = Mth.cos((float)(ageInTicks * 0.25f - 2.0f)) * 0.25f;
                this.middleBody.zRot = Mth.cos((float)(ageInTicks * 0.25f - 1.0f)) * 0.25f;
                this.torso.zRot = Mth.cos((float)(ageInTicks * 0.25f)) * 0.25f;
            }
            if (entity.getAnimationID() == 12 && entity.getAnimationTick() > 30 && entity.getAnimationTick() < 50) {
                this.rightForearm.xRot = 0.1f * Mth.cos((float)(ageInTicks * 2.0f)) * (float)Math.PI;
                this.leftForearm.xRot = -(0.1f * Mth.cos((float)(ageInTicks * 2.0f)) * (float)Math.PI);
            }
            if (entity.getAnimationID() == 1) {
                switch (entity.getAntiTitanAttackAnimationID()) {
                    case 0: {
                        this.animateAntiTitanAttack1();
                        break;
                    }
                    case 1: {
                        this.animateAntiTitanAttack2();
                        break;
                    }
                    case 2: {
                        this.animateAntiTitanAttack3();
                        break;
                    }
                    case 3: {
                        this.animateAntiTitanAttack4();
                    }
                }
            }
            this.animateBirth();
            this.animateRoar();
            this.animateRangedAttackThrow();
            this.animateSlam();
            this.animateSwat();
            this.animateSwordDig();
            this.animateLightning();
            this.animateStomp();
            this.animateDownwardSlash();
            this.animateStun();
            this.animateSidewaySlash();
        } else {
            this.animateDeath();
        }
    }

    private void animateAntiTitanAttack1() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 2.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 5.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 5.0f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, -1.5f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.middleBody, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.torso, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.rightShoulder, 3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, -1.0f);
        this.animator.rotate(this.leftForearm, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, -12.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 1.5f, 0.0f);
        this.animator.rotate(this.topBody, -0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, -1.2f);
        this.animator.rotate(this.rightForearm, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 3.0f, 0.0f, -1.0f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, -11.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(10);
    }

    private void animateAntiTitanAttack2() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(8);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.0f, 0.5f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(12);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.0f);
        this.animator.rotate(this.rightThigh, 1.8f, -10.0f, 0.5f);
        this.animator.rotate(this.rightCalf, 0.0f, 0.0f, 0.5f);
        this.animator.rotate(this.leftThigh, -0.5f, -10.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 1.75f, -10.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.rotate(this.rightThigh, 0.0f, -12.6f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, -12.6f, 0.0f);
        this.animator.rotate(this.torso, 0.0f, -12.6f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(0);
    }

    private void animateAntiTitanAttack3() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 2.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 5.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 5.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 1.5f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.middleBody, -0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.torso, -0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.leftShoulder, 2.0f, -1.0f, -1.0f);
        this.animator.rotate(this.leftForearm, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 3.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.0f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, -1.5f, 0.0f);
        this.animator.rotate(this.topBody, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.6f, 0.0f, -1.0f);
        this.animator.rotate(this.leftShoulder, -0.5f, 0.0f, 1.0f);
        this.animator.rotate(this.rightForearm, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 3.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(10);
    }

    private void animateAntiTitanAttack4() {
        this.animator.setAnimationID(1);
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 5.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 5.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.0f, 0.5f);
        this.animator.rotate(this.rightForearm, -1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.heldItem, -1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 2.0f, -12.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, -12.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, -12.0f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.5f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, -0.5f);
        this.animator.rotate(this.heldItem, 1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(10);
    }

    private void animateSwat() {
        this.animator.setAnimationID(2);
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightCalf, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 1.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.0f, 0.0f, 1.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -1.0f, 0.0f);
        this.animator.rotate(this.heldItem, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 4.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 4.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 4.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -1.0f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.0f, -0.5f, 0.0f);
        this.animator.rotate(this.rightCalf, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -1.0f, 0.0f, -1.0f);
        this.animator.rotate(this.leftForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.75f, 1.0f, 0.0f);
        this.animator.rotate(this.heldItem, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animateSwordDig() {
        this.animator.setAnimationID(4);
        this.animator.startPhase(25);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(25);
        this.animator.move(this.torso, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, -1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -2.0f, 0.2f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, -0.2f, 0.0f);
        this.animator.rotate(this.rightCalf, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.2f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, -0.2f, 0.0f);
        this.animator.rotate(this.rightForearm, 0.0f, -0.4f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.4f, 0.0f);
        this.animator.rotate(this.heldItem, 1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 3.0f, 1.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.head, -1.2f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.0f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, -1.0f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, -0.5f);
        this.animator.rotate(this.leftForearm, -0.25f, 0.0f, 0.5f);
        this.animator.rotate(this.heldItem, 3.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(40);
        this.animator.startPhase(30);
        this.animator.move(this.torso, 0.0f, 3.0f, 1.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.head, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.0f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, -1.0f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.5f);
        this.animator.rotate(this.heldItem, 2.0f, 0.0f, 2.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animateSlam() {
        this.animator.setAnimationID(3);
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 0.6f, 0.0f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(15);
        this.animator.move(this.torso, 0.0f, -1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, -1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -1.6f, 0.2f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, 0.2f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.9f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, -0.3f, 0.0f, -0.75f);
        this.animator.endPhase();
        this.animator.startPhase(15);
        this.animator.move(this.torso, 0.0f, 3.0f, 1.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, -0.5f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.5f);
        this.animator.endPhase();
        this.animator.resetPhase(30);
    }

    private void animateLightning() {
        this.animator.setAnimationID(5);
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 0.0f, 0.0f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, -1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -2.0f, 0.2f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, -0.2f, 0.0f);
        this.animator.rotate(this.rightCalf, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.35f, 0.4f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.35f, -0.4f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, -1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -2.0f, 0.2f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, -0.2f, 0.0f);
        this.animator.rotate(this.rightCalf, 2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.35f, 0.4f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.35f, -0.4f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(5);
        this.animator.startPhase(5);
        this.animator.move(this.torso, 0.0f, 3.0f, 1.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.9f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, -0.9f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, -0.5f);
        this.animator.rotate(this.leftForearm, -0.25f, 0.0f, 0.5f);
        this.animator.rotate(this.heldItem, 2.0f, 0.0f, 2.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animateStomp() {
        this.animator.setAnimationID(6);
        this.animator.startPhase(25);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.0f, 0.5f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(25);
        this.animator.move(this.torso, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, -2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -2.0f, 0.2f, 0.75f);
        this.animator.rotate(this.leftThigh, 0.0f, 0.2f, 0.0f);
        this.animator.rotate(this.rightCalf, 1.5f, 0.0f, -0.5f);
        this.animator.rotate(this.leftCalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.5f);
        this.animator.rotate(this.topBody, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.0f, 0.0f, 0.25f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, -0.75f, 0.0f, 0.75f);
        this.animator.rotate(this.rightForearm, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.0f, 0.5f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.1f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.5f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.0f, 0.0f, -0.4f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, -0.75f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.3f, 0.0f, 0.75f);
        this.animator.rotate(this.leftForearm, -0.3f, 0.0f, -0.75f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(5);
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, -2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -2.0f, 0.0f, -0.75f);
        this.animator.rotate(this.rightCalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 1.5f, 0.0f, 0.5f);
        this.animator.rotate(this.head, 1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.topBody, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.0f, 0.0f, -0.25f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, -0.75f, 0.0f, 0.75f);
        this.animator.rotate(this.rightForearm, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.0f, 0.5f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, -0.5f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, -0.5f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.0f, 0.0f, 0.4f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, -0.75f, 0.0f, 0.75f);
        this.animator.rotate(this.rightForearm, -0.3f, 0.0f, -0.75f);
        this.animator.rotate(this.leftForearm, -0.3f, 0.0f, 0.75f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.resetPhase(20);
    }

    private void animateDownwardSlash() {
        this.animator.setAnimationID(7);
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, -0.2f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.1f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.1f, 0.0f);
        this.animator.rotate(this.rightShoulder, 1.0f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, 0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 2.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 5.5f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 5.5f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, -1.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.middleBody, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.torso, -0.5f, 0.5f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 0.0f, -1.5f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.75f);
        this.animator.rotate(this.heldItem, 0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(50);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 1.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.55f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.5f, -1.5f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 2.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 5.5f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 5.5f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 2.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.resetPhase(20);
    }

    private void animateStun() {
        this.animator.setAnimationID(8);
        this.animator.startPhase(0);
        this.animator.move(this.torso, 0.0f, 1.0f, -3.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -2.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -3.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, -0.5f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, -0.5f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.75f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.5f, 1.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.75f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.55f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.75f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.55f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.75f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.55f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.75f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.55f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.75f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -2.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.55f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.75f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, -0.25f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.55f, 0.0f, -0.75f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.75f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(40);
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(160);
        this.animator.startPhase(40);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, -0.75f, 0.0f, -0.75f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 1.5f, -0.75f, 0.0f);
        this.animator.rotate(this.leftShoulder, 1.5f, 0.75f, 0.0f);
        this.animator.rotate(this.heldItem, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 0.0f, 0.0f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(30);
        this.animator.move(this.torso, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.25f, 0.25f);
        this.animator.rotate(this.leftThigh, -0.25f, -0.25f, -0.25f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.25f, 1.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.25f, -1.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(60);
        this.animator.resetPhase(20);
    }

    private void animateSidewaySlash() {
        this.animator.setAnimationID(9);
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.1f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.1f, 0.0f);
        this.animator.rotate(this.rightShoulder, 1.0f, 0.0f, 0.75f);
        this.animator.rotate(this.leftShoulder, 0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 2.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 5.5f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 5.5f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.25f, 0.5f, -0.5f);
        this.animator.rotate(this.middleBody, -0.25f, 0.5f, -0.5f);
        this.animator.rotate(this.torso, -0.25f, 0.5f, -0.5f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, -1.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, -1.5f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.75f);
        this.animator.rotate(this.heldItem, 0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, -0.25f, -0.25f);
        this.animator.rotate(this.middleBody, 0.5f, -0.25f, -0.25f);
        this.animator.rotate(this.torso, 1.0f, -0.25f, -0.5f);
        this.animator.rotate(this.rightShoulder, -1.0f, 0.0f, -1.0f);
        this.animator.rotate(this.leftShoulder, 1.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightForearm, 0.5f, 0.0f, -0.75f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 2.0f, 0.0f, -0.5f);
        this.animator.endPhase();
        this.animator.resetPhase(40);
    }

    private void animateDeath() {
        this.animator.setAnimationID(10);
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 2.0f, 4.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 4.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 4.0f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.5f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, -0.5f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 2.0f, 8.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 8.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 8.0f);
        this.animator.rotate(this.rightThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.5f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, -0.5f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.5f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 2.0f, 9.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 9.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 9.0f);
        this.animator.rotate(this.rightThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.35f, 0.4f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.35f, -0.4f, 0.0f);
        this.animator.rotate(this.rightForearm, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 2.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(80);
        this.animator.move(this.torso, 0.0f, 10.0f, 1.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 1.4f, -0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, 1.4f, 0.5f, 0.0f);
        this.animator.rotate(this.rightCalf, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 0.9f, 0.0f);
        this.animator.rotate(this.topBody, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 1.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.5f, 0.0f, -0.5f);
        this.animator.rotate(this.leftShoulder, -1.5f, 0.0f, 0.5f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.25f, 0.0f, 0.0f);
        this.animator.move(this.heldItem, 0.0f, 0.0f, 30.0f);
        this.animator.endPhase();
        this.animator.startPhase(100);
        this.animator.move(this.torso, 0.0f, 10.0f, 1.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 1.6f, -0.5f, 0.0f);
        this.animator.rotate(this.leftThigh, 1.6f, 0.5f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 0.9f, 0.0f);
        this.animator.rotate(this.topBody, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 1.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.3f, 0.0f, -0.5f);
        this.animator.rotate(this.leftShoulder, -1.3f, 0.0f, 0.5f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.heldItem, 0.0f, 0.0f, 30.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(1700);
        this.animator.resetPhase(0);
    }

    private void animateRoar() {
        this.animator.setAnimationID(11);
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, -0.75f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.75f);
        this.animator.rotate(this.heldItem, 0.0f, 0.0f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(5);
        this.animator.move(this.torso, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.25f, 0.25f);
        this.animator.rotate(this.leftThigh, -0.25f, -0.25f, -0.25f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.25f, 1.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.25f, -1.0f, 0.0f);
        this.animator.rotate(this.rightForearm, 0.0f, -1.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 1.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(5);
        this.animator.move(this.torso, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.25f, 0.25f);
        this.animator.rotate(this.leftThigh, -0.25f, -0.25f, -0.25f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.25f, 1.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.25f, -1.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(140);
        this.animator.resetPhase(40);
    }

    private void animateRangedAttackThrow() {
        this.animator.setAnimationID(12);
        this.animator.startPhase(25);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(25);
        this.animator.move(this.torso, 0.0f, 2.0f, 5.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 5.5f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 5.5f);
        this.animator.rotate(this.rightThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.65f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, -1.5f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.75f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.75f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.5f, 0.0f, 0.8f);
        this.animator.rotate(this.leftShoulder, -0.5f, 0.0f, -0.8f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, -0.8f);
        this.animator.rotate(this.leftForearm, -0.25f, 0.0f, 0.8f);
        this.animator.rotate(this.heldItem, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 1.0f, -5.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, -5.5f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, -5.5f);
        this.animator.rotate(this.rightThigh, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 4.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(20);
        this.animator.resetPhase(20);
    }

    private void animateBirth() {
        this.animator.setAnimationID(13);
        this.animator.startPhase(0);
        this.animator.move(this.torso, 0.0f, 11.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -1.4f, 1.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.4f, -1.25f, 0.0f);
        this.animator.rotate(this.rightCalf, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.75f, -0.75f);
        this.animator.rotate(this.leftShoulder, 0.0f, -0.75f, 0.75f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 3.0f, 0.25f, -0.5f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(60);
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 11.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 10.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -1.4f, 1.25f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.4f, -1.25f, 0.0f);
        this.animator.rotate(this.rightCalf, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.75f, 0.75f, -0.75f);
        this.animator.rotate(this.leftShoulder, 0.0f, -0.75f, 0.75f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 3.0f, 0.25f, -0.5f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 7.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 7.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.0f, -1.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 2.3f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 1.3f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -1.25f, 0.75f, -0.75f);
        this.animator.rotate(this.leftShoulder, -0.5f, -0.75f, 0.75f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 1.75f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 3.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 5.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 5.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 5.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 1.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 1.3f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.6f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, -0.5f, 0.75f, -0.75f);
        this.animator.rotate(this.leftShoulder, 0.0f, -0.75f, 0.75f);
        this.animator.rotate(this.rightForearm, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 3.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 3.0f, 6.0f);
        this.animator.move(this.rightThigh, 0.0f, 3.0f, 6.0f);
        this.animator.move(this.leftThigh, 0.0f, 3.0f, 6.0f);
        this.animator.rotate(this.rightThigh, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.0f, 0.0f, 0.5f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.5f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, -0.5f, 0.0f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 2.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(20);
        this.animator.move(this.torso, 0.0f, 0.0f, -4.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, -4.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, -4.0f);
        this.animator.rotate(this.rightThigh, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.0f, 0.0f, -0.5f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 1.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(40);
        this.animator.move(this.torso, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.torso, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 0.0f, 0.0f);
        this.animator.rotate(this.heldItem, 0.0f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(10);
        this.animator.move(this.torso, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leftThigh, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.8f, 0.5f, 0.5f);
        this.animator.rotate(this.leftShoulder, 0.8f, -0.5f, -0.5f);
        this.animator.rotate(this.rightForearm, -1.6f, 0.0f, -0.75f);
        this.animator.rotate(this.leftForearm, -1.6f, 0.0f, 0.75f);
        this.animator.rotate(this.heldItem, 0.0f, 0.0f, 0.75f);
        this.animator.endPhase();
        this.animator.startPhase(5);
        this.animator.move(this.torso, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.25f, 0.25f);
        this.animator.rotate(this.leftThigh, -0.25f, -0.25f, -0.25f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.25f, 1.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.25f, -1.0f, 0.0f);
        this.animator.rotate(this.rightForearm, 0.0f, -1.0f, 0.0f);
        this.animator.rotate(this.leftForearm, 0.0f, 1.0f, 0.0f);
        this.animator.endPhase();
        this.animator.startPhase(5);
        this.animator.move(this.torso, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.rightThigh, 0.0f, 2.0f, 0.0f);
        this.animator.move(this.leftThigh, 0.0f, 2.0f, 0.0f);
        this.animator.rotate(this.rightThigh, -0.25f, 0.25f, 0.25f);
        this.animator.rotate(this.leftThigh, -0.25f, -0.25f, -0.25f);
        this.animator.rotate(this.rightCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.leftCalf, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.topBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.middleBody, -0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.rightShoulder, 0.5f, 1.0f, 0.0f);
        this.animator.rotate(this.leftShoulder, 0.5f, -1.0f, 0.0f);
        this.animator.rotate(this.rightForearm, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.leftForearm, -0.75f, 0.0f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(80);
        this.animator.resetPhase(40);
    }
}

