/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.byAqua3.thetitansneo.entity.titan.EntityBlazeTitan;
import net.byAqua3.thetitansneo.model.ModelBlazeTitan;
import net.byAqua3.thetitansneo.render.layer.LayerBlazeTitanArmor;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderBlazeTitan
extends LivingEntityRenderer<EntityBlazeTitan, ModelBlazeTitan> {
    public static final ResourceLocation BLAZE_TITAN = ResourceLocation.withDefaultNamespace((String)"textures/entity/blaze.png");

    public RenderBlazeTitan(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelBlazeTitan(0.0f), 0.5f);
        this.addLayer(new LayerBlazeTitanArmor((RenderLayerParent<EntityBlazeTitan, ModelBlazeTitan>)this));
    }

    public void render(EntityBlazeTitan entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    protected void scale(EntityBlazeTitan entity, PoseStack poseStack, float partialTick) {
        int i2;
        float f1 = 16.0f;
        int i = entity.getInvulTime();
        if (i > 0) {
            f1 -= ((float)i - partialTick) / 440.0f * 7.75f;
        }
        if (i > 900) {
            poseStack.scale(1.0f, -1.0f, 1.0f);
        }
        if ((i2 = entity.getExtraPower()) > 0) {
            f1 += (float)i2 * 0.5f;
        }
        poseStack.scale(f1, f1, f1);
        poseStack.translate(0.0f, 1.26f, 0.0f);
    }

    protected float getShadowRadius(EntityBlazeTitan entity) {
        return this.shadowRadius * entity.getBbWidth();
    }

    protected boolean shouldShowName(EntityBlazeTitan entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(EntityBlazeTitan entity) {
        return BLAZE_TITAN;
    }
}

