/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossus;
import net.byAqua3.thetitansneo.model.ModelEnderColossus;
import net.byAqua3.thetitansneo.render.layer.LayerEnderColossusEyes;
import net.byAqua3.thetitansneo.render.layer.LayerEnderColossusEyesLaser;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderEnderColossus
extends LivingEntityRenderer<EntityEnderColossus, ModelEnderColossus> {
    public static final ResourceLocation ENDER_COLOSSUS = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/ender_colossus.png");
    public static final ResourceLocation ENDER_COLOSSUS_DEAD = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/ender_colossus_dead.png");
    public static final ResourceLocation ENDER_COLOSSUS_EYES = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/ender_colossus_eyes.png");
    public static final ResourceLocation ENDER_COLOSSUS_EYES_DEAD = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/ender_colossus_eyes_dead.png");
    public static final ResourceLocation ENDER_COLOSSUS_EYES_BEAM = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/ender_colossus_beam.png");

    public RenderEnderColossus(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelEnderColossus(), 0.5f);
        this.addLayer(new LayerEnderColossusEyes((RenderLayerParent<EntityEnderColossus, ModelEnderColossus>)this));
        this.addLayer(new LayerEnderColossusEyesLaser((RenderLayerParent<EntityEnderColossus, ModelEnderColossus>)this));
    }

    public void render(EntityEnderColossus entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        ((ModelEnderColossus)this.model).isAttacking = entity.isScreaming();
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    protected void scale(EntityEnderColossus entity, PoseStack poseStack, float partialTick) {
        int i2;
        float f1 = 24.0f;
        int i = entity.getInvulTime();
        if (i > 0) {
            f1 -= ((float)i - partialTick) / 440.0f * 7.75f;
        }
        if ((i2 = entity.getExtraPower()) > 0) {
            f1 += (float)i2 * 0.5f;
        }
        poseStack.scale(f1, f1, f1);
        poseStack.translate(0.0f, 0.015f, 0.0f);
        if (entity.isPassenger()) {
            poseStack.translate(0.0f, 0.1f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
    }

    protected float getShadowRadius(EntityEnderColossus entity) {
        return this.shadowRadius * entity.getBbWidth();
    }

    protected boolean shouldShowName(EntityEnderColossus entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(EntityEnderColossus entity) {
        return entity.getAnimationID() == 10 && entity.deathTicks > 200 ? ENDER_COLOSSUS_DEAD : ENDER_COLOSSUS;
    }
}

