/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.byAqua3.thetitansneo.entity.titan.EntityGhastTitan;
import net.byAqua3.thetitansneo.model.ModelGhastTitan;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderGhastTitan
extends LivingEntityRenderer<EntityGhastTitan, ModelGhastTitan> {
    public static final ResourceLocation GHAST_TITAN = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/ghast_titan.png");
    public static final ResourceLocation GHAST_TITAN_SHOOTING = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/ghast_titan_shooting.png");

    public RenderGhastTitan(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelGhastTitan(), 4.0f);
    }

    public void render(EntityGhastTitan entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    protected void scale(EntityGhastTitan entity, PoseStack poseStack, float partialTick) {
        int i2;
        float f1 = ((float)entity.prevAttackCounter + (float)(entity.attackCounter - entity.prevAttackCounter) * partialTick) / 20.0f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        f1 = 1.0f / (f1 * f1 * f1 * f1 * f1 * 2.0f + 1.0f);
        float f2 = (8.0f + f1) / 2.0f;
        float f3 = (8.0f + 1.0f / f1) / 2.0f;
        poseStack.scale(f3, f2, f3);
        float f11 = 24.0f;
        int i = entity.getInvulTime();
        if (i > 0) {
            f11 -= ((float)i - partialTick) / 440.0f * 7.75f;
        }
        if ((i2 = entity.getExtraPower()) > 0) {
            f1 += (float)i2 * 0.5f;
        }
        poseStack.scale(f11, f11, f11);
        poseStack.translate(0.0f, 0.01f, 0.0f);
    }

    protected float getShadowRadius(EntityGhastTitan entity) {
        return this.shadowRadius * entity.getBbWidth();
    }

    protected boolean shouldShowName(EntityGhastTitan entity) {
        return false;
    }

    public boolean shouldRender(EntityGhastTitan livingEntity, Frustum camera, double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public ResourceLocation getTextureLocation(EntityGhastTitan entity) {
        return entity.isCharging() ? GHAST_TITAN_SHOOTING : GHAST_TITAN;
    }
}

