/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.byAqua3.thetitansneo.entity.titan.EntityItemTitan;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

@OnlyIn(value=Dist.CLIENT)
public class RenderItemTitan
extends EntityRenderer<EntityItemTitan> {
    private final RandomSource random = RandomSource.create();
    private final ItemRenderer itemRenderer;

    public RenderItemTitan(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
        this.shadowRadius = 2.4f;
        this.shadowStrength = 0.75f;
    }

    public static int getRenderedAmount(int count) {
        if (count <= 1) {
            return 1;
        }
        if (count <= 16) {
            return 2;
        }
        if (count <= 32) {
            return 3;
        }
        return count <= 48 ? 4 : 5;
    }

    public void render(EntityItemTitan entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        poseStack.pushPose();
        ItemStack itemStack = entity.getItem();
        this.random.setSeed((long)ItemEntityRenderer.getSeedForItemStack((ItemStack)itemStack));
        BakedModel bakedmodel = this.itemRenderer.getModel(itemStack, entity.level(), null, entity.getId());
        boolean flag = bakedmodel.isGui3d();
        boolean shouldBob = IClientItemExtensions.of((ItemStack)itemStack).shouldBobAsEntity(itemStack);
        float f = shouldBob ? Mth.sin((float)(((float)entity.getAge() + partialTicks) / 10.0f + entity.bobOffs)) * 0.1f + 0.1f : 0.0f;
        float f1 = bakedmodel.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
        poseStack.scale(16.0f, 16.0f, 16.0f);
        poseStack.translate(0.0f, -0.1f, 0.0f);
        poseStack.translate(0.0f, f + 0.25f * f1, 0.0f);
        float f2 = entity.getSpin(partialTicks);
        poseStack.mulPose(Axis.YP.rotation(f2));
        RenderItemTitan.renderMultipleFromCount(this.itemRenderer, poseStack, multiBufferSource, packedLight, itemStack, bakedmodel, flag, this.random);
        poseStack.popPose();
    }

    public static void renderMultipleFromCount(ItemRenderer itemRenderer, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, ItemStack stack, BakedModel bakedModel, boolean isGui3d, RandomSource random) {
        int i = RenderItemTitan.getRenderedAmount(stack.getCount());
        float f = bakedModel.getTransforms().ground.scale.x();
        float f1 = bakedModel.getTransforms().ground.scale.y();
        float f2 = bakedModel.getTransforms().ground.scale.z();
        if (!isGui3d) {
            float f3 = -0.0f * (float)(i - 1) * 0.5f * f;
            float f4 = -0.0f * (float)(i - 1) * 0.5f * f1;
            float f5 = -0.09375f * (float)(i - 1) * 0.5f * f2;
            poseStack.translate(f3, f4, f5);
        }
        boolean shouldSpread = IClientItemExtensions.of((ItemStack)stack).shouldSpreadAsEntity(stack);
        for (int j = 0; j < i; ++j) {
            poseStack.pushPose();
            if (j > 0 && shouldSpread) {
                if (isGui3d) {
                    float f7 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f9 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f6 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    poseStack.translate(f7, f9, f6);
                } else {
                    float f8 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    float f10 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    poseStack.translate(f8, f10, 0.0f);
                }
            }
            itemRenderer.render(stack, ItemDisplayContext.GROUND, false, poseStack, multiBufferSource, packedLight, OverlayTexture.NO_OVERLAY, bakedModel);
            poseStack.popPose();
            if (isGui3d) continue;
            poseStack.translate(0.0f * f, 0.0f * f1, 0.09375f * f2);
        }
    }

    public ResourceLocation getTextureLocation(EntityItemTitan pEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

