/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.byAqua3.thetitansneo.entity.titan.EntitySkeletonTitan;
import net.byAqua3.thetitansneo.model.ModelSkeletonTitan;
import net.byAqua3.thetitansneo.render.layer.LayerSkeletonTitanArmor;
import net.byAqua3.thetitansneo.render.layer.LayerSkeletonTitanItemInHand;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderSkeletonTitan
extends LivingEntityRenderer<EntitySkeletonTitan, ModelSkeletonTitan> {
    public static final ResourceLocation SKELETON_TITAN = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/skeleton_titan.png");
    public static final ResourceLocation SKELETON_TITAN_PULL_0 = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/skeleton_titan_pulling_0.png");
    public static final ResourceLocation SKELETON_TITAN_PULL_1 = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/skeleton_titan_pulling_1.png");
    public static final ResourceLocation SKELETON_TITAN_PULL_2 = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/skeleton_titan_pulling_2.png");
    public static final ResourceLocation SKELETON_TITAN_BROKEN_BOW = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/skeleton_titan_broken_bow.png");
    public static final ResourceLocation WITHER_SKELETON_TITAN = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/wither_skeleton_titan.png");

    public RenderSkeletonTitan(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelSkeletonTitan(0.0f), 0.5f);
        this.addLayer(new LayerSkeletonTitanItemInHand((RenderLayerParent<EntitySkeletonTitan, ModelSkeletonTitan>)this));
        this.addLayer(new LayerSkeletonTitanArmor((RenderLayerParent<EntitySkeletonTitan, ModelSkeletonTitan>)this));
    }

    public void render(EntitySkeletonTitan entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        ((ModelSkeletonTitan)this.getModel()).isWither = entity.getSkeletonType() == 1;
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    protected void scale(EntitySkeletonTitan entity, PoseStack poseStack, float partialTick) {
        int i2;
        float f1 = entity.getSkeletonType() == 1 ? 28.0f : 16.0f;
        int i = entity.getInvulTime();
        if (i > 0) {
            f1 -= ((float)i - partialTick) / 440.0f * 7.75f;
        }
        if ((i2 = entity.getExtraPower()) > 0) {
            f1 += (float)i2 * 0.5f;
        }
        poseStack.scale(f1, f1, f1);
        poseStack.translate(0.0f, 0.0075f, 0.0f);
    }

    protected float getShadowRadius(EntitySkeletonTitan entity) {
        return this.shadowRadius * entity.getBbWidth();
    }

    protected boolean shouldShowName(EntitySkeletonTitan entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(EntitySkeletonTitan entity) {
        return entity.getSkeletonType() == 1 ? WITHER_SKELETON_TITAN : (entity.attackTimer < 20 && entity.attackTimer >= 10 ? SKELETON_TITAN_PULL_0 : (entity.attackTimer < 30 && entity.attackTimer >= 20 ? SKELETON_TITAN_PULL_1 : (entity.attackTimer >= 30 ? SKELETON_TITAN_PULL_2 : (entity.isStunned ? SKELETON_TITAN_BROKEN_BOW : SKELETON_TITAN))));
    }
}

