/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.thetitansneo.entity.titan.EntityWitherzilla;
import net.byAqua3.thetitansneo.loader.TheTitansNeoRenderTypes;
import net.byAqua3.thetitansneo.model.ModelWitherzilla;
import net.byAqua3.thetitansneo.render.layer.LayerWitherzillaArmor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RenderWitherzilla
extends LivingEntityRenderer<EntityWitherzilla, ModelWitherzilla> {
    public static final ResourceLocation WITHERZILLA = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/witherzilla.png");
    public static final ResourceLocation WITHERZILLA_OMEGA = ResourceLocation.tryBuild((String)"thetitansneo", (String)"textures/entity/titans/witherzilla_omega.png");
    private final BlockRenderDispatcher blockRenderer;

    public RenderWitherzilla(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelWitherzilla(0.0f), 1.0f);
        this.blockRenderer = context.getBlockRenderDispatcher();
        this.addLayer(new LayerWitherzillaArmor((RenderLayerParent<EntityWitherzilla, ModelWitherzilla>)this));
    }

    private static void renderRays(PoseStack poseStack, float dragonDeathCompletion, int color, VertexConsumer vertexConsumer) {
        poseStack.pushPose();
        float f = Math.min(dragonDeathCompletion > 0.8f ? (dragonDeathCompletion - 0.8f) / 0.2f : 0.0f, 1.0f);
        int i = FastColor.ARGB32.colorFromFloat((float)(1.0f - f), (float)1.0f, (float)1.0f, (float)1.0f);
        RandomSource randomSource = RandomSource.create((long)432L);
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f1 = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Quaternionf quaternionf = new Quaternionf();
        int k = Mth.floor((float)((dragonDeathCompletion + dragonDeathCompletion * dragonDeathCompletion) / 2.0f * 100.0f));
        for (int l = 0; l < k; ++l) {
            quaternionf.rotationXYZ(randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2)).rotateXYZ(randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2) + dragonDeathCompletion * 1.5707964f);
            poseStack.mulPose(quaternionf);
            float f1 = randomSource.nextFloat() * 20.0f + 5.0f + f * 10.0f;
            float f2 = randomSource.nextFloat() * 2.0f + 1.0f + f * 2.0f;
            vector3f1.set(-((float)(Math.sqrt(3.0) / 2.0)) * f2, f1, -0.5f * f2);
            vector3f2.set((float)(Math.sqrt(3.0) / 2.0) * f2, f1, -0.5f * f2);
            vector3f3.set(0.0f, f1, f2);
            PoseStack.Pose poseStack$pose = poseStack.last();
            vertexConsumer.addVertex(poseStack$pose, vector3f).setColor(i);
            vertexConsumer.addVertex(poseStack$pose, vector3f1).setColor(FastColor.ARGB32.color((int)0, (int)14809319));
            vertexConsumer.addVertex(poseStack$pose, vector3f2).setColor(FastColor.ARGB32.color((int)0, (int)14809319));
            vertexConsumer.addVertex(poseStack$pose, vector3f).setColor(i);
            vertexConsumer.addVertex(poseStack$pose, vector3f2).setColor(FastColor.ARGB32.color((int)0, (int)14809319));
            vertexConsumer.addVertex(poseStack$pose, vector3f3).setColor(FastColor.ARGB32.color((int)0, (int)14809319));
            vertexConsumer.addVertex(poseStack$pose, vector3f).setColor(i);
            vertexConsumer.addVertex(poseStack$pose, vector3f3).setColor(FastColor.ARGB32.color((int)0, (int)14809319));
            vertexConsumer.addVertex(poseStack$pose, vector3f1).setColor(FastColor.ARGB32.color((int)0, (int)14809319));
        }
        poseStack.popPose();
    }

    public void render(EntityWitherzilla entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        poseStack.pushPose();
        float f8 = entity.getScale();
        poseStack.scale(f8, f8, f8);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale(entity, poseStack, partialTicks);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        poseStack.translate(0.0f, -2.0f, 0.0f);
        poseStack.scale(0.15f, 0.15f, 0.15f);
        Minecraft mc = Minecraft.getInstance();
        Block block = Blocks.GLOWSTONE;
        BlockState blockState = block.defaultBlockState();
        BakedModel bakedModel = this.blockRenderer.getBlockModel(blockState);
        int i = LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        mc.gameRenderer.lightTexture().turnOnLightLayer();
        this.blockRenderer.getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), blockState, bakedModel, 1.0f, 1.0f, 1.0f, LightTexture.pack((int)blockState.getLightBlock((BlockGetter)entity.level(), entity.blockPosition()), (int)this.getSkyLightLevel((Entity)entity, entity.blockPosition())), i);
        mc.gameRenderer.lightTexture().turnOffLightLayer();
        if (entity.affectTicks > 0 && entity.getInvulTime() < 1) {
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.scale(3.0f, 3.0f, 3.0f);
            float f = ((float)entity.affectTicks + partialTicks) / 1000.0f;
            float f2 = 0.0f;
            if (f > 0.8f) {
                f2 = (f - 0.8f) / 0.2f;
            }
            int i2 = FastColor.ARGB32.color((int)Mth.floor((float)(255.0f * (1.0f - f2))), (int)14809319);
            RenderWitherzilla.renderRays(poseStack, f, i2, multiBufferSource.getBuffer(TheTitansNeoRenderTypes.WITHERZILLA_RAYS));
            RenderWitherzilla.renderRays(poseStack, f, i2, multiBufferSource.getBuffer(TheTitansNeoRenderTypes.WITHERZILLA_RAYS_DEPTH));
        }
        poseStack.popPose();
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    protected void scale(EntityWitherzilla entity, PoseStack poseStack, float partialTick) {
        int i2;
        float f1 = entity.isInOmegaForm() ? 256.0f : 128.0f;
        int i = entity.getInvulTime();
        if (i > 0) {
            f1 -= ((float)i - partialTick) / 440.0f * 7.75f;
        }
        if ((i2 = entity.getExtraPower()) > 0) {
            f1 += (float)i2 * 0.5f;
        }
        poseStack.scale(f1, f1, f1);
        poseStack.translate(0.0f, 0.01f, 0.0f);
    }

    protected boolean shouldShowName(EntityWitherzilla entity) {
        return false;
    }

    public boolean shouldRender(EntityWitherzilla livingEntity, Frustum camera, double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public ResourceLocation getTextureLocation(EntityWitherzilla entity) {
        return WITHERZILLA;
    }
}

