/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render.item;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.byAqua3.thetitansneo.item.ItemTitanSpawnEgg;
import net.byAqua3.thetitansneo.loader.TheTitansNeoConfigs;
import net.byAqua3.thetitansneo.loader.TheTitansNeoEntities;
import net.byAqua3.thetitansneo.model.ModelTitanSpawnEgg;
import net.byAqua3.thetitansneo.render.item.IItemRenderer;
import net.byAqua3.thetitansneo.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class RenderTitanSpawnEgg
implements IItemRenderer {
    public ModelTitanSpawnEgg model = new ModelTitanSpawnEgg();

    public void renderItem(ResourceLocation itemTexture, boolean itemFlipped, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.getInstance();
        TextureAtlas textureAtlas = mc.getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
        poseStack.pushPose();
        this.model.item.translateAndRotate(poseStack);
        if (itemFlipped) {
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            poseStack.translate(0.0f, 0.5f, 0.0f);
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(-120.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.translate(0.325f, -0.5f, 0.0f);
        poseStack.scale(0.68f, 0.68f, 0.68f);
        poseStack.translate(0.070625f, 0.2f, 0.070625f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(25.0f));
        TextureAtlasSprite textureAtlasSprite = textureAtlas.getSprite(itemTexture);
        List<BakedQuad> quads = RenderUtils.bakeItem(textureAtlasSprite);
        PoseStack.Pose poseStack$pose = poseStack.last();
        for (BakedQuad quad : quads) {
            vertexConsumer.putBulkData(poseStack$pose, quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.NO_OVERLAY, true);
        }
        poseStack.popPose();
    }

    public void renderFire(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.getInstance();
        BlockRenderDispatcher blockRenderDispatcher = mc.getBlockRenderer();
        poseStack.pushPose();
        this.model.fire.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.34375f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.scale(0.8f, -0.625f, -0.8f);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        Block block = Blocks.FIRE;
        BlockState blockState = block.defaultBlockState();
        BakedModel bakedModel = blockRenderDispatcher.getBlockModel(blockState);
        PoseStack.Pose poseStack$pose = poseStack.last();
        blockRenderDispatcher.getModelRenderer().renderModel(poseStack$pose, vertexConsumer, blockState, bakedModel, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay, ModelData.EMPTY, null);
        poseStack.popPose();
    }

    @Override
    public void render(ItemStack stack, ItemDisplayContext context, boolean leftHand, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, BakedModel bakedModel) {
        MultiBufferSource.BufferSource bufferSource;
        VertexConsumer vertexConsumer;
        Minecraft mc = Minecraft.getInstance();
        Item item = stack.getItem();
        this.model.ticksExisted = mc.player.tickCount;
        ResourceLocation texture = null;
        ResourceLocation itemTexture = null;
        boolean itemFlipped = false;
        if (item instanceof ItemTitanSpawnEgg) {
            ItemTitanSpawnEgg spawnEgg = (ItemTitanSpawnEgg)item;
            EntityType<?> entityType = spawnEgg.getEntityType();
            if (entityType == TheTitansNeoEntities.SNOW_GOLEM_TITAN.get()) {
                this.model.eggType = 0;
                texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/snow_golem_titan_egg");
            } else if (entityType == TheTitansNeoEntities.SLIME_TITAN.get()) {
                this.model.eggType = 0;
                texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/slime_titan_egg");
            } else if (entityType == TheTitansNeoEntities.MAGMACUBE_TITAN.get()) {
                this.model.eggType = 0;
                texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/magma_cube_titan_egg");
            } else if (entityType == TheTitansNeoEntities.OMEGAFISH.get()) {
                this.model.eggType = 3;
                texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/omegafish_egg");
            } else if (entityType == TheTitansNeoEntities.ZOMBIE_TITAN.get()) {
                this.model.eggType = 0;
                texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/zombie_titan_egg");
            } else if (entityType == TheTitansNeoEntities.SKELETON_TITAN.get()) {
                if (spawnEgg.getSpecialId() == 1) {
                    this.model.eggType = 4;
                    texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/wither_skeleton_titan_egg");
                    itemTexture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"item/stone_sword_256");
                } else {
                    this.model.eggType = 4;
                    texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/skeleton_titan_egg");
                    itemTexture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"item/bow_pulling_2_256");
                    itemFlipped = true;
                }
            } else if (entityType == TheTitansNeoEntities.CREEPER_TITAN.get()) {
                if (spawnEgg.getSpecialId() == 1) {
                    this.model.eggType = 1;
                    texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/charged_creeper_titan_egg");
                } else {
                    this.model.eggType = 0;
                    texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/creeper_titan_egg");
                }
            } else if (entityType == TheTitansNeoEntities.SPIDER_TITAN.get()) {
                if (spawnEgg.getSpecialId() == 1) {
                    this.model.eggType = 4;
                    texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/spider_jockey_titan_egg");
                    itemTexture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"item/bow_pulling_2_256");
                    itemFlipped = true;
                } else {
                    this.model.eggType = 0;
                    texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/spider_titan_egg");
                }
            } else if (entityType == TheTitansNeoEntities.CAVE_SPIDER_TITAN.get()) {
                this.model.eggType = 0;
                texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/cave_spider_titan_egg");
            } else if (entityType == TheTitansNeoEntities.ZOMBIFIED_PIGLIN_TITAN.get()) {
                this.model.eggType = 4;
                texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/zombified_piglin_titan_egg");
                itemTexture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"item/gold_sword_256");
            } else if (entityType == TheTitansNeoEntities.BLAZE_TITAN.get()) {
                this.model.eggType = 2;
                texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/blaze_titan_egg");
            } else if (entityType == TheTitansNeoEntities.ENDER_COLOSSUS.get()) {
                this.model.eggType = 5;
                texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/ender_colossus_egg");
            } else if (entityType == TheTitansNeoEntities.GHAST_TITAN.get()) {
                this.model.eggType = 3;
                texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/ghast_titan_egg");
            } else if (entityType == TheTitansNeoEntities.IRON_GOLEM_TITAN.get()) {
                this.model.eggType = 0;
                texture = ResourceLocation.tryBuild((String)"thetitansneo", (String)"entity/items/eggs/iron_golem_titan_egg");
            }
        }
        if (((Boolean)TheTitansNeoConfigs.titanWeaponOldModel.get()).booleanValue()) {
            if (!this.model.item.visible) {
                this.model.item.visible = true;
            }
        } else if (itemTexture != null) {
            vertexConsumer = multiBufferSource.getBuffer(Sheets.translucentItemSheet());
            this.model.item.visible = false;
            switch (context) {
                case FIRST_PERSON_LEFT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(190.0f));
                    poseStack.translate(0.57f, -0.8f, 0.1f);
                    this.renderItem(itemTexture, itemFlipped, poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case FIRST_PERSON_RIGHT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(190.0f));
                    poseStack.translate(-0.55f, -0.8f, 0.1f);
                    this.renderItem(itemTexture, itemFlipped, poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case THIRD_PERSON_LEFT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.translate(0.1f, -0.7f, -0.4f);
                    this.renderItem(itemTexture, itemFlipped, poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case THIRD_PERSON_RIGHT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.translate(0.1f, -0.7f, -0.4f);
                    this.renderItem(itemTexture, itemFlipped, poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case GROUND: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    poseStack.translate(-0.15f, -0.6f, 0.2f);
                    this.renderItem(itemTexture, itemFlipped, poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case GUI: {
                    poseStack.pushPose();
                    poseStack.scale(0.7f, 0.65f, 0.65f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
                    poseStack.translate(0.05f, -0.75f, 0.3f);
                    Lighting.setupForFlatItems();
                    this.renderItem(itemTexture, itemFlipped, poseStack, vertexConsumer, packedLight, packedOverlay);
                    RenderSystem.disableDepthTest();
                    if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
                        bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
                        bufferSource.endBatch();
                    }
                    RenderSystem.enableDepthTest();
                    Lighting.setupFor3DItems();
                    poseStack.popPose();
                    break;
                }
                case FIXED: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    poseStack.translate(-0.9f, -0.5f, 0.25f);
                    this.renderItem(itemTexture, itemFlipped, poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
            }
        }
        if (this.model.eggType == 2) {
            vertexConsumer = multiBufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
            this.model.fire.visible = false;
            switch (context) {
                case FIRST_PERSON_LEFT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(190.0f));
                    poseStack.translate(1.12f, -0.4f, 0.1f);
                    this.renderFire(poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case FIRST_PERSON_RIGHT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(190.0f));
                    poseStack.translate(0.0f, -0.4f, 0.1f);
                    this.renderFire(poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case THIRD_PERSON_LEFT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.translate(0.5f, -0.3f, -0.2f);
                    this.renderFire(poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case THIRD_PERSON_RIGHT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.translate(0.5f, -0.3f, -0.2f);
                    this.renderFire(poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case GROUND: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    poseStack.translate(0.5f, -0.3f, 0.4f);
                    this.renderFire(poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case GUI: {
                    poseStack.pushPose();
                    poseStack.scale(0.7f, 0.7f, 0.7f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
                    poseStack.translate(0.2f, -0.35f, 0.8f);
                    Lighting.setupForFlatItems();
                    this.renderFire(poseStack, vertexConsumer, packedLight, packedOverlay);
                    RenderSystem.disableDepthTest();
                    if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
                        bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
                        bufferSource.endBatch();
                    }
                    RenderSystem.enableDepthTest();
                    Lighting.setupFor3DItems();
                    poseStack.popPose();
                    break;
                }
                case FIXED: {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    poseStack.translate(-0.5f, -0.1f, 0.5f);
                    this.renderFire(poseStack, vertexConsumer, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
            }
        }
        if (texture != null) {
            Material material = new Material(InventoryMenu.BLOCK_ATLAS, texture);
            VertexConsumer vertexConsumer2 = material.buffer(multiBufferSource, RenderType::entityTranslucentCull);
            switch (context) {
                case FIRST_PERSON_LEFT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(2.0f, 2.0f, 2.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(190.0f));
                    poseStack.translate(0.56f, -0.4f, 0.1f);
                    this.model.renderToBuffer(poseStack, vertexConsumer2, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case FIRST_PERSON_RIGHT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(2.0f, 2.0f, 2.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(190.0f));
                    poseStack.translate(0.0f, -0.4f, 0.1f);
                    this.model.renderToBuffer(poseStack, vertexConsumer2, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case THIRD_PERSON_LEFT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(2.0f, 2.0f, 2.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.translate(0.25f, -0.3f, -0.1f);
                    this.model.renderToBuffer(poseStack, vertexConsumer2, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case THIRD_PERSON_RIGHT_HAND: {
                    poseStack.pushPose();
                    poseStack.scale(2.0f, 2.0f, 2.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.translate(0.25f, -0.3f, -0.1f);
                    this.model.renderToBuffer(poseStack, vertexConsumer2, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case GROUND: {
                    poseStack.pushPose();
                    poseStack.scale(2.0f, 2.0f, 2.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    poseStack.translate(0.25f, -0.3f, 0.2f);
                    this.model.renderToBuffer(poseStack, vertexConsumer2, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
                case GUI: {
                    poseStack.pushPose();
                    poseStack.scale(1.25f, 1.25f, 1.25f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
                    poseStack.translate(0.25f, -0.45f, 0.3f);
                    Lighting.setupForFlatItems();
                    this.model.renderToBuffer(poseStack, vertexConsumer2, packedLight, packedOverlay);
                    RenderSystem.disableDepthTest();
                    if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
                        MultiBufferSource.BufferSource bufferSource2 = (MultiBufferSource.BufferSource)multiBufferSource;
                        bufferSource2.endBatch();
                    }
                    RenderSystem.enableDepthTest();
                    Lighting.setupFor3DItems();
                    poseStack.popPose();
                    break;
                }
                case FIXED: {
                    poseStack.pushPose();
                    poseStack.scale(2.0f, 2.0f, 2.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    poseStack.translate(-0.25f, -0.25f, 0.25f);
                    this.model.renderToBuffer(poseStack, vertexConsumer2, packedLight, packedOverlay);
                    poseStack.popPose();
                    break;
                }
            }
        }
    }
}

