/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.thetitansneo.entity.titan.EntityEnderColossus;
import net.byAqua3.thetitansneo.model.ModelEnderColossus;
import net.byAqua3.thetitansneo.render.RenderEnderColossus;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerEnderColossusEyesLaser
extends RenderLayer<EntityEnderColossus, ModelEnderColossus> {
    public LayerEnderColossusEyesLaser(RenderLayerParent<EntityEnderColossus, ModelEnderColossus> renderer) {
        super(renderer);
    }

    private Vec3 getEntityInterpolatedPosition(EntityEnderColossus entity, double y, float partialTicks) {
        double d1 = entity.xOld + (entity.getX() - entity.xOld) * (double)partialTicks;
        double d2 = y + entity.yOld + (entity.getY() - entity.yOld) * (double)partialTicks;
        double d3 = entity.zOld + (entity.getZ() - entity.zOld) * (double)partialTicks;
        return new Vec3(d1, d2, d3);
    }

    private Vec3 getEntityLookAheadPosition(EntityEnderColossus entity, double y, float partialTicks) {
        Vec3 vec3 = entity.getViewVector(1.0f);
        double dx = vec3.x * 300.0;
        double dy = vec3.y * 300.0;
        double dz = vec3.z * 300.0;
        double d1 = entity.xOld + (entity.getX() + dx - entity.xOld) * (double)partialTicks;
        double d2 = y + entity.yOld + (entity.getY() + dy - entity.yOld) * (double)partialTicks;
        double d3 = entity.zOld + (entity.getZ() + dz - entity.zOld) * (double)partialTicks;
        return new Vec3(d1, d2, d3);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, EntityEnderColossus entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float headYaw, float headPitch) {
        if (entity.isAlive() && entity.getEyeLaserTime() >= 0) {
            poseStack.pushPose();
            float f4 = (float)entity.level().getDayTime() + partialTicks;
            float f5 = f4 * 0.5f % 1.0f;
            float f6 = entity.getEyeHeight();
            poseStack.pushPose();
            ((ModelEnderColossus)this.getParentModel()).bodyBottom.translateAndRotate(poseStack);
            poseStack.pushPose();
            ((ModelEnderColossus)this.getParentModel()).bodyMiddle.translateAndRotate(poseStack);
            ((ModelEnderColossus)this.getParentModel()).bodyTop.translateAndRotate(poseStack);
            ((ModelEnderColossus)this.getParentModel()).mouth.translateAndRotate(poseStack);
            ((ModelEnderColossus)this.getParentModel()).head.translateAndRotate(poseStack);
            poseStack.translate(0.0f, -0.22f, -0.25f);
            Vec3 vec3 = this.getEntityLookAheadPosition(entity, f6, partialTicks);
            Vec3 vec31 = this.getEntityInterpolatedPosition(entity, f6, partialTicks);
            Vec3 vec32 = vec3.subtract(vec31);
            double d3 = vec32.length() + 0.1;
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.energySwirl((ResourceLocation)RenderEnderColossus.ENDER_COLOSSUS_EYES_BEAM, (float)0.0f, (float)0.0f));
            PoseStack.Pose poseStack$pose = poseStack.last();
            double d4 = (double)f4 * 0.005 * -1.5;
            double d15 = Math.cos(d4 * 0.0 + Math.PI) * 0.25;
            double d16 = Math.sin(d4 * 0.0 + Math.PI) * 0.25;
            double d17 = Math.cos(d4 * 0.0 + 0.0) * 0.25;
            double d18 = Math.sin(d4 * 0.0 + 0.0) * 0.25;
            double d25 = -1.0f + f5;
            double d26 = d3 * 2.5 + d25;
            vertexConsumer.addVertex(poseStack$pose, (float)d15, (float)d16, (float)(-d3)).setColor(255, 0, 255, 255).setUv(0.5f, (float)d26).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack$pose, 0.0f, 0.0f, 0.0f);
            vertexConsumer.addVertex(poseStack$pose, (float)d15, (float)d16, 0.0f).setColor(255, 0, 255, 255).setUv(0.5f, (float)d25).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack$pose, 0.0f, 0.0f, 0.0f);
            vertexConsumer.addVertex(poseStack$pose, (float)d17, (float)d18, 0.0f).setColor(255, 0, 255, 255).setUv(0.0f, (float)d25).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack$pose, 0.0f, 0.0f, 0.0f);
            vertexConsumer.addVertex(poseStack$pose, (float)d17, (float)d18, (float)(-d3)).setColor(255, 0, 255, 255).setUv(0.0f, (float)d26).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack$pose, 0.0f, 0.0f, 0.0f);
            poseStack.popPose();
            poseStack.popPose();
            poseStack.popPose();
        }
    }
}

