/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.byAqua3.thetitansneo.entity.titan.EntitySnowGolemTitan;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerSnowGolemTitanHead
extends RenderLayer<EntitySnowGolemTitan, SnowGolemModel<EntitySnowGolemTitan>> {
    private final BlockRenderDispatcher blockRenderer;

    public LayerSnowGolemTitanHead(RenderLayerParent<EntitySnowGolemTitan, SnowGolemModel<EntitySnowGolemTitan>> renderer, BlockRenderDispatcher blockRenderer) {
        super(renderer);
        this.blockRenderer = blockRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, EntitySnowGolemTitan entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float headYaw, float headPitch) {
        Minecraft mc = Minecraft.getInstance();
        if (entity.getTitanHealth() > entity.getMaxHealth() / 4.0f) {
            boolean flag;
            boolean bl = flag = mc.shouldEntityAppearGlowing((Entity)entity) && entity.isInvisible();
            if (!entity.isInvisible() || flag) {
                poseStack.pushPose();
                ((SnowGolemModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
                poseStack.translate(0.0f, -0.34375f, 0.0f);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.scale(0.625f, -0.625f, -0.625f);
                Block block = entity.getTitanHealth() > entity.getMaxHealth() / 2.0f ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN;
                BlockState blockState = block.defaultBlockState();
                BakedModel bakedModel = this.blockRenderer.getBlockModel(blockState);
                int i = LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f);
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                PoseStack.Pose poseStack$pose = poseStack.last();
                mc.gameRenderer.lightTexture().turnOnLightLayer();
                this.blockRenderer.getModelRenderer().renderModel(poseStack$pose, multiBufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), blockState, bakedModel, 1.0f, 1.0f, 1.0f, LightTexture.pack((int)blockState.getLightBlock((BlockGetter)entity.level(), entity.blockPosition()), (int)entity.level().getBrightness(LightLayer.SKY, entity.blockPosition())), i);
                mc.gameRenderer.lightTexture().turnOffLightLayer();
                poseStack.popPose();
            }
        }
    }
}

