/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.thetitansneo.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class EntityUtils {
    public static List<Entity> getEntities(List<Entity> exclude, Player player, double inflateX, double inflateY, double inflateZ, double moveX, double moveY, double moveZ) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Entity entity : player.level().getEntities((Entity)player, player.getBoundingBox().inflate(20000.0, 20000.0, 20000.0))) {
            AABB aabb = entity.getBoundingBox();
            double d1 = Mth.clamp((double)(player.getX() + moveX), (double)aabb.minX, (double)aabb.maxX);
            double d2 = Mth.clamp((double)(player.getY() + moveY), (double)aabb.minY, (double)aabb.maxY);
            double d3 = Mth.clamp((double)(player.getZ() + moveZ), (double)aabb.minZ, (double)aabb.maxZ);
            double d4 = player.getX() + moveX - d1;
            double d5 = player.getY() + moveY - d2;
            double d6 = player.getZ() + moveZ - d3;
            double d7 = Math.abs(d4 * d4);
            double d8 = Math.abs(d5 * d5);
            double d9 = Math.abs(d6 * d6);
            if (exclude.contains(entity) || !(d7 <= inflateX) || !(d8 <= inflateY) || !(d9 <= inflateZ)) continue;
            entities.add(entity);
        }
        return entities;
    }

    public static List<Entity> getEntities(List<Entity> exclude, Player player, double inflateX, double inflateY, double inflateZ) {
        return EntityUtils.getEntities(exclude, player, inflateX, inflateY, inflateZ, 0.0, 0.0, 0.0);
    }

    public static List<Entity> getBigBoxEntities(List<Entity> exclude, Player player, double inflate) {
        return EntityUtils.getEntities(exclude, player, inflate, inflate, inflate);
    }
}

