/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.slotmachine.block.entity;

import java.util.HashMap;
import java.util.UUID;
import net.micaxs.slotmachine.Config;
import net.micaxs.slotmachine.block.entity.ModBlockEntities;
import net.micaxs.slotmachine.screen.SlotMachineMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotMachineBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            SlotMachineBlockEntity.this.m_6596_();
            assert (SlotMachineBlockEntity.this.f_58857_ != null);
            if (!SlotMachineBlockEntity.this.f_58857_.m_5776_()) {
                SlotMachineBlockEntity.this.f_58857_.m_7260_(SlotMachineBlockEntity.this.m_58899_(), SlotMachineBlockEntity.this.m_58900_(), SlotMachineBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> Config.validBetItems.contains(stack.m_41720_());
                case 1 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private final ItemStackHandler ownerItemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            SlotMachineBlockEntity.this.m_6596_();
            assert (SlotMachineBlockEntity.this.f_58857_ != null);
            if (!SlotMachineBlockEntity.this.f_58857_.m_5776_()) {
                SlotMachineBlockEntity.this.f_58857_.m_7260_(SlotMachineBlockEntity.this.m_58899_(), SlotMachineBlockEntity.this.m_58900_(), SlotMachineBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 -> Config.validBetItems.contains(stack.m_41720_());
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    public ItemStack BET_ITEM;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IItemHandler> lazyOwnerItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> SlotMachineBlockEntity.this.stopped;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    SlotMachineBlockEntity.this.stopped = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int slot1;
    private int slot2;
    private int slot3;
    private int stopped;
    private UUID ownerUUID;

    public SlotMachineBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SLOT_MACHINE_BE.get(), pPos, pBlockState);
    }

    public void setOwner(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void dropSlotsMachine(Player player, BlockPos pos) {
        this.drops();
        this.dropOwnerItems();
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, new ItemStack((ItemLike)player.m_9236_().m_8055_(pos).m_60734_().m_5456_()).m_41777_()));
        player.m_9236_().m_7471_(pos, true);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void dropOwnerItems() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            for (int i = 0; i < this.ownerItemHandler.getSlots(); ++i) {
                ItemStack stack = this.ownerItemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), stack);
                this.f_58857_.m_7967_((Entity)itemEntity);
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public LazyOptional<IItemHandler> getOwnerItemHandler() {
        return this.lazyOwnerItemHandler;
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyOwnerItemHandler = LazyOptional.of(() -> this.ownerItemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyOwnerItemHandler.invalidate();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.slotmachinemod.slot_machine");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SlotMachineMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128365_("ownerInventory", (Tag)this.ownerItemHandler.serializeNBT());
        pTag.m_128405_("slot_machine.stopped", this.stopped);
        if (this.ownerUUID != null) {
            pTag.m_128362_("ownerUUID", this.ownerUUID);
        }
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.ownerItemHandler.deserializeNBT(pTag.m_128469_("ownerInventory"));
        this.stopped = pTag.m_128451_("slot_machine.stopped");
        if (pTag.m_128441_("ownerUUID")) {
            this.ownerUUID = pTag.m_128342_("ownerUUID");
        }
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity) {
        SlotMachineBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    private void addToOwnerInventory() {
        ItemStack betItemOwner = new ItemStack((ItemLike)this.BET_ITEM.m_41720_());
        for (int i = 0; i < this.ownerItemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.ownerItemHandler.getStackInSlot(i);
            if (stackInSlot.m_41619_()) {
                this.ownerItemHandler.setStackInSlot(i, betItemOwner);
                break;
            }
            if (!Config.validBetItems.contains(stackInSlot.m_41720_()) || stackInSlot.m_41613_() >= stackInSlot.m_41741_() || stackInSlot.m_41720_() != betItemOwner.m_41720_()) continue;
            stackInSlot.m_41764_(stackInSlot.m_41613_() + 1);
            this.ownerItemHandler.setStackInSlot(i, stackInSlot);
            break;
        }
    }

    private void removeFromOwnerInventory(int amount) {
        Item betItem = this.BET_ITEM.m_41720_();
        for (int i = this.ownerItemHandler.getSlots() - 1; i >= 0 && amount > 0; --i) {
            ItemStack stackInSlot = this.ownerItemHandler.getStackInSlot(i);
            if (stackInSlot.m_41619_() || stackInSlot.m_41720_() != betItem) continue;
            int itemsInSlot = stackInSlot.m_41613_();
            if (itemsInSlot >= amount) {
                stackInSlot.m_41764_(itemsInSlot - amount);
                this.ownerItemHandler.setStackInSlot(i, stackInSlot);
                break;
            }
            amount -= itemsInSlot;
            this.ownerItemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public boolean isSlotMachineInventoryFull() {
        for (int i = 0; i < this.ownerItemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.ownerItemHandler.getStackInSlot(i);
            if (!stackInSlot.m_41619_() && stackInSlot.m_41613_() >= stackInSlot.m_41741_()) continue;
            return false;
        }
        return true;
    }

    private void payout(int slot1, int slot2, int slot3) {
        this.addToOwnerInventory();
        if (slot1 == slot2 && slot2 == slot3) {
            this.removeFromOwnerInventory(Config.triplePayoutAmount);
            ItemStack betItem = this.BET_ITEM;
            betItem.m_41764_(Config.triplePayoutAmount);
            ItemStack outputSlotItem = this.itemHandler.getStackInSlot(1);
            if (outputSlotItem.m_41619_()) {
                this.itemHandler.setStackInSlot(1, betItem);
            } else if (outputSlotItem.m_41720_() == betItem.m_41720_()) {
                outputSlotItem.m_41764_(outputSlotItem.m_41613_() + Config.triplePayoutAmount);
                this.itemHandler.setStackInSlot(1, outputSlotItem);
            }
        } else if (slot1 == slot2 || slot2 == slot3 || slot1 == slot3) {
            this.removeFromOwnerInventory(Config.doublePayoutAmount);
            ItemStack betItem = this.BET_ITEM;
            betItem.m_41764_(Config.doublePayoutAmount);
            ItemStack outputSlotItem = this.itemHandler.getStackInSlot(1);
            if (outputSlotItem.m_41619_()) {
                this.itemHandler.setStackInSlot(1, betItem);
            } else if (outputSlotItem.m_41720_() == betItem.m_41720_()) {
                outputSlotItem.m_41764_(outputSlotItem.m_41613_() + Config.doublePayoutAmount);
                this.itemHandler.setStackInSlot(1, outputSlotItem);
            }
        }
        this.m_6596_();
    }

    private boolean hasCoin() {
        return this.itemHandler.getStackInSlot(0).m_41720_() == Items.f_42415_;
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(1).m_41619_() || this.itemHandler.getStackInSlot(1).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(1).m_41613_() + count <= this.itemHandler.getStackInSlot(1).m_41741_();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int[] stopSpin() {
        double twoSameProbability = Config.doubleWinChance;
        double threeSameProbability = Config.tripleWinChance;
        double random = Math.random();
        if (random < threeSameProbability) {
            this.slot2 = this.slot3 = (int)(Math.random() * 5.0 + 1.0);
            this.slot1 = this.slot3;
        } else if (random < twoSameProbability + threeSameProbability) {
            this.slot1 = this.slot2 = (int)(Math.random() * 5.0 + 1.0);
            do {
                this.slot3 = (int)(Math.random() * 5.0 + 1.0);
            } while ((this.slot3 == this.slot1 || this.slot3 == this.slot2) && this.slot1 != this.slot2);
        } else {
            do {
                this.slot1 = (int)(Math.random() * 5.0 + 1.0);
                this.slot2 = (int)(Math.random() * 5.0 + 1.0);
                this.slot3 = (int)(Math.random() * 5.0 + 1.0);
            } while (this.slot1 == this.slot2 || this.slot2 == this.slot3 || this.slot1 == this.slot3);
        }
        int[] slots = this.checkBetItemAndPayout(this.slot1, this.slot2, this.slot3);
        this.slot1 = slots[0];
        this.slot2 = slots[1];
        this.slot3 = slots[2];
        this.payout(this.slot1, this.slot2, this.slot3);
        this.m_6596_();
        return new int[]{this.slot1, this.slot2, this.slot3};
    }

    public int[] checkBetItemAndPayout(int slot1, int slot2, int slot3) {
        HashMap<Item, Integer> itemCounts = new HashMap<Item, Integer>();
        for (int i = 0; i < this.ownerItemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.ownerItemHandler.getStackInSlot(i);
            itemCounts.put(stackInSlot.m_41720_(), itemCounts.getOrDefault(stackInSlot.m_41720_(), 0) + stackInSlot.m_41613_());
        }
        if (itemCounts.containsKey(this.BET_ITEM.m_41720_()) && (Integer)itemCounts.get(this.BET_ITEM.m_41720_()) >= Config.triplePayoutAmount) {
            return new int[]{slot1, slot2, slot3};
        }
        int[] result = new int[3];
        result[0] = (int)(Math.random() * 5.0 + 1.0);
        do {
            result[1] = (int)(Math.random() * 5.0 + 1.0);
        } while (result[1] == result[0]);
        do {
            result[2] = (int)(Math.random() * 5.0 + 1.0);
        } while (result[2] == result[0] || result[2] == result[1]);
        return result;
    }

    public int[] startSpin() {
        this.BET_ITEM = this.itemHandler.getStackInSlot(0);
        ItemStack itemInOutputSlot = this.itemHandler.getStackInSlot(1);
        this.itemHandler.extractItem(0, 1, false);
        if (Config.validBetItems.contains(this.BET_ITEM.m_41720_())) {
            if (itemInOutputSlot.m_41619_() || itemInOutputSlot.m_41720_() == this.BET_ITEM.m_41720_() && itemInOutputSlot.m_41613_() + Config.triplePayoutAmount < itemInOutputSlot.m_41741_()) {
                return new int[]{0, 0, 0};
            }
            return new int[]{6, 6, 6};
        }
        return new int[]{6, 6, 6};
    }

    public Object getOwner() {
        return this.ownerUUID;
    }
}

