/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.slotmachine.network.packet;

import java.util.function.Supplier;
import net.micaxs.slotmachine.block.entity.SlotMachineBlockEntity;
import net.micaxs.slotmachine.network.PacketHandler;
import net.micaxs.slotmachine.network.packet.SlotsS2CPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SlotsC2SPacket {
    private final BlockPos pos;
    private final boolean spinState;

    public SlotsC2SPacket(BlockPos pos, boolean spinState) {
        this.pos = pos;
        this.spinState = spinState;
    }

    public SlotsC2SPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.spinState = buffer.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.spinState);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_284548_();
            BlockEntity be = level.m_7702_(this.pos);
            if (be instanceof SlotMachineBlockEntity) {
                int[] results = this.spinState ? ((SlotMachineBlockEntity)be).startSpin() : ((SlotMachineBlockEntity)be).stopSpin();
                PacketHandler.sendToPlayer(new SlotsS2CPacket(this.pos, results), player);
            }
        });
        return true;
    }
}

