#include "program/version.glsl"
#include "program/config.glsl"
#include "lib/ambient.glsl"
#include "lib/coord.glsl"
#include "lib/lighting.glsl"

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;

uniform sampler2D colortex10;//sun
uniform sampler2D colortex11;//moon
uniform sampler2D colortex12;//clouds

uniform sampler2D depthtex0;



in vec2 texcoord;

/* RENDERTARGETS:0,1,2 */
layout(location = 0) out vec4 color;
layout(location = 1) out vec4 lightmapData;
layout(location = 2) out vec4 encodedNormal;




void main() {
    color = vec4(0, 0, 0, 1);
    vec4 terrainColor = texture(colortex0, texcoord);
    lightmapData = texture(colortex1, texcoord);
    encodedNormal = texture(colortex2, texcoord);
    vec3 normal = normalize(encodedNormal.xyz * 2.0 - 1.0);
    vec3 viewNormal = mat3(gbufferModelView) * normal;
    vec3 translucentData = texture(colortex3, texcoord).xyz; //sky,todo,todo
    float depth = texture(depthtex0, texcoord).r;




    vec3 screenPos = vec3(texcoord, depth);
    vec3 ndcPos = screenPos * 2.0 - 1.0;
    vec3 viewPos = projectAndDivide(gbufferProjectionInverse, ndcPos);
    vec3 eyePlayerPos = mat3(gbufferModelViewInverse) * viewPos;
    vec3 feetPlayerPos = (gbufferModelViewInverse * vec4(viewPos, 1.0)).xyz;
    vec3 eyeDirection = normalize(eyePlayerPos);
    float viewDist = length(viewPos.xz);
    

    if (depth != 1) {
        #if RENDERING_MODE == RENDERING_MODE_DEFERRED

        vec3 lightVector = normalize(shadowLightPosition);
        vec3 worldLightVector = mat3(gbufferModelViewInverse) * lightVector;
        float blockDirectionShadow = max(dot(worldLightVector, normal), 0);

        vec3 lighting = getLighting(feetPlayerPos, viewDist, lightmapData.xy, blockDirectionShadow);
        terrainColor.rgb *= lighting;

        float fog = getFog(viewPos);
        terrainColor.rgb = mix(terrainColor.rgb, getFogColor(), fog);

        #endif
    }


    vec3 sky = getSky(eyeDirection, colortex10, colortex11);
    color.rgb = mix(terrainColor.rgb, sky, translucentData.r);
    
}