#include "program/version.glsl"
#include "program/config.glsl"
#include "lib/ambient.glsl"
#include "lib/coord.glsl"
#include "lib/lighting.glsl"

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;

uniform sampler2D colortex10;//sun
uniform sampler2D colortex11;//moon
uniform sampler2D colortex12;//clouds

uniform sampler2D depthtex0;



in vec2 texcoord;

/* RENDERTARGETS:0 */
layout(location = 0) out vec4 color;


vec4 getSkyReflection(vec3 reflectVec, float skyExposure) {
    vec3 sky = getSky(mat3(gbufferModelViewInverse) * reflectVec, colortex10, colortex11);
    return vec4(sky, skyExposure);
}


vec4 getReflection(vec3 position, vec3 normal, float skyExposure) {
    vec3 reflectVec = reflect(normalize(position), normal);

    int iterations = 100;

    vec3 rayOrigin = position;
    vec3 rayDirection = reflectVec;
    vec3 rayEnd = rayOrigin + rayDirection * 10;
    vec3 rayDelta = rayEnd - rayOrigin;
    vec3 rayDeltaStep = rayDelta / iterations;

    vec3 rayPosition = rayOrigin;

    return getSkyReflection(reflectVec, skyExposure);

    /*
    for (int i = 0; i < iterations; i++) {
        rayPosition += rayDeltaStep;

        vec3 ndcPos = projectAndDivide(gbufferProjection, rayPosition);
        vec3 screenPos = ndcPos * 0.5 + 0.5;

        float rayDepth = texture(depthtex0, screenPos.xy).r;
        if (screenPos.x < 0 || screenPos.y < 0 || screenPos.x > 1 || screenPos.y > 1 || rayDepth == 1 || true) {
            vec3 sky = getSky(mat3(gbufferModelViewInverse) * rayDirection, colortex2, colortex3);
            color.rgb = sky;
            break;
        }


        if (rayDepth < screenPos.z - 0.001) {
            vec4 reflectColor = texture(colortex0, screenPos.xy);
            color.rgb = reflectColor.rgb;
            break;
        }
    }
    */
}


void main() {
    color = vec4(0, 0, 0, 1);
    vec4 terrainColor = texture(colortex0, texcoord);
    vec2 lightmapData = texture(colortex1, texcoord).xy;
    vec3 encodedNormal = texture(colortex2, texcoord).xyz;
    vec3 normal = normalize(encodedNormal.xyz * 2.0 - 1.0);
    vec3 viewNormal = mat3(gbufferModelView) * normal;
    float depth = texture(depthtex0, texcoord).r;


    vec3 screenPos = vec3(texcoord, depth);
    vec3 ndcPos = screenPos * 2.0 - 1.0;
    vec3 viewPos = projectAndDivide(gbufferProjectionInverse, ndcPos);
    //vec3 eyePlayerPos = mat3(gbufferModelViewInverse) * viewPos;
    //vec3 feetPlayerPos = (gbufferModelViewInverse * vec4(viewPos, 1.0)).xyz;
    //vec3 eyeDirection = normalize(eyePlayerPos);
    //float viewDist = length(viewPos.xz);
    
    color.rgb = terrainColor.rgb;

    /*
    if (depth != 1) {
        float skyExposure = max(1.0 - (1.0 - lightmapData.g) * 10.0, 0);
        vec4 refData = getReflection(viewPos, viewNormal, skyExposure);
        //color.rgb = mix(color.rgb, refData.rgb, refData.a);
    }
    */



    color.rgb = pow(color.rgb, vec3(2.2));
}