#if !defined(__COORD__)
#define __COORD__

#define PI 3.14159265359

uniform vec3 cameraPosition;
uniform vec3 shadowLightPosition;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 shadowModelView;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowProjectionInverse;

uniform float viewWidth;
uniform float viewHeight;

uniform float near;
uniform float far;

uniform float fogStart;
uniform float fogEnd;

uniform float shadowAngle;

vec3 projectAndDivide(mat4 projectionMatrix, vec3 pos) {
    vec4 homPos = projectionMatrix * vec4(pos, 1.0);
    return homPos.xyz / homPos.w;
}

#endif