#if !defined(__LIGHTING__)
#define __LIGHTING__
#include "coord.glsl"
#include "ambient.glsl"
#include "shadow.glsl"


float getShadowPower() {
    float angle = sin(shadowAngle * 2.0 * PI);
    if (angle < 0.05) {
        return (angle / 0.05);
    }
    return 1;
}


vec3 getLighting(vec3 feetPlayerPos, float viewDist, vec2 lightmapData, float blockDirectionShadow) {
    #if SHADOW == SHADOW_ON

    vec3 shadow = getSoftShadow(viewDist, feetPlayerPos);
    
    float shadowFade = 1.0 - (viewDist - shadowDistance);
    shadowFade /= float(SHADOW_FADE_LENGTH);
    shadowFade = clamp(shadowFade, 0, 1);
    shadow = mix(vec3(1), shadow, shadowFade);

    #else

    vec3 shadow = vec3(1.0);

    #endif



    float shadowPowerMul = getShadowPower();
    shadow *= getShadowPower();





    vec3 ambientLight = getAmbientLightColor();
    

    float skyLightPower = lightmapData.g;
    vec3 skyLight = getSkyLightColor() * skyLightPower;


    float sunLightPower = getSunLightPower(lightmapData);
    sunLightPower *= shadowPowerMul;

    vec3 sunLight = getSunLightColor() * sunLightPower;
    //sunLight *= shadow;
    sunLight *= blockDirectionShadow;
    

    vec3 blockLightPower = vec3(lightmapData.r);
    vec3 blockLight = getBlockLightColor() * blockLightPower;

    return ambientLight + skyLight + (sunLight * shadow) + blockLight;
}


#endif