#if !defined(__SHADOW__)
#define __SHADOW__
#include "../program/config.glsl"
#include "coord.glsl"
#include "noise.glsl"
#include "distort.glsl"

#if SHADOW == SHADOW_ON

uniform sampler2D shadowtex0;
uniform sampler2D shadowtex1;
uniform sampler2D shadowcolor0;

vec3 getShadow(vec3 shadowScreenPos) {
    #if SHADOW_FILTERMODE != SHADOW_FILTERMODE_PIXEL
    float transparentShadow = step(shadowScreenPos.z, texture(shadowtex0, shadowScreenPos.xy).r);
    #else
    float transparentShadow = step(shadowScreenPos.z, texture(shadowtex1, shadowScreenPos.xy).r);
    #endif


    #if SHADOW_COLOREDSHADOW == SHADOW_COLOREDSHADOW_ON && SHADOW_FILTERMODE != SHADOW_FILTERMODE_PIXEL

    if (transparentShadow == 1.0) {
        return vec3(1.0);
    }

    float opaqueShadow = step(shadowScreenPos.z, texture(shadowtex1, shadowScreenPos.xy).r);
    if (opaqueShadow == 0.0) {
        return vec3(0.0);
    }
    
    vec4 shadowColor = texture(shadowcolor0, shadowScreenPos.xy);
    shadowColor.rgb *= 3.0;

    return shadowColor.rgb * (1.0 - shadowColor.a);

    #else

    return vec3(transparentShadow);

    #endif
}

vec3 getSoftShadow(float viewDist, vec3 feetPlayerPos) {

    #if SHADOW_FILTERMODE == SHADOW_FILTERMODE_PIXEL
    
    vec3 cameraFract = fract(cameraPosition);
    feetPlayerPos += cameraFract;
    feetPlayerPos.xz = (floor(feetPlayerPos.xz * SHADOW_PIXEL_SIZE) + 0.5) / float(SHADOW_PIXEL_SIZE);
    feetPlayerPos -= cameraFract;

    #endif


    vec3 shadowViewPos = (shadowModelView * vec4(feetPlayerPos, 1.0)).xyz;
    vec4 shadowClipPos = shadowProjection * vec4(shadowViewPos, 1.0);


    vec3 shadow = vec3(0.0);

    #if SHADOW_FILTERMODE == SHADOW_FILTERMODE_SOFT
    
    float noise = getNoise(shadowClipPos.xy * 100.0).r;
    float theta = noise * radians(360.0);
    float cosTheta = cos(theta);
    float sinTheta = sin(theta);
    mat2 rotation = mat2(cosTheta, -sinTheta, sinTheta, cosTheta);

    int range = SHADOW_SOFTNESS_FAR_RANGE;
    float rangeCenter = __IMPL__SHADOW_SOFT_FAR_RANGE_CENTER;
    if (viewDist < SHADOW_SOFTNESS_NEAR_LENGTH) {
        range = SHADOW_SOFTNESS_NEAR_RANGE;
        rangeCenter = __IMPL__SHADOW_SOFT_NEAR_RANGE_CENTER;
    }
    int samples = range * range;

    #else

    int range = 1;
    float rangeCenter = 0.0;
    int samples = 1;

    #endif

    for (int x = 0; x < range; x++) {
        for (int y = 0; y < range; y++) {
            vec2 offset = vec2(x, y) - rangeCenter;
            offset *= __IMPL__SHADOW_SOFT_RADIUS / float(range);

            #if SHADOW_FILTERMODE == SHADOW_FILTERMODE_SOFT

            offset = rotation * offset;
            
            #endif
            
            vec4 offsetShadowClipPos = shadowClipPos + vec4(offset, 0.0, 0.0);
            offsetShadowClipPos.z -= 0.002 * max(log(viewDist), 1);
            offsetShadowClipPos.xyz = distortShadowClipPos(offsetShadowClipPos.xyz);
            vec3 shadowNDCPos = offsetShadowClipPos.xyz / offsetShadowClipPos.w;
            vec3 shadowScreenPos = shadowNDCPos * 0.5 + 0.5;

            shadow += getShadow(shadowScreenPos);
        }
    }

    #if SHADOW_FILTERMODE == SHADOW_FILTERMODE_PIXEL

    return shadow;
    
    #else

    return shadow / float(samples);
    
    #endif

}

#endif

#endif