#if !defined(__CONFIG__)
#define __CONFIG__

/*
const int colortex0Format = RGB16;

const bool shadowtex0Nearest = true;
const bool shadowtex1Nearest = true;
const bool shadowcolor0Nearest = true;
*/

#define RENDERING_MODE 0 // [0 1]
#define RENDERING_MODE_FORWARD 0
#define RENDERING_MODE_DEFERRED 1

#define SHADOW 1 //[0 1]
#define SHADOW_OFF 0
#define SHADOW_ON 1

#define SHADOW_DISTANCE 12 // [4 8 10 12 16 24 32 48 64 128]
#define SHADOW_RESOLUTION 1024 // [512 1024 2048 4096 8192 16384]

#define SHADOW_COLOREDSHADOW 1 // [0 1]
#define SHADOW_COLOREDSHADOW_OFF 0
#define SHADOW_COLOREDSHADOW_ON 1

#define SHADOW_FILTERMODE 1 // [0 1 2]
#define SHADOW_FILTERMODE_HARD 0
#define SHADOW_FILTERMODE_SOFT 1
#define SHADOW_FILTERMODE_PIXEL 2

#define SHADOW_SOFTNESS 5 // [0 1 2 3 4 5 6 7 8 9 10]
#define SHADOW_SOFTNESS_NEAR_RANGE 4 // [1 2 3 4 5 6 7 8]
#define SHADOW_SOFTNESS_FAR_RANGE 2 // [1 2 3 4 5 6 7 8]
#define SHADOW_SOFTNESS_NEAR_LENGTH 10 // [5 10 15 20 25 30]

#define SHADOW_PIXEL_SIZE 16 // [4 8 16 32 64]

#define SHADOW_FADE_LENGTH 16 // [8 16 24 32 48 64]


#define CLOUD_DISTANCE 128 * 16


#define __IMPL__SHADOW_SOFT_RADIUS SHADOW_SOFTNESS * 0.0002
#define __IMPL__SHADOW_SOFT_NEAR_RANGE_CENTER (SHADOW_SOFTNESS_NEAR_RANGE - 1) * 0.5
#define __IMPL__SHADOW_SOFT_FAR_RANGE_CENTER (SHADOW_SOFTNESS_FAR_RANGE - 1) * 0.5



const float ambientOcclusionLevel = 1.0;
const int shadowMapResolution = SHADOW_RESOLUTION;
const float shadowDistance = SHADOW_DISTANCE * 16.0;

const vec3 ambientLightColor = vec3(0.05, 0.05, 0.05);
const vec3 sunLightColor = vec3(0.7, 0.45, 0.1);
const vec3 sunLightColorMidNight = vec3(0.0, 0.1, 0.4);
const vec3 blockLightColor = vec3(1.0, 0.9, 0.8);

uniform float alphaTestRef;

#endif